<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 7/5/2019	ELL
//

// Modification if this file allows for development of new website while old website remains inactive and unaffected.
// You will need to copy the /connect/ for and all of the files (except this one) to a new folder named  /connect2/.
// Subsequent test sites may also be created by incrementing the number in the /connect2/ folder name, i.e.
// /connect3/, /connect4/, etc.  You also need to copy the Breeze Website Builder database.  At a minimum, your config.php
// file under /connectX/ will need to assign a differt folder for BWB_CSS_DIR.  If you want to have different web page
// files, you may also have a different folder for BWB_WEBPAGE_DIR.  Alternahively, you may set a different folder for
// BWB_BASE_DIR (typically = '') which will have all of the website folders located under it.
//
// After copying your Breeze database, you will also need to change db_connect.php with the new database credentials.
// 

// *** Active Site ***
// Default is 1. To activate the first additional site, change this to 2.  Increment to add even more sites. 
define('BWB_ACTIVE_SITE', 1);

// ***Site Count ***
// Defaut is 1.  Set to the number of sites you have, i.e. active site plus test sites.
define('BWB_SITE_CNT', 1);

// *** Session Save Path ***
define('SESSION_SAVE_PATH', '/tmp');
// This is included here in addition to config.php because a session must be started before the config.php file is loaded
// to obtain the site_under_edit session value in order to determine which where the config folder is.  This is because once
// a define is declared, it can not be overwritten simply by redefining it.
// Session save path is not defined on all servers by default.  Default path on most severs is /tmp, but you may need to change
// this path to a folder within your hosting account for example. Note: do not use trailing slash '/'.
?>