<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/10/2016	ELL
// Revised: 7/11/2016	ELL
// Replaced used of archive.php and the gzip_file class with PharData class.
// 
// 
// 
	include ("check_session.php");
	
	$password = $_REQUEST['password'];
	
	//////////////////////////////////////
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$cur_ts = date('YmdHis', time());
	ini_set('max_execution_time', 1800);
	set_time_limit(1800);
	ini_set('memory_limit','2048M');
	//////////////////////////////////////////
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<style>
	#download_btn	{	width:170px;	}
</style>
</head>
<body>
<center>
<img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo BACKUP_RESTORE_CREATING_BACKUP_PLEASE_WAIT_MSG; ?>" id="uploading_gif" style="margin-top:50px;" />
<?php

	if (!is_dir($document_root . "/backup"))	{
		if (!mkdir($document_root . "/backup"))
		die(BACKUP_RESTORE_ERROR_CREATING_FOLDER_ERR . " backup " . FOLDER_WORD . ".");
	}
		
	if (file_exists($document_root . "/backup/backup.sql"))
		unlink($document_root . "/backup/backup.sql");
	
	echo "\n<br /><br />\n<div id='dumping_msg'>" . BACKUP_RESTORE_DUMPING_DATABASE . "</div><br /><br />\n";
	// Dump database.
	$command = "mysqldump --user=$db_username --password=\"$db_password\" --host=$hostname --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "users --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "version --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "login_attempts --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "meta_tags_template --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "options --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "page_cache --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "template --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "blogs_draft --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "page_data_draft --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "plugins --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "plugin_categories --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "access_levels $bwb_database > $document_root/backup/backup.sql";
	exec($command);
	
	// Standardize table prefix to allow restoring of site in any account.  (Note: Sites with blank table prefixes can only be restored to an account with table prefix set to blank.
	if ((BWB_TABLE_PREFIX != "bwb_") && (BWB_TABLE_PREFIX != ""))
	{
		$filename = $document_root . "/backup/backup.sql";
		$handle = fopen($filename, "r");
		$contents = fread($handle, filesize($filename));
		fclose($handle);
		
		$contents = str_replace(BWB_TABLE_PREFIX, "bwb_", $contents);
		$handle = fopen($filename, "w");
		if (fwrite($handle, $contents) === FALSE) {
			echo BACKUP_RESTORE_ERROR_ERROR_WRITING_FILE_ERR . " <b>" . $filename . "</b>.";
			exit;
		}
		fclose($handle);
	}
	
	echo "<div id='zipping_msg'>" . BACKUP_RESTORE_ZIPPING_FILES . "</div><br /><br />\n";
	// Collect all possible user-created/modified files for archiving.
	$tmp_dir = $document_root . "/tmp" . $cur_ts;
	if (!mkdir($tmp_dir))
		die(BACKUP_RESTORE_ERROR_CREATING_FOLDER_ERR . " tmp " . FOLDER_WORD . ".");
	
	mkdir($tmp_dir . "/images");
	mkdir($tmp_dir . "/css");
	mkdir($tmp_dir . "/flash");
	mkdir($tmp_dir . "/media");
	mkdir($tmp_dir . "/scripts");
	mkdir($tmp_dir . "/files");
	mkdir($tmp_dir . "/php");
	mkdir($tmp_dir . "/fonts");
	if (BWB_BASE_DIR == "")
	{
		$command = "cp -r " . $document_root . "/" . BWB_IMAGE_DIR . "/* " . $tmp_dir . "/images";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_CSS_DIR . "/* " . $tmp_dir . "/css";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_FLASH_DIR . "/* " . $tmp_dir . "/flash";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_MEDIA_DIR . "/* " . $tmp_dir . "/media";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_SCRIPTS_DIR . "/* " . $tmp_dir . "/scripts";
		exec($command);
		if (BWB_WEBPAGE_DIR != "")
			$command = "cp " . $document_root . "/" . BWB_WEBPAGE_DIR . "/* " . $tmp_dir . "/files";
		else
			$command = "cp " . $document_root . "/* " . $tmp_dir . "/files";
		exec($command);
	}
	else
	{
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/* " . $tmp_dir . "/images";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_CSS_DIR . "/* " . $tmp_dir . "/css";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/* " . $tmp_dir . "/flash";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/* " . $tmp_dir . "/media";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/* " . $tmp_dir . "/scripts";
		exec($command);
		if (BWB_WEBPAGE_DIR != "")
			$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/* " . $tmp_dir . "/files";
		else
			$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/* " . $tmp_dir . "/files";
		exec($command);
	}
	$command = "cp -r " . $document_root . "/" . BWB_LIB_DIR . "/* " . $tmp_dir . "/php";
	
	exec($command);
	if (defined("BWB_FONTS_DIR") && file_exists($document_root . "/" . BWB_FONTS_DIR))	{
		$command = "cp " . $document_root . "/" . BWB_FONTS_DIR . "/* " . $tmp_dir . "/fonts";
		exec($command);
	}
	
	$command = "cp " . $document_root . "/backup/backup.sql " . $tmp_dir;
	exec($command);
	
	
	$file_name = $document_root . "/backup/backup_" . $cur_ts . ".tgz";
	$gz_file_name = $document_root . "/backup/backup_" . $cur_ts . ".tar.gz";
	$tar_file_name = $document_root . "/backup/backup_" . $cur_ts . ".tar";

	$compression_err = false;
	try	{
		$phar = new PharData($tar_file_name);
	
		// ADD FILES TO archive.tar FILE
		$phar->buildFromDirectory($tmp_dir);
	
		// COMPRESS archive.tar FILE. COMPRESSED FILE WILL BE archive.tar.gz
		$phar->compress(Phar::GZ);
	
		// NOTE THAT BOTH FILES WILL EXISTS. SO IF YOU WANT YOU CAN UNLINK archive.tar
		unlink($tar_file_name);
		rename($gz_file_name, $file_name);
	} 
	catch (Exception $e) {
		$compression_err = true;
	}
	
	if ($compression_err)
		print (ERROR_CAPS_WORD . " " . $e);
	else
	{
?>
		<h1><?php echo BACKUP_RESTORE_BACKUP_COMPLETE_MSG; ?></h1>
		<table align="center"><tr><td><?php echo BACKUP_RESTORE_BACKUP_READY_FOR_DOWNLOAD_1_MSG . " " . CLICK_WORD . " </td><td><div class='button_console_download' id='download_btn'><a href='../backup/backup_$cur_ts.tgz' class='button_console_link'><span class='button_console_text_w_icon'>" . DOWNLOAD_WORD . "</span></a></div></td><td> " . BACKUP_RESTORE_BACKUP_READY_FOR_DOWNLOAD_2_MSG; ?></td></tr></table>

		<h2>- <?php echo OR_CAP_WORD; ?> -</h2>
        
        <div class="button_console" style="width:360px;" onClick="window.location='backup_restore.php?password=<?php echo $password; ?>';"><span class='button_console_text'><?php echo CLICK_WORD . " " . HERE_WORD . " " . BACKUP_RESTORE_RETURN_TO_MSG ; ?></span></div>
    
<?php
	}
	// Delete tmp folder to reclaim space.
	$command = "rm -r -f " . $tmp_dir;
	exec($command);
?>
</center>
<script>
	document.getElementById("uploading_gif").style.display = "none";
    document.getElementById("dumping_msg").style.display = "none";
    document.getElementById("zipping_msg").style.display = "none";
</script>
</body>
</html>