<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/30/2010
// Modified: 12/2/2010	Ed Lemmers
// Changed relative path to index.php to absolute path to fix problem of infinite loop back to index.php in kfm folder.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 3/25/2013	ELL
// Security enhancements for PDO.
// Revised: 7/31/2014	ELL
// Added checking and setting of session path in case not set by default.
// Revised: 7/5/2019	ELL
// Added ability to switch between different sites in one Breeze installation utilizing cofig_sites.php file and user selection on login.
//
	error_reporting (E_ALL ^ E_NOTICE);
	
	$connect_dir = "connect";
	if (file_exists("../connect/config_sites.php"))	{
		include ("../connect/config_sites.php");
		if (BWB_ACTIVE_SITE != 1)
			$connect_dir .= BWB_ACTIVE_SITE;
	}
	else
		define('BWB_ACTIVE_SITE', 1);
	
	$sess_save_path = session_save_path();
	if (!isset($sess_save_path) || ($sess_save_path == ""))	{
		if (defined('SESSION_SAVE_PATH'))
			session_save_path(SESSION_SAVE_PATH);
		else
			session_save_path('/tmp');
	}
	
	session_start();
	$userid = $_SESSION['userid'];
	$curr_session = md5(session_id());
	
	if (isset($_SESSION['site_under_edit']) && ($_SESSION['site_under_edit'] != BWB_ACTIVE_SITE))	{
		$site_under_edit = $_SESSION['site_under_edit'];
		if ($site_under_edit == 1)
			$connect_dir = "connect";
		else
			$connect_dir = "connect" . $site_under_edit;
	}
	else
		$site_under_edit = BWB_ACTIVE_SITE;

	include ("../$connect_dir/config.php");
	include ("../$connect_dir/db_connect.php");
	
	$query = "SELECT `Session`, `IP`, `AccessLevel`, `first_name`, `last_name` FROM `" . BWB_TABLE_PREFIX . "users` WHERE `UserID`=:userid";
	$stmt = $bwb_dbh->prepare($query);
	$stmt->execute(array(':userid' => $userid));
	$row = $stmt->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT);
	
	$session = $row['Session'];
	$ip = $row['IP'];
	$access_level = $row['AccessLevel'];
	$curr_ip = $_SERVER['REMOTE_ADDR'];
	
	if (($curr_session != $session) || ($curr_ip != $ip))
		header("Location: /index.php");
		
	$first_name = $row['first_name'];
	$last_name = $row['last_name'];

	if (defined("BWB_LANG"))
		include ("lang/" . BWB_LANG . ".php");
	else
		include ("lang/en.php");
		
	$query = "SELECT `option_value` FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name`='Theme'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$theme = $row['option_value'];
	}
	else
		$theme = "classic";
		
	if (BWB_REQUIRE_SSL == 1)
		$http = "https://";
	elseif (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')
		$http = "https://";
	else
		$http = "http://";
?>