	<!--
	Copyright (c) 2007 John Dyer (http://johndyer.name)
	
	Permission is hereby granted, free of charge, to any person
	obtaining a copy of this software and associated documentation
	files (the "Software"), to deal in the Software without
	restriction, including without limitation the rights to use,
	copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the
	Software is furnished to do so, subject to the following
	conditions:
	
	The above copyright notice and this permission notice shall be
	included in all copies or substantial portions of the Software.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
	EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
	OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
	NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
	HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
	WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
	FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
	OTHER DEALINGS IN THE SOFTWARE.
	-->
	
<?php
	////////////////////////////////////////////////////////////////////////
	// Modified for Breeze Website Builder
	// 
	// Revised: 11/13/08	ELL
	// Added GET of source page to allow color picker to populate CSS editor properly. 
	// Revised: 11/7/2012	ELL
	// Added ability to inject a different start color.
	// 
	$form_name = $_GET['form_name'];
	$field_name = $_GET['field_name'];
	$source_page = $_GET['source_page'];
	$start_color = $_GET['start_color'];
	if ((!$start_color) || ($start_color == "-not set-"))
		$start_color = "ffcc00";
	else
		$start_color = str_replace("#", "", $start_color);
		
	// Custom srtpos function for taking array as needle.
	function strpos_a($haystack, $needle)
	{
		 if (is_array($needle)) {
			 foreach ($needle as $need) {
				   if (strpos($haystack, $need) !== false) {
						   return (strpos($haystack, $need));
				   }
			 }
		 }else {
			  if (strpos($haystack, $need) !== false) {
						   return (strpos($haystack, $need));
			  }
		 }
	
		 return false;
	}
		
	// If detect any hackers, fail silently.
	$bad_stuff = array("http", ":", "//");
	if (strpos_a($form_name, $bad_stuff) !== false)
		exit;
	if (strpos_a($field_name, $bad_stuff) !== false)
		exit;
	if (strpos_a($source_page, $bad_stuff) !== false)
		exit;
	if (strpos_a($start_color, $bad_stuff) !== false)
		exit;
?>
	<html>
	<head>
		<title>Color Picker</title>
		<style type="text/css">
		body, td {
			font-family: tahoma;
			font-size: 10pt;
		}
		</style>
	
		<script type="text/javascript" src="refresh_web/prototype.js" ></script>
		<script type="text/javascript" src="refresh_web/colorpicker/colormethods.js" ></script>
		<script type="text/javascript" src="refresh_web/colorpicker/colorvaluepicker.js" ></script>
		<script type="text/javascript" src="refresh_web/colorpicker/slider.js" ></script>
		<script type="text/javascript" src="refresh_web/colorpicker/colorpicker.js" ></script>
        <script type="text/javascript" src="js/invert_color.js" ></script>
		
		<script type="text/javascript" language="JavaScript">
		function close_and_return()
		{
			if (opener && !opener.closed){
				var opposite_color = invertColor(this.document.colorpicker.cp1_Hex.value);
				opener.document.<?php echo "$form_name.$field_name";?>.value = "#" + this.document.colorpicker.cp1_Hex.value;		
				if (this.document.colorpicker.cp1_Hex.value == "")	{
					var class_name = opener.document.<?php echo "$form_name.$field_name";?>.className;
					if (class_name.indexOf("not_set" < 0))
						class_name = "not_set";
					else
						class_name = class_name + " not_set";
					opener.document.<?php echo "$form_name.$field_name";?>.className = class_name;
					opener.document.<?php echo "$form_name.$field_name";?>.style.backgroundColor = "#FFFFFF";
					opener.document.<?php echo "$form_name.$field_name";?>.style.color = "#000000";
				}
				else	{
					var class_name = opener.document.<?php echo "$form_name.$field_name";?>.className;
					class_name = class_name.replace("not_set", "");
					opener.document.<?php echo "$form_name.$field_name";?>.className = class_name;
					opener.document.<?php echo "$form_name.$field_name";?>.style.backgroundColor = "#" + this.document.colorpicker.cp1_Hex.value;
					opener.document.<?php echo "$form_name.$field_name";?>.style.color = opposite_color;
				}
				opener.focus();
			  }
			  window.close();
		}
		</script>
	
	</head>
	<body>
	<?php echo $field_name; ?>
	  <form method="post" name="colorpicker" action="<?php echo $source_page; ?>">
		<table>
			<tr>
				<td valign="top">
					<div id="cp1_ColorMap"></div>
				</td>
				<td valign="top">
					<div id="cp1_ColorBar"></div>
				</td>
	
				<td valign="top">
	
					<table>
						<tr>
							<td colspan="3">
								<div id="cp1_Preview" style="background-color: #fff; width: 60px; height: 60px; padding: 0; margin: 0; border: solid 1px #000;">
									<br />
								</div>
							</td>
						</tr>
						<tr>
							<td>
								<input type="radio" id="cp1_HueRadio" name="cp1_Mode" value="0" />
							</td>
							<td>
								<label for="cp1_HueRadio">H:</label>
							</td>
							<td>
								<input type="text" id="cp1_Hue" value="0" style="width: 40px;" /> &deg;
							</td>
						</tr>
	
						<tr>
							<td>
								<input type="radio" id="cp1_SaturationRadio" name="cp1_Mode" value="1" />
							</td>
							<td>
								<label for="cp1_SaturationRadio">S:</label>
							</td>
							<td>
								<input type="text" id="cp1_Saturation" value="100" style="width: 40px;" /> %
							</td>
						</tr>
	
						<tr>
							<td>
								<input type="radio" id="cp1_BrightnessRadio" name="cp1_Mode" value="2" />
							</td>
							<td>
								<label for="cp1_BrightnessRadio">B:</label>
							</td>
							<td>
								<input type="text" id="cp1_Brightness" value="100" style="width: 40px;" /> %
							</td>
						</tr>
	
						<tr>
							<td colspan="3" height="5">
	
							</td>
						</tr>
	
						<tr>
							<td>
								<input type="radio" id="cp1_RedRadio" name="cp1_Mode" value="r" />
							</td>
							<td>
								<label for="cp1_RedRadio">R:</label>
							</td>
							<td>
								<input type="text" id="cp1_Red" value="255" style="width: 40px;" />
							</td>
						</tr>
	
						<tr>
							<td>
								<input type="radio" id="cp1_GreenRadio" name="cp1_Mode" value="g" />
							</td>
							<td>
								<label for="cp1_GreenRadio">G:</label>
							</td>
							<td>
								<input type="text" id="cp1_Green" value="0" style="width: 40px;" />
							</td>
						</tr>
	
						<tr>
							<td>
								<input type="radio" id="cp1_BlueRadio" name="cp1_Mode" value="b" />
							</td>
							<td>
								<label for="cp1_BlueRadio">B:</label>
							</td>
							<td>
								<input type="text" id="cp1_Blue" value="0" style="width: 40px;" />
							</td>
						</tr>
	
	
						<tr>
							<td>
								#:
							</td>
							<td colspan="2">
								<input type="text" id="cp1_Hex" name="cp1_Hex" value="FF0000" style="width: 60px;" />
							</td>
						</tr>
	
					</table>
				</td>
			</tr>
			<tr>
				<td align="center">
				<input name="cancel" type="button" value="Close" onClick="window.close();">
				</td>
				<td colspan="2" align="center">
				<input name="submit" type="button" value="Submit" onClick="close_and_return();">
				</td>
			</tr>
		</table>
	  </form>
	
	<div style="display:none;">
		<img src="refresh_web/colorpicker/images/rangearrows.gif" />
		<img src="refresh_web/colorpicker/images/mappoint.gif" />
		
		<img src="refresh_web/colorpicker/images/bar-saturation.png" />
		<img src="refresh_web/colorpicker/images/bar-brightness.png" />
		
		<img src="refresh_web/colorpicker/images/bar-blue-tl.png" />
		<img src="refresh_web/colorpicker/images/bar-blue-tr.png" />
		<img src="refresh_web/colorpicker/images/bar-blue-bl.png" />
		<img src="refresh_web/colorpicker/images/bar-blue-br.png" />
		<img src="refresh_web/colorpicker/images/bar-red-tl.png" />
		<img src="refresh_web/colorpicker/images/bar-red-tr.png" />
		<img src="refresh_web/colorpicker/images/bar-red-bl.png" />
		<img src="refresh_web/colorpicker/images/bar-red-br.png" />	
		<img src="refresh_web/colorpicker/images/bar-green-tl.png" />
		<img src="refresh_web/colorpicker/images/bar-green-tr.png" />
		<img src="refresh_web/colorpicker/images/bar-green-bl.png" />
		<img src="refresh_web/colorpicker/images/bar-green-br.png" />
		
		<img src="refresh_web/colorpicker/images/map-red-max.png" />
		<img src="refresh_web/colorpicker/images/map-red-min.png" />
		<img src="refresh_web/colorpicker/images/map-green-max.png" />
		<img src="refresh_web/colorpicker/images/map-green-min.png" />
		<img src="refresh_web/colorpicker/images/map-blue-max.png" />
		<img src="refresh_web/colorpicker/images/map-blue-min.png" />
		
		<img src="refresh_web/colorpicker/images/map-saturation.png" />
		<img src="refresh_web/colorpicker/images/map-saturation-overlay.png" />
		<img src="refresh_web/colorpicker/images/map-brightness.png" />
		<img src="refresh_web/colorpicker/images/map-hue.png" />
		
		
		
	</div>
	
	<script type="text/javascript">
	
	Event.observe(window,'load',function() {
		cp1 = new Refresh.Web.ColorPicker('cp1',{startHex: '<?php echo $start_color; ?>', startMode:'s'});
	});
	
	
	</script>
	
	</body>
	</html>