<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/28/2015	ELL
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// 
// 
// 
	include ("check_session.php");
	include("lib/build_css_string.php");
	
	$mode = $_POST['mode'];
	$copy_from_class = $_POST['copy_from_class'];
	$copy_to_class = trim($_POST['copy_to_class']);
	$style_sheet = $_POST['style_sheet'];
	if (isset($_POST['to_style_sheet']) && ($_POST['to_style_sheet'] != "") && ($_POST['to_style_sheet'] != "-not selected-"))
		$to_style_sheet = $_POST['to_style_sheet'];
	else
		$to_style_sheet = $_POST['style_sheet'];
	if ($mode == "rename")
		$css_file = $style_sheet . ".css";
	else
		$css_file = $to_style_sheet . ".css";

	$replace = array(".", "#", " ", ",", ">", "&gt;", "+", "~");
	$search = array("PERIOD", "POUND", "SPACE", "COMMA", "GREATERTHAN", "GREATERTHAN", "PLUS", "TILDA");
	$copy_from_class = str_replace($search, $replace, $copy_from_class);
	$copy_to_class = str_replace($search, $replace, $copy_to_class);
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "site_classes` WHERE `style_sheet` = '$style_sheet' AND `class`='" . $copy_from_class . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)
	{
		echo "-no data-";
		return;
	}
	if ($mode == "copy")
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$description = $row['description'];
		$sort_order = $row['sort_order'];
		$subclass_sort_order = $row['subclass_sort_order'];
	}
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "site_classes` WHERE `style_sheet` = '$to_style_sheet' AND `class`='" . $copy_to_class . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)
	{
		echo "to class already exists";
		return;
	}
	
	if ($mode == "copy")
	{
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "site_classes` SET `style_sheet` = '" . $to_style_sheet . "', `class`='" . $copy_to_class . "', `description`='" . $description . "', `sort_order`='" . $sort_order . "', `subclass_sort_order`='" . $subclass_sort_order . "', `custom` = 1";
		$cnt = $bwb_dbh->exec($query);
	}
	elseif ($mode == "rename")
	{
		$query = "UPDATE `" . BWB_TABLE_PREFIX . "site_classes` SET `class`='" . $copy_to_class . "' WHERE `style_sheet` = '" . $style_sheet . "' AND `class`='" . $copy_from_class . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	else
	{
		echo "-no data-";
		exit;
	}
	
	unset($row);
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $style_sheet . "' AND `class`='" . $copy_from_class . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)
	{
		echo "-no attributes set-";
		return;
	}
	if ($mode == "copy")
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$sql = "INSERT INTO `" . BWB_TABLE_PREFIX . "site_css` SET `style_sheet` = '" . $to_style_sheet . "', `class` = '" . $copy_to_class . "'";
		foreach($row as $key => $val)
		{
			if (($key != 'style_sheet') && ($key != 'class'))
				$sql .= ", `" . $key . "` = '" . $val . "'";
		}
		$cnt = $bwb_dbh->exec($sql);
	}
	elseif ($mode == "rename")
	{
		$query = "UPDATE `" . BWB_TABLE_PREFIX . "site_css` SET `class`='" . $copy_to_class . "' WHERE `style_sheet` = '" . $style_sheet . "' AND `class`='" . $copy_from_class . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	$search = array(".", "#", " ", ",", ">", "&gt;", "+", "~");
	$replace = array("PERIOD", "POUND", "SPACE", "COMMA", "GREATERTHAN", "GREATERTHAN", "PLUS", "TILDA");
	$class_str = str_replace($search, $replace, $copy_to_class);
	$_SESSION['last_class_edited'] = $class_str;
	
	if ($cnt < 1)
		echo "-no data-";
	else
		echo $cnt;
		
	/////////////////////////////////////////////
	// Build string for site.css file /////
	if ($mode == "copy")
		$style_sheet = $to_style_sheet;

	$css_string = BuildCSSString($style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
//	echo $css_string;

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////////////////
	// Add custom styles to CKEditor style list. ///////////
	// Build string for fckstyles.xml file /////
	include("build_jason_style_string.php");
	
	// Rename styles.js file for backup
	$file_name = $document_root . "/ckeditor/styles.js";
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $jason_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
?>