<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/14/2015
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Consolidated all menu items tables into menu_items.
// Revised: 3/1/2018	ELL
// Added ability to copy from any of Desktop, Mobile or Touchscreen to any of Desktop, Mobile or Touchscreen.
	
	include ("check_session.php");
	include ("lib/build_css_string.php");

	$source_style_sheet = $_POST['source_style_sheet'];
	$destination_type = $_POST['destination_type'];
	
	$search = array("_touchscreen", "_mobile", "Touchscreen", "Mobile");
	$destination_style_sheet = str_replace($search, "", $source_style_sheet);
	if ($destination_type != "desktop")
		$destination_style_sheet .= "_" . $destination_type;

	// Create new classes.
	$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_classes WHERE style_sheet = '" . $destination_style_sheet . "'";
	$cnt = $bwb_dbh->exec($query);

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE style_sheet = '" . $source_style_sheet . "'";
	$result = $bwb_dbh->query($query);
	$comma = ", ";
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes SET style_sheet = '" . $destination_style_sheet . "'";
		foreach ($row as $field => $val)
		{
			if ($field != "style_sheet")	{
				$sql .= $comma . "`" . $field . "` = '" . $val . "'";
			}
		}
		$cnt = $bwb_dbh->exec($sql);
	}
	
	// Create new css.
	$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $destination_style_sheet . "'";
	$cnt = $bwb_dbh->exec($query);
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $source_style_sheet . "'";
	$result = $bwb_dbh->query($query);
	$comma = ", ";
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $destination_style_sheet . "'";
		foreach ($row as $field => $val)
		{
			if ($field != "style_sheet")	{
				$sql .= $comma . "`" . $field . "` = '" . $val . "'";
			}
		}
		$cnt = $bwb_dbh->exec($sql);
	}
	
	// Copy custon site CSS if site.css.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = '". $source_style_sheet . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$custom_css = addslashes(stripslashes($row['custom_css']));
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = '". $destination_style_sheet . "'";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() < 1)
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_css SET name = '" . $destination_style_sheet . "', custom_css = '" . $custom_css . "'";
		else
			$query = "UPDATE " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "' WHERE name = '" . $destination_style_sheet . "'";
		
		$cnt = $bwb_dbh->exec($query);
	}
	
	// Add to style sheets if new/non-existing mobile style sheet.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE name = '" . $destination_style_sheet . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE name = '" . $source_style_sheet . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$description = str_replace($search, "", $row['description']);
		if ($destination_type == "mobile")
			$description = $row['description'] . " Mobile";
		elseif ($destination_type == "touchscreen")
			$description = $row['description'] . " Touchscreen";
		$show_class_editor = $row['show_class_editor'];
		$show_custom_styles = $row['show_custom_styles'];
		$sort_order = $row['sort_order'] + 1;
		
		$charset = $row['charset'];
		$import = $row['import'];
		$media_type_modifier = $row['media_type_modifier'];
		$media_type = $row['media_type'];
		$media_feature = $row['media_feature'];
		$media_feature_value = $row['media_feature_value'];

		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "style_sheets SET `name` = '" . $destination_style_sheet . "', `description` = '" . $description . "', show_class_editor = '" 
		. $show_class_editor . "', show_custom_styles = '" . $show_custom_styles . "', sort_order = '" . $sort_order . "', charset = '" . $charset . "', import = '" 
		. $import . "', media_type_modifier = '" . $media_type_modifier . "', media_type = '" . $media_type . "', media_feature = '" . $media_feature . "', media_feature_value = '" 
		. $media_feature_value . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	// Make sure mobile menu style sheet added to menus as well.
	if ((strpos($style_sheet, "menu", 0) !== false) && (strpos($style_sheet, "item", 4) === false))
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '" . $destination_style_sheet . "'";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() < 1)	{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '" . $source_style_sheet . "'";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$description = str_replace($search, "", $row['description']);
			if ($destination_type == "mobile")
				$description = $row['description'] . " Mobile";
			elseif ($destination_type == "touchscreen")
				$description = $row['description'] . " Touchscreen";
			$proportional = $row['proportional'];
			$proportional_sub = $row['proportional_sub'];
			
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "menus SET `menu_name` = '" . $destination_style_sheet . "', `description` = '" . $description . "', proportional = '" 
			. $proportional . "', proportional_sub = '" . $proportional_sub . "'";
			$cnt = $bwb_dbh->exec($query);
		}
	}
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($destination_style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
			
	//Test to see if file already exists.
	$css_file = $destination_style_sheet . ".css";
	
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	////////////////////////////////////////////////////////////
	// Create new item tables if menu style sheet.
	if (strpos($style_sheet, "menu") !== false)
	{
		// Create new classes.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_classes WHERE style_sheet = '" . $destination_style_sheet . "_item'";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE style_sheet = '" . $source_style_sheet . "_item'";
		$result = $bwb_dbh->query($query);
		$comma = ", ";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes SET style_sheet = '" . $destination_style_sheet . "_item'";
			foreach ($row as $field => $val)
			{
				if ($field != "style_sheet")	{
					$sql .= $comma . "`" . $field . "` = '" . $val . "'";
				}
			}
			$cnt = $bwb_dbh->exec($sql);
		}
		
		// Create new css.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $destination_style_sheet . "_item'";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $source_style_sheet . "_item'";
		$result = $bwb_dbh->query($query);
		$comma = ", ";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $destination_style_sheet . "_item'";
			foreach ($row as $field => $val)
			{
				if ($field != "style_sheet")	{
					$sql .= $comma . "`" . $field . "` = '" . $val . "'";
				}
			}
			$cnt = $bwb_dbh->exec($sql);
		}
		
		/////////////////////////////////////////////
		// Build string for site.css file /////
		$css_string = BuildCSSString($destination_style_sheet . "_item", $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
				
		//Test to see if file already exists.
		$css_file = $style_sheet . "_item.css";
		
		$document_root = $_SERVER['DOCUMENT_ROOT'];
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
			
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $css_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}
	
	if ($cnt === false)
		echo -1;
	else
		echo $destination_style_sheet;
?>
