<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/17/2018	ELL
// Revised: 2/26/2018	ELL
// Added 3rd menu category for systems that ane not mobile (cell phones) but have touchscreens.
// 
// 
	include ("check_session.php");
	include ("lib/create_new_menu_class.php");
	include ("lib/build_css_string.php");
	
	$copy_to_description = $_POST['copy_to_description'];
	$copy_from_menu = $_POST['copy_from_menu'];
	$copy_to_menu = $_POST['copy_to_menu'];
	
	if ($copy_to_menu == "-new-")
	{
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` ORDER BY `menu_name` DESC";
		$result = $bwb_dbh->query($query);
		$row_cnt = $result->rowCount();
		if ($row_cnt < 1)
			$new_suffix = 1;
		else
		{
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$menu_name = $row["menu_name"];
			
			$index = array();
			$i = 1;
			$index[0] = substr($menu_name, strlen("menu"));
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$menu_name = $row["menu_name"];
				$index[$i] = substr($menu_name, strlen("menu"));
				$i++;
			}
			sort($index);
			$new_suffix = $index[$i-1] + 1;
		}

		$new_menu = substr($menu_name, 0, 4) . $new_suffix;
		$new_menu_mobile = substr($menu_name, 0, 4) . $new_suffix . "_mobile";
		$new_menu_touchscreen = substr($menu_name, 0, 4) . $new_suffix . "_touchscreen";
		$copy_to_description_mobile = $copy_to_description . " Mobile";
		$copy_to_description_touchscreen = $copy_to_description . " Touchscreen";
		$item_style_description = $copy_to_description . " Item Styles";		
		$item_style_description_mobile = $copy_to_description . " Mobile Item Styles";
		$item_style_description_touchscreen = $copy_to_description . " Touchscreen Item Styles";
		
		// Add to menus table.
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "menus` SET `menu_name` = '" . $new_menu . "', `description` = '" . $copy_to_description . "'";
		$cnt = $bwb_dbh->exec($query);
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "menus` SET `menu_name` = '" . $new_menu_mobile . "', `description` = '" . $copy_to_description_mobile . "'";
		$cnt = $bwb_dbh->exec($query);
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "menus` SET `menu_name` = '" . $new_menu_touchscreen . "', `description` = '" . $copy_to_description_touchscreen . "'";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` LIKE 'menu%' ORDER BY `name` DESC";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$sort_order = $row["sort_order"];
		$sort_order++;
		
		// Add to style sheet list.
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $new_menu . "'";
		$result = $bwb_dbh->query($query);
		$row_cnt = $result->rowCount();
		if ($row_cnt < 1)
		{
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu . "', `description` = '" . $copy_to_description . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_mobile . "', `description` = '" . $copy_to_description_mobile . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_touchscreen . "', `description` = '" . $item_style_description_touchscreen . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
			$sort_order++;
		}
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $new_menu . "_item'";
		$result = $bwb_dbh->query($query);
		$row_cnt = $result->rowCount();
		if ($row_cnt < 1)
		{
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu . "_item', `description` = '" . $item_style_description . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_mobile . "_item', `description` = '" . $item_style_description_mobile . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "style_sheets` SET `name` = '" . $new_menu_touchscreen . "_item', `description` = '" . $item_style_description_touchscreen . "', show_class_editor = 0, show_custom_styles = 0, `sort_order` = $sort_order";
			$cnt = $bwb_dbh->exec($query);
		}
	}
	else
	{
		$new_menu = $copy_to_menu;
		$new_menu_mobile = $copy_to_menu . "_mobile";
		$new_menu_touchscreen = $copy_to_menu . "_touchscreen";
		$new_menu_parts = explode("_", $copy_to_menu);
		$new_suffix = substr($new_menu_parts[0], 4);
		
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_classes` WHERE `style_sheet` = '" . $new_menu . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_classes` WHERE `style_sheet` = '" . $new_menu_mobile . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_classes` WHERE `style_sheet` = '" . $new_menu_touchscreen . "'";
		$cnt = $bwb_dbh->exec($sql);
		
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $new_menu . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $new_menu_mobile . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $new_menu_touchscreen . "'";
		$cnt = $bwb_dbh->exec($sql);
		
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $new_menu . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $new_menu_mobile . "'";
		$cnt = $bwb_dbh->exec($sql);
		$sql = "DELETE FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $new_menu_touchscreen . "'";
		$cnt = $bwb_dbh->exec($sql);
	}
	
	$old_menu = $copy_from_menu;
	$old_menu_mobile = $copy_from_menu . "_mobile";
	$old_menu_touchscreen = $copy_from_menu . "_touchscreen";
	$old_menu_parts = explode("_", $copy_from_menu);
	$old_suffix = substr($old_menu_parts[0], 4);
	
	// Insert/update new menu classes.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet` = '" . $old_menu . "'";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$copy_from_class = $row['class'];
		$copy_to_class = CreateNewMenuClass($copy_from_class, $old_suffix, $new_suffix);
		$description = $row['description'];
		$sort_order = $row['sort_order'];
		$sql = "INSERT INTO " . BWB_TABLE_PREFIX . "site_classes SET `style_sheet` = '" . $new_menu . "', `class` = '" . $copy_to_class . "', `description` = '" . $description . "', `sort_order` = " . $sort_order;
		$cnt = $bwb_dbh->exec($sql);
		
		// Copy/update style into CSS table.
		unset($row2);
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $old_menu . "' AND `class`='" . $copy_from_class . "'";
		$result2 = $bwb_dbh->query($query);
		if ($result2->rowCount() > 0)
		{
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			
			$sql = "REPLACE INTO `" . BWB_TABLE_PREFIX . "site_css` SET `style_sheet` = '" . $new_menu . "', `class` = '" . $copy_to_class . "'";
			foreach($row2 as $key => $val)
			{
				if (($key != 'style_sheet') && ($key != 'class'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet` = '" . $old_menu_mobile . "'";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$copy_from_class = $row['class'];
		$copy_to_class = CreateNewMenuClass($copy_from_class, $old_suffix, $new_suffix);
		$description = $row['description'];
		$sort_order = $row['sort_order'];
		$sql = "INSERT INTO " . BWB_TABLE_PREFIX . "site_classes SET `style_sheet` = '" . $new_menu_mobile . "', `class` = '" . $copy_to_class . "', `description` = '" . $description . "', `sort_order` = " . $sort_order;
		$cnt = $bwb_dbh->exec($sql);
		
		// Copy/update style into CSS table.
		unset($row2);
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $old_menu_mobile . "' AND `class`='" . $copy_from_class . "'";
		$result2 = $bwb_dbh->query($query);
		if ($result2->rowCount() > 0)
		{
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			
			$sql = "REPLACE INTO `" . BWB_TABLE_PREFIX . "site_css` SET `style_sheet` = '" . $new_menu_mobile . "', `class` = '" . $copy_to_class . "'";
			foreach($row2 as $key => $val)
			{
				if (($key != 'style_sheet') && ($key != 'class'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet` = '" . $old_menu_touchscreen . "'";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$copy_from_class = $row['class'];
		$copy_to_class = CreateNewMenuClass($copy_from_class, $old_suffix, $new_suffix);
		$description = $row['description'];
		$sort_order = $row['sort_order'];
		$sql = "INSERT INTO " . BWB_TABLE_PREFIX . "site_classes SET `style_sheet` = '" . $new_menu_touchscreen . "', `class` = '" . $copy_to_class . "', `description` = '" . $description . "', `sort_order` = " . $sort_order;
		$cnt = $bwb_dbh->exec($sql);
		
		// Copy/update style into CSS table.
		unset($row2);
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "site_css` WHERE `style_sheet` = '" . $old_menu_touchscreen . "' AND `class`='" . $copy_from_class . "'";
		$result2 = $bwb_dbh->query($query);
		if ($result2->rowCount() > 0)
		{
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			
			$sql = "REPLACE INTO `" . BWB_TABLE_PREFIX . "site_css` SET `style_sheet` = '" . $new_menu_touchscreen . "', `class` = '" . $copy_to_class . "'";
			foreach($row2 as $key => $val)
			{
				if (($key != 'style_sheet') && ($key != 'class'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	// Copy menu items to new 
	unset($row);
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $old_menu . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)
	{
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "INSERT INTO `" . BWB_TABLE_PREFIX . "menu_items` SET `menu` = '" . $new_menu . "'";
			foreach($row as $key => $val)
			{
				if (($key != 'menu') && ($key != 'ID'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	unset($row);
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $old_menu_mobile . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)
	{
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "INSERT INTO `" . BWB_TABLE_PREFIX . "menu_items` SET `menu` = '" . $new_menu_mobile . "'";
			foreach($row as $key => $val)
			{
				if (($key != 'menu') && ($key != 'ID'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	unset($row);
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_items` WHERE `menu` = '" . $old_menu_touchscreen . "'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)
	{
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "INSERT INTO `" . BWB_TABLE_PREFIX . "menu_items` SET `menu` = '" . $new_menu_touchscreen . "'";
			foreach($row as $key => $val)
			{
				if (($key != 'menu') && ($key != 'ID'))
					$sql .= ", `" . $key . "` = '" . $val . "'";
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($new_menu, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
	
	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $new_menu . ".css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($new_menu_mobile, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
	
	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $new_menu_mobile . ".css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($new_menu_touchscreen, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
	
	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $new_menu_touchscreen . ".css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////////////////
	// Add custom styles to CKEditor style list. ///////////
	// Build string for fckstyles.xml file /////
	include("build_jason_style_string.php");
	
	// Rename styles.js file for backup
	$file_name = $document_root . "/ckeditor/styles.js";
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $jason_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);

	header("Location: manage_menu.php?menu=$new_menu");
?>