<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/28/2013	ELL
// Modified: 10/14/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 2/22/2015	ELL
// Added update template image on mouseover.
// Modified: 4/27/2016	ELL
// Changed sort from sort_order to use dropdown_sort_order so sorting of templates would actually work.
// Widened layout templete select buttons to handle new longer layout template names.
// Revised: 1/9/2017	ELL
// Added ability to create a group of pages based on plugin groups.
// Modified: 6/20/2017	ELL
// Added filtering to not list "Console Only' plugins.
// Modified: 10/6/2017	ELL
// Fixed bug with sub categories that have no plugins display div of next sub category.
// Added message on where to get plugins when category or sub category contions no plugin.
// Revised:	10/2/2019	ELL
// Changed "parent" from using parent plugin name to using parent plugin ID.
// Revised: 11/12/2020	ELL
// Added display of plugin version number.
// 
	
	include ("check_session.php");
?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Create Page Select | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

.vertical_scroll_div	{
	max-height:450px;
	overflow-y:auto;
	overflow-x:hidden;
}

#selections_div	{
	display:block;
	position:absolute;
	top:60px;
	left:300px;
}

.selection_div	{
	height:33px;
	font-family:Arial, Helvetica, sans-serif;
}

#create_btn	{
	width:150px;
	display:block;
	position:absolute;
	top:170px;
	left:30px;
	z-index:1;
}

#template_pic_div	{
	display:block;
	position:absolute;
	top:0px;
	left:305px;
}
</style>

<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/create_page_select.js"></script>
<script src="js/fix_on_mouse_out.js"></script>

<script>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `dropdown_sort_order`";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo "var layouts = new Array($num_results);\n";
	echo "var images = new Array($num_results);\n";
	for ($i = 0; $i < $num_results; $i++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$option_value = $row["option_value"];
		$option_image = $row["option_image"];
		echo "layouts[$i] = \"$option_value\";\n";
		echo "images[$i] = \"$option_image\";\n";
	}

	$query = "SELECT `id`, `name`, `description`, `version` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `available` = 1";
	$result = $bwb_dbh->query($query);
	$plugin_cnt = $result->rowCount();
	echo "var plugins = new Array();\n";
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		echo "plugins[" . $row['id'] . "] = '" . $row['name'] . "';\n";
	}
	
	$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'Template'";
	$result2 = $bwb_dbh->query($query2);
	$row2 = $result2->fetch(PDO::FETCH_ASSOC);
	$option_value_selected = $row2["option_value"];
	echo "\nvar option_value_selected = '$option_value_selected';\n";
	
	echo "var CREATE_PAGE_SELECT_ALREADY_EXISTS_ERR = '" . CREATE_PAGE_SELECT_ALREADY_EXISTS_ERR . "';\n";
	echo "var GET_MORE_PLUGINS_BTN = '" . GET_MORE_PLUGINS_BTN . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 . "';\n";
	echo "var CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3 = '" . CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3 . "';\n";
	
	echo "var http = '$http';\n";
?>
</script>

</head>

<body id="workspace_body">

<div id="sub_level_1_buttons">
	<div class="button_heading_sub_level_1" id="create_page_heading" onClick="ShowSelections();"><div class="button_heading_text_sub_level_1"><?php echo CREATE_PAGE_SELECT_HEADING; ?></div><div class="help_button" id="help_button" onMouseOver="OpenHelpList();" onClick="OpenHelpWindow('create');">&nbsp;</div></div>
	
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowEnterPageName();" id="enter_page_name_btn"><span class='button_text_sub_level_1'><?php echo CREATE_PAGE_SELECT_ENTER_PAGE_NAME_BTN; ?></span></div>
    
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowPlugins();" id="add_plugin_btn"><span class='button_text_sub_level_1'><?php echo CREATE_PAGE_SELECT_ADD_PLUGIN_BTN; ?></span></div>
    
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowSelectLayout();" id="select_layout_btn"><span class='button_text_sub_level_1'><?php echo CREATE_PAGE_SELECT_SELECT_LAYOUT_BTN; ?></span></div>
</div>
		<form name="frmCreatePage" id="frmCreatePage" method="post" action="create_page.php">
        
        <input name="createPage" type="text" id="createPage" style="width:300px; display:none;" onBlur="SelectPageName(); CheckPageName(this.value, 'selected_page_name');" onKeyUp="CheckForm(this.value);" />
        
        <div id="select_layout_div" style="display:none;">
        
          <?php
		  	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `dropdown_sort_order`";
			$result = $bwb_dbh->query($query);
			$i = 0;
			$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$option_value = $row["option_value"];				
			 	
				if ($option_value_selected == $option_value)
					echo "<div class='button_sub_level_1 down_sub' id='layout_select$i' style='width:285px;$top_border_style' onClick=\"UpdateTemplateImage($i, true);\" onmouseover=\"UpdateTemplateImage($i, false);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
				else
					echo "<div class='button_sub_level_1' id='layout_select$i' style='width:285px;$top_border_style' onClick=\"UpdateTemplateImage($i, true);\" onmouseover=\"UpdateTemplateImage($i, false);\" onmouseout=\"RevertTemplateImage(option_value_selected);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
				$top_border_style = "";
				$i++;
			}
			?>

     <input type="hidden" id="template_name" name="template_name" value="<?php echo $option_value_selected; ?>" />
     
     <div id="template_pic_div"><img id="template_pic_edit" src="images/<?php echo $option_value_selected; ?>.jpg" border="0"></div>
     </div>         
            <div id="select_plugin_div" class="vertical_scroll_div" style="display:none;">
          <?php
			$cat_id = 0;
			$parent_cat_id = 0;
			$i = 0;
			$j = 0;
			$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
			
		  	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (((parent_category IS NULL) OR (parent_category = '')) AND (category <> 'Console Only')) ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$category = $row['category'];
				$parent_cat_id = $cat_id;
				echo "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;$top_border_style' onClick=\"SelectPluginCategory('$category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$category</span></div>\n";
				$j++;
				$top_border_style = "";
				
				$query = "SELECT `id`, `name`, `description`, `parent`, `default_page_name`, `version` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$category') ORDER BY `sort_order`";
				$result3 = $bwb_dbh->query($query);
				$num_results = $result3->rowCount();
				if ($num_results > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}
				
				$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
				while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
				{
					$id = $row3["id"];
					$plugin_name = $row3["name"];
					$description = $row3["description"];
					$version = $row3["version"];
					if (isset($row3["parent"]))
						$parent = $row3["parent"];
					else
						$parent = -1;
					$default_page_name = $row3["default_page_name"];
					if ($description != "")
						$description = " - " . $description;
					if ($version != "")
						$version = " - v. " . $version;
					$parent_child =  "";
					$got_parent = 0;
					if ($id == $parent)	{
						$parent_child = " parent";
						$txt_width = 98;
						$got_parent = 1;
					}
					elseif ($parent > -1)	{
						$parent_child = " child";
						$txt_width = 96;
					}

					echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i, $got_parent, '$parent', '$default_page_name');\"><span class='button_text_sub_level_1 $parent_child' style='width:$txt_width%;'>$plugin_name$description$version</span></div>\n";
					$i++;
					$top_border_style = "";
				}
				if ($num_results > 0)
					echo "</div>\n";
					
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (parent_category = '$category') ORDER BY sort_order";
				$result2 = $bwb_dbh->query($query);
				if ($result2->rowCount() > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}

				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$sub_category = $row2['category'];
					$sub_cat_div_str = "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"SelectPluginCategory('$sub_category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$alt_sub_cat_div_str = "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"DisplayNoPluginsInSubCatMsg('$sub_category', $cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$j++;
					
					$query = "SELECT `id`, `name`, `description`, `parent`, `default_page_name`, `version` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$sub_category') ORDER BY `sort_order`";
					$result3 = $bwb_dbh->query($query);
					$num_results = $result3->rowCount();
					if ($num_results > 0)	{
						echo $sub_cat_div_str;
						echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					}
					else
						echo $alt_sub_cat_div_str;
					$cat_id++;
					
					$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
					while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
					{
						$id = $row3["id"];
						$plugin_name = $row3["name"];
						$description = $row3["description"];
						$version = $row3["version"];
						if (isset($row3["parent"]))
							$parent = $row3["parent"];
						else
							$parent = -1;
						$default_page_name = $row3["default_page_name"];
						if ($description != "")
							$description = " - " . $description;
						if ($version != "")
							$version = " - v. " . $version;
						$parent_child = "";
						$got_parent = 0;
						
						if ($id == $parent)	{
							$parent_child = " parent";
							$txt_width = 98;
							$got_parent = 1;
						}
						elseif ($parent > -1)	{
							$parent_child = " child";
							$txt_width = 96;
						}
						
						echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i, $got_parent, '$parent', '$default_page_name');\"><span class='button_text_sub_level_1$parent_child' style='width:$txt_width%;'>$plugin_name$description$version</span></div>\n";
						$i++;
						$top_border_style = "";
					}
					if ($num_results > 0)
						echo "</div>\n";
				}
				if ($result2->rowCount() > 0)
					echo "</div>\n";
			}
			$cat_id++;
			
            ?>
            <div class='button_sub_level_1' style='width:258px;' ><a href="<?php echo $http; ?>breezewebsitebuilder.com/plugins.php" target="_blank" class="button_console_link"><span class='button_text_sub_level_1'><?php echo GET_MORE_PLUGINS_BTN; ?></span></a></div>
            <div class='button_console_delete' style="width:258px; display:none;" onClick="ClearPlugin();" id="clear_plugin_btn"><span class='button_console_text_w_icon'>Clear Plugin</span></div>
            <input type="hidden" name="plugin" id="plugin" value="-not selected-" />
            <input type="hidden" name="plugin_cnt" id="plugin_cnt" value="<?php echo $plugin_cnt; ?>" />
            <input type="hidden" name="cat_cnt" id="cat_cnt" value="<?php echo $cat_id; ?>" />
            </div>
            
            <div id="selections_div">
            <div id="selected_page_name" class="selection_div">&lsaquo;&mdash; <em>(required)</em></div>
            <div id="selected_plugin" class="selection_div">&lsaquo;&mdash; <em>(optional)</em></div>
            <img id="template_pic" src="images/<?php echo $option_value_selected; ?>.jpg" border="0" width="155" height="88" onMouseOver="this.width = '310'; this.height = '175'; this.style.cursor = 'zoom-in';" onMouseOut="this.width = '155'; this.height = '88';">
            </div>
            
            <div id="create_plugin_group_div">
            	<input type="checkbox" name="create_plugin_group" id="create_plugin_group" onClick="ShowHideChildPlugins(this);" /> <?php echo CREATE_PAGE_SELECT_CREATE_PLUGIN_GROUP; ?>
                <div id="child_plugin_pages_div">&nbsp;</div>
            </div>
           
        <div class='button_console_add_disabled' onClick="CreatePage();" id="create_btn"><span class='button_console_text_w_icon'><?php echo CREATE_WORD; ?></span></div>
        
          <input type="hidden" name="mode" value="create" />
	  </form>


	<div id="help_list" style="display:none;" onMouseOut="fixOnMouseOut(this, event, 'CloseHelpList();');">
    	<div id='help_list_close_btn'><img src='theme/<?php echo $theme; ?>/images/close-button.png' alt='Close' onClick="document.getElementById('help_list').style.display='none';" style='cursor:pointer;' /></div>
    	<span onClick="window.open('<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#create', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'><?php echo CREATE_PAGE_SELECT_CREATING_A_PAGE; ?></span><br />
		<hr /><span onClick="window.open('<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#plugins', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'><?php echo PLUGINS_WORD; ?></span><br />
		<hr /><span onClick="window.open('<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#start', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'><?php echo CREATE_PAGE_SELECT_SELECTING_PAGE_LAYOUT; ?></span><br />
        <hr /><span onClick="window.open('<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#create_page_tips', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'><?php echo CREATE_PAGE_SELECT_HELPFUL_TIPS; ?></span>
    </div>
    
<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
</script>
</body>
</html>