<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010	ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 9/28/2010	ELL
// Fixed bug with shadow parameters not loading into editor.
// Revised: 10/7/2010	ELL
// Added selection of top, bottom, right, left for border style assignment, each independently selectable.
// Revised: 11/9/2010	ELL
// Changed centering to modify #wrap instead of .wrap.  Part of switching 
// Revised: 11/10/2010	ELL
// Added persistence of style sheet selected.
// Revised: 2/3/2011	ELL
// Added sorting of image file list.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added reference to user files folder constant.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/27/2013	ELL
// Added ability to change style sheet from this module.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/16/2014	ELL
// Added modal color tinting of grouping tables to make it easier to find controls and to make enabled=disabled obvious.
// Revised 2/20/2014	ELL
// Added checking for correct parameters selected for border and line height.
// Revised: 3/3/2014	ELL
// Replaced image uploader with "AJAX" image uploader.
// Revised: 8/27/2014	ELL
// Added switch between alpha and user-defined sort for class list.
// Revised: 12/27/2014	ELL
// Added drilling down one more directory level for building background image list.
// Revised: 12/30/2014	ELL
// Added browser CSS reset button.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added "initial" throughout.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Added full compliment of length units to existing unit fields.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Added button to go to Manage Custom Fonts console.
// Revised: 9/21/2015	ELL
// Added text-indent attribute.
// Revised: 1/19/2016	ELL
// Overhauled preview to use popup page.
// Revised: 3/25/2016	ELL
// Replace numeric placeholders of -1 and -1000000 for not set with "-not set".  Added code to clear "-not set-" when user wants to type
// and code to re-apply "-not set-" when user clears the field.
// Revised: 11/3/2016	ELL
// Added ability to set both min and max widths simultaneously, and both min and max heights simultaneously.
// Revised: 11/10/2016	ELL
// Adding alfa sort style sheets.
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Revised: 4/22/2017	ELL
// Added background RGBA labeled as "Foreground Opaque".
// Revised: 5/21/2017	ELL
// Added flex and inline-flex to display attribute.
// Added justify-content.
// Added various transition, flex and content attributes.
// Added text-transform.
// Revised: 7/17/2017	ELL
// Added button for setting important CSS attributes.
// Revised: 8/28/2017	ELL
// Added background gradient capability.
// Revised: 12/29/2017	ELL
// Added value of 'sticky' to display attribute.
// Added quick-setup button to set header as 'sticky'.
// Revised: 2/5/2018	ELL
// Filtered out fonts style sheet as this is created soley under custom fonts management and thus should not be edited in the CSS editor, 
// has no attributes that should be altered, and has no reason to be modified for mobile.
// Revised: 3/26/2018	ELL
// Replaced font select dropdowns with custom-built select comprised of divs, JavaScript and CSS for the display of font face both upon reviewing select and after selection.
// Added color feedback to all color selects.
// Revised: 4/16/2018	ELL
// Added importing of font sources to display these types of fonts correctly.
// Revised: 10/12/2018	ELL
// Changed CSS field from "align" to "text_align" to match actual CSS term.
// Changed CSS field from "shadow" to "text_shadow" to match actual CSS term.
// Added "auto" to width, height, top, bottom, left and right.
// Added box-sizing.
// Added length and length units to vertical-align.
// Added align-content, align-items and align-self.
// Added "inherit" and "initial" to vertical-align.
// Revised: 10/21/2018	ELL
// Re-engeneered width and height to use individual field sets for width, min-width and max-width, 
// and height, min-height and max-height.
// Revised: 3/26/2019	ELL
// Added enumeration of style-sheet type (desktop, touchscreen or mobile) with color highlight to aid in notifying webmaster which device format they are styling for.
// Revised: 8/4/2019	ELL
// Converted population of class select list to AJAX and added highlighting of classes that are in use.
// 
//
	include ("check_session.php");

	
	$style_sheet = $_REQUEST['style_sheet'];
	$_SESSION['last_style_sheet_edited'] = $style_sheet;
	
	if (isset($_REQUEST['goto_class']))
		$goto_class = $_REQUEST['goto_class'];
	elseif (isset($_SESSION['last_class_edited']))
		$goto_class = $_SESSION['last_class_edited'];
	else
		$goto_class = "";
	
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $style_sheet . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$show_class_editor = $row["show_class_editor"];
	$show_custom_styles = $row["show_custom_styles"];
	
	$class_sort_method = $_SESSION['class_sort_method'];
	if (isset($_REQUEST['style_sheet_sort_method']) && ($_REQUEST['style_sheet_sort_method'] != ""))	{
		$style_sheet_sort_method = $_REQUEST['style_sheet_sort_method'];
		$_SESSION['style_sheet_sort_method'] = $style_sheet_sort_method;
	}
	else
		$style_sheet_sort_method = $_SESSION['style_sheet_sort_method'];
		
	if (BWB_BASE_DIR == '')
		$css_path = BWB_CSS_DIR;
	else
		$css_path = BWB_BASE_DIR . "/" . BWB_CSS_DIR;
		
?>
<!DOCTYPE HTML>
<html>
<head>
<title>Editing <?php echo $style_sheet; ?> CSS | Breeze Website Builder</title>
<meta charset="utf-8">
<link rel="stylesheet" href="/<?php echo $css_path; ?>/fonts.css" type="text/css">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

#page_select_div	{
	left: 50px;
}

#content_text	{
	width:300px;
	heights:50px;
}
</style>

<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "fonts` WHERE `src` LIKE 'http%'";
	if ($result = $bwb_dbh->query($query))
	{
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			echo "<link href=\"" . $row['src'] . "\" rel=\"stylesheet\">\n";
		}
	}
?>

<script src="js/json2.js"></script>
<script src="js/ajax.js"> </script>
<script src="js/jquery.min.js"></script>
<script src="js/ajaxupload.js"></script>

<script src="js/check_color_str.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/font_select.js"></script>
<script src="js/invert_color.js"></script>

<script src="js/edit_css.js"></script>

<script>
////////////////////////////////////////////////////////////////////////////////////
var upload_index;
var populate_class_select = false;

<?php
echo "var style_sheet = '$style_sheet';\n\n";
echo "var goto_class = '$goto_class';\n\n";
echo "var theme = '$theme';\n\n";

$document_root = $_SERVER['DOCUMENT_ROOT'];
$http_host = $http . $_SERVER['HTTP_HOST'];

if (BWB_BASE_DIR == '')
{
	$path = $document_root . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_IMAGE_DIR . "/tn";
}
else
{
	$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/tn";
}
							
echo "var image_dir_path = '$image_dir_path';\n";
echo "var image_tn_dir_path = '$image_tn_dir_path';\n\n";

if (!is_dir($path . "/tn"))
		mkdir($path . "/tn", 0755);
		
echo "var EDIT_CSS_CLICK_UPDATE_TO_COMMIT_MSG = \"" . EDIT_CSS_CLICK_UPDATE_TO_COMMIT_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_COMPLETE_MSG = \"" . EDIT_CSS_UPDATE_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_READY_TO_SEND_MSG = \"" . EDIT_CSS_UPDATE_READY_TO_SEND_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_SENT_MSG = \"" . EDIT_CSS_UPDATE_SENT_MSG . "\";\n";
echo "var EDIT_CSS_UPDATING_MSG = \"" . EDIT_CSS_UPDATING_MSG . "\";\n";
echo "var EDIT_CSS_RESET_BROWSER_CSS_COMPLETE_MSG = \"" . EDIT_CSS_RESET_BROWSER_CSS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_CENTERED_PAGES_CSS_ALERT_MSG = \"" . EDIT_CSS_LOAD_CENTERED_PAGES_CSS_ALERT_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_CENTERED_PAGES_CSS_COMPLETE_MSG = \"" . EDIT_CSS_LOAD_CENTERED_PAGES_CSS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_HEADERS_ALERT_MSG = \"" . EDIT_CSS_LOAD_STICKY_HEADERS_ALERT_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_HEADERS_COMPLETE_MSG = \"" . EDIT_CSS_LOAD_STICKY_HEADERS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_FOOTERS_ALERT_MSG = \"" . EDIT_CSS_LOAD_STICKY_FOOTERS_ALERT_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_FOOTERS_COMPLETE_MSG = \"" . EDIT_CSS_LOAD_STICKY_FOOTERS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_BORDER_REQUIREMENTS_MSG = \"" . EDIT_CSS_BORDER_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_BORDER_REQUIREMENTS_STYLE_ADENDUM_MSG = \"" . EDIT_CSS_BORDER_REQUIREMENTS_STYLE_ADENDUM_MSG . "\";\n";
echo "var EDIT_CSS_LETTER_SPACING_REQUIREMENTS_MSG = \"" . EDIT_CSS_LETTER_SPACING_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_LINE_HEIGHT_REQUIREMENTS_MSG = \"" . EDIT_CSS_LINE_HEIGHT_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_SORTING_CLASS_LIST_MSG = \"" . EDIT_CSS_SORTING_CLASS_LIST_MSG . "\";\n";
echo "var EDIT_CSS_SORT_COMPLETE = \"" . EDIT_CSS_SORT_COMPLETE . "\";\n";
echo "var EDIT_CSS_SORTING_MSG = \"" . EDIT_CSS_SORTING_MSG . "\";\n";
echo "var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
echo "var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
echo "var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
echo "var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
echo "var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
echo "var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
echo "var EDIT_CSS_DISPLAY_SET_TO_FLEX = \"" . EDIT_CSS_DISPLAY_SET_TO_FLEX . "\";\n";
echo "var EDIT_CSS_ENTER_STR_MSG = \"" . EDIT_CSS_ENTER_STR_MSG . "\";\n";
echo "var EDIT_CSS_ENTER_URL_MSG = \"" . EDIT_CSS_ENTER_URL_MSG . "\";\n";
echo "var EDIT_CSS_ENTER_ATTR_MSG = \"" . EDIT_CSS_ENTER_ATTR_MSG . "\";\n";

echo "var http = '$http';\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeConsole();">
<div align="center" id="css_editor_div">
<table border="0" width="95%">
 <tr>
  <td align="left">
    <div class="button_heading_sub_level_1" id="edit_styles_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
    
    <a name="top_anchor"></a>
  </td>
  <td align="right">
  	<?php echo EDIT_CSS_CHANGE_STYLE_SHEET; ?>: 
  </td>
  <td style="text-align:left;">
  	<form name="frmChangeStyleSheet" id="frmChangeStyleSheet" action="edit_css.php" method="post" enctype="multipart/form-data">
  	<select name="style_sheet" id="style_sheet" onChange="document.getElementById('frmChangeStyleSheet').submit();">
<?php
	if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
		$sort = "`description`, `name`";
	else
		$sort = "sort_order";
		
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` <> 'fonts' ORDER BY " . $sort;
	$result = $bwb_dbh->query($query);
	$style_sheets = array();
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_style_sheet = $row['name'];
		$tmp_description = $row['description'];
		if ((strpos($tmp_style_sheet, "menu", 0) !== false) && (strpos($tmp_style_sheet, "item", 4) === false))
		{
			$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_style_sheet'";
			$result2 = $bwb_dbh->query($query2);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			$tmp_description = $row2['description'] . " Styles";
		}
		elseif ((strpos($tmp_style_sheet, "menu", 0) !== false) && (strpos($tmp_style_sheet, "item", 4) !== false))
		{
			$tmp_name = str_replace("_item", "", $tmp_style_sheet);
			$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_name'";
			$result2 = $bwb_dbh->query($query2);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			$tmp_description = $row2['description'] . " Item Styles";
		}
		$style_sheets[$tmp_style_sheet] = $tmp_description;
	}
	
	if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
		asort($style_sheets, SORT_FLAG_CASE);
	
	foreach ($style_sheets as $tmp_style_sheet => $tmp_description)
	{
		
		if ($tmp_style_sheet == $style_sheet)
			echo "		<option value='$tmp_style_sheet' selected>$tmp_description</option>\n";
		else
			echo "		<option value='$tmp_style_sheet'>$tmp_description</option>\n";
	}
?>
    </select>
    <span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_style_sheet" name="sort_alpha_style_sheet" <?php if ($style_sheet_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeStyleSheetSort(this.checked);" />
   </form>
  </td>
  <td>
<?php
	$style_sheet_type = "Desktop";
	$style_sheet_type_class = "type_desktop";
	if (strpos($style_sheet, "touchscreen"))	{
		$style_sheet_type = "Touchscreen";
		$style_sheet_type_class = "type_touchscreen";
	}
	elseif (strpos($style_sheet, "mobile"))	{
		$style_sheet_type = "Mobile";
		$style_sheet_type_class = "type_mobile";
	}
  	echo "<span class='" . $style_sheet_type_class . "'>" . TYPE_WORD . ": " . $style_sheet_type . "</span>";
?>
  </td>
<?php
	if (($show_class_editor == 1) || ($access_level == "admin"))
	{
?>
  <td>
    <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADD_DELETE_CUSTOM_STYLE_BTN; ?></span></div>
  </td>
<?php
	}
	if (($show_custom_styles == 1) || ($access_level == "admin"))
	{
?>
  <td align="right">
  	<div class='button_console_code' style="width:170px;" onClick="window.location.href='edit_custom_css.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADVANCED_STYLES_BTN; ?></span></div>
  </td>
<?php
	}
?>
 </tr>
</table>

<table width="95%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
   <form action="save_css.php" method="post" enctype="multipart/form-data" name="frm_site_styles" id="frm_site_styles">
     <table width="100%" border="1">
	  	<tr>
		  <td>
          
		    <table width="100%" border="0">
			  <tr>
		        <td><h3 id="class_heading">&nbsp;</h3></td>
		        <td><?php echo EDIT_CSS_USE_SETTINGS_BELOW; ?>: <input type="checkbox" name="use_table_data" id="use_table_data" value="1" onClick="EnableDisableControls(1);"></td>
                <td>
                <?php echo EDIT_CSS_GO_TO; ?>:
                <div id="goto_class_div" style="display:inline;">
                  <select name="goto_class" id="goto_class" onChange="PopulateForm(this.value);">
                  </select>
                  </div>
                  
                  <span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
                  </td>
                  <td align="right">
                  <div class='button_console_save' style="width:110px;" onClick="UpdateCSS('Update', false);" id="update_btn"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
                  </td>
		      </tr>
			</table>
		  
		    <table border="1" width="100%" id="text_table">
		      <tr>
			    <td>
				  <table border="0" width="100%">
				    <tr>
					  <td colspan="8" class="bold"><?php echo TEXT_WORD; ?></td>
				    </tr>
				    <tr>
					  <td align="right"><?php echo FONT_WORD; ?>: </td>
					  <td colspan="5">
					      <?php
						  $fonts = array();
						  $query = "SELECT DISTINCT font, websafe FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						  $result = $bwb_dbh->query($query);
						  while ($row = $result->fetch(PDO::FETCH_ASSOC))
							$fonts[$row['font']] = $row['websafe'];
					      ?>
                          
                          <div class="font_select_container">
                          <input type="text" name="font" id="font" class="font_input" />
                          <div id="font_select" class="font_select" onClick="ExpandCollapseFonts(this, 'font');" tabindex="1000" onblur="CollapseFonts(this);">
                          <div class='font_option' onClick="SetFont('font_select', 'font', '-not selected-');"><span style=''><?php echo _NOT_SELECTED_; ?></span></div>
                          <?php
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<div class='font_option' onclick=\"SetFont('font_select', 'font', '$tmp_font');\">";
							echo "<span style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo "<span style='font-family:Arial;'> &nbsp; &nbsp; &nbsp; &radic;</span>";
							echo "</span></div>\n";
						  }
					      ?>
                          </div>
                          </div>
                                                    
                          <div class="font_select_container">
                          <input type="text" name="font2" id="font2" class="font_input" />
                          <div id="font_select2" class="font_select" onClick="ExpandCollapseFonts(this, 'font2');" tabindex="1001" onblur="CollapseFonts(this);">
                          <div class='font_option' onClick="SetFont('font_select2', 'font2', '-not selected-');"><span style=''><?php echo _NOT_SELECTED_; ?></span></div>
                          <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<div class='font_option' onclick=\"SetFont('font_select2', 'font2', '$tmp_font');\">";
							echo "<span style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo "<span style='font-family:Arial;'> &nbsp; &nbsp; &nbsp; &radic;</span>";
							echo "</span></div>\n";
						  }
					      ?>
                          </div>
                          </div>
                          
                          <div class="font_select_container">
                          <input type="text" name="font3" id="font3" class="font_input" />
                          <div id="font_select3" class="font_select" onClick="ExpandCollapseFonts(this, 'font3');" tabindex="1002" onblur="CollapseFonts(this);">
                          <div class='font_option' onClick="SetFont('font_select3', 'font3', '-not selected-');"><span style=''><?php echo _NOT_SELECTED_; ?></span></div>
                          <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<div class='font_option' onclick=\"SetFont('font_select3', 'font3', '$tmp_font');\">";
							echo "<span style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo "<span style='font-family:Arial;'> &nbsp; &nbsp; &nbsp; &radic;</span>";
							echo "</span></div>\n";
						  }
					      ?>
                          </div>
                          </div>
                          
                          <div class='button_console_add_sm' style="width:100px; float:right;" onClick="window.location='manage_fonts.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_sm_icon'><?php echo MANAGE_CUSTOM_FONTS_ADD_FONT; ?></span></div>
					  </td>
					  <td align="right"><?php echo FONT_SIZE; ?>: </td>
					  <td>
                      	<input name="font_size" type="text" id="font_size" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                      	<select name="font_size_units" id="font_size_units" onChange="enable_disable_font_size();">
						    <option value="px">px</option>
						    <option value="em">em</option>
                            <option value="pt">pt</option>
                            <option value="pc">pc</option>
                            <option value="cm">cm</option>
                            <option value="mm">mm</option>
                            <option value="in">in</option>
                            <option value="%">%</option>
                            <option value="rem">rem</option>
                            <option value="vw">vw</option>
                            <option value="vh">vh</option>
                            <option value="vmin">vmin</option>
                            <option value="vmax">vmax</option>
                            <option value="ch">ch</option>
                            <option value="xx-small"><?php echo XX_SMALL_WORD; ?></option>
                            <option value="x-small"><?php echo X_SMALL_WORD; ?></option>
                            <option value="small"><?php echo SMALL_WORD; ?></option>
                            <option value="medium"><?php echo MEDIUM_WORD; ?></option>
                            <option value="large"><?php echo LARGE_WORD; ?></option>
                            <option value="x-large"><?php echo X_LARGE_WORD; ?></option>
                            <option value="xx-large"><?php echo XX_LARGE_WORD; ?></option>
                            <option value="smaller"><?php echo SMALLER_WORD; ?></option>
                            <option value="larger"><?php echo LARGER_WORD; ?></option>
                            <option value="initial"><?php echo INITIAL_LC_WORD; ?></option>
                            <option value="inherit"><?php echo INHERIT_LC_WORD; ?></option>
						</select> 
                      </td>					
					  <td align="right"><?php echo COLOR_WORD; ?>: </td>
					  <td>
					      <input name="text_color" type="text" id="text_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> 
					      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'text_color');"><?php echo RGB_WORD; ?></span>
					  </td>
				    </tr>
				    <tr>
					  <td align="right">&nbsp;</td>
					  <td class="small_message" valign="top">&radic; = <?php echo WEBSAFE_WORD; ?></td>
					  <td align="right"><?php echo TEXT_ALIGN; ?>: </td>
					  <td>
					      <select name="text_align" id="text_align">
						  <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="left"><?php echo LEFT_1ST_CAP_WORD; ?></option>
                          <option value="center"><?php echo CENTER_WORD; ?></option>
                          <option value="right"><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                          <option value="justify"><?php echo JUSTIFY_WORD; ?></option>
                          </select>
					  </td>
					  
                      <td align="right"><?php echo INDENT_WORD; ?>: </td>
                      <td colspan="3">
                      	<input name="text_indent" type="text" id="text_indent" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="text_indent_units" id="text_indent_units" onChange="CheckFormatOnUnitSelect(this.id, 'text_indent', 0);">
                       		<option value="-1" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                      </td>
					  <td align="right"><?php echo EDIT_CSS_WHITE_SPACE; ?>: </td>
					  <td>
                      	<select name="white_space" id="white_space">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value='normal'><?php echo NORMAL_WORD; ?></option>
                         <option value='nowrap'><?php echo NO_WRAP_WORD; ?></option>
                         <option value='pre'><?php echo PRE_WORD; ?></option>
                         <option value='pre-line'><?php echo PRE_LINE_WORD; ?></option>
                         <option value='pre-wrap'><?php echo PRE_WRAP_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value='inherit'><?php echo INHERIT_WORD; ?></option>
					     </select>
                      </td>
				    </tr>
					<tr>
					  <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
					  <td>
					      <select name="weight" id="weight">
					   <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					   <option value="normal"><?php echo NORMAL_WORD; ?></option>
					   <option value="bold"><?php echo BOLD_WORD; ?></option>
					   <option value="bolder"><?php echo BOLDER_WORD; ?></option>
					   <option value="lighter"><?php echo LIGHTER_WORD; ?></option>
					   <option value="100">100</option>
					   <option value="200">200</option>
					   <option value="300">300</option>
					   <option value="400">400</option>
					   <option value="500">500</option>
					   <option value="600">600</option>
					   <option value="700">700</option>
					   <option value="800">800</option>
					   <option value="900">900</option>
					   </select>
					  </td>
					  <td align="right"><?php echo LETTER_SPACING; ?>:</td>
					  <td colspan="2">
                       <input name="letter_spacing" type="text" id="letter_spacing" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
					   <select name="letter_spacing_units" id="letter_spacing_units" onChange="CheckLetterSpacing(this);">
					    <option value="-1"><?php echo _NOT_SELECTED_; ?></option>
					    <option value="0"><?php echo NORMAL_WORD; ?></option>
					    <option value="1">px</option>
                        <option value="2">%</option>
                        <option value="3">em</option>
                        <option value="4">pt</option>
                        <option value="5">pc</option>
                        <option value="6">cm</option>
                        <option value="7">mm</option>
                        <option value="8">in</option>
                        <option value="9">rem</option>
                        <option value="10">vw</option>
                        <option value="11">vh</option>
                        <option value="12">vmin</option>
                        <option value="13">vmax</option>
                        <option value="14">ch</option>
					    <option value="15"><?php echo INITIAL_WORD; ?></option>
					    <option value="16"><?php echo INHERIT_WORD; ?></option>
					   </select>
					  </td>  
					  <td align="right"><?php echo LINE_HEIGHT; ?>: </td>
					  <td colspan="2" >
					   <input name="line_height" type="text" id="line_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="line_height_units" id="line_height_units" onChange="CheckLineHeight(this);">
                       		<option value="-1"><?php echo _NOT_SELECTED_; ?></option>
						    <option value="0"><?php echo NORMAL_WORD; ?></option>
						    <option value="1">Multiplier</option>
                            <option value="2">px</option>
                            <option value="3">%</option>
                            <option value="4">em</option>
                            <option value="5">pt</option>
                            <option value="6">pc</option>
                            <option value="7">cm</option>
                            <option value="8">mm</option>
                            <option value="9">in</option>
                            <option value="10">rem</option>
                            <option value="11">vw</option>
                            <option value="12">vh</option>
                            <option value="13">vmin</option>
                            <option value="14">vmax</option>
                            <option value="15">ch</option>
                            <option value="16"><?php echo INHERIT_WORD; ?></option>
                            <option value="17"><?php echo INITIAL_WORD; ?></option>
						</select>
					  </td>
					  <td class="small_message" align="right" valign="bottom" colspan="2"><?php echo EDIT_CSS_CLICK_NONE_MSG; ?></td>
					</tr>
				    <tr>
					  <td colspan="10">
					    <table border="0" width="100%">
					      <tr>
						    <td align="center">
							   <?php echo ITALIC_WORD; ?>: 
							   <input name="italic" type="checkbox" id="italic" value="1" />
						    </td>
						    <td align="center">
						       <?php echo UNDERLINE_WORD; ?>: 
						       <input name="underline" type="checkbox" id="underline" value="1" />
						    </td>
						    <td align="center">
						       <?php echo OVERLINE_WORD; ?>: 
						       <input name="overline" type="checkbox" id="overline" value="1" />
						    </td>
						    <td align="center">
						       <?php echo BLINK_WORD; ?>: 
						       <input name="blink" type="checkbox" id="blink" value="1" />
						    </td>
						    <td align="center">
						       <?php echo LINETHROUGH_WORD; ?>: 
						       <input name="linethrough" type="checkbox" id="linethrough" value="1" />
						    </td>
						    <td align="center">
						       <?php echo OBLIQUE_WORD; ?>: 
						       <input name="oblique" type="checkbox" id="oblique" value="1" />
						    </td>
						    <td align="center">
						       <?php echo SMALL_CAPS; ?>: 
						       <input name="small_caps" type="checkbox" id="small_caps" value="1" />
						    </td>
                            <td align="center">
						       <?php echo NONE_WORD; ?>: 
						       <input name="no_text_decoration" type="checkbox" id="no_text_decoration" value="1" onChange="text_decoration_none_clicked();" />
						    </td>
                            <td align="center">
						       <?php echo TEXT_TRANSFORM; ?>: 
						       <select name="text_transform" id="text_transform">
                               	 <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                                 <option value="capitalize"><?php echo CAPITALIZE_WORD; ?></option>
                                 <option value="uppercase"><?php echo UPPERCASE_WORD; ?></option>
                                 <option value="lowercase"><?php echo LOWERCASE_WORD; ?></option>
                                 <option value="initial"><?php echo INITIAL_WORD; ?></option>
                                 <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                               </select>
						    </td>
						  </tr>
					    </table>
                        <table border="0" width="100%">
                          <tr>
                             <td align="center">
                                <?php echo SHADOW_WORD; ?>:
                                <input name="text_shadow" type="checkbox" id="text_shadow" value="1" onClick="enable_disable_shadow();" /> 
                            </td>
                            <td align="center">
                                <?php echo COLOR_WORD; ?>: 
                                  <input name="shadow_color" type="text" id="shadow_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'shadow_color');"><?php echo RGB_WORD; ?></span>						  </td>
                            <td align="center">
                                <?php echo X_OFFSET_WORD; ?>: 
                                  <input name="shadow_x_offset" type="text" id="shadow_x_offset" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                           <td align="center">
                                <?php echo Y_OFFSET_WORD; ?>: 
                                  <input name="shadow_y_offset" type="text" id="shadow_y_offset" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                           <td align="center">
                                <?php echo BLUR_WORD; ?>: 
                                  <input name="shadow_blur" type="text" id="shadow_blur" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                         </tr>
                       </table>
					  </td>
				    </tr>
			      </table>
			    </td>
			   </tr>
             </table>
             
             <table border="1" width="100%" id="margin_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
                   
                 	<tr>
                    	<td colspan="2" rowspan="6" style="border-right:medium #666666 double;">
                       
                       <table width="100%" border="0">
                       <tr>
                       	<td colspan="6"><span class="bold"><?php echo SIZE_WORD; ?></span></td>
                       </tr>
                       <tr>
                       	<td align="right">
                       <?php echo WIDTH_WORD; ?>: 
                       </td>
					   <td style="position:relative;">
					     <input name="width" type="text" id="width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="width_units" id="width_units" onChange="CheckFormatOnUnitSelect(this.id, 'width', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
                         </td>
                         <td align="right">
                         <?php echo MIN_WIDTH; ?>:
                         </td>
                         <td>
					     <input name="min_width" type="text" id="min_width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="min_width_units" id="min_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'min_width', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
                         </td>
                         <td align="right">
                         <?php echo MAX_WIDTH; ?>: 
                         </td>
                         <td>
					     <input name="max_width" type="text" id="max_width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="max_width_units" id="max_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'max_width', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
                       </td>
                       </tr>
                       <tr>
                       	<td align="right">
                        <?php echo HEIGHT_WORD; ?>: 
                        </td>
					   <td>
					     <input name="height" type="text" id="height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="height_units" id="height_units" onChange="CheckFormatOnUnitSelect(this.id, 'height', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
                         </td>
                         <td align="right">
                         <?php echo MIN_HEIGHT; ?>:
                         </td>
                         <td>
					     <input name="min_height" type="text" id="min_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="min_height_units" id="min_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'min_height', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
                         </td>
                         <td align="right">
                         <?php echo MAX_HEIGHT; ?>:
                         </td>
                         <td>
					     <input name="max_height" type="text" id="max_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="max_height_units" id="max_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'max_height', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
                          <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
					   </td>
                       </tr>
                       </table>
                       
                       <hr />
                       
                       <table width="100%" border="0">
                       <tr>
                       	<td colspan="3"><span class="bold"><?php echo ALIGNMENT_WORD; ?></span></td>
                       </tr>
                       <tr>
                        <td align="right"><?php echo VERTICAL_ALIGN; ?>: </td>
                        <td style="width:15%;">
                          <select name="vertical_align" id="vertical_align" OnChange="VerticalAlignChange(this.value);">
                          <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="baseline"><?php echo BASELINE_WORD; ?></option>
                          <option value="sub"><?php echo SUB_WORD; ?></option>
                          <option value="super"><?php echo SUPER_WORD; ?></option>
                          <option value="top"><?php echo TOP_1ST_CAP_WORD; ?></option>
                          <option value="text-top"><?php echo TEXT_TOP; ?></option>
                          <option value="middle"><?php echo MIDDLE_WORD; ?></option>
                          <option value="bottom"><?php echo BOTTOM_1ST_CAP_WORD; ?></option>
                          <option value="text-bottom"><?php echo TEXT_BOTTOM; ?></option>
                          <option value="length"><?php echo LENGTH_WORD; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                          </select>
                        </td>
                        <td>
                         <input name="vertical_align_length" type="text" id="vertical_align_length" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="vertical_align_length_units" id="vertical_align_length_units" onChange="CheckFormatOnUnitSelect(this.id, 'vertical_align_length', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
					     </select>
                        </td>
                       </tr>
                       <tr>
                        <td align="right"><?php echo CONTENT_ALIGNMENT; ?>: </td>
                        <td colspan="2">
                          <select name="align_content" id="align_content">
                          <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="stretch"><?php echo MANAGE_CUSTOM_FONTS_STRETCH; ?></option>
                          <option value="center"><?php echo CENTER_WORD; ?></option>
                          <option value="flex-start"><?php echo EDIT_CSS_FLEX_START; ?></option>
                          <option value="flex-end"><?php echo EDIT_CSS_FLEX_END; ?></option>
                          <option value="space-between"><?php echo EDIT_CSS_SPACE_BETWEEN; ?></option>
                          <option value="space-around"><?php echo EDIT_CSS_SPACE_AROUND; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                          </select>
                        </td>
                       </tr>
                       <tr>
                        <td align="right"><?php echo ITEM_ALIGNMENT; ?>: </td>
                        <td colspan="2">
                          <select name="align_items" id="align_items">
                          <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="stretch"><?php echo MANAGE_CUSTOM_FONTS_STRETCH; ?></option>
                          <option value="center"><?php echo CENTER_WORD; ?></option>
                          <option value="flex-start"><?php echo EDIT_CSS_FLEX_START; ?></option>
                          <option value="flex-end"><?php echo EDIT_CSS_FLEX_END; ?></option>
                          <option value="baseline"><?php echo BASELINE_WORD; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                          </select>
                        </td>
                       </tr>
                       <tr>
                        <td align="right"><?php echo SELF_ALIGNMENT; ?>: </td>
                        <td colspan="2">
                          <select name="align_self" id="align_self">
                          <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="auto"><?php echo AUTO_WORD; ?></option>
                          <option value="stretch"><?php echo MANAGE_CUSTOM_FONTS_STRETCH; ?></option>
                          <option value="center"><?php echo CENTER_WORD; ?></option>
                          <option value="flex-start"><?php echo EDIT_CSS_FLEX_START; ?></option>
                          <option value="flex-end"><?php echo EDIT_CSS_FLEX_END; ?></option>
                          <option value="baseline"><?php echo BASELINE_WORD; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                          </select>
                        </td>
                       </tr>
                       </table>
                                   
                       </td>
                       
					   <td colspan="8" class="bold" style="padding-left:3px;"><?php echo PADDING_WORD; ?> </td>
				     </tr>
                   	<tr>
                   		<td align="right">
                       <?php echo TOP_1ST_CAP_WORD; ?>:</td>					  
					   <td>
                       <input name="padding_top" type="text" id="padding_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_top_units" id="padding_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_top', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
					   </td>
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>:</td>
					   <td>
                       <input name="padding_right" type="text" id="padding_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_right_units" id="padding_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_right', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>:</td>
					   <td>
                       <input name="padding_bottom" type="text" id="padding_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_bottom_units" id="padding_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_bottom', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>:</td>
                       <td>
                       <input name="padding_left" type="text" id="padding_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_left_units" id="padding_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_left, 0');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
                       
                     </tr>
                     <tr>
                     	<td colspan="8">
                        	<hr />
                        </td>
                     </tr>                  
				     <tr>
					   <td colspan="4" class="bold" style="padding-left:3px;"><?php echo MARGIN_WORD; ?> </td>
                       <td colspan="4" align="center"><span class="small_message"><?php echo EDIT_CSS_CLICK_AUTO_MSG; ?></span></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="margin_top" type="text" id="margin_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="margin_top_units" id="margin_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_top', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						  </select> 
                       </td>					  
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_right" type="text" id="margin_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="margin_right_units" id="margin_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_right', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						 </select>
					   </td>
                       <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_bottom" type="text" id="margin_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="margin_bottom_units" id="margin_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_bottom', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						 </select>
					   </td>					
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_left" type="text" id="margin_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         	<select name="margin_left_units" id="margin_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_left', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
					    </select> 
					   </td>
                       
				     </tr>
                     <tr>
                     	<td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_top_auto" type="checkbox" id="margin_top_auto" value="1" onChange="margin_auto_clicked('top')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_right_auto" type="checkbox" id="margin_right_auto" value="1" onChange="margin_auto_clicked('right')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_bottom_auto" type="checkbox" id="margin_bottom_auto" value="1" onChange="margin_auto_clicked('bottom')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_left_auto" type="checkbox" id="margin_left_auto" value="1" onChange="margin_auto_clicked('left')" />
                        </td>
                        
                     </tr>
			       </table>
                   
                </td>
               </tr>
              </table>
                   
               <table border="1" width="100%" id="position_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo POSITION_WORD; ?></td>
				     </tr>
				     <tr>
                       <td align="right"><?php echo POSITIONING_WORD; ?>: </td>
					   <td><select name="position" id="position">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="absolute"><?php echo ABSOLUTE_WORD; ?></option>
					     <option value="fixed"><?php echo FIXED_WORD; ?></option>
                         <option value="relative"><?php echo RELATIVE_WORD; ?></option>
                         <option value="static"><?php echo STATIC_WORD; ?></option>
                         <option value="sticky"><?php echo STICKY_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="position_left" type="text" id="position_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="position_left_units" id="position_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_left', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
                            <option value="14"><?php echo AUTO_WORD; ?></option>
					      </select>
                        </td>					  
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_top" type="text" id="position_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_top_units" id="position_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_top', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
                            <option value="14"><?php echo AUTO_WORD; ?></option>
					     </select>
					   </td>					
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_right" type="text" id="position_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_right_units" id="position_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_right', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
                            <option value="14"><?php echo AUTO_WORD; ?></option>
						  </select>
					   </td>
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_bottom" type="text" id="position_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_bottom_units" id="position_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_bottom', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
                            <option value="14"><?php echo AUTO_WORD; ?></option>
						  </select>
					   </td>
				     </tr>
                     <tr>
                       <td align="right"><?php echo DISPLAY_WORD; ?>: </td>
					   <td>
                       <select name="display" id="display">
						  <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <option value="none"><?php echo NONE_WORD; ?></option>
					      <option value="inline"><?php echo INLINE_WORD; ?></option>
					      <option value="block"><?php echo BLOCK_WORD; ?></option>
                          <option value="inline-block"><?php echo EDIT_CSS_INLINE_BLOCK; ?></option>
					      <option value="list-item"><?php echo EDIT_CSS_LIST_ITEM; ?></option>
					      <option value="run-in"><?php echo EDIT_CSS_RUN_IN; ?></option>
					      <option value="compact"><?php echo COMPACT_WORD; ?></option>
					      <option value="marker"><?php echo MARKER_WORD; ?></option>
					      <option value="table"><?php echo TABLE_WORD; ?></option>
					      <option value="inline-table"><?php echo EDIT_CSS_INLINE_TABLE; ?></option>
					      <option value="table-row-group"><?php echo EDIT_CSS_TABLE_ROW_GROUP; ?></option>
					      <option value="table-footer-group"><?php echo EDIT_CSS_TABLE_FOOTER_GROUP; ?></option>
					      <option value="table-row"><?php echo EDIT_CSS_TABLE_ROW; ?></option>
					      <option value="table-column-group"><?php echo EDIT_CSS_TABLE_COLUMN_GROUP; ?></option>
					      <option value="table-column"><?php echo EDIT_CSS_TABLE_COLUMN; ?></option>
					      <option value="table-cell"><?php echo EDIT_CSS_TABLE_CELL; ?></option>
					      <option value="table-caption"><?php echo EDIT_CSS_TABLE_CAPTION; ?></option>
                          <option value="flex"><?php echo EDIT_CSS_FLEX; ?></option>
                          <option value="inline-flex"><?php echo EDIT_CSS_INLINE_FLEX; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					      </select>
                       </td>
                       <td align="right"><?php echo VISIBILITY_WORD; ?>: </td>
                       <td>
                       	 <select name="visibility" id="visibility">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
                         <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="collapse"><?php echo COLLAPSE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo EDIT_CSS_Z_INDEX; ?>:</td>
					   <td>
                       <input name="z_index" type="text" id="z_index" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                        </td>					  					
					   <td align="right"><?php echo FLOAT_WORD; ?>: </td>
					   <td colspan="3">
                       <select name="float" id="float">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value='left'><?php echo LEFT_1ST_CAP_WORD; ?></option>
                         <option value='right'><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                         <option value='none'><?php echo NONE_WORD; ?></option>
                         <option value='inherit'><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                     	<td align="right"><?php echo OVERFLOW_WORD; ?>:</td>
					   <td>
                        <select name="overflow" id="overflow" onChange="CheckOverflowLists(this.value, 'xy');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                       </td>
                     	<td align="right"><?php echo OVERFLOW_WORD . "-X"; ?>:</td>
					 	<td>
                        <select name="overflow_x" id="overflow_x" onChange="CheckOverflowLists(this.value, 'x');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                    	</td>
                     	<td align="right"><?php echo OVERFLOW_WORD . "-Y"; ?>:</td>
					 	<td>
                        <select name="overflow_y" id="overflow_y" onChange="CheckOverflowLists(this.value, 'y');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                    	</td>
                        <td align="right"><?php echo EDITOR_CLEAR; ?>: </td>
					   <td colspan="3">
                       <select name="clear" id="clear">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="left"><?php echo LEFT_1ST_CAP_WORD; ?></option>
                         <option value="right"><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                         <option value="both"><?php echo BOTH_WORD; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
                       </td>
                     </tr>
                     <tr>
					   <td align="right" colspan="2"><?php echo CLIPPING_WORD; ?>:</td>
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="clip_top" type="text" id="clip_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="clip_top_units" id="clip_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_top', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
                        </td>					  
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_right" type="text" id="clip_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="clip_right_units" id="clip_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_right', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
					     </select>
					   </td>					
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_bottom" type="text" id="clip_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 					
                         <select name="clip_bottom_units" id="clip_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_bottom', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_left" type="text" id="clip_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="clip_left_units" id="clip_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_left', 0);">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>
		   
		     <table border="1" width="100%" id="border_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo BORDER_WORD; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo BORDER_WORD; ?>: </td>
					   <td>
					    <input name="border" type="text" id="border" value="" size="6" onChange="CheckBorderParams(this);" onClick="TextFieldClick(this);" onBlur="TextFieldBlur(this);" />
                      	<select name="border_units" id="border_units" onChange="CheckFormatOnUnitSelect(this.id, 'border', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
					   </td>					  
					   <td align="right"><?php echo BORDER_COLOR; ?>: </td>
					   <td>
					     <input name="border_color" type="text" id="border_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'border_color');"> <?php echo RGB_WORD; ?></span>
                         </td>
					   <td align="right"><?php echo BORDER_STYLE; ?>: </td>
					   <td>
                       <select name="border_style" id="border_style" onChange="CheckBorderParams(this);">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="dotted"><?php echo DOTTED_WORD; ?></option>
                         <option value="dashed"><?php echo DASHED_WORD; ?></option>
                         <option value="solid"><?php echo SOLID_WORD; ?></option>
                         <option value="double"><?php echo DOUBLE_WORD; ?></option>
                         <option value="groove"><?php echo GROOVE_WORD; ?></option>
                         <option value="ridge"><?php echo RIDGE_WORD; ?></option>
                         <option value="inset"><?php echo INSET_WORD; ?></option>
                         <option value="outset"><?php echo OUTSET_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
                       <td><?php echo TOP_1ST_CAP_WORD; ?>: <input name="border_top" type="checkbox" id="border_top" value="1" /> </td>
                       <td><?php echo BOTTOM_1ST_CAP_WORD; ?>: <input name="border_bottom" type="checkbox" id="border_bottom" value="1" /> </td>
                       <td><?php echo LEFT_1ST_CAP_WORD; ?>: <input name="border_left" type="checkbox" id="border_left" value="1" /> </td>
                       <td><?php echo RIGHT_1ST_CAP_WORD; ?>: <input name="border_right" type="checkbox" id="border_right" value="1" /> </td>
				     </tr>
                  </table>
                  <table width="100%" border="0">
                     <tr>
                       <td align="right"><?php echo EDIT_CSS_OUTLINE_STYLE; ?>: </td>
					   <td>
                       <select name="outline_style" id="outline_style">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="dotted"><?php echo DOTTED_WORD; ?></option>
                         <option value="dashed"><?php echo DASHED_WORD; ?></option>
                         <option value="solid"><?php echo SOLID_WORD; ?></option>
                         <option value="double"><?php echo DOUBLE_WORD; ?></option>
                         <option value="groove"><?php echo GROOVE_WORD; ?></option>
                         <option value="ridge"><?php echo RIDGE_WORD; ?></option>
                         <option value="inset"><?php echo INSET_WORD; ?></option>
                         <option value="outset"><?php echo OUTSET_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
					   </td>
                       <td align="right"><?php echo EDIT_CSS_BORDER_COLLAPSE; ?>: </td>
					   <td>
                       <select name="border_collapse" id="border_collapse">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="collapse"><?php echo COLLAPSE_WORD; ?></option>
                         <option value="separate"><?php echo SEPARATE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
					   </td>
                       <td align="right"><?php echo EDIT_CSS_BOX_SIZING; ?>: </td>
					   <td>
                       <select name="box_sizing" id="box_sizing">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="content-box"><?php echo EDIT_CSS_CONTENT_BOX; ?></option>
                         <option value="border-box"><?php echo EDIT_CSS_BORDER_BOX; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
					   </td>
				     </tr>
                  </table>
                  <table  width="100%" border="0">
                     <tr>
					   <td align="right" class="bold"><?php echo RADIUS_WORD; ?></td>
					   <td align="right">
                       <?php echo EDIT_CSS_TOP_LEFT; ?>: </td>					  
					   <td>
                       <input type="text" name="radius_top_left" id="radius_top_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_top_left_units" id="radius_top_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_top_left', 0);">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_TOP_RIGHT; ?>: </td>
					   <td>
                       <input type="text" name="radius_top_right" id="radius_top_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_top_right_units" id="radius_top_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_top_right', 0);">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_BOTTOM_RIGHT; ?>: </td>
					   <td>
                       <input type="text" name="radius_bottom_right" id="radius_bottom_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_bottom_right_units" id="radius_bottom_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_bottom_right', 0);">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_BOTTOM_LEFT; ?>: </td>
                       <td>
                       <input type="text" name="radius_bottom_left" id="radius_bottom_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_bottom_left_units" id="radius_bottom_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_bottom_left', 0);">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>                        
                       </select> 
                       </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
             <table border="1" width="100%" id="background_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="5" class="bold"><?php echo BACKGROUND_WORD; ?></td>
                       <td><?php echo EDIT_CSS_FOREGROUND_OPAQUE_1; ?></td>
                       <td colspan="2" class="bold" style="border-left:medium #666666 double; padding-left:3px;"><?php echo EDIT_CSS_TABLE_LAYOUT; ?></td>
                       <td colspan="2" class="bold"  style="border-left:medium #666666 double; padding-left:3px;"><?php echo EDIT_CSS_CURSOR; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					   <td>
					     <input name="bkgd_color" type="text" id="bkgd_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'bkgd_color');"> <?php echo RGB_WORD; ?></span>
					   </td>
                       <td align="right">
					   	<?php echo TRANSPARENT_WORD; ?>: 
                        <input name="bkgd_transparent" type="checkbox" id="bkgd_transparent" value="1" onChange="enable_disable_background_color(this.id);" />
                       </td>
                       
					   <td align="right"><?php echo OPACITY_WORD; ?>: </td>
					   <td>
					     <input name="bkgd_opacity" type="text" id="bkgd_opacity" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> % 
					   </td>
                       <td align="right">
					   	<?php echo EDIT_CSS_FOREGROUND_OPAQUE_2; ?>: 
                        <input name="bkgd_rgba" type="checkbox" id="bkgd_rgba" value="1" onChange="enable_disable_background_color(this.id);" />
                       </td>
					   <td align="right"  style="border-left:medium #666666 double;"><?php echo EDIT_CSS_TABLE_LAYOUT; ?>:</td>
					   <td>
                       <select name="table_layout" id="table_layout">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="fixed"><?php echo FIXED_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
                       </td>
                       <td align="right" style="border-left:medium #666666 double;">Cursor: </td>
					   <td>
                       <select name="cursor" id="cursor">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="pointer"><?php echo POINTER_WORD; ?></option>
                         <option value="crosshair"><?php echo CROSSHAIR_WORD; ?></option>
                         <option value="default"><?php echo DEFAULT_WORD; ?></option>
                         <option value="wait"><?php echo WAIT_WORD; ?></option>
                         <option value="help"><?php echo HELP_WORD; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="alias"><?php echo ALIAS_WORD; ?></option>
                         <option value="all-scroll"><?php echo EDIT_CSS_ALL_SCROLL; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="cell"><?php echo CELL_WORD; ?></option>
                         <option value="context-menu"><?php echo EDIT_CSS_CONTEXT_MENU; ?></option>
                         <option value="col-resize"><?php echo EDIT_CSS_COLUMN_RESIZE; ?></option>
                         <option value="row-resize"><?php echo EDIT_CSS_ROW_RESIZE; ?></option>
                         <option value="copy"><?php echo COPY_WORD; ?></option>
                         <option value="move"><?php echo MOVE_WORD; ?></option>
                         <option value="no-drop"><?php echo EDIT_CSS_NO_DROP; ?></option>
                         <option value="not-allowed"><?php echo EDIT_CSS_NOT_ALLOWED; ?></option>
                         <option value="progress"><?php echo PROGRESS_WORD; ?></option>
                         <option value="text"><?php echo TEXT_WORD; ?></option>
                         <option value="vertical-text"><?php echo EDIT_CSS_VERTICAL_TEXT; ?></option>
                         <option value="e-resize"><?php echo EDIT_CSS_EAST_RESIZE; ?></option>
                         <option value="ew-resize"><?php echo EDIT_CSS_EAST_WEST_RESIZE; ?></option>
                         <option value="n-resize"><?php echo EDIT_CSS_NORTH_RESIZE; ?></option>
                         <option value="ne-resize"><?php echo EDIT_CSS_NORTH_EAST_RESIZE; ?></option>
                         <option value="nesw-resize"><?php echo EDIT_CSS_NORTH_EAST_SOUTH_WEST_RESIZE; ?></option>
                         <option value="ns-resize"><?php echo EDIT_CSS_NORTH_SOUTH_RESIZE; ?></option>
                         <option value="nw-resize"><?php echo EDIT_CSS_NORTH_WEST_RESIZE; ?></option>
                         <option value="nwse-resize"><?php echo EDIT_CSS_NORTH_WEST_SOUTH_EAST_RESIZE; ?></option>
                         <option value="s-resize"><?php echo EDIT_CSS_SOUTH_RESIZE; ?></option>
                         <option value="se-resize"><?php echo EDIT_CSS_SOUTH_EAST_RESIZE; ?></option>
                         <option value="sw-resize"><?php echo EDIT_CSS_SOUTH_WEST_RESIZE; ?></option>
                         <option value="w-resize"><?php echo EDIT_CSS_WEST_RESIZE; ?></option>
                         <option value="zoom-in"><?php echo EDIT_CSS_ZOOM_IN; ?></option>
                         <option value="zoom-out"><?php echo EDIT_CSS_ZOOM_OUT; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
					   </td>
				     </tr>
			       </table>
                   <hr />
                   <table border="0" width="100%">
                   	<tr>
                    	<td colspan="2" class="bold"><?php echo BACKGROUND_GRADIENT; ?></td>
                        <td>&nbsp;</td><td style="padding-left:25px;">1</td><td style="padding-left:25px;">2</td><td style="padding-left:25px;">3</td><td style="padding-left:25px;">4</td><td style="padding-left:25px;">5</td><td style="padding-left:25px;">6</td><td style="padding-left:25px;">7</td><td style="padding-left:25px;">8</td>
                    </tr>
                    <tr>
                    	<td>
                        	<?php echo TYPE_WORD; ?>:
                            <select name="gradient_type" id="gradient_type" onChange="enable_disable_gradient();">
        	                   	<option value="0" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
    	    			        <option value="1"><?php echo LINEAR_WORD; ?></option>
	                  			<option value="2"><?php echo RADIAL_WORD; ?></option>
                             </select>
                        </td>
                        <td>
                        	<?php echo ANGLE_WORD; ?>:
                            <select name="gradient_angle" id="gradient_angle">
                            	<option value="180">180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                                <option value="170">170 <?php echo DEGREES_WORD; ?></option>
                                <option value="160">160 <?php echo DEGREES_WORD; ?></option>
                                <option value="150">150 <?php echo DEGREES_WORD; ?></option>
                                <option value="135">135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                                <option value="120">120 <?php echo DEGREES_WORD; ?></option>
                                <option value="110">110 <?php echo DEGREES_WORD; ?></option>
                                <option value="100">100 <?php echo DEGREES_WORD; ?></option>
                                <option value="90">90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                                <option value="80">80 <?php echo DEGREES_WORD; ?></option>
                                <option value="70">70 <?php echo DEGREES_WORD; ?></option>
                                <option value="60">60 <?php echo DEGREES_WORD; ?></option>
                                <option value="45">45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                                <option value="30">30 <?php echo DEGREES_WORD; ?></option>
                                <option value="20">20 <?php echo DEGREES_WORD; ?></option>
                                <option value="10">10 <?php echo DEGREES_WORD; ?></option>
        	                   	<option value="0">0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
    	    			        <option value="350">350 <?php echo DEGREES_WORD; ?></option>
                                <option value="340">340 <?php echo DEGREES_WORD; ?></option>
                                <option value="330">330 <?php echo DEGREES_WORD; ?></option>
                                <option value="315">315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                                <option value="300">300 <?php echo DEGREES_WORD; ?></option>
                                <option value="290">290 <?php echo DEGREES_WORD; ?></option>
                                <option value="280">280 <?php echo DEGREES_WORD; ?></option>
                                <option value="270">270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                                <option value="260">260 <?php echo DEGREES_WORD; ?></option>
                                <option value="250">250 <?php echo DEGREES_WORD; ?></option>
                                <option value="240">240 <?php echo DEGREES_WORD; ?></option>
                                <option value="225">225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                                <option value="210">210 <?php echo DEGREES_WORD; ?></option>
	                  			<option value="200">200 <?php echo DEGREES_WORD; ?></option>
                                <option value="190">190 <?php echo DEGREES_WORD; ?></option>
                             </select>
                        </td>
                       	<td><?php echo COLOR_WORD; ?>:</td>
                        <td>	
                            <input type="text" name="gradient_color_1" id="gradient_color_1" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_1');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_2" id="gradient_color_2" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_2');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_3" id="gradient_color_3" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_3');"> <?php echo RGB_WORD; ?></span>
                            
                        </td>
                        <td>
                            <input type="text" name="gradient_color_4" id="gradient_color_4" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_4');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_5" id="gradient_color_5" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_5');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_6" id="gradient_color_6" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_6');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_7" id="gradient_color_7" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_7');"> <?php echo RGB_WORD; ?></span>
                        </td>
                        <td>
                            <input type="text" name="gradient_color_8" id="gradient_color_8" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'gradient_color_8');"> <?php echo RGB_WORD; ?></span>
                        </td>
                     </tr>
                     <tr>
                       	<td>&nbsp;</td>
                        <td>
                        	<?php echo REPEAT_WORD; ?>:
                            <select name="gradient_repeat" id="gradient_repeat">
        	                   	<option value="0" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                                <option value="2">2</option>
                                <option value="3">3</option>
                                <option value="4">4</option>
                                <option value="5">5</option>
                                <option value="6">6</option>
                                <option value="7">7</option>
                                <option value="8">8</option>
                                <option value="9">9</option>
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="30">30</option>
                                <option value="40">40</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                                <option value="200">200</option>
                             </select>
                       	</td>
                       	<td><?php echo OPACITY_WORD; ?>:</td><td>
                            <select name="gradient_opacity_1" id="gradient_opacity_1">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_2" id="gradient_opacity_2">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_3" id="gradient_opacity_3">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_4" id="gradient_opacity_4">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_5" id="gradient_opacity_5">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_6" id="gradient_opacity_6">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_7" id="gradient_opacity_7">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                        <td>
                            <select name="gradient_opacity_8" id="gradient_opacity_8">
                            	<option value="100">100%</option>
                                <option value="90">90%</option>
                                <option value="80">80%</option>
                                <option value="70">70%</option>
                                <option value="60">60%</option>
                                <option value="50">50%</option>
                                <option value="40">40%</option>
                                <option value="30">30%</option>
                                <option value="20">20%</option>
                                <option value="10">10%</option>
                                <option value="0">0%</option>
                            </select>
                        </td>
                      </tr>
                   </table>
			     </td>
			   </tr>
	         </table>
             
             
             
             <table border="1" width="100%" id="background_img_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo EDIT_CSS_BACKGROUND_IMAGE; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo IMAGE_WORD; ?>: </td>
					   <td align="right" width="110">
                       <div id='preview1'><img alt='photo' src='/manage/theme/<?php echo $theme; ?>/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img1' /></div>
                       </td>					  
					   <td align="left" colspan="2">
                       <input type='file' name='file_browse1' id='file_browse1' onChange="upload_index=1; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse1&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview1','&lt;br /&gt;&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>				
					   <td align="right"><?php echo ATTACHMENT_WORD; ?>:</td>
					   <td><select name="background_attachment" id="background_attachment">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="fixed"><?php echo FIXED_WORD; ?></option>
					     <option value="scroll"><?php echo SCROLLING_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>
					   <td align="right"><?php echo REPEAT_WORD; ?>:</td>
					   <td><select name="background_repeat" id="background_repeat">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="repeat"><?php echo REPEAT_WORD; ?></option>
					     <option value="repeat-x"><?php echo EDIT_CSS_REPEAT_HORIZONTALLY; ?></option>
					     <option value="repeat-y"><?php echo EDIT_CSS_REPEAT_VERTICALLY; ?></option>
					     <option value="no-repeat"><?php echo EDIT_CSS_NO_REPEAT; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>
                       <td align="right">&nbsp;</td>
					   <td>&nbsp;</td>
				     </tr>
                     <tr>
					   <td align="center" colspan="4">
                       
                       	<!-- <input type="file" name="browse_image" id="browse_image" />	-->
                        <select name="background_image" id="background_image" onChange="UpdateImage(1);">
                       		<option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                       <?php
					   $file_arr = array();
					   
					   	if ($handle = opendir($path)) 
						{
							/* This is the correct way to loop over the directory. */
							while (false !== ($file = readdir($handle)))
							{
								if (($file != ".") && ($file != "..") && ($file != "tn") && ($file != "gallery") && ($file != "lightbox") && ($file != "orig"))
								{
									if (is_dir($path . "/" . $file))
									{
										$path2 = $path . "/" . $file;
										if ($handle2 = opendir($path2))
										{
											while (false !== ($file2 = readdir($handle2)))
											{
												if (($file2 != ".") && ($file2 != "..") && ($file2 != "tn") && ($file2 != "gallery") && ($file2 != "lightbox") && ($file2 != "orig"))
													$file_arr[] = $file . "/" . $file2;
											}
											closedir($handle2);
										}
									}
									else
										$file_arr[] = $file;
								}
							}
							closedir($handle);
							
							sort($file_arr);
							foreach($file_arr as $file)
							{
								if ($background_image == $file)
									echo "      <option value='$file' selected='selected'>$file</option>\n";
								else
									echo "      <option value='$file'>$file</option>\n";
							}
					    } 
                       ?>
					     </select>
                       </td>
                       <td colspan="6">
                       <table border="1" width="100%">
                       <tr>
                       <td>
                       <table border="0" width="100%">
                       <tr>
                           <td align="right"><?php echo POSITION_WORD; ?>:</td>
                           <td><select name="background_position" id="background_position" onChange="enable_disable_background_positions();">
                             <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                             <option value="top left"><?php echo EDIT_CSS_TOP_LEFT; ?></option>
                             <option value="top center"><?php echo EDIT_CSS_TOP_CENTER; ?></option>
                             <option value="top right"><?php echo EDIT_CSS_TOP_RIGHT; ?></option>
                             <option value="center left"><?php echo EDIT_CSS_CENTER_LEFT; ?></option>
                             <option value="center center"><?php echo EDIT_CSS_CENTER_CENTER; ?></option>
                             <option value="center right"><?php echo EDIT_CSS_CENTER_RIGHT; ?></option>
                             <option value="bottom left"><?php echo EDIT_CSS_BOTTOM_LEFT; ?></option>
                             <option value="bottom center"><?php echo EDIT_CSS_BOTTOM_CENTER; ?></option>
                             <option value="bottom right"><?php echo EDIT_CSS_BOTTOM_RIGHT; ?></option>
                             <option value="xpos ypos"><?php echo EDIT_CSS_XPOS_YPOS; ?></option>
                             <option value="initial"><?php echo INITIAL_WORD; ?></option>
	                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                             </select></td>
                           <td align="right">X:</td>
                           <td><input name="background_position_x" type="text" id="background_position_x" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                           <td align="right">Y:</td>
                           <td><input name="background_position_y" type="text" id="background_position_y" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                           <td>
                             <select name="background_position_units" id="background_position_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_position_x', 0); CheckFormatOnUnitSelect(this.id, 'background_position_y', 0);">
                               	<option value="0">px</option>
                               	<option value="1">%</option>
                               	<option value="2">em</option>
                                <option value="3">pt</option>
                                <option value="4">pc</option>
                                <option value="5">cm</option>
                                <option value="6">mm</option>
                                <option value="7">in</option>
                                <option value="8">rem</option>
                                <option value="9">vw</option>
                                <option value="10">vh</option>
                                <option value="11">vmin</option>
                                <option value="12">vmax</option>
                                <option value="13">ch</option>
                             </select>
                           </td>
                        </tr>
                       </table>
                       
                       </td>       
                      </tr>
			       </table>
		
			     </td>
			   </tr>
                <tr>
                  <td colspan="3">&nbsp;</td>
                  <td colspan="7">
                    <table border="1" width="100%"><tr><td>
                    <table border="0" width="100%">
                      <tr>
                        <td align="right"><?php echo SIZE_WORD; ?>:</td>
                        <td>
                        <select name="background_size" id="background_size" onChange="enable_disable_background_sizes();">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="scale"><?php echo SCALE_WORD; ?></option>
                         <option value="cover"><?php echo COVER_WORD; ?></option>
                         <option value="contain"><?php echo CONTAIN_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                        </td>
                        <td align="right"><?php echo WIDTH_WORD; ?>:</td>
                        <td><input name="background_width" type="text" id="background_width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                        <td>
                         <select name="background_width_units" id="background_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_width', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                         </select>
                        </td>
                        <td align="right"><?php echo HEIGHT_WORD; ?>:</td>
                        <td><input name="background_height" type="text" id="background_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                        <td>
                          <select name="background_height_units" id="background_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_height', 0);">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                         </select>
                        </td>
                      </tr>
                    </table> 
                    </td></tr></table>
                  </td>
                </tr>
	         </table>
			 
	       </td>
	     </tr>
	   </table>
       
       <table border="1" width="100%" id="list_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="8" class="bold"><?php echo LIST_WORD; ?></td>
				     </tr>
				     <tr>
                       <td align="right"><?php echo TYPE_WORD; ?>: </td>
					   <td><select name="list_style_type" id="list_style_type">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="none"><?php echo NONE_WORD; ?></option>
					     <option value="disc"><?php echo DISC_WORD; ?></option>
					     <option value="circle"><?php echo CIRCLE_WORD; ?></option>
					     <option value="square"><?php echo SQUARE_WORD; ?></option>
					     <option value="decimal"><?php echo DECIMAL_WORD; ?></option>
					     <option value="decimal-leading-zero"><?php echo EDIT_CSS_DECIMAL_LEADING_ZERO; ?></option>
					     <option value="lower-roman"><?php echo EDIT_CSS_LOWER_ROMAN; ?></option>
					     <option value="upper-roman"><?php echo EDIT_CSS_UPPER_ROMAN; ?></option>
					     <option value="lower-alpha"><?php echo EDIT_CSS_LOWER_ALPHA; ?></option>
					     <option value="upper-alpha"><?php echo EDIT_CSS_UPPER_ALPHA; ?></option>
					     <option value="lower-greek"><?php echo EDIT_CSS_LOWER_GREEK; ?></option>
					     <option value="lower-latin"><?php echo EDIT_CSS_LOWER_LATIN; ?></option>
					     <option value="upper-latin"><?php echo EDIT_CSS_UPPER_LATIN; ?></option>
					     <option value="hebrew"><?php echo HEBREW_WORD; ?></option>
					     <option value="armenian"><?php echo ARMENIAN_WORD; ?></option>
					     <option value="gorgian"><?php echo GORGIAN_WORD; ?></option>
					     <option value="cjk-ideographic"><?php echo EDIT_CSS_CJK_IDEOGRAPHIC; ?></option>
					     <option value="hiragana"><?php echo EDIT_CSS_HIRAGANA; ?></option>
					     <option value="katakana"><?php echo EDIT_CSS_KATAKANA; ?></option>
					     <option value="hiragana-iroha"><?php echo EDIT_CSS_HIRAGANA_IROHA; ?></option>
					     <option value="katakana-iroha"><?php echo EDIT_CSS_KATAKANA_IROHA; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo POSITION_WORD; ?>: </td>
					   <td><select name="list_style_position" id="list_style_position">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="inside"><?php echo INSIDE_WORD; ?></option>
					     <option value="outside"><?php echo OUTSIDE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>					  
					   <td align="right"><?php echo IMAGE_WORD; ?>: </td>
					   <td align="right" width="110">
                       <div id='preview2'><img alt='photo' src='/manage/theme/<?php echo $theme; ?>/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img2' /></div>
                       </td>					
					   <td>
                       <input type='file' name='file_browse2' id='file_browse2' onChange="upload_index=2; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse2&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview2','&lt;br /&gt;&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>
					   <td>
                       	<select name="list_style_image" id="list_style_image" onChange="UpdateImage(2);">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					   <?php
						foreach($file_arr as $file)
						{
							if ($list_style_image == $file)
								echo "      <option value='$file' selected='selected'>$file</option>\n";
							else
								echo "      <option value='$file'>$file</option>\n";
						}
                       ?>
					     </select>
                       </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>

			<table border="1" width="100%" id="box_shadow_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="12"><?php echo BOX_SHADOW; ?></td>
                  </tr>
                  <tr>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="box_shadow_horizontal" id="box_shadow_horizontal" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="box_shadow_vertical" id="box_shadow_vertical" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_blur" id="box_shadow_blur" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_spread" id="box_shadow_spread" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_color" id="box_shadow_color" value="" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_site_styles', 'box_shadow_color');"><?php echo RGB_WORD; ?></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="box_shadow_inset" id="box_shadow_inset" value="1" /></td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
            
            <table border="1" width="100%" id="content_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="6"><?php echo CONTENT_WORD; ?></td>
                  </tr>
                  <tr>
                    <td align="right"><?php echo CONTENT_WORD; ?>: </td>
                    <td>
                    	<select name="content" id="content" onChange="enable_disable_content_text(); display_text_instructions(this.value);">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="string"><?php echo STRING_WORD; ?></option>
                            <option value="url"><?php echo EDIT_MENU_ITEMS_URL; ?></option>
                            <option value="attr"><?php echo ATTRIBUTE_WORD; ?></option>
                            <option value="normal"><?php echo NORMAL_WORD; ?></option>
                            <option value="none"><?php echo NONE_WORD; ?></option>
                            <option value="counter"><?php echo COUNTER_WORD; ?></option>
                            <option value="open-quote"><?php echo OPEN_QUOTE; ?></option>
                            <option value="close-quote"><?php echo CLOSE_QUOTE; ?></option>
                            <option value="no-open-quote"><?php echo NO_OPEN_QUOTE; ?></option>
                            <option value="no-close-quote"><?php echo NO_CLOSE_QUOTE; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                    <td align="right"><?php echo EDIT_CSS_CONTENT_TEXT; ?>: </td>
                    <td>
                    	<textarea name="content_text" id="content_text"></textarea>
                    </td>
                    <td align="right"><?php echo EDIT_CSS_JUSTIFY_CONTENT; ?>: </td>
                    <td>
                    	<select name="justify_content" id="justify_content">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="flex-start"><?php echo EDIT_CSS_FLEX_START; ?></option>
                            <option value="flex-end"><?php echo EDIT_CSS_FLEX_END; ?></option>
                            <option value="center"><?php echo CENTER_WORD; ?></option>
                            <option value="space-between"><?php echo EDIT_CSS_SPACE_BETWEEN; ?></option>
                            <option value="space-around"><?php echo EDIT_CSS_SPACE_AROUND; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
            
            <table border="1" width="100%" id="transition_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="8"><?php echo TRANSITION_WORD; ?></td>
                  </tr>
                  <tr>
                    <td align="right"><?php echo PROPERTY_WORD; ?>: </td>
                    <td>
                    	<select name="transition_property" id="transition_property">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="width"><?php echo WIDTH_WORD; ?></option>
                            <option value="height"><?php echo HEIGHT_WORD; ?></option>
                            <option value="width, height"><?php echo WIDTH_AND_HEIGHT; ?></option>
                            <option value="font-size"><?php echo FONT_SIZE; ?></option>
                            <option value="width, height, min-width, min-height, max-width, max-height, border-width, font-size"><?php echo EDIT_CSS_MENU_STYLES_HT_WD_MHT_MWD_BW_FS; ?></option>
                            <option value="all"><?php echo ALL_WORD; ?></option>
                            <option value="none"><?php echo NONE_WORD; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                    <td align="right"><?php echo TIMING_FUNCTION; ?>: </td>
                    <td>
                    	<select name="transition_timing_function" id="transition_timing_function">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="ease"><?php echo EASE_WORD; ?></option>
                            <option value="linear"><?php echo LINEAR_WORD; ?></option>
                            <option value="ease-in"><?php echo EASE_IN; ?></option>
                            <option value="ease-out"><?php echo EASE_OUT; ?></option>
                            <option value="ease-in-out"><?php echo EASE_IN_OUT; ?></option>
                        </select>
                    </td>
                    <td align="right"><?php echo DURATION_WORD; ?>: </td>
                    <td>
                    	<input type="text" name="transition_duration" id="transition_duration" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                        <select name="transition_duration_units" id="transition_duration_units">
                        	<option value="0">s</option>
                            <option value="1">ms</option>
                        </select>
                    </td>
                    <td align="right"><?php echo DELAY_WORD; ?>: </td>
                    <td>
                    	<input type="text" name="transition_delay" id="transition_delay" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                        <select name="transition_delay_units" id="transition_delay_units">
                        	<option value="0">s</option>
                            <option value="1">ms</option>
                        </select>
                    </td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
            
            <table border="1" width="100%" id="flex_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="8"><?php echo EDIT_CSS_FLEX; ?></td>
                  </tr>
                  <tr>
                  	<td colspan="3" align="center">
                    	<div class='button_console' style="width:150px;" onClick="SetDisplayFlex();" id="set_display_flex_btn"><span class='button_console_text'><?php echo EDIT_CSS_SET_DISPLAY_FLEX; ?></span></div>
                    </td>
                    <td align="right"><?php echo BASIS_WORD; ?>: </td>
                    <td style="width:110px;">
                    	<select name="flex_basis" id="flex_basis" onChange="enable_disable_flex_basis_length();">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="length"><?php echo LENGTH_WORD; ?></option>
                            <option value="auto"><?php echo AUTO_WORD; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                    <td colspan="3">
                    	<input type="text" name="flex_basis_length" id="flex_basis_length" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                        <select name="flex_basis_length_units" id="flex_basis_length_units" onChange="CheckFormatOnUnitSelect(this.id, 'flex_basis_length', 0);">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
					     </select>
                    </td>
                 </tr>
                 <tr>
                    <td align="right"><?php echo GROW_WORD; ?>: </td>
                    <td><input type="text" name="flex_grow" id="flex_grow" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SHRINK_WORD; ?>: </td>
                    <td>
                    	<input type="text" name="flex_shrink" id="flex_shrink" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    </td>
                    <td align="right"><?php echo DIRECTION_WORD; ?>: </td>
                    <td>
                    	<select name="flex_direction" id="flex_direction">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="row"><?php echo ROW_WORD; ?></option>
                            <option value="row-reverse"><?php echo EDIT_CSS_ROW_REVERSE; ?></option>
                            <option value="column"><?php echo COLUMN_WORD; ?></option>
                            <option value="column-reverse"><?php echo EDIT_CSS_COLUMN_REVERSE; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                    <td align="right"><?php echo WRAP_WORD; ?>: </td>
                    <td>
                    	<select name="flex_wrap" id="flex_wrap">
                        	<option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                        	<option value="nowrap"><?php echo NO_WRAP_WORD; ?></option>
                            <option value="wrap"><?php echo WRAP_WORD; ?></option>
                            <option value="wrap-reverse"><?php echo EDIT_CSS_WRAP_REVERSE; ?></option>
                            <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     	<option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                    </td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
             
     </td>
     <tr><td align="center">
     <table width="100%">
       <tr>
     	<td align="center">
            <div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();" id="preview_btn"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
            <input type="hidden" name="MAX_FILE_SIZE" value="500000" />
            <input type="hidden" name="browse_image_control" value="file_browse1"/>
            <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
            <input type="hidden" name="show_class_editor" value="<?php echo $show_class_editor; ?>" />
            <input type="hidden" name="submit_action" id="submit_action" />
        </td>
        <td align="center" width="70%">&nbsp;
			<div class='button_console_important' style="width:280px;" onClick="ManageImportantCSS();" id="important_btn"><span class='button_console_text_w_icon'><?php echo IMPORTANT_HEADING; ?></span></div>
        </td>
        <td align="center">
            <div class='button_console_save' style="width:110px;" onClick="UpdateCSS('Update', false);" id="update_btn_2"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
        </td>
       </tr>
      </table>
      </td></tr></table>
      </form>
	 
       <?php
	   		if (($show_class_editor == 1) || ($style_sheet == "site") || ($access_level == "admin"))
			{
		?>
        <table width="100%" border="0" cellspacing="1" cellpadding="1">
	     <tr>
          <?php
	   		if ($style_sheet == "site")
			{
		  ?>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadBrowserResetParams();"><span class='button_console_text'><?php echo EDIT_CSS_LOAD_BROWSER_RESET_CSS_BTN; ?></span></div>
           </td>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadCenterParams();"><span class='button_console_text'><?php echo EDIT_CSS_SETUP_CENTERED_PAGES_BTN; ?></span></div>
           </td>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadStickyHeaderParams();"><span class='button_console_text'><?php echo EDIT_CSS_SETUP_STICKY_HEADER_BTN; ?></span></div>
           </td>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadStickyFooterParams();"><span class='button_console_text'><?php echo EDIT_CSS_SETUP_STICKY_FOOTER_BTN; ?></span></div>
           </td>
           <?php
			}
		 
	   		if (($show_class_editor == 1) || ($access_level == "admin"))
			{
		   ?>
		 	<td align="center">
            <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADD_DELETE_CUSTOM_STYLE_BTN; ?></span></div>
            </td>
          <?php
			}
			if (($show_custom_styles == 1) || ($access_level == "admin"))
			{
		  ?>
          	<td align="right">
            <div class='button_console_code' style="width:170px;" onClick="window.location.href='edit_custom_css.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADVANCED_STYLES_BTN; ?></span></div>
          	</td>
            <?php
				}
			?>
		  </tr>
         </table>
         <?php
			}
		?>

	 </td>
   </tr>
</table>
<a name="bottom_anchor"></a>
</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

</body>
</html>