<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created : 11/16/2014
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Revised: 1/22/2015	ELL
// Updated CKEditor from version 4.4.5 to version 4.4.6.
// Modified: 9/12/2016	ELL
// Added basename() around filename tag to accomodate new ability to drill down thru file tree.
// Revised: 5/16/2018	ELL
// Added hooks for plugin buttons and code.
// Revised: 9/28/2018	ELL
// Added access to WYSIWYG mode if .html or .htm file.
	
	include ("check_session.php");
	
	if ($access_level != "admin")
		exit;
		
	$file_name = $_REQUEST['file_name'];
	$folder = $_REQUEST['folder'];
	$source = $_REQUEST['source'];
	$file_name = str_replace("%2F", "/",  $file_name);
	$folder = str_replace("%2F", "/", $folder);
	
	$file_parts = explode(".", strrev($file_name));
	$ext = strrev($file_parts[0]);
	$html_exts = array("html", "htm");
	$got_html = false;
	if (in_array(strtolower($ext), $html_exts))
		$got_html = true;
	
	if (strpos($file_name, "/") === 0)
		$file_name = substr($file_name, 1);
	if (strpos($folder, "/") === 0)
		$folder = substr($folder, 1);
		
	if (isset($folder) && ($folder != ""))
		$path = "../" . $folder . "/" . $file_name;
	else
		$path = "../" . $file_name;
	
	if ((strpos($folder, BWB_SCRIPTS_DIR) === 0) || (strpos($folder, BWB_SCRIPTS_DIR) === 1))
	{
		$_SESSION['last_script_edited'] = $file_name;
	}
	elseif ((strpos($folder, BWB_LIB_DIR) === 0) || (strpos($folder, BWB_LIB_DIR) === 1))
	{
		$_SESSION['last_php_edited'] = $file_name;
	}
	else
	{
		$_SESSION['last_file_edited'] = $file_name;
	}
	
	$referer = $_SERVER['HTTP_REFERER'];
	$referer_arr = explode("/manage/", $referer);
	$redirect = $referer_arr[1];
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CKEditorSkin'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))
		$CKEditorSkin = $row['option_value'];
	else
		$CKEditorSkin = "breeze";

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CodeMirrorTheme'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))	{
		$CodeMirrorTheme = $row['option_value'];
		if (strpos($CodeMirrorTheme, "solarized") !== false)
			$CodeMirrorCSS = "solarized";
		else
			$CodeMirrorCSS = $row['option_value'];
	}
	else	{
		$CodeMirrorTheme = "rubyblue";
		$CodeMirrorCSS = "rubyblue";
	}
	
	$disable_site_styles = 0;
	
	/////////// Determine Plugin Buttons ///////////////////////////
	$location = "editor";
	include ("generate_plugin_buttons.php");
?>
<!DOCTYPE html>
<html>
<head>
<title><?php echo $file_name; ?> - Editing | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="../ckeditor/plugins/codemirror/theme/<?php echo $CodeMirrorCSS; ?>.css">

<style>
<?php
	if ($plugin_css)
	{
		foreach ($plugin_css as $key => $value)
			echo $value[1];
	}
?>
	#plugin_iframe	{	
		display:none;
	}
</style>

<script src="js/jquery.min.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/edit_file.js"></script>
<script src="../ckeditor/ckeditor.js"></script>

<script>
	var file_name = "<?php echo $file_name; ?>";
	var folder = "<?php echo $folder; ?>";
	
	var saved = true;
 
	var browser = BrowserDetect.browser;
	var browser_version = BrowserDetect.version;
	
	var redirect = "<?php echo $redirect; ?>";
	
	var disable_site_styles = <?php echo $disable_site_styles; ?>;
	
<?php
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
	echo "	var EDITOR_REVERT_FILE_CONFIRM_1_MSG = \"" . EDITOR_REVERT_FILE_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_FILE_CONFIRM_2_MSG = \"" . EDITOR_REVERT_FILE_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERTING_MSG = \"" . EDITOR_REVERTING_MSG . "\";\n";
	echo "	var EDITOR_REVERT_COMPLETE_MSG = \"" . EDITOR_REVERT_COMPLETE_MSG . "\";\n";
	echo "	var EDITOR_FILE_NOT_SAVED_MSG = \"" . EDITOR_FILE_NOT_SAVED_MSG . "\";\n";
	echo "	var EDITOR_FILE_BLANK_ERR = \"" . EDITOR_FILE_BLANK_ERR . "\";\n";
	echo "	var EDITOR_FILE_ALREADY_EXISTS_1_ERR = \"" . EDITOR_FILE_ALREADY_EXISTS_1_ERR . "\";\n";
	echo "	var EDITOR_FILE_ALREADY_EXISTS_2_ERR = \"" . EDITOR_FILE_ALREADY_EXISTS_2_ERR . "\";\n";
	echo "	var EDITOR_DELETE_FILE_CONFIRM_1_MSG = \"" . EDITOR_DELETE_FILE_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_DELETE_FILE_CONFIRM_2_MSG = \"" . EDITOR_DELETE_FILE_CONFIRM_2_MSG . "\";\n";
	echo "	var SAVE_AS_WORD = \"" . SAVE_AS_WORD . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var OK_WORD = \"" . OK_WORD . "\";\n";
	echo "	var CANCEL_WORD = \"" . CANCEL_WORD . "\";\n";
	
	echo "	var BWB_SCRIPTS_DIR = \"" . BWB_SCRIPTS_DIR . "\";\n";
	echo "	var BWB_LIB_DIR = \"" . BWB_LIB_DIR . "\";\n";
	
	echo "	var http = '$http';\n";
?>
</script>

</head>

<body id="workspace_body">
<div style='text-align:center;'>
<form name="frmEditHead" id="frmEditHead" action="save_head.php" method="post">

<div style="height:93%; width:100%;" id="editorContainer" name="editorContainer"></div>

<script>
	var workspace = window.parent.document.getElementById('workspace');
	var workspace_width = $(workspace).innerWidth();
	var workspace_height = $(workspace).innerHeight();
    
	CKEDITOR_BASEPATH = '../ckeditor/';

<?php	if (!$got_html)	{	?>
	CKEDITOR.replace( 'editorContainer', { contentsCss : ['/ckeditor/contents.css'], removePlugins: 'zoom,letterspacing' });
<?php }	else	{	?>
	CKEDITOR.replace( 'editorContainer', {
		filebrowserBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_WEBPAGE_DIR; ?>&langCode=<?php echo BWB_LANG; ?>',
		filebrowserImageBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_IMAGE_DIR; ?>&type=Images&langCode=<?php echo BWB_LANG; ?>',
		filebrowserFlashBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_FLASH_DIR; ?>&type=Flash&langCode=<?php echo BWB_LANG; ?>',
		allowedContent: true,
<?php 
	if ($disable_site_styles != 1)
	{
		echo "			contentsCss : [";
									   
		if (isset($_SESSION['style_mode']) && ($_SESSION['style_mode'] == "mobile"))
		{
			$where = " WHERE (`name` NOT LIKE '%_touchscreen%') AND (exclude <> 1)";
			$where_clause = "";
			$and = " AND";
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets";
			$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` LIKE '%_mobile%' ORDER BY sort_order";
			$result = $bwb_dbh->query($query2);
			if ($result->rowCount() < 1)
				$where_clause = $where;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$mobile_name = $row["name"];
				$query3 = "SELECT DISTINCT name FROM " . BWB_TABLE_PREFIX . "style_sheets INNER JOIN " . BWB_TABLE_PREFIX . "site_css ON " . BWB_TABLE_PREFIX . "style_sheets.name = " . BWB_TABLE_PREFIX . "site_css.style_sheet WHERE " . BWB_TABLE_PREFIX . "style_sheets.name = '$mobile_name'";
				$result3 = $bwb_dbh->query($query3);
				if ($result3->rowCount() > 0)
					$name = str_replace("_mobile", "", $mobile_name);
				else	
					$name = $mobile_name;
				$where_clause .= $where . $and . " (`name` <> '" . $name . "')";
				$where = "";
			}
			$query .= $where_clause . " ORDER BY sort_order";
		}
		elseif (isset($_SESSION['style_mode']) && ($_SESSION['style_mode'] == "touchscreen"))
		{
			$where = " WHERE (`name` NOT LIKE '%_mobile%') AND (exclude <> 1)";
			$where_clause = "";
			$and = " AND";
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets";
			$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE (`name` LIKE '%_touchscreen%') ORDER BY sort_order";
			$result = $bwb_dbh->query($query2);
			if ($result->rowCount() < 1)
				$where_clause = $where;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$touchscreen_menu_name = $row["name"];
				$query3 = "SELECT DISTINCT name FROM " . BWB_TABLE_PREFIX . "style_sheets INNER JOIN " . BWB_TABLE_PREFIX . "site_css ON " . BWB_TABLE_PREFIX . "style_sheets.name = " . BWB_TABLE_PREFIX . "site_css.style_sheet WHERE " . BWB_TABLE_PREFIX . "style_sheets.name = '$touchscreen_menu_name'";
				$result3 = $bwb_dbh->query($query3);
				if ($result3->rowCount() > 0)
					$name = str_replace("_touchscreen", "", $touchscreen_menu_name);
				else	
					$name = $touchscreen_menu_name;
				$where_clause .= $where . $and . " (`name` <> '" . $name . "')";
				$where = "";
			}
			$query .= $where_clause . " ORDER BY sort_order";
		}
		else
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE (`name` NOT LIKE '%_mobile%') AND (`name` NOT LIKE '%_touchscreen%') AND (exclude <> 1) ORDER BY sort_order";
		
		$result = $bwb_dbh->query($query);
		$delim = "";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$style_sheet = $row["name"] . ".css";
			echo $delim . "'" . $userfiles . "/" . BWB_CSS_DIR . "/" . $style_sheet . "'";
			$delim = ",";
		}
		echo "]\n";
	}
	else
		echo "			contentsCss : ['/ckeditor/contents.css']\n";
?>
		});
<?php	}	?>
	
	
	
	
	

	CKEDITOR.config.language = '<?php echo BWB_LANG; ?>';
</script>
<?php include("plugins/ckeditor_plugins_no_design_view.php");	?>
<script>
	CKEDITOR.config.skin = '<?php echo $CKEditorSkin; ?>';
	CKEDITOR.config.allowedContent = true;

<?php	if (!$got_html)	{	?>
	CKEDITOR.config.toolbarGroups = [
    { name: 'document',    groups: [ 'mode', 'document', 'doctools' ] },
    { name: 'editing',     groups: [ 'find', 'selection' ] },
    { name: 'tools' },
    { name: 'others' },
    { name: 'about' }
];
		
	CKEDITOR.config.removePlugins = 'newpage,print,templates,showblocks';
	CKEDITOR.config.removeButtons = 'Source';
<?php	}	else	{	?>
	if (disable_site_styles != 1)
		CKEDITOR.config.stylesSet = 'bwb_styles:/ckeditor/styles.js';
<?php	}	?>
	
	CKEDITOR.config.width = '99%';
<?php	if (!$got_html)	{	?>
	CKEDITOR.config.height = workspace_height - 130;
<?php	}	else	{	?>
	CKEDITOR.config.height = workspace_height - 175;
<?php	}	?>
	CKEDITOR.config.resize_enabled = false;

	CKEDITOR.config.startupMode = 'source';

		
	CKEDITOR.config.codemirror = {
		 // Set this to the theme you wish to use (codemirror themes)
		theme: '<?php echo $CodeMirrorTheme; ?>',
		// Whether or not you want Brackets to automatically close themselves
		autoCloseBrackets: true,
		 // Whether or not you want tags to automatically close themselves
		autoCloseTags: true,
		 // Whether or not to automatically format code should be done when the editor is loaded
		autoFormatOnStart: true, 
		// Whether or not to automatically format code which has just been uncommented
		autoFormatOnUncomment: true,
		// Whether or not to continue a comment when you press Enter inside a comment block
		continueComments: true,
		 // Whether or not you wish to enable code folding (requires 'lineNumbers' to be set to 'true')
		enableCodeFolding: true,
		// Whether or not to enable code formatting
		enableCodeFormatting: true,
		// Whether or not to enable search tools, CTRL+F (Find), CTRL+SHIFT+F (Replace), CTRL+SHIFT+R (Replace All), CTRL+G (Find Next), CTRL+SHIFT+G (Find Previous)
		enableSearchTools: true,
		// Whether or not to highlight all matches of current word/selection
		highlightMatches: true,
		 // Whether, when indenting, the first N*tabSize spaces should be replaced by N tabs
		indentWithTabs: false,
		 // Whether or not you want to show line numbers
		lineNumbers: true,
		// Whether or not you want to use line wrapping
		lineWrapping: true,
		 // Define the language specific mode 'htmlmixed' for html  including (css, xml, javascript), 'application/x-httpd-php' for php mode including html, or 'text/javascript' for using java script only 
		//mode: 'htmlmixed',
<?php
	if (($ext == "php") || ($ext == "inc"))
		echo "		mode: 'application/x-httpd-php',\n";
	elseif ($ext == "js")
		echo "		mode: 'text/javascript',\n";
	elseif (($ext == "html") || ($ext == "htm"))
		echo "		mode: 'htmlmixed',\n";
	elseif ($ext == "css")
		echo "		mode: 'text/css',\n";
	elseif (($ext == "c") || ($ext == "cc"))
		echo "		mode: 'text/x-csrc',\n";
	elseif ($ext == "cpp")
		echo "		mode: 'text/x-c++src',\n";
	elseif (($ext == "java") || ($ext == "class"))
		echo "		mode: 'text/x-java',\n";
	elseif (($ext == "pl") || ($ext == "perl") || ($ext == "cgi"))
		echo "		mode: 'text/x-perl',\n";
	elseif (($ext == "py") || ($ext == "pyc") || ($ext == "pym") || ($ext == "pyo") || ($ext == "pyw") || ($ext == "rpy"))
		echo "		mode: 'text/x-python',\n";
	elseif (($ext == "rb") || ($ext == "rhtml") || ($ext == "rjs"))
		echo "		mode: 'text/x-ruby',\n";
	elseif ($ext == "sql")
		echo "		mode: 'text/x-mysql',\n";
	elseif ($ext == "xml")
		echo "		mode: 'application/xml',\n";
	else
		echo "		mode: 'htmlmixed',\n";
?>
		// Whether or not you want to highlight matching braces
		matchBrackets: true,
		// Whether or not you want to highlight matching tags
		matchTags: true,
		// Whether or not to show the showAutoCompleteButton   button on the toolbar
		showAutoCompleteButton: true,
		 // Whether or not to show the comment button on the toolbar
		showCommentButton: true,
		// Whether or not to show the format button on the toolbar
		showFormatButton: true,
		 // Whether or not to show the search Code button on the toolbar
		showSearchButton: true,
		 // Whether or not to show Trailing Spaces
		showTrailingSpace: true,
		// Whether or not to show the uncomment button on the toolbar
		showUncommentButton: true,
		 // Whether or not to highlight the currently active line
		styleActiveLine: true,
		// "Whether or not to use Beautify for auto formatting
		useBeautify: false
	};
		
	var bwb_ckeditor = CKEDITOR.instances['editorContainer'];

	function somethingChanged()	{
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
		{
			saved = false;
			window.parent.SetWorkSavedNotSaved(saved);
			try	{
				bwb_ckeditor.commands.save.enable();
			}
			catch(err)	{
				err = 0;
			}
		}
	}

	function somethingHappened(e)	{
//			alert(e.data.name);
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
			window.parent.SetWorkSavedNotSaved(true);
			
		if (e.data.name == "newpage")
		{
			e.data.command = null;
			//ClearContent();
		}
		else if (e.data.name == "preview")
		{
			e.data.command = null;
//				Save('Preview');
		}
		else if (e.data.name == "save")
		{
			e.data.command = null;
			Save('Save');
			try	{
				bwb_ckeditor.commands.save.disable();
			}
			catch(err)	{
				err = 0;
			}
			bwb_ckeditor.resetDirty();
		}
<?php if (!$got_html)	{	?>
		else if (e.data.name == "source")
		{
			e.data.command = null;
		}
<?php	}	?>
	}
	
	bwb_ckeditor.on( 'saveSnapshot', function(e) { somethingChanged(); });
	bwb_ckeditor.on( 'beforeCommandExec', function(e) { somethingHappened(e); });
</script>
 
<div id="btn_div" style="text-align:center;">
 <div class="medium_message editor_btns">
  <span id="page_name_label"><?php echo EDITOR_FILE_NAME; ?>:<br /><?php echo basename($file_name); ?></span>
 </div>
<?php if ((strpos($folder, BWB_SCRIPTS_DIR) !== 0) && (strpos($folder, BWB_SCRIPTS_DIR) !== 1) && (strpos($folder, BWB_LIB_DIR) !== 0) && (strpos($folder, BWB_LIB_DIR) !== 1))	{	?>
  <div class='button_console_preview editor_btns' style="width:110px;" onClick="Preview();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
<?php }	?>
  <div class='button_console_save editor_btns' style="width:110px;" onClick="Save('save');"><span class='button_console_text_w_icon'><?php echo EDITOR_SAVE; ?></span></div>
  <div class='button_console_save editor_btns' style="width:110px;" onClick="ShowSaveAsMsg();"><span class='button_console_text_w_icon'><?php echo EDITOR_SAVE_AS; ?></span></div>
  <div class='button_console_save editor_btns' style="width:110px;" onClick="Save('publish');"><span class='button_console_text_w_icon'><?php echo EDITOR_PUBLISH; ?></span></div>
  <div class='button_console_cancel editor_btns' style="width:110px;" onClick="RevertConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_REVERT; ?></span></div>
  <div class='button_console_delete editor_btns' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
<?php if (strrev($file_parts[1]) != "untitled")	{	?>
  <div class='button_console_preview editor_btns' style="width:110px;" onClick="window.open('<?php echo $path; ?>', '_blank');"><span class='button_console_text_w_icon'><?php echo EDITOR_SEE_FILE; ?></span></div>
<?php	}

	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if (($plugin_button[2] == "all_editors") || ($plugin_button[2] == "code_view_only_editors") || ($plugin_button[2] == "file_editor"))
				echo $plugin_button[1];
		}
	}
?>
  <div class='button_console_back_sm editor_btns' style="min-width:140px;" onClick="window.location='<?php echo $source; ?>';"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_BACK_TO_SELECT; ?></span></div>
  <div class="help_button editor_btns" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div>
</div>
      
</form>
</div>

<iframe id="plugin_iframe" name="plugin_iframe"></iframe>

<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
	mTimer3 = setTimeout("LoadFile();", 1500);
	
	if (document.body.scrollWidth > document.body.clientWidth)
		CKEDITOR.config.height = CKEDITOR.config.height - 40;
</script>

</body>
</html>
