<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Completely re-engineered: 12/17/2010	ELL
// Revised: 2/19/2011	ELL
// Fixed bugs with moving items and inserting items when using Internet Explore.  It was working fine in
// Firefox, Opera, Safari and Chrome, but IE processes .innerHTML in a very weird way.  Note that UpdateAll() 
// function is run after moving items for IE only to correct some of the problems with working with id
// attributes to tags once IE processes the .innerHTML.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 3/1/2012	ELL
// Fixed bugs with indents not working properly upon inserting new items.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/22/2013	ELL
// Removed obsolete "saved" var.
// Revised: 7/19/2015	ELL
// Fixed bug with getting mobile menu items.
// Revised: 10/22/2016	ELL
// Added population of mega menu array.
// Modified: 12/2/2016	ELL
// Consolidated all menu items tables into menu_items.
// Revised: 7/3/2019	ELL
// Overhauled to use jQuery AJAX instead of pure JavaScript to eliminate bugs and make easier to troubleshoot.
// Modified: 11/26/2019	ELL
// Added visual indication of inactive pages.
// 
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
	
?>
<!DOCTYPE HTML>
<html>
<head>
<title>Editing <?php echo $menu; ?> Menu Items | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

.header_row	{
	padding-left:5px;
	padding-right:5px;
}

#manage_mega_menu_btn	{
	width:210px;
	position:absolute;
	right:100px;
}

.button_heading_sub_level_1	{	margin-left: 5%;	}
</style>

<script src="js/jquery.min.js"></script>
<script src="js/trim.js"></script>
<script src="js/escape_url.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/edit_menu_items.js"></script>

<script>
var update_all = false;
var unsaved_new_item = false;
var pages = new Array();
var pages_full = new Array();
var bgclr = "#eeeeee";
var nCount;

<?php
	echo "	var theme = '$theme';\n\n";
	
	echo "pages = new Array();\n";
	echo "pages_full = new Array();\n";
	echo "active = new Array();\n";
	$query = "SELECT page_name, active FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_name = $row["page_name"];
		$page_name_full = $page_name . ".php";
		$active = $row["active"];
		echo "pages[$j] = '$page_name';\n";
		echo "pages_full[$j] = '$page_name_full';\n";
		echo "active[$j] = '$active';\n";
	}
	echo "	var page_cnt = $j;\n\n";
	
	echo "mega_menus = new Array();\n";
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name LIKE 'mm_%' ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$mega_menu = $row["page_name"];
		echo "mega_menus[$j] = '$mega_menu';\n";
	}
	echo "	var mega_menu_cnt = $j;\n\n";
	
	echo "	var EDIT_MENU_ITEMS_ITEM_TEXT = \"" . EDIT_MENU_ITEMS_ITEM_TEXT . "\";\n";
	echo "	var EDIT_MENU_ITEMS_NESTING_LEVEL = \"" . EDIT_MENU_ITEMS_NESTING_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_URL = \"" . EDIT_MENU_ITEMS_URL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_TARGET_WINDOW = \"" . EDIT_MENU_ITEMS_TARGET_WINDOW . "\";\n";
	echo "	var EDIT_MENU_ITEMS_TOP_LEVEL = \"" . EDIT_MENU_ITEMS_TOP_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_1ST_SUB_LEVEL = \"" . EDIT_MENU_ITEMS_1ST_SUB_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_2ND_SUB_LEVEL = \"" . EDIT_MENU_ITEMS_2ND_SUB_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_3RD_SUB_LEVEL = \"" . EDIT_MENU_ITEMS_3RD_SUB_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_4TH_SUB_LEVEL = \"" . EDIT_MENU_ITEMS_4TH_SUB_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_5TH_SUB_LEVEL = \"" . EDIT_MENU_ITEMS_5TH_SUB_LEVEL . "\";\n";
	echo "	var EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_1_MSG = \"" . EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_1_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_2_MSG = \"" . EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_2_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_STARTING_DELETE_MSG = \"" . EDIT_MENU_ITEMS_STARTING_DELETE_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_LOCATING_MENU_ITEMS_MSG = \"" . EDIT_MENU_ITEMS_LOCATING_MENU_ITEMS_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_COULD_NOT_DELETE_ITEM_MSG = \"" . EDIT_MENU_ITEMS_COULD_NOT_DELETE_ITEM_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_MENU_ITEM_DELETED_MSG = \"" . EDIT_MENU_ITEMS_MENU_ITEM_DELETED_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_DELETING_MENU_ITEM_MSG = \"" . EDIT_MENU_ITEMS_DELETING_MENU_ITEM_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEM_MSG = \"" . EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEM_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_MENU_ITEM_UPDATED_MSG = \"" . EDIT_MENU_ITEMS_MENU_ITEM_UPDATED_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_UPDATING_MENU_ITEM_MSG = \"" . EDIT_MENU_ITEMS_UPDATING_MENU_ITEM_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEMS_MSG = \"" . EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEMS_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_MENU_ITEMS_UPDATED_MSG = \"" . EDIT_MENU_ITEMS_MENU_ITEMS_UPDATED_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_UPDATING_MENU_ITEMS_MSG = \"" . EDIT_MENU_ITEMS_UPDATING_MENU_ITEMS_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_RETRIEVING_MENU_ITEMS_MSG = \"" . EDIT_MENU_ITEMS_RETRIEVING_MENU_ITEMS_MSG . "\";\n";
	echo "	var EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG = \"" . EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
	echo "	var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
	echo "	var QUERY_COMPLETE = \"" . QUERY_COMPLETE . "\";\n";
	echo "	var QUERY_COMPLETE_NO_RECORD_FOUND = \"" . QUERY_COMPLETE_NO_RECORD_FOUND . "\";\n";
	echo "	var SELF_NORMAL = \"" . SELF_NORMAL . "\";\n";
	echo "	var NEW_WINDOW = \"" . NEW_WINDOW . "\";\n";
	echo "	var NAMED_FRAME = \"" . NAMED_FRAME . "\";\n";
	echo "	var ENTER_FRAME_NAME = \"" . ENTER_FRAME_NAME . "\";\n";
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var EDIT_MENU_ITEMS_MEGA_MENU = \"" . EDIT_MENU_ITEMS_MEGA_MENU . "\";\n";
	echo "	var EDIT_MENU_ITEMS_ADD_BEFORE_SAVE_NEW_MSG = \"" . EDIT_MENU_ITEMS_ADD_BEFORE_SAVE_NEW_MSG . "\";\n";
	echo "	var INACTIVE_WORD = \"" . INACTIVE_WORD . "\";\n";
	
	echo "	var http = '$http';\n";
?>
</script>

</head>

<body onLoad="RetrieveMenuItems();" id="workspace_body">

	<div class="button_heading_sub_level_1" id="edit_menus_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_MENU_ITEMS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
    
<div align="center">

	<span class="bold"><?php echo EDIT_MENU_ITEMS_SELECT_MENU; ?>: </span>
    <form name="frmMenuItems" id="frmMenuItems" action="save_menu_items.php" enctype="multipart/form-data">
    <select name="selectMenu" id="selectMenu" onChange="javascript:RetrieveMenuItems();">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$use_default_menu = 0;
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY description, menu_name";
	$result = $bwb_dbh->query($query);
	$use_default_menu = $result->rowCount();
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if (($menu_name == $menu) || (($use_default_menu == 2) && ($menu_name == "menu1") && ($menu == "")))
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
    </select>
	
    <div id='select_menu_msg_div'>
<?php
	if (($use_default_menu != 2) && (($menu == "-not selected-") || ($menu == "")))
		echo "<br /><br />" . EDIT_MENU_ITEMS_SELECT_MENU_MSG;
?>
	</div>
    
	<div id="MenuItemsTable" style="width:100%;">&nbsp;</div>
    <input type="hidden" name="nCount" id="nCount" />
    </form>
    
     <table width="90%" border="0">
		<tr><td colspan="5">&nbsp;</td></tr>
		<tr>
		<td align="center">
        <div class='button_console_save' id="update" <?php if (($menu == "-not selected-") || ($menu == "")) echo " style='display:none;'"; else echo " style='display:block; width:130px;'"; ?> onClick="UpdateAll();"><span class='button_console_text_w_icon'><?php echo EDIT_MENU_ITEMS_UPDATE_ALL_BTN; ?></span></div>
        </td>
		</tr>
	</table>

</div>

<div class='button_console_manage_menu' onClick="window.location='manage_mega_menu.php';" id="manage_mega_menu_btn"><span class='button_console_text_w_icon'><?php echo MEGA_MENU_MANAGE_BTN; ?></span></div>

<?php include("lib/popup_msg.html"); ?>

<script language='javascript' type='text/javascript'>
	popup_msg.HidePopupMsg();
<?php
	if (isset($menu))
		echo "      RetrieveMenuItems();\n";
?>
</script>
</body>
</html>