<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 5/14/2018	ELL
// Revised: 4/29/2019	ELL
// Converted referenceing of deployed plugins from using 'plugin_id' to 'name'. This is because the SQL REPLACE command used to update aftermarket plugin records 
// causes the id field to increment in the 'plugins' table only, making it out-of-sync with the 'plugins_deployed' table.

	include_once ("check_session.php");
	
	function custom_inArray($needle, $haystack) {
	// $needle is string, but elements of array $haystack are also arrays.  If any element in array element
	// matches string, return true, otherwise false.
		foreach ($haystack as $value) {
			if (in_array($needle, $value)) {
				return true;
			}
		}
		return false;
	}

	if ($access_level == "blogger")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name = T2.name WHERE (T1.AccessLevel='blogger') AND (T2.deployed=1) ORDER BY T1.sort_order";
	elseif ($access_level == "restricted")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name = T2.name WHERE ((T1.AccessLevel='blogger') OR (T1.AccessLevel='restricted')) AND (T2.deployed=1) ORDER BY T1.sort_order";
	elseif ($access_level == "user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name = T2.name WHERE ((T1.AccessLevel='blogger') OR (T1.AccessLevel='restricted') OR (T1.AccessLevel='user') OR (T1.AccessLevel='') OR (T1.AccessLevel IS NULL)) AND (T2.deployed=1) ORDER BY T1.sort_order";
	elseif ($access_level == "power_user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name = T2.name WHERE ((T1.AccessLevel='blogger') OR (T1.AccessLevel='restricted') OR (T1.AccessLevel='user') OR (T1.AccessLevel='power_user') OR (T1.AccessLevel='') OR (T1.AccessLevel IS NULL)) AND (T2.deployed=1) ORDER BY T1.sort_order";
	elseif ($access_level == "admin")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name = T2.name WHERE T2.deployed=1 ORDER BY T1.sort_order";
		
	$plugin_buttons = array();
	$plugin_css = array();
	$editor_group = array('all_editors', 'design_view_editors', 'code_view_only_editors', 'head_code_editor', 'css_editor', 'file_editor');
	$icon_width_sm = 25;
	$letter_width_sm = 8;
	$result = $bwb_dbh->query($query);
	if (($result->rowCount() < 1) && (($access_level == "restricted") || ($access_level == "blogger")))
		$show_other = false;
	else
		$show_other = true;
	$i = 0;
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$console_path = $row['console_path'];
		if (isset($console_path) && ($console_path != ""))
		{
			$console_link_text = $row['console_link_text'];
			$console_link_image = $row['console_link_image'];
			$console_link_image_mo = $row['console_link_image_mo'];
			$console_link_image_down = $row['console_link_image_down'];
			$language_folder = $row['language_folder'];
			$console_link_text_define = $row['console_link_text_define'];
			if (isset($row['menu_group']) && !is_null($row['menu_group']))
				$menu_group = $row['menu_group'];
			else
				$menu_group = "";
			if (in_array($menu_group, $editor_group) && (!isset($location) || ($location == "main")))
				continue;
			elseif (!in_array($menu_group, $editor_group) && ($location == "editor"))
				continue;
			if (isset($language_folder) && isset($console_link_text_define) && ($console_link_text_define != ""))
			{
				if (file_exists($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php"))
					include_once ($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php");
				else
					include_once ($document_root . "/" . $language_folder . "/en.php");
				if (defined($console_link_text_define) && (constant($console_link_text_define) != ""))
					$console_link_text = constant($console_link_text_define);
			}

			if (!custom_inArray($console_path, $plugin_buttons))
			{
				if (!isset($location) || ($location == "main"))	{
					$button_string = "<div class=\"button_top_level\" id=\"btn_custom_" . $i . "\" title=\"" . $console_link_text . "\" onClick=\"SetWorkspaceLocation('" . $console_path . "', this);\"><span class=\"button_text_top_level\">" . $console_link_text . "</span></div>\n";
					$width_css = "";
				}
				elseif ($location == "editor")	{
					$button_string = "<div class='button_console editor_btns' id='btn_custom_" . $i . "' onClick=\"document.getElementById('plugin_iframe').src = '" . $console_path . "';\" title='" . $console_link_text . "'><span class='button_console_text_w_icon'>" . $console_link_text . "</span></div>\n";
					$btn_width = $icon_width_sm + $letter_width_sm * strlen($console_link_text);
					$width_css = "	width:" . $btn_width . "px;";
				}
				
				$css_string = "#btn_custom_" . $i . "	{	background-image:url(" . $console_link_image . ");$width_css	}\n";
				$css_string .= "#btn_custom_" . $i . ":hover	{	background-image:url(" . $console_link_image_mo . ");	}\n";
				$css_string .= "#btn_custom_" . $i . ".down	{	background-image:url(" . $console_link_image_down . ");	}\n";
				
				$plugin_buttons[$console_link_text] = array($console_path, $button_string, $menu_group, "$i");
				$plugin_css[$console_link_text] = array($console_path, $css_string);
				$i++;
			}
		}
	}
	$plugin_button_cnt = count($plugin_buttons);
?>