<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/13/2016	ELL
// 
	include ("check_session.php");

	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$backup_path = $document_root . "/backup";
	$backup_path_rel = "/backup/";
	$files = array();
	$srch = array(".zip", ".gz", ".tgz", ".tar", ".ZIP", ".GZ", ".TGZ", ".TAR", ".Zip", ".Gz", ".Tgz", ".Tar");
	if (!file_exists($backup_path))
		mkdir($backup_path);
	if ($handle = opendir("$backup_path")) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if (($file != ".") && ($file != "..") && !is_dir($backup_path_rel . $file))	{
				$file_parts = explode(".", $file);
				$ext = "." . $file_parts[count($file_parts) -1];
				if (in_array($ext, $srch))	{
					$file_date = date("F d, Y H:i:s", filemtime("$backup_path/$file"));
					$files["$file_date"] = $file;
				}
			}
		}
		closedir($handle);
	}
	
	if (count($files) < 1)	{
		echo "-no data-";
		exit;
	}
	
	ksort($files);
	$row_delim = "";
	$file_table = "";
	foreach ($files as $file_date => $file)	{
		$file_table .= $row_delim . json_encode(array("file_name" => $file, "file_date" => $file_date));
		$row_delim = "@@@@@";
	}	
	print $file_table;
?>