<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/1/2018

include ("check_session.php");

$source_type = $_POST['source_type'];

$sort_alpha = $_POST['sort_alpha'];
if (isset($sort_alpha) && ($sort_alpha == 1))
	$_SESSION['style_sheet_sort_method'] = 1;
elseif (isset($sort_alpha) && ($sort_alpha == 0))
	$_SESSION['style_sheet_sort_method'] = 0;
		
if (isset($_SESSION['style_sheet_sort_method']) && ($_SESSION['style_sheet_sort_method'] == 1))
	$style_sheet_sort_method = 1;
else
	$style_sheet_sort_method = 0;

if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
	$sort = "`description`, `name`";
else
	$sort = "sort_order";
	
if ($source_type == "desktop")
	$name_where = "(`name` NOT LIKE '%_mobile%') AND (`name` NOT LIKE '%_touchscreen%')";
elseif ($source_type == "mobile")
	$name_where = "(`name` LIKE '%_mobile%')";
elseif ($source_type == "touchscreen")
	$name_where = "(`name` LIKE '%_touchscreen%')";

$query = "SELECT `name`,`description` FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE " . $name_where . " AND (`name` NOT LIKE '%_item%') AND (`name` <> 'fonts') ORDER BY $sort";
$result = $bwb_dbh->query($query);
$style_sheets = array();

while($row = $result->fetch(PDO::FETCH_BOTH))
{
	$name = $row["name"];
	$description = $row["description"];
	if ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) === false))
	{
		$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$name'";
		$result2 = $bwb_dbh->query($query2);
		$row2 = $result2->fetch(PDO::FETCH_ASSOC);
		$description = $row2['description'] . " Styles";
	}
	elseif ((strpos($name, "menu", 0) !== false) && (strpos($name, "item", 4) !== false))
	{
		$tmp_name = str_replace("_item", "", $name);
		$query2 = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$tmp_name'";
		$result2 = $bwb_dbh->query($query2);
		$row2 = $result2->fetch(PDO::FETCH_ASSOC);
		$description = $row2['description'] . " Item Styles";
	}
	$style_sheets[$name] = $description;
}

$row_delim = "";
if (isset($style_sheet_sort_method) && ($style_sheet_sort_method == 1))
	asort($style_sheets, SORT_FLAG_CASE | SORT_STRING);
foreach($style_sheets as $name => $description)
{
	echo $row_delim . json_encode(array('name' => $name, 'description' => $description));
	$row_delim = "@@@@@";
}
?>