<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/26/2010	ELL
// Added warning message about system requiring JavaScript.
// Revised: 11/16/2012	ELL
// Added sending of passwords as SHA-256 hashed.  Set focus on user ID upon body load.  Capture enter key for submitting form.
// Revised: 2/11/2013	ELL
// Added override to allow saving of password in browser.
// Revised: 11/5/2014	ELL
// Added link for "forgot password".
// Revised: 4/13/2015	ELL
// Fixed bug with refresh CAPTCHA routine sucking up tons of bandwidth if login screen left open.
// Revised: 11/20/2016	ELL
// Modified reset password to store temp password in temp users table, then update users table upon logging in with temp password to new temp password.
// Revised: 11/23/2018	ELL
// Modified to go to last selected module if session timed out and logging back in.
// Revised: 7/5/2019	ELL
// Added ability to switch between different sites in one Breeze installation utilizing cofig_sites.php file and user selection on login.
//
	
	session_start();
	session_regenerate_id(true);
	
	$mask = "captcha/*.captcha";
	array_map("unlink", glob($mask));
	
	$connect_dir = "connect";
	if (file_exists("../connect/config_sites.php"))	{
		include ("../connect/config_sites.php");
		if (BWB_ACTIVE_SITE != 1)
			$connect_dir .= BWB_ACTIVE_SITE;
	}
	else
		define('BWB_ACTIVE_SITE', 1);
	
	include ("../$connect_dir/config.php");
	include ("../$connect_dir/db_connect.php");
	
	if (defined("BWB_LANG"))
		include ("lang/" . BWB_LANG . ".php");
	else
		include ("lang/en.php");
	
	$server_name = $_SERVER['SERVER_NAME'];
	$script_filename = $_SERVER['SCRIPT_NAME'];
	$url = "https://" . $server_name . $script_filename;
	if (BWB_REQUIRE_SSL == 1)
	{
		//if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off' || $_SERVER['SERVER_PORT'] !== 443)
		if ($_SERVER['HTTPS'] !== 'on')
			header("Location: $url");
	}
	
	$module = urldecode($_GET['module']);
	$btn = $_GET['btn'];
	$site_select = $_GET['site_select'];
	
	$doc_root = getenv('DOCUMENT_ROOT');
	$captcha_path = $doc_root . "/manage/captcha";
	$captcha_images = array();
	$i = 0;
	
	if ($handle = opendir($captcha_path)) {
		while (false !== ($entry = readdir($handle))) {
			if ($entry != "." && $entry != ".." && $entry != "index.php") {
				$captcha_images[$i] = $entry;
				$i++;
			}
		}
		closedir($handle);
	}
	
	$index = rand(0, $i - 1);
	$link = "captcha/" . time() . ".captcha";
	$target = "captcha/" . $captcha_images[$index];
	error_reporting(E_ERROR);
	if (link($target , $link))	{
		$use_captcha = true;
		$captcha = hash('sha256', $captcha_images[$index]);
		$_SESSION['captcha'] = $captcha;
	}
	else
		$use_captcha = false;
		
	$err_code = $_GET['err'];
	$password_reset = $_GET['password_reset'];
	
	$query = "SELECT `option_value` FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name`='Theme'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() > 0)	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$theme = $row['option_value'];
	}
	else
		$theme = "classic";
?>
<!DOCTYPE html>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<style type="text/css">
#login_btn	{
	width:100px;
	margin-top:5px;
}
#reset_password_btn	{	width:100px;	}
#cancel_btn	{
	height:25px;
	width:90px;
	background-position: 5px 3px;
}
#login_logo	{
	text-align:center;
	padding:0px;
	margin:0px;
	height:110px;
}
</style>
<script language="javascript" src="js/hash.js" type="text/javascript"> </script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>

<script language="javascript" type="text/javascript">
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var err_code = "<?php echo $err_code; ?>";
var refresh_captcha_running = false;

function SubmitLogin()
{
	var password = document.getElementById("password_input").value;
	var hash = Sha256.hash(password);
	document.getElementById("password").value = hash;
	if (!document.getElementById("browser_save_password").checked)
		document.getElementById("password_input").value = '';
	document.forms["frmLogin"].submit();
}

function checkForEnter(e) {
	if (e.keyCode == 13) {
		SubmitLogin();	
	}
}

function WarnAboutSSL(show_warning)	{
	if (show_warning)
	{
		popup_msg.top_offset = 50;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 2;
		popup_msg.popup_timeout = 30000;
		popup_msg.msg_width = 500;
		popup_msg.status_msg = "<?php echo LOGIN_SSL_WARNING_1 . $url . LOGIN_SSL_WARNING_2; ?>";
		popup_msg.ShowPopupMsg();
	}
}

function ShowPasswordReset(show_reset)
{
	if (show_reset == 1)	{
		document.getElementById('frmResetPassword').style.display = 'block';
		document.getElementById('frmLogin').style.display = 'none';
		if (refresh_captcha_running === false)	{
			mTimer = setInterval("RefreshCaptcha();", 30000);
			refresh_captcha_running = true;
		}
	}
	else	{
		document.getElementById('frmResetPassword').style.display = 'none';
		document.getElementById('frmLogin').style.display = 'block';
		if (refresh_captcha_running === true)	{
			clearInterval(mTimer);
			refresh_captcha_running = false;
		}
	}
}

function SubmitPasswordReset()
{
	document.forms["frmResetPassword"].submit();
}

function RefreshCaptcha()
{
	$.post( "refresh_captcha.php", { } ).done(CompleteRefreshCaptcha) ;
}
function CompleteRefreshCaptcha(data)
{
	document.getElementById("captcha_image").src = data;
}

function ResetRefreshTimer()
{
	clearInterval(mTimer);
	mTimer = setInterval("RefreshCaptcha();", 30000);
}

function SetSiteSelect4Reset(site_select)
{
	document.getElementById("site_select_reset").value = site_select;
}
</script>
</head>

<body onLoad="document.getElementById('userid').focus();">
<div align="center" id="login_logo"><img src="theme/<?php echo $theme; ?>/images/Breeze_header_logo.png" alt="Breeze Website Builder"></div>
<div id="header_divider_login">&nbsp;</div>
<form name="frmLogin" id="frmLogin" method="post" action="login_verify.php">
<div align="center">
	<div id="ErrMsg" style="display: none;" class="form_submit_error_txt">&nbsp</div>
  <table border="0" cellspacing="0" cellpadding="0">
    <tbody>
      <tr>
        <td colspan="2" class="sub_title"><?php echo LOGIN_USERID_PASS_MSG; ?>:</td>
      </tr>
      <tr>
        <td><?php echo USERID_WORD; ?>:</td>
        <td><input type="text" name="userid" id="userid" /></td>
      </tr>
      <tr>
        <td><?php echo PASSWORD_WORD; ?>:</td>
        <td>
        	<input type="password" name="password_input" id="password_input" onKeyDown="checkForEnter(event);" />
            <input type="hidden" name="password" id="password" />
            <input type="hidden" name="module" id="module" value="<?php echo $module; ?>" />
            <input type="hidden" name="btn" id="btn" value="<?php echo $btn; ?>" />
<?php if (isset($password_reset) && ($password_reset == 1))	{	?>
			<input type="hidden" name="password_reset" id="password_reset" value="1" />
            <input type="hidden" name="active_site" id="active_site" value="<?php echo BWB_ACTIVE_SITE; ?>" />
<?php	}	?>
        </td>
      </tr>
<?php
	if (defined('BWB_SITE_CNT') && (BWB_SITE_CNT > 1))	{
		echo "<tr>\n<td>" . LOGIN_SELECT_SITE . ":&nbsp;</td>\n";
		echo "<td>\n<select name='site_select' id='site_select' onchange='SetSiteSelect4Reset(this.value);'>\n";
		for ($i = 1; $i <= BWB_SITE_CNT; $i++)	{
			$selected = "";
			if (($i == BWB_ACTIVE_SITE) || (isset($site_select) && ($i == $site_select)))
				$selected = " selected='selected'";
			echo "<option value='$i'$selected>$i</option>\n";
		}
		echo "</select>\n</td>\n</tr>\n";
	}
?>
      <tr>
        <td>
        	<input type="checkbox" name="browser_save_password" id="browser_save_password" <?php if ($_SERVER['HTTPS'] !== 'on') echo "onChange=\"WarnAboutSSL(this.checked);\""; ?> />
        	<span class="small_message"><?php echo LOGIN_SAVE_LOGIN_MSG; ?></span>
        </td>
        <td align="right">
        <div class='button_console_login' id="login_btn" onClick="SubmitLogin();"><span class='button_console_text_w_icon'><?php echo LOGIN_LOGIN_BTN; ?></span></div>
        </td>
      </tr>
<?php if ($use_captcha === true)	{	?>
      <tr>
      	<td>&nbsp;</td>
        <td><span class="small_message" onClick="ShowPasswordReset(1);" style="cursor:pointer; text-decoration:underline;"><?php echo LOGIN_FORGOT_PASSWORD_MSG; ?></span></td>
      </tr>
<?php }	?>
    </tbody>
  </table>
</div>
</form>

<?php if ($use_captcha === true)	{	?>
<form action="reset_password.php" id="frmResetPassword" method="post" name="frmResetPassword" style="display:none;">
<div align="center">
  <table border="0" cellspacing="0" cellpadding="0">
	<tbody>
		<tr>
			<td colspan="2" class="sub_title"><?php echo LOGIN_ENTER_EMAIL_MSG; ?>:</td>
		</tr>
		<tr>
			<td style="width:110px;"><?php echo EMAIL_WORD; ?>: </td>
			<td>
            	<input id="email" name="email" type="text" style="width:250px;" />
                <input type="hidden" name="active_site" id="active_site_reset" value="<?php echo BWB_ACTIVE_SITE; ?>" />
                <input type="hidden" name="site_select" id="site_select_reset"<?php if (isset($site_select)) echo "value='$site_select'"; ?> />
            </td>
		</tr>
        <tr>
        	<td colspan="2">&nbsp;</td>
        </tr>
		<tr>
			<td>&nbsp;</td>
			<td style="height:100px;"><img src="<?php echo $link; ?>" alt="chaptcha" id="captcha_image" /></td>
		</tr>
		<tr>
			<td colspan="2">
            <?php echo LOGIN_CAPTCHA_MSG; ?>:
            <input autocomplete="off" id="captcha_response" name="captcha_response" size="10" type="text" value="" onKeyPress="ResetRefreshTimer();" />
            <img src="theme/<?php echo $theme; ?>/images/icon_Reset.png" alt="Reset" style="cursor:pointer; display:inline; margin-top:1px; margin-bottom:-10px; margin-left:10px;" onClick="RefreshCaptcha();" />
            </td>
		</tr>
		<tr>
        	<td colspan="2">&nbsp;</td>
        </tr>
        <tr>
			<td>
                <div class='button_console_cancel_sm' id="cancel_btn" onClick="ShowPasswordReset(0);"><span class='button_console_text_w_sm_icon' style="top:6px;"><?php echo CANCEL_WORD; ?></span></div>
            </td>
            <td align="right">
                <div class='button_console_save' id="reset_password_btn" onClick="SubmitPasswordReset();"><span class='button_console_text_w_icon'><?php echo SUBMIT_WORD; ?></span></div>
			</td>
		</tr>
	</tbody>
  </table>
</div>
</form>
<?php }	?>

<div id="javascript_warning" align="center" class="warning_text">
<?php echo LOGIN_JS_WARNING_MSG; ?>
</div>

<?php include("lib/popup_msg.html"); ?>

<script>
	document.getElementById("javascript_warning").innerHTML = "";
	popup_msg.HidePopupMsg();
	
	if (err_code != "")
	{
		popup_msg.top_offset = 50;
		popup_msg.left_offset = 400;
		popup_msg.popup_msg_type = 2;
		popup_msg.popup_timeout = 8000;
		popup_msg.msg_width = 500;
		var userid = "<?php echo $_GET['userid']; ?>";
		var email = "<?php echo $_GET['email']; ?>";
		
		switch (err_code)
		{
			case "no_user_found":
				popup_msg.status_msg = "<?php echo LOGIN_NO_USER_FOUND_ERR; ?>";
				break;
			case "wrong_password":
				popup_msg.status_msg = "<?php echo LOGIN_PASSWORD_NOT_CONFIRMED_MSG; ?>";
				break;
			case "captcha":
				popup_msg.status_msg = "<?php echo LOGIN_CAPTCHA_ERR; ?>";
				break;
			case "bad_email":
				popup_msg.status_msg = "<?php echo LOGIN_BAD_EMAIL_ERR; ?>";
				break;
			case "bad_referer":
				popup_msg.status_msg = "<?php echo LOGIN_BAD_REFERER_ERR; ?>";
				break;
			case "bad_user":
				popup_msg.status_msg = "<?php echo LOGIN_BAD_USER_ERR; ?>";
				break;
			case "password_reset":
				popup_msg.status_msg = "<?php echo LOGIN_PASSWORD_RESET_ERR; ?>";
				break;
			default :
				popup_msg.status_msg = "<?php echo LOGIN_DEFAULT_ERR; ?>";
		}
	
		popup_msg.ShowPopupMsg();
		
		if ((err_code == "no_user_found") || (err_code == "wrong_password") || (err_code == "password_reset"))	{
			ShowPasswordReset(0);
			document.getElementById('userid').value = userid;
			if (err_code == "no_user_found")	{
				document.getElementById("userid").className = "highlight";
				document.getElementById("password_input").className = "highlight";
			}
			else if (err_code == "wrong_password")	{
				document.getElementById("password_input").className = "highlight";
				setTimeout("document.getElementById('password_input').focus();", 500);
			}
		}
		else	{
			ShowPasswordReset(1);
			document.getElementById('email').value = email;
			if (err_code == "bad_email")	{
				document.getElementById("email").className = "highlight";
				document.getElementById("captcha_response").className = "highlight";
				setTimeout("document.getElementById('email').focus();", 500);
			}
			else if (err_code == "captcha")	{
				document.getElementById("captcha_response").className = "highlight";
				setTimeout("document.getElementById('captcha_response').focus();", 500);
			}
		}
	}
</script>
</body>
</html>