////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/15/2015	ELL

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#copy_css_to_mobile", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function CopyToMobileConfirm(style_sheet)
{
	var destination_type = document.getElementById("destination_type").value;
		
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	if (destination_type == "")	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_CSS_SELECT_DESTINATION_TYPE_NOT_SELECTED;
	}
	else	{
		popup_msg.popup_msg_type = 3;
		popup_msg.popup_btn_cnt = 2;
		var destination_style_sheet = style_sheet.replace("_mobile", "");
		destination_style_sheet = destination_style_sheet.replace("_touchscreen", "");
		if (destination_type != "desktop")
			destination_style_sheet = destination_style_sheet + "_" + destination_type;
		else
			destination_style_sheet = destination_style_sheet + " (desktop)";
		
		popup_msg.popup_msg_cell = COPY_STYLE_TO_MOBILE_CONFIRM_1_MSG + " <b>" + style_sheet + "</b> " + TO_WORD + " <b>" + destination_style_sheet + "</b> " + COPY_STYLE_TO_MOBILE_CONFIRM_2_MSG + " <b>" + destination_style_sheet + "</b> " + COPY_STYLE_TO_MOBILE_CONFIRM_3_MSG;
		
		popup_msg.popup_button_2_span = YES_WORD;
		popup_msg.popup_button_1_span = NO_WORD;
	}
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	if (destination_type != "")	{
		document.getElementById("popup_button_2_span").onclick = function () { CopyToMobile(style_sheet); };
		document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	}
}

function CopyToMobile(style_sheet)
{
	popup_msg.HidePopupMsg();
	var destination_type = document.getElementById("destination_type").value;
	$.post( "copy_css_to_mobile.php", { source_style_sheet: style_sheet, destination_type: destination_type } ).done(CompleteCopyToMobile) ;
}
function CompleteCopyToMobile(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data != -1)
		popup_msg.status_msg = " <b>" + data + "</b> " + COPY_STYLE_TO_MOBILE_COMPLETE_MSG + " <b>" + data + "_mobile</b>.";
	else
		popup_msg.status_msg = COPY_STYLE_TO_MOBILE_COMPLETE_ERR + " <b>" + data + "</b> " + TO_WORD + " <b>" + data + "_mobile</b>.";
		
	popup_msg.ShowPopupMsg();
}

function ChangeStyleSheetSort(bAlpha)
{
	sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;

	var source_type = document.getElementById("source_type").value;
	if (source_type == "")	{
		document.getElementById("style_sheet_list").innerHTML = "";
		return;
	}
	
	$.post( "get_copy_css_list.php", { source_type: source_type, sort_alpha: sort_alpha } ).done(CompletePopulateStyleSheetList) ;
}

function PopulateStyleSheetList(source_type)
{
	if (source_type == "")	{
		document.getElementById("style_sheet_list").innerHTML = "";
		document.getElementById("sort_alpha_style_sheet").disabled = true;
		return;
	}
	document.getElementById("sort_alpha_style_sheet").disabled = false;
		
	var sort_alpha_style_sheet;
	if (document.getElementById("sort_alpha_style_sheet").checked === true)
		sort_alpha_style_sheet = 1;
	else
		sort_alpha_style_sheet = 0;
	$.post( "get_copy_css_list.php", { source_type: source_type, sort_alpha: sort_alpha_style_sheet } ).done(CompletePopulateStyleSheetList) ;
}
function CompletePopulateStyleSheetList(rows_str)
{
	var rows = new Array();
	rows = rows_str.split("@@@@@");
	var selected, html = "";
	for (var i in rows)
	{
		var JSON_row = JSON.parse(rows[i]);
		
		if (JSON_row.style_sheet == last_style_sheet_edited)
			var selected = " down_sub";
		else
			var selected = "";

		html = html + "<div class='button_sub_level_1" + selected + "' onClick=\"CopyToMobileConfirm('" + JSON_row.name + "');\"><span class='button_text_sub_level_1'>" + JSON_row.description + "</span></div>\n";
	}

	document.getElementById("style_sheet_list").innerHTML = html;
}

function EnableDisableDestTypeOptions(source_type)
{
	var op = document.getElementById("destination_type").getElementsByTagName("option");
	for (var i = 0; i < op.length; i++) {
	  (op[i].value.toLowerCase() == source_type) 
		? op[i].disabled = true 
		: op[i].disabled = false ;
		
		if ((op[i].value.toLowerCase() == source_type) && (op[i].selected == true))	{
			op[i].selected = false;
			op[0].selected = true;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}