/////////////////////////////////////////////
// Create Page Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Modified: 10/14/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 11/9/2014	ELL
// Fix bugs with not being able to select plugin.
// Modified: 2/22/2015	ELL
// Added update template image on mouseover.
// Revised: 1/9/2017	ELL
// Added ability to create a group of pages based on plugin groups.
// Added page name AJAX checking.
// Modified: 10/6/2017	ELL
// Fixed bug with sub categories that have no plugins display div of next sub category.
// Added message on where to get plugins when category or sub category contions no plugin.

var mTimer;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var timer_is_on = 0;

window.parent.document.title = document.title;

function OpenHelpWindow(topic)
{
	var help_url = http + "breezewebsitebuilder.com/docs/cms/help.html#" + topic;
	window.open(help_url, "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function OpenHelpList()
{	
	document.getElementById('help_list').style.display = "block";
	
	var ntop = 30;
	var nleft = 280;
	
	var strtop = ntop + "px";
	var strleft = nleft + "px";
	
	document.getElementById("help_list").style.position = "absolute";
	document.getElementById("help_list").style.top = strtop;
	document.getElementById("help_list").style.left = strleft;
}
 
function CloseHelpList()
{
	document.getElementById('help_list').style.display = "none";
}

function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else
		return false;
}

function UpdateTemplateImage(i, clicked)
{
	document.getElementById("template_pic_edit").src = "images/" + images[i];
	document.getElementById("template_pic").src = "images/" + images[i];
	
	if (clicked)
	{
		document.getElementById("template_name").value = layouts[i];
		option_value_selected = layouts[i];
		
		for (var n = 0; n < layouts.length; n++)
		{
			layout_select_ctl = "layout_select" + n;
			document.getElementById(layout_select_ctl).className = "button_sub_level_1";
		}
		
		layout_select_ctl = "layout_select" + i;
		document.getElementById(layout_select_ctl).className = "button_sub_level_1 down_sub";
		
		mTimer = setTimeout("ShowSelections();", 1000);
		timer_is_on = 1;
	}
}

function RevertTemplateImage(layout)
{
	document.getElementById("template_pic_edit").src = "images/" + layout + ".jpg";
}

function SelectPlugin(plugin, i, got_parent, parent, default_page_name)
{
	document.getElementById('plugin').value = plugin;
	
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		try	{
			plugin_name_select_ctl = "plugin_select" + n;
		} 	catch(e)	{	e = 0;	}
		if (ElExists(plugin_name_select_ctl))
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
	}
	plugin_name_select_ctl = "plugin_select" + i;
	document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById("selected_plugin").innerHTML = "<b>" + plugins[plugin] + "</b>";
	document.getElementById("selected_plugin").value = "<b>" + plugins[plugin] + "</b>";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
	
	document.getElementById("clear_plugin_btn").style.display = "block";
	
	if (got_parent == 1)	{
		document.getElementById("create_plugin_group_div").style.display = "block";
		document.getElementById("create_plugin_group").checked = true;
	}
	else
		document.getElementById("create_plugin_group_div").style.display = "none";
		
	var test = document.getElementById("selected_page_name").innerHTML;
	
	var page_name;
	if (((document.getElementById("selected_page_name").innerHTML).charAt(0) == "") || ((document.getElementById("selected_page_name").innerHTML).charCodeAt(0) == 8249))	{
		document.getElementById("selected_page_name").innerHTML = "<b>" + default_page_name + "</b>";
		document.getElementById("selected_page_name").value = "<b>" + default_page_name + "</b>";
		document.getElementById("createPage").value = default_page_name;
		page_name = default_page_name;
	}
	else	{
		page_name = document.getElementById("selected_page_name").innerHTML;
		page_name = page_name.replace("<b>", "");
		page_name = page_name.replace("</b>", "");
	}
	CheckForm(page_name);
	
	if (got_parent == 1)	{
		var where = "parent = '" + parent + "' AND id <> '" + parent + "'";
		$.post( "get_rows.php", { table: "plugins", fields: "id, default_page_name, page_name_suffix", where: where, order_by: "sort_order" }, function( data ) {PopulateChildPluginPages(data, page_name) } ) ;
	}
}
function PopulateChildPluginPages(data, page_name)
{
	if (data == "-no data-")
		return;
		
	var rows = data.split("@@@@@");
	var html = "";
	var JSON_row;
	var child_default_page_name;
	var	page_name_suffix;
	var plugin_id;
	for (var i = 0; i < rows.length; i++)
	{
		JSON_row = JSON.parse(rows[i]);
		child_default_page_name = JSON_row.default_page_name;
		page_name_suffix = JSON_row.page_name_suffix;
		plugin_id = JSON_row.id;
		html = html + "<div name='child_page_name' id='child_page_name_" + i + "'>" + page_name + page_name_suffix + "</div>";
		html = html + "<input type='hidden' name='child_plugin_id' id='child_plugin_id_" + i + "' value='" + plugin_id + "' />";
	}
	document.getElementById("child_plugin_pages_div").innerHTML = html;
	
	CheckPageName(page_name, 'selected_page_name');
	var child_page_name_divs = document.getElementsByName("child_page_name");
	var code;
	var id;
	var child_page_name;
	for (i = 0; i < child_page_name_divs.length; i++)
	{
		id = child_page_name_divs[i].id;
		child_page_name = child_page_name_divs[i].innerHTML;
		code = "CheckPageName('" + child_page_name + "', '" + id + "');";
		setTimeout(code, 1000);
	}
}

function ClearPlugin()
{		
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		if (ElExists(plugin_name_select_ctl))
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
	}
	document.getElementById("plugin").value = "-not selected-";
	document.getElementById("selected_plugin").innerHTML = "&lsaquo;&mdash; <em>(optional)</em>";
	document.getElementById("clear_plugin_btn").style.display = "none";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
}

function SelectPluginCategory(category, cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_id_str = "div_" + cat_id;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			if (ElExists(cat_div_str))
				document.getElementById(cat_div_str).style.display = "none";
			cat_select = "cat_select" + i;
			if (ElExists(cat_select))
				document.getElementById(cat_select).className = "button_sub_level_1";
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	if (ElExists(cat_id_str))
		document.getElementById(cat_id_str).style.display = "block";
	else
		DisplayNoPluginsInSubCatMsg(category, cat_id, parent_cat_id)
	
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		if (ElExists(plugin_name_select_ctl))
			document.getElementById(plugin_name_select_ctl).style.width = "99%";
	}
}

function SelectPageName()
{
	if ((document.getElementById("createPage").value != "") && (document.getElementById("createPage").value != " "))
		document.getElementById("selected_page_name").innerHTML = "<b>" + document.getElementById("createPage").value + "</b>";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
}

function CheckForm(page_name)
{
	if ((page_name.length > 0) && (page_name != " "))
		document.getElementById("create_btn").className = "button_console_add";
	else
		document.getElementById("create_btn").className = "button_console_add_disabled";
}

function CheckPageName(page_name, target_div_id)
{	
	var where = "page_name = '" + page_name + "'";
	$.post( "get_rows.php", { table: "page_data", fields: "page_name", where: where }, function( data ) {CompleteCheckPageName(data, page_name, target_div_id) } ) ;
}
function CompleteCheckPageName(data, page_name, target_div_id)
{
	if ((data != "-no data-") && (target_div_id == "selected_page_name"))	{
		document.getElementById(target_div_id).className = "selection_div highlight";
		popup_msg.popup_msg_type = 1;
		popup_msg.status_msg = "<b>" + page_name + "</b> " + CREATE_PAGE_SELECT_ALREADY_EXISTS_ERR;
		popup_msg.popup_timeout = 5000;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
		document.getElementById("create_btn").className = "button_console_add_disabled";
	}
	else if(target_div_id == "selected_page_name")	{
		document.getElementById(target_div_id).className = "selection_div";
		document.getElementById("create_btn").className = "button_console_add";
	}
	else if (data != "-no data-")	{
		var ts = Math.round((new Date()).getTime() / 1000);
		document.getElementById(target_div_id).innerHTML = document.getElementById(target_div_id).innerHTML + "_" + ts;
	}
}

function ShowEnterPageName()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1 down_sub";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
	
	var page_name_input = document.getElementById("createPage");
	page_name_input.style.display = "block";
	page_name_input.style.position = "absolute";
	page_name_input.style.top = "70px";
	page_name_input.style.left = "300px";
	page_name_input.focus();
}

function ShowSelectLayout()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("createPage").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1 down_sub";
	
	var select_layout_div = document.getElementById("select_layout_div");
	select_layout_div.style.display = "block";
	select_layout_div.style.position = "absolute";
	select_layout_div.style.top = "130px";
	select_layout_div.style.left = "300px";
	select_layout_div.style.zIndex = 10;
}

function ShowPlugins()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";
	document.getElementById("createPage").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1 down_sub";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
	
	var select_plugin_div = document.getElementById("select_plugin_div");
	select_plugin_div.style.display = "block";
	select_plugin_div.style.width = "80%";
	select_plugin_div.style.position = "absolute";
	select_plugin_div.style.top = "100px";
	select_plugin_div.style.left = "300px";
	select_plugin_div.style.zIndex = 10;
}

function ShowSelections()
{
	timer_is_on = 0;
	
	document.getElementById("createPage").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";

	document.getElementById("selections_div").style.display = "block";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
}

function ShowHideChildPlugins(create_plugin_group_checkbox)
{
	if (create_plugin_group_checkbox.checked === true)
		document.getElementById("child_plugin_pages_div").style.display = "block";
	else
		document.getElementById("child_plugin_pages_div").style.display = "none";
}

function CreatePage()
{
	if (document.getElementById("create_btn").className == "button_console_add_disabled")
		return;
		
	if (document.getElementById("create_plugin_group").checked == true)	{
		var child_page_name_divs = document.getElementsByName("child_page_name");
		var child_page_name;
		var child_plugin_id;
		var template_name = document.getElementById("template_name").value;
		var child_plugins = new Array();
		for (i = 0; i < child_page_name_divs.length; i++)
		{
			child_page_name = document.getElementById("child_page_name_" + i).innerHTML;
			child_plugin_id = document.getElementById("child_plugin_id_" + i).value;
			child_plugins[i] = new Array(child_page_name, child_plugin_id);
		}
		
		$.post( "create_page.php", { createPage: child_plugins[0][0], plugin: child_plugins[0][1], template_name: template_name, no_edit: 1 }, function( data ) {ContinueChildPluginPageCreate(data, child_plugins, 0, template_name) } ) ;
	}
	else
		document.getElementById('frmCreatePage').submit();
}

function ContinueChildPluginPageCreate(data, child_plugins, child_plugins_index, template_name)
{
	child_plugins_index++;
	if (child_plugins_index >= child_plugins.length)
		document.getElementById('frmCreatePage').submit();
	else
		$.post( "create_page.php", { createPage: child_plugins[child_plugins_index][0], plugin: child_plugins[child_plugins_index][1], template_name: template_name, no_edit: 1 }, function( data ) {ContinueChildPluginPageCreate(data, child_plugins, child_plugins_index, template_name) } ) ;
}

function DisplayNoPluginsInSubCatMsg(sub_category, cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			if (ElExists(cat_div_str))
				document.getElementById(cat_div_str).style.display = "none";
			cat_select = "cat_select" + i;
			if (ElExists(cat_select))
				document.getElementById(cat_select).className = "button_sub_level_1";
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 + " <b>'" + sub_category + "'</b>. " + CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 + " <b>'" + GET_MORE_PLUGINS_BTN + "'</b> " + CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3;
	popup_msg.popup_timeout = 6000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 0;
	popup_msg.ShowPopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}