/////////////////////////////////////////////
// Edit Custom CSS /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/1/2014	ELL
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 10/19/2014	ELL
// Converted editor for simple text area to CKEditor is source view.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Revised: 11/10/2016	ELL
// Modified custom CSS editing to allow for any number of custom CSS records associated with custom style sheets.
// Revised: 5/16/2018	ELL
// Added hooks for plugin buttons and code.
// Revised: 4/19/2019	ELL
// Added window resizing if opened from stand-alone CSS editor (no parent).

var mTimer;
var lockoutChangeCheck = true;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

if (self != top)	{
	window.parent.document.title = document.title;
	setTimeout("window.parent.CallResizeWorkspace();", 500);
}
else	{
	var code = "ResizeWorkspaceNoParent();";
	setTimeout(code, 1000);
	window.addEventListener('resize', function(event) {
	mTimer7 = setTimeout("ResizeWorkspaceNoParent();", 500);
	});
}

function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#edit_custom", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////
function LoadCSS()
{
	$.post( "get_custom_css.php", { style_sheet: style_sheet } ).done(CompleteLoadCSS) ;
}
function CompleteLoadCSS(data)
{
//	alert(data);
	CKEDITOR.instances['editorContainer'].setData(data);
	
	mTimer = setTimeout("StartChangeCheckTimer();", 4000);
	bwb_ckeditor.commands.save.disable();
}

function StartChangeCheckTimer()
{
	if (self != top)	{
		bwb_ckeditor.commands.save.disable();
		saved = true;
		window.parent.SetWorkSavedNotSaved(true);
		bwb_ckeditor.resetDirty();
		mTimerCheckDirty = setInterval("somethingChanged();", 8000);
		lockoutChangeCheck = false;
	}
}

function Save(action)
{
	var custom_css = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	$.post( "save_custom_css.php", { custom_css: custom_css, action: action, style_sheet: style_sheet } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	popup_msg.status_msg = data;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	saved = true;
	window.parent.SetWorkSavedNotSaved(saved);
	bwb_ckeditor.resetDirty();
}

function RevertConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDITOR_REVERT_CSS_CONFIRM_1_MSG + " <b>" + style_sheet + "</b> " + EDITOR_REVERT_CSS_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { Revert(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}
function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_REVERTING_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	$.post( "revert_custom_css.php", { style_sheet: style_sheet } ).done(CompleteRevert) ;
}
function CompleteRevert(data)	{
	if (data == "No draft found")
		popup_msg.status_msg = data;
	else	{
		popup_msg.status_msg = EDITOR_REVERT_COMPLETE_MSG;
		CKEDITOR.instances['editorContainer'].setData(data);
	}
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 3;
	popup_msg.popup_msg_cell = EDITOR_CSS_NOT_SAVED_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_button_3_span = CANCEL_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
	document.getElementById("popup_button_3_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function PreviewPageSelect()
{
	var ntop = tempY - 450;
	var strtop = ntop + "px";
	document.getElementById("page_select_div").style.display = "block";
	document.getElementById("page_select_div").style.bottom = strtop;
}
var preview_window;
function Preview(page_name, do_refresh)
{
	document.getElementById("page_select_div").style.display = "none";
	var custom_css = CKEDITOR.instances['editorContainer'].getData();
	
	$.post( "save_custom_css.php", { custom_css: custom_css, action: "Preview", style_sheet: style_sheet }, function(data){ ShowPreview(data, do_refresh, page_name); }, "text" ) ;
}
function ShowPreview(data, do_refresh, page_name)
{
	if (do_refresh != 1)	{
		var preview_page_string = "preview_page.php?page_name=" + page_name + "&special=3&mode=0&blog_id=0&style_sheet=" + style_sheet;
		preview_window = window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
	}
	else
		preview_window.location.reload();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function SaveBeforeMain()
{
	Save('Save');
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {
	var editorWidth = mainWidth - menuWidth - 2;
	var btnDivWidth = editorWidth - 2;
	document.getElementById("btn_div").style.width = btnDivWidth.toString() + "px";
	var btnDivHeight = document.getElementById("btn_div").clientHeight;
	var editorHeight = mainHeight - headerHeight - btnDivHeight - 20;

	CKEDITOR.instances['editorContainer'].resize(editorWidth, editorHeight);
	
	sEditorWidth = editorWidth.toString() + "px";
}

function ResizeWorkspaceNoParent()
{
	ResizeWorkspace(window.innerWidth, window.innerHeight, 0, 0);
}