/////////////////////////////////////////////
// Edit File Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/17/2014	ELL
// Modified: 9/12/2016	ELL
// Added ability to drill down thru file tree.

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var level = 0;

function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#edit_file", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowFiles(folder, sub_folder, btn_div)
{
	var show_hidden = 0;
	if (document.getElementById('show_hidden').checked)
		show_hidden = 1;
	$.post( "get_files.php", { folder: folder, sub_folder: sub_folder, show_hidden: show_hidden, source: "edit_file_select.php" } ).done(CompleteShowFiles) ;
	document.getElementById("btn_pages").className = "button_sub_level_1";
	document.getElementById("btn_scripts").className = "button_sub_level_1";
	document.getElementById("btn_php").className = "button_sub_level_1";
	var btn = "btn_";
	if (folder.indexOf(BWB_SCRIPTS_DIR) > -1)
		btn = btn + "scripts";
	else if (folder.indexOf(BWB_LIB_DIR) > -1)
		btn = btn + "php";
	else
		btn = btn + "pages";
	document.getElementById(btn).className = "button_sub_level_1 down_sub";
	
	if ((sub_folder == "root") || (sub_folder == ""))
		level = 0;
	else	{
		sub_folder_arr = sub_folder.split("/");
		level =  sub_folder_arr.length - 1;
	}
	
	if (btn_div != "-no button-")	{
		var btn_container = btn_div.parentNode;
		var btn_divs = btn_container.children;
		for(var i = 0; i < btn_divs.length; i++) {
			if ((btn_divs[i].tagName == 'DIV') && (btn_divs[i].className != "button_heading_sub_level_1"))	{
				if (btn_divs[i].className == "button_sub_level_1 btn_folder_select down_sub")
					btn_divs[i].className = "button_sub_level_1 btn_folder_select";
			}
		}
		if (btn_div.className == "button_sub_level_1 btn_folder_select")	{
			btn_div.className = "button_sub_level_1 btn_folder_select down_sub";
			btn_div.style.backgroundImage = "url('theme/" + theme + "/images/icon_Folder_sm_mo.png')";
		}
		else
			btn_div.className = "button_sub_level_1 down_sub";
	}
}
function CompleteShowFiles(data)
{
	document.getElementById("sub_level_2_buttons").style.display = "block";
	if (level == 0)
		document.getElementById("file_list_div").innerHTML = data;
	
	if (level > 0)	{
		document.getElementById("sub_level_3_buttons").style.display = "block";
		if (level == 1)
			document.getElementById("file_list_div_2").innerHTML = data;
	}
	else
		document.getElementById("sub_level_3_buttons").style.display = "none";
		
	if (level > 1)	{
		document.getElementById("sub_level_4_buttons").style.display = "block";
		if (level == 2)
			document.getElementById("file_list_div_3").innerHTML = data;
	}
	else
		document.getElementById("sub_level_4_buttons").style.display = "none";
		
	if (level > 2)	{
		document.getElementById("sub_level_5_buttons").style.display = "block";
		if (level == 3)
			document.getElementById("file_list_div_4").innerHTML = data;
	}
	else
		document.getElementById("sub_level_5_buttons").style.display = "none";
		
	if (level > 3)	{
		document.getElementById("sub_level_6_buttons").style.display = "block";
		if (level == 4)
			document.getElementById("file_list_div_5").innerHTML = data;
	}
	else
		document.getElementById("sub_level_6_buttons").style.display = "none";
		
	if (level > 4)	{
		document.getElementById("sub_level_7_buttons").style.display = "block";
		if (level == 5)
			document.getElementById("file_list_div_6").innerHTML = data;
	}
	else
		document.getElementById("sub_level_7_buttons").style.display = "none";
		
	if (level > 5)	{
		document.getElementById("sub_level_8_buttons").style.display = "block";
		if (level == 6)
			document.getElementById("file_list_div_7").innerHTML = data;
	}
	else
		document.getElementById("sub_level_8_buttons").style.display = "none";
		
	if (level > 6)	{
		document.getElementById("sub_level_9_buttons").style.display = "block";
		if (level == 7)
			document.getElementById("file_list_div_8").innerHTML = data;
	}
	else
		document.getElementById("sub_level_9_buttons").style.display = "none";
	
	if (level > 7)	{
		document.getElementById("sub_level_10_buttons").style.display = "block";
		if (level == 8)
			document.getElementById("file_list_div_9").innerHTML = data;
	}
	else
		document.getElementById("sub_level_10_buttons").style.display = "none";
		
	if (level > 8)	{
		document.getElementById("sub_level_11_buttons").style.display = "block";
		if (level == 9)
			document.getElementById("file_list_div_10").innerHTML = data;
	}
	else
		document.getElementById("sub_level_11_buttons").style.display = "none";
		
	if (level > 9)	{
		document.getElementById("sub_level_12_buttons").style.display = "block";
		if (level == 10)
			document.getElementById("file_list_div_11").innerHTML = data;
	}
	else
		document.getElementById("sub_level_12_buttons").style.display = "none";
		
	if (level > 10)	{
		document.getElementById("sub_level_13_buttons").style.display = "block";
		if (level == 11)
			document.getElementById("file_list_div_12").innerHTML = data;
	}
	else
		document.getElementById("sub_level_13_buttons").style.display = "none";
		
	if (level > 11)	{
		document.getElementById("sub_level_14_buttons").style.display = "block";
		if (level == 12)
			document.getElementById("file_list_div_13").innerHTML = data;
	}
	else
		document.getElementById("sub_level_14_buttons").style.display = "none";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function CreateFolderMsg(folder, sub_folder)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.popup_msg_type = 4;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_prompt_cell = FOLDER_NAME + ": ";
	popup_msg.popup_button_2_span = CANCEL_WORD;
	popup_msg.popup_button_1_span = OK_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { popup_msg.HidePopupMsg(); };
	document.getElementById("popup_button_1_span").onclick = function () { CreateFolder(folder, sub_folder); };
}

function CreateFolder(folder, sub_folder)
{
	var new_folder = document.getElementById("popup_prompt_textbox").value;
	if ((new_folder == null) || (new_folder == ""))
	{
		alert(EDITOR_FOLDER_BLANK_ERR);
		return;
	}
	
	var folder_exists;
	var desired_folder = "";
	if ((sub_folder != "root") && (sub_folder != ""))
		desired_folder = sub_folder + "/" + new_folder;
	else
		desired_folder = new_folder;
	$.post( "check_file_exists.php", { file_name: desired_folder, folder: folder }, function(data){ folder_exists = data; }, "text" ) ;
		
	if (folder_exists == "1")
		alert(EDITOR_FOLDER_ALREADY_EXISTS_1_ERR + " " + new_folder + " " + EDITOR_FOLDER_ALREADY_EXISTS_2_ERR);
	else
	{
		$.post( "create_dir.php", { new_folder: new_folder, folder: folder, sub_folder: sub_folder } ).done(CompleteCreateFolder) ;
	}
	
	popup_msg.HidePopupMsg();
}
function CompleteCreateFolder(data)
{
	var result_arr = data.split("@@@@@");
	
	if (result_arr[0] == -1)
		alert(EDITOR_ERROR_CREATING_FOLDER_ERR);
	else
		ShowFiles(result_arr[2], result_arr[3], "-no button-");
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved file.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}