/////////////////////////////////////////////
// Main Menu Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/20/2013	ELL
// New main.php created for version 5 of the BWB.
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 12/22/2013	ELL
// Added ability to check for saved wokspace data and prompt user for action.
// Added session checking and prompt for re-login if logged out.
// Revised: 4/3/2014	ELL
// Added button for installing plugins into existing pages.
// Revised: 4/14/2014	ELL
// Added ability to present plugin buttons to bloggers and restricted users if plugin access set to blogger or restricted.
// Revised: 11/17/2014	ELL
// Added new button for editing files.
// Revised 1/12/2015	ELL
// Added code to hide/show new NEW SESSION button. Fixed bug with sliver of LOGOUT button showing with collapsed header.
// Revised: 1/18/2016	ELL
// Added ability to put custom in any button group.
// Revined: 4/18/2016	ELL
// Fixed bug with menu groups locking up due to plugin_button = notdefined.
// Removed "Manage Head Code" from main menu which is now consolidated with "Edit Head Code".  Renamed "Edit Head Code" to "Manage Head Code".
// "Manage Head Code" now exists as "Manage Custom Head Code" under "Manage Head Code".
// Added ability to switch CSS menu tools and JS menu tools on or off.
// Revised: 11/22/2017	ELL
// Made "Users & Site Options" button modal switchig to "Manage My Account" when logged in as non-admin but at least user access level.
// Revised: 4/27/2018	ELL
// Added "Minify Files" button.
// Revised: 11/23/2018	ELL
// Modified to go to last selected module if session timed out and logging back in.
// 
// 
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var menu_width_expanded = 260;
var menu_width_collapsed = 44;
var menu_item_height = 32;
var anni_delay = 15;
var horiz_anni_delay = 5;
var vert_anni_delay = 5;
var header_height = 108;
var workspace_left_expanded = 302;
var workspace_top_expanded = 134;
var workspace_height_expanded = 720;

var mTimer = null;
var mTimer2 = null;
var mTimer3 = null;
var mTimer4 = null;
var mTimer5 = null;
var mTimer6 = null;
var mTimer7 = null;
var curr_height = 0;
var curr_height2 = 0;
var curr_height3 = 0;
var curr_height4 = 0;
var curr_height5 = 0;
var curr_height6 = header_height;

var mTimerH = null;
var curr_width = 0;
var workspace_width;
var workspace_left;
var workspace_height;
var workspace_top;

if ((browser == "Explorer") && (browser_version <= 7))
	var inherit = "";
else
	var inherit = "inherit";
	
var work_saved = true;
var next_btn;
var mSessionTimer;

/////////////////////////////////////////////////////////////////////
function ExpandCollapseMenus(menu_group)
{
	if ((menu_group == "content_functions") && (mTimer == null) && (document.getElementById("btn_edit_content").style.height != (menu_item_height.toString() + 'px')))
	{
		curr_height = 0;
		mTimer = setInterval(function() {ExpandContentFunctions()}, anni_delay);
	}
	else if ((menu_group != "content_functions") && (mTimer == null) && (document.getElementById("btn_edit_content").style.height != '0px'))
	{
		curr_height = menu_item_height;
		mTimer = setInterval(function() {CollapseContentFunctions()}, anni_delay);
	}
	
	if ((menu_group == "menu_functions") && (mTimer2 == null)&& (document.getElementById("btn_edit_menu_items").style.height != (menu_item_height.toString() + 'px')))
	{
		curr_height2 = 0;
		mTimer2 = setInterval(function() {ExpandMenuFunctions()}, anni_delay);
	}
	else if ((menu_group != "menu_functions") && (mTimer2 == null) && (document.getElementById("btn_edit_menu_items").style.height != '0px'))
	{
		curr_height2 = menu_item_height;
		mTimer2 = setInterval(function() {CollapseMenuFunctions()}, anni_delay);
	}
	
	if ((menu_group == "style_functions") && (mTimer3 == null)&& (document.getElementById("btn_edit_styles").style.height != (menu_item_height.toString() + 'px')))
	{
		curr_height3 = 0;
		mTimer3 = setInterval(function() {ExpandStyleFunctions()}, anni_delay);
	}
	else if ((menu_group != "style_functions") && (mTimer3 == null) && (document.getElementById("btn_edit_styles").style.height != '0px'))
	{
		curr_height3 = menu_item_height;
		mTimer3 = setInterval(function() {CollapseStyleFunctions()}, anni_delay);
	}
	
	if ((menu_group == "page_functions") && (mTimer4 == null)&& (document.getElementById("btn_edit_page_titles").style.height != (menu_item_height.toString() + 'px')))
	{
		curr_height4 = 0;
		mTimer4 = setInterval(function() {ExpandPageFunctions()}, anni_delay);
	}
	else if ((menu_group != "page_functions") && (mTimer4 == null) && (document.getElementById("btn_edit_page_titles").style.height != '0px'))
	{
		curr_height4 = menu_item_height;
		mTimer4 = setInterval(function() {CollapsePageFunctions()}, anni_delay);
	}

	if ((access_level != "blogger") && (access_level != "restricted"))
	{
		if ((menu_group == "other_functions") && (mTimer5 == null) && (document.getElementById("btn_users_site_options").style.height != (menu_item_height.toString() + 'px')))
		{
			curr_height5 = 0;
			mTimer5 = setInterval(function() {ExpandOtherFunctions()}, anni_delay);
		}
		else if ((menu_group != "other_functions") && (mTimer5 == null) && (document.getElementById("btn_users_site_options").style.height != '0px'))
		{
			curr_height5 = menu_item_height;
			mTimer5 = setInterval(function() {CollapseOtherFunctions()}, anni_delay);
		}
	}
	else if (show_other)
	{
		if ((menu_group == "other_functions") && (mTimer5 == null) && (document.getElementById("btn_custom_0").style.height != (menu_item_height.toString() + 'px')))
		{
			curr_height5 = 0;
			mTimer5 = setInterval(function() {ExpandOtherFunctions()}, anni_delay);
		}
		else if ((menu_group != "other_functions") && (mTimer5 == null) && (document.getElementById("btn_custom_0").style.height != '0px'))
		{
			curr_height5 = menu_item_height;
			mTimer5 = setInterval(function() {CollapseOtherFunctions()}, anni_delay);
		}
	}
}
/////////////////////////////////////////////////////////////////////
function ExpandContentFunctions()
{	
	var strHeight = curr_height.toString() + 'px';
	var plugin_button;
	if (access_level != "blogger")
	{
		document.getElementById("btn_edit_content").style.height = strHeight;
		if (access_level != "restricted")
		{
			document.getElementById("btn_create_page").style.height = strHeight;
			document.getElementById("btn_manage_images").style.height = strHeight;
		}
		if ((access_level == "admin") || (access_level == "power_user"))
			document.getElementById("btn_manage_border_areas").style.height = strHeight;
		if (access_level == "admin")
			document.getElementById("btn_edit_file").style.height = strHeight;
	}
	document.getElementById("btn_preview_published_site").style.height = strHeight;
	document.getElementById("btn_manage_edit_blog").style.height = strHeight;
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "content_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height == 0)
	{
		if (access_level != "blogger")
		{
			document.getElementById("btn_edit_content").style.display = inherit;
			if (access_level != "restricted")
			{
				document.getElementById("btn_create_page").style.display = inherit;
				document.getElementById("btn_manage_images").style.display = inherit;
			}
			if ((access_level == "admin") || (access_level == "power_user"))
				document.getElementById("btn_manage_border_areas").style.display = inherit;
			if (access_level == "admin")
				document.getElementById("btn_edit_file").style.display = inherit;
		}
		document.getElementById("btn_preview_published_site").style.display = inherit;
		document.getElementById("btn_manage_edit_blog").style.display = inherit;
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "content_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = inherit;
				}
			}
		}
	}

	curr_height++;
	if (curr_height > menu_item_height)
	{
		clearInterval(mTimer);
		mTimer = null;
	}
}

function CollapseContentFunctions()
{
	var strHeight = curr_height.toString() + 'px';
	var plugin_button;
	if (access_level != "blogger")
	{
		document.getElementById("btn_edit_content").style.height = strHeight;
		if (access_level != "restricted")
		{
			document.getElementById("btn_create_page").style.height = strHeight;
			document.getElementById("btn_manage_images").style.height = strHeight;
		}
		if ((access_level == "admin") || (access_level == "power_user"))
			document.getElementById("btn_manage_border_areas").style.height = strHeight;
		if (access_level == "admin")
			document.getElementById("btn_edit_file").style.height = strHeight;
	}
	document.getElementById("btn_preview_published_site").style.height = strHeight;
	document.getElementById("btn_manage_edit_blog").style.height = strHeight;
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "content_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height <= 0)
	{
		document.getElementById("btn_edit_content").style.display = "none";
		document.getElementById("btn_create_page").style.display = "none";
		document.getElementById("btn_manage_images").style.display = "none";
		document.getElementById("btn_manage_border_areas").style.display = "none";
		document.getElementById("btn_preview_published_site").style.display = "none";
		document.getElementById("btn_manage_edit_blog").style.display = "none";
		document.getElementById("btn_edit_file").style.display = "none";
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "content_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = "none";
				}
			}
		}
	}
	
	curr_height--;
	if (curr_height < 0)
	{
		clearInterval(mTimer);
		mTimer = null;
	}
}


function ExpandMenuFunctions()
{
	var strHeight = curr_height2.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_menu_items").style.height = strHeight;
	if (access_level != "user")
	{
		document.getElementById("btn_manage_menu_assignments").style.height = strHeight;
		document.getElementById("btn_edit_css_menu_params").style.height = strHeight;
		document.getElementById("btn_edit_css_menu_styles").style.height = strHeight;
	}
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "menu_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height2 == 0)
	{
		document.getElementById("btn_edit_menu_items").style.display = inherit;
		if (access_level != "user")
		{
			document.getElementById("btn_manage_menu_assignments").style.display = inherit;
			document.getElementById("btn_edit_css_menu_params").style.display = inherit;
			document.getElementById("btn_edit_css_menu_styles").style.display = inherit;
		}
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "menu_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = inherit;
				}
			}
		}
	}
	
	curr_height2++;
	if (curr_height2 > menu_item_height)
	{
		clearInterval(mTimer2);
		mTimer2 = null;
	}
}

function CollapseMenuFunctions()
{
	var strHeight = curr_height2.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_menu_items").style.height = strHeight;
	if (access_level != "user")
	{
		document.getElementById("btn_manage_menu_assignments").style.height = strHeight;
		document.getElementById("btn_edit_css_menu_params").style.height = strHeight;
		document.getElementById("btn_edit_css_menu_styles").style.height = strHeight;
	}
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "menu_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height2 <= 0)
	{
		document.getElementById("btn_edit_menu_items").style.display = "none";
		document.getElementById("btn_manage_menu_assignments").style.display = "none";
		document.getElementById("btn_edit_css_menu_params").style.display = "none";
		document.getElementById("btn_edit_css_menu_styles").style.display = "none";
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "menu_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = "none";
				}
			}
		}
	}
	
	curr_height2--;
	if (curr_height2 < 0)
	{
		clearInterval(mTimer2);
		mTimer2 = null;
	}
}


function ExpandStyleFunctions()
{
	var strHeight = curr_height3.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_styles").style.height = strHeight;
	document.getElementById("btn_edit_head_code").style.height = strHeight;
	document.getElementById("btn_edit_favicon").style.height = strHeight;
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "style_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height3 == 0)
	{
		document.getElementById("btn_edit_styles").style.display = inherit;
		document.getElementById("btn_edit_head_code").style.display = inherit;
		document.getElementById("btn_edit_favicon").style.display = inherit;
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "style_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = inherit;
				}
			}
		}
	}
	
	curr_height3++;
	if (curr_height3 > menu_item_height)
	{
		clearInterval(mTimer3);
		mTimer3 = null;
	}
}

function CollapseStyleFunctions()
{
	var strHeight = curr_height3.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_styles").style.height = strHeight;
	document.getElementById("btn_edit_head_code").style.height = strHeight;
	document.getElementById("btn_edit_favicon").style.height = strHeight;
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "style_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height3 <= 0)
	{
		document.getElementById("btn_edit_styles").style.display = "none";
		document.getElementById("btn_edit_head_code").style.display = "none";
		document.getElementById("btn_edit_favicon").style.display = "none";
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "style_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = "none";
				}
			}
		}
	}
	
	curr_height3--;
	if (curr_height3 < 0)
	{
		clearInterval(mTimer3);
		mTimer3 = null;
	}
}


function ExpandPageFunctions()
{
	var strHeight = curr_height4.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_page_titles").style.height = strHeight;
	document.getElementById("btn_edit_meta_tags").style.height = strHeight;
	if (access_level != "user")
	{
		document.getElementById("btn_delete_page").style.height = strHeight;
		document.getElementById("btn_copy_rename_page").style.height = strHeight;
		document.getElementById("btn_restore_page").style.height = strHeight;
		document.getElementById("btn_add_plugin_to_page").style.height = strHeight;
		document.getElementById("btn_manage_page_access").style.height = strHeight;
		document.getElementById("btn_manage_page_attributes").style.height = strHeight;
	}
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "page_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height4 == 0)
	{
		document.getElementById("btn_edit_page_titles").style.display = inherit;
		document.getElementById("btn_edit_meta_tags").style.display = inherit;
		if (access_level != "user")
		{
			document.getElementById("btn_delete_page").style.display = inherit;
			document.getElementById("btn_copy_rename_page").style.display = inherit;
			document.getElementById("btn_restore_page").style.display = inherit;
			document.getElementById("btn_add_plugin_to_page").style.display = inherit;
			document.getElementById("btn_manage_page_access").style.display = inherit;
			document.getElementById("btn_manage_page_attributes").style.display = inherit;
		}
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "page_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = inherit;
				}
			}
		}
	}
	
	curr_height4++;
	if (curr_height4 > menu_item_height)
	{
		clearInterval(mTimer4);
		mTimer4 = null;
	}
}

function CollapsePageFunctions()
{
	var strHeight = curr_height4.toString() + 'px';
	var plugin_button;
	document.getElementById("btn_edit_page_titles").style.height = strHeight;
	document.getElementById("btn_edit_meta_tags").style.height = strHeight;
	if (access_level != "user")
	{
		document.getElementById("btn_delete_page").style.height = strHeight;
		document.getElementById("btn_copy_rename_page").style.height = strHeight;
		document.getElementById("btn_restore_page").style.height = strHeight;
		document.getElementById("btn_add_plugin_to_page").style.height = strHeight;
		document.getElementById("btn_manage_page_access").style.height = strHeight;
		document.getElementById("btn_manage_page_attributes").style.height = strHeight;
	}
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && (plugin_button[1] == "page_functions"))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height4 <= 0)
	{
		document.getElementById("btn_edit_page_titles").style.display = "none";
		document.getElementById("btn_edit_meta_tags").style.display = "none";
		document.getElementById("btn_delete_page").style.display = "none";
		document.getElementById("btn_copy_rename_page").style.display = "none";
		document.getElementById("btn_restore_page").style.display = "none";
		document.getElementById("btn_add_plugin_to_page").style.display = "none";
		document.getElementById("btn_manage_page_access").style.display = "none";
		document.getElementById("btn_manage_page_attributes").style.display = "none";
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && (plugin_button[1] == "page_functions"))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = "none";
				}
			}
		}
	}
	
	curr_height4--;
	if (curr_height4 < 0)
	{
		clearInterval(mTimer4);
		mTimer4 = null;
	}
}


function ExpandOtherFunctions()
{
	var strHeight = curr_height5.toString() + 'px';
	var btn_custom_str;
	var i;
	var plugin_button;
	if ((access_level != "blogger") && (access_level != "restricted"))
	{
		if (enable_wizard == 1)
			document.getElementById("btn_show_wizard").style.height = strHeight;;
		if ((access_level == "admin") || (access_level == "power_user"))
			document.getElementById("btn_minify_files").style.height = strHeight;
		document.getElementById("btn_users_site_options").style.height = strHeight;
	}
	
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && ((plugin_button[1] == "other_functions") || (plugin_button[1] == "")))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height5 == 0)
	{
		if ((access_level != "blogger") && (access_level != "restricted"))
		{
			if (enable_wizard == 1)
				document.getElementById("btn_show_wizard").style.display = inherit;
			if ((access_level == "admin") || (access_level == "power_user"))
				document.getElementById("btn_minify_files").style.display = inherit;
			document.getElementById("btn_users_site_options").style.display = inherit;
		}
			
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && ((plugin_button[1] == "other_functions") || (plugin_button[1] == "")))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = inherit;
				}
			}
		}
	}
	
	curr_height5++;
	if (curr_height5 > menu_item_height)
	{
		clearInterval(mTimer5);
		mTimer5 = null;
	}
}

function CollapseOtherFunctions()
{
	var strHeight = curr_height5.toString() + 'px';
	var btn_custom_str;
	var i;
	if ((access_level != "blogger") && (access_level != "restricted"))
	{
		if (enable_wizard == 1)
			document.getElementById("btn_show_wizard").style.height = strHeight;
		if ((access_level == "admin") || (access_level == "power_user"))
			document.getElementById("btn_minify_files").style.height = strHeight;
		document.getElementById("btn_users_site_options").style.height = strHeight;
	}
		
	for (i = 0; i < plugin_button_cnt; i++)
	{
		plugin_button = plugin_buttons[i];
		if (typeof plugin_button != 'undefined')	{
			if ((plugin_button[0] == i) && ((plugin_button[1] == "other_functions") || (plugin_button[1] == "")))	{
				btn_custom_str = "btn_custom_" + parseInt(i);
				document.getElementById(btn_custom_str).style.height = strHeight;
			}
		}
	}
	
	if (curr_height5 <= 0)
	{
		if ((access_level != "blogger") && (access_level != "restricted"))
		{
			if (enable_wizard == 1)
				document.getElementById("btn_show_wizard").style.display = "none";
			if ((access_level == "admin") || (access_level == "power_user"))
				document.getElementById("btn_minify_files").style.display = "none";
			document.getElementById("btn_users_site_options").style.display = "none";
		}
		
		for (i = 0; i < plugin_button_cnt; i++)
		{
			plugin_button = plugin_buttons[i];
			if (typeof plugin_button != 'undefined')	{
				if ((plugin_button[0] == i) && ((plugin_button[1] == "other_functions") || (plugin_button[1] == "")))	{
					btn_custom_str = "btn_custom_" + parseInt(i);
					document.getElementById(btn_custom_str).style.display = "none";
				}
			}
		}
	}
	
	curr_height5--;
	if (curr_height5 < 0)
	{
		clearInterval(mTimer5);
		mTimer5 = null;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function HorizontalExpandCollapseMenuClick()
{
	var img_src = document.getElementById("btn_horizontal_expand_collapse_menus").src;
	
	if (img_src.indexOf("theme/" + theme + "/images/icon_collapse-column.png") > -1)
	{
		if (mTimerH == null)
		{
			curr_width = menu_width_expanded;
			workspace_width = document.getElementById("workspace").width;
			workspace_width = workspace_width.replace("px", "");
			if ((document.getElementById("workspace").style.left) == "")
				workspace_left = workspace_left_expanded;
			else
			{
				workspace_left = document.getElementById("workspace").style.left;
				workspace_left = workspace_left.replace("px", "");
			}
			mTimerH = setInterval(function() {HorizontalExpandCollapseMenus(0)}, horiz_anni_delay);
		}
	}
	else
	{
		if (mTimerH == null)
		{
			curr_width = menu_width_collapsed;
			workspace_width = document.getElementById("workspace").width;
			workspace_width = workspace_width.replace("px", "");
			workspace_left = document.getElementById("workspace").style.left;
			workspace_left = workspace_left.replace("px", "");
			mTimerH = setInterval(function() {HorizontalExpandCollapseMenus(1)}, horiz_anni_delay);
		}
	}
}

function HorizontalExpandCollapseMenus(expand_collapse)
{
	var strWidth = curr_width.toString() + 'px';
	var strWorkspaceWidth = workspace_width.toString() + 'px';
	var strWorkspaceLeft = workspace_left.toString() + 'px';
	
	document.getElementById("view_buttons").style.width = strWidth;
	document.getElementById("workspace").width = strWorkspaceWidth;
	document.getElementById("workspace").style.left = strWorkspaceLeft;
	
	if (expand_collapse == 1)
	{
		curr_width = parseInt(curr_width) + 2;
		workspace_width = parseInt(workspace_width) - 2;
		workspace_left = parseInt(workspace_left) + 2;
		if (curr_width > menu_width_expanded)
		{
			document.getElementById("btn_horizontal_expand_collapse_menus").src = "theme/" + theme + "/images/icon_collapse-column.png";
			clearInterval(mTimerH);
			mTimerH = null;
		}
	}
	else
	{
		curr_width = parseInt(curr_width) - 2;
		workspace_width = parseInt(workspace_width) + 2;
		workspace_left = parseInt(workspace_left) - 2;
		if (curr_width < menu_width_collapsed)
		{
			document.getElementById("btn_horizontal_expand_collapse_menus").src = "theme/" + theme + "/images/icon_expand-column.png";
			clearInterval(mTimerH);
			mTimerH = null;
		}
	}
}

/////////////////////////////////////////////////////////////////////
function CollapseHeader()
{
	if ((mTimer6 == null) && (curr_height6 >= header_height))
	{
		if ((document.getElementById("workspace").height) == "")
				workspace_height = workspace_height_expanded;
		else
		{
			workspace_height = document.getElementById("workspace").height;
			workspace_height = workspace_height.replace("px", "");
		}
		
		if ((document.getElementById("workspace").style.top) == "")
			workspace_top = workspace_top_expanded;
		else
		{
			workspace_top = document.getElementById("workspace").style.top;
			workspace_top = workspace_top.replace("px", "");
		}
		
		mTimer6 = setInterval(function() {AnimateCollapseHeader()}, vert_anni_delay);
	}
}

function AnimateCollapseHeader()
{
	var strHeight = curr_height6.toString() + 'px';
	var strWorkspageHeight = workspace_height.toString() + 'px';
	var strWorkspageTop = workspace_top.toString() + 'px';
	document.getElementById("logo_div").style.height = strHeight;
	document.getElementById("workspace").height = strWorkspageHeight;
	document.getElementById("workspace").style.top = strWorkspageTop;
	
	if (curr_height6 <= 0)
	{
		document.getElementById("logo_div").style.display = "none";
		document.getElementById("help_button").style.display = "none";
		document.getElementById("btn_logout").style.display = "none";
		if ((access_level == "power_user") || (access_level == "admin"))
			document.getElementById("btn_new_session").style.display = "none";
	}
	
	curr_height6--;
	workspace_height++;
	workspace_top--;
	if (curr_height6 < 0)
	{
		var styleElem = document.createElement('style');
		styleElem.type = 'text/css' ;
		var css = 'body.main{background-position: 200px 0px;}' ;
		var head = document.getElementsByTagName('head')[0] ;
		head.appendChild(styleElem);
    	styleElem.appendChild(document.createTextNode(css));

		clearInterval(mTimer6);
		mTimer6 = null;
	}
}

function ExpandHeader()
{
	if ((mTimer6 == null) && (curr_height6 <= 0))
	{
		mTimer6 = setInterval(function() {AnimateExpandHeader()}, vert_anni_delay);
	}
}

function AnimateExpandHeader()
{
	var strHeight = curr_height6.toString() + 'px';
	var strWorkspageHeight = workspace_height.toString() + 'px';
	var strWorkspageTop = workspace_top.toString() + 'px';
	document.getElementById("logo_div").style.height = strHeight;
	document.getElementById("workspace").height = strWorkspageHeight;
	document.getElementById("workspace").style.top = strWorkspageTop;
	
	if (curr_height6 == 0)
	{
		document.getElementById("logo_div").style.display = inherit;
		document.getElementById("help_button").style.display = inherit;
		document.getElementById("btn_logout").style.display = inherit;
		if ((access_level == "power_user") || (access_level == "admin"))
			document.getElementById("btn_new_session").style.display = inherit;
	}

	curr_height6++;
	workspace_height--;
	workspace_top++;
	if (curr_height6 > header_height)
	{
		var styleElem = document.createElement('style');
		styleElem.type = 'text/css' ;
		var css = 'body.main{background-position: -200px 0px;}' ;
		var head = document.getElementsByTagName('head')[0] ;
		head.appendChild(styleElem);
    	styleElem.appendChild(document.createTextNode(css));
		
		clearInterval(mTimer6);
		mTimer6 = null;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function SetBtnDown(btn)
{
	// Reset all buttons to mouse out state.
	document.getElementById("btn_edit_content").className =	"button_top_level";
	document.getElementById("btn_create_page").className =	"button_top_level";
	document.getElementById("btn_manage_border_areas").className =	"button_top_level";
	document.getElementById("btn_manage_images").className =	"button_top_level";
	document.getElementById("btn_preview_published_site").className =	"button_top_level";
	document.getElementById("btn_manage_edit_blog").className =	"button_top_level";
	document.getElementById("btn_edit_file").className =	"button_top_level";
	document.getElementById("btn_edit_menu_items").className =	"button_top_level";
	document.getElementById("btn_manage_menu_assignments").className =	"button_top_level";
	document.getElementById("btn_edit_css_menu_params").className =	"button_top_level";
	document.getElementById("btn_edit_css_menu_styles").className =	"button_top_level";
	document.getElementById("btn_edit_styles").className =	"button_top_level";
	document.getElementById("btn_edit_head_code").className =	"button_top_level";
	document.getElementById("btn_edit_favicon").className =	"button_top_level";
	document.getElementById("btn_edit_page_titles").className =	"button_top_level";
	document.getElementById("btn_edit_meta_tags").className =	"button_top_level";
	document.getElementById("btn_delete_page").className =	"button_top_level";
	document.getElementById("btn_copy_rename_page").className =	"button_top_level";
	document.getElementById("btn_restore_page").className =	"button_top_level";
	document.getElementById("btn_add_plugin_to_page").className =	"button_top_level";
	document.getElementById("btn_manage_page_access").className =	"button_top_level";
	document.getElementById("btn_manage_page_attributes").className =	"button_top_level";
	if ((access_level != "blogger") && (access_level != "restricted"))
	{
		if (enable_wizard == 1)
			document.getElementById("btn_show_wizard").className =	"button_top_level";
		if ((access_level == "admin") || (access_level != "power_user"))
			document.getElementById("btn_minify_files").className =	"button_top_level";
		document.getElementById("btn_users_site_options").className =	"button_top_level";
	}
	for (i = 0; i < plugin_button_cnt; i++)
	{
		btn_custom_str = "btn_custom_" + parseInt(i);
		document.getElementById(btn_custom_str).className =	"button_top_level";
	}
	
	btn.className = btn.className + " down";
}

function GetBtnDown()
{
	var down_btn = document.getElementsByClassName("button_top_level down");
	if (down_btn.length > 0)
		return down_btn[0];
	else
		return "";
}

//////////////////////////////////////////////////////////////////////////////////////
function SetAccessLevel()
{
	if ((access_level == "blogger") || (access_level == "restricted"))
	{
		document.getElementById("menu_functions").style.display = "none";
		document.getElementById("page_functions").style.display = "none";
		if (show_other)
			document.getElementById("other_functions").style.display = inherit;
		else
			document.getElementById("other_functions").style.display = "none";
	}
	else
	{
		document.getElementById("menu_functions").style.display = inherit;
		document.getElementById("page_functions").style.display = inherit;
		document.getElementById("other_functions").style.display = inherit;
	}
		
	if ((access_level == "admin") || (access_level == "power_user"))
		document.getElementById("style_functions").style.display = inherit;
	else
		document.getElementById("style_functions").style.display = "none";
}

//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#main", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

//////////////////////////////////////////////////////////////////////////////////////
function LoadPluginButtons()
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","plugin_buttons.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);
		xmlhttp.send();
	}
}

function UpdateMessage(xmlhttp)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var response_txt = xmlhttp.responseText;
				var plugin_btn_html = response_txt.split(":::");
				var plugin_btn_css = plugin_btn_html[0];
				document.getElementById("plugin_buttons_div").innerHTML = plugin_btn_html[1];
				plugin_button_cnt = plugin_btn_html[2];
				
				var sheet = document.createElement('style')
				sheet.appendChild(document.createTextNode(""));
				sheet.appendChild(document.createTextNode(""));
				sheet.innerHTML = plugin_btn_css;
				document.body.appendChild(sheet);
			}
		}
	}
	return (xmlhttp);
}

//////////////////////////////////////////////////////////////////////////////////////
function SetWorkSavedNotSaved(saved)
{
	work_saved = saved;
}

function SetWorkspaceLocation(module, btn)
{
	if (work_saved) 
	{
		document.title = "Breeze Website Builder";
		workspace.location = module;
		SetBtnDown(btn);
	}
	else
	{
		workspace.DisplayNotSavedMessage(btn);
		next_btn = btn;
	}
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		clearInterval(mSessionTimer);
		xmlhttp.open("POST","check_session.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = CheckSession(xmlhttp, module, btn);
		xmlhttp.send();
		mSessionTimer = setInterval("CheckSessionExec();", 600000);

	}
}

function DoNextClick()
{
	next_btn.click();
	SetBtnDown(next_btn);
}

function CheckSession(xmlhttp, module, btn)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				popup_msg.top_offset = 0;
				popup_msg.left_offset = 300;
				popup_msg.popup_msg_type = 3;
				popup_msg.popup_btn_cnt = 2;
				popup_msg.popup_msg_cell = MAIN_MENU_TIMEOUT_ERR;
				popup_msg.popup_button_2_span = YES_WORD;
				popup_msg.popup_button_1_span = NO_WORD;
				popup_msg.popup_timeout = -1;
				popup_msg.ShowPopupMsg();

				if ((module !== null) && (typeof module !== "undefined") && (module != ""))	{
					var module_encode = encodeURI(module);
					var btn_id = btn.id;
					var url = "index.php?module=" + module_encode + "&btn=" + btn_id;
					document.getElementById("popup_button_2_span").onclick = function () { window.location = url; };
				}
				else
					document.getElementById("popup_button_2_span").onclick = function () { window.location = 'index.php'; };
				document.getElementById("popup_button_1_span").onclick = function () { window.location = '/index.php'; };
				
				clearInterval(mSessionTimer);
			}
		}
	}
	return (xmlhttp);
}

function CheckSessionExec()
{
	var module = workspace.location;
	var btn = GetBtnDown();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","check_session.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = CheckSession(xmlhttp, module, btn);
		xmlhttp.send();
	}
}

mSessionTimer = setInterval("CheckSessionExec();", 600000);

/////////////////////////////////////////////////////////////////////
window.addEventListener('resize', function(event) {
	mTimer7 = setTimeout("CallResizeWorkspace();", 500);
});

function CallResizeWorkspace()
{
	var mainWidth = 0, mainHeight = 0, menuWidth = 0, headerHeight = 0;
	if( typeof( window.innerWidth ) == 'number' ) {
		//Non-IE
		mainWidth = window.innerWidth;
		mainHeight = window.innerHeight;
	} else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
		//IE 6+ in 'standards compliant mode'
		mainWidth = document.documentElement.clientWidth;
		mainHeight = document.documentElement.clientHeight;
	} else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
		//IE 4 compatible
		mainWidth = document.body.clientWidth;
		mainHeight = document.body.clientHeight;
	}

	if ((document.getElementById("btn_horizontal_expand_collapse_menus").src).indexOf("theme/" + theme + "/images/icon_collapse-column.png") > -1)
		menuWidth = 300;
	else
		menuWidth = 90;
		
	if (document.getElementById("logo_div").style.display == "none")
		headerHeight = 25;
	else
		headerHeight = 135;
		
//	window.alert( 'Width = ' + mainWidth + ' --- Height = ' + mainHeight + ' --- Menu Width = ' + menuWidth + ' --- Header Height = ' + headerHeight );
	if ((document.getElementById("btn_edit_content").className.indexOf("down") > -1) || (document.getElementById("btn_manage_border_areas").className.indexOf("down") > -1) || (document.getElementById("btn_manage_edit_blog").className.indexOf("down") > -1) || (document.getElementById("btn_edit_styles").className.indexOf("down") > -1) || (document.getElementById("btn_edit_head_code").className.indexOf("down") > -1) || (document.getElementById("btn_edit_file").className.indexOf("down") > -1))
		document.getElementById("workspace").contentWindow.ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight);
	
	var workspaceWidth = mainWidth - menuWidth;
	var workspaceHeight = mainHeight - headerHeight;
	sWorkspaceWidth = workspaceWidth.toString() + "px";
	sWorkspaceHeight = workspaceHeight.toString() + "px";
	document.getElementById("workspace").style.width = sWorkspaceWidth;
	document.getElementById("workspace").style.height = sWorkspaceHeight;
}