/////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/20/2018	ELL
// Modified: 11/19/2020	ELL
// Added style, italic and bold to sort by font name of fonts table.
// Added font group boxes to distinguish font groups.
// 
//

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

if (self != top)
	window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var border_width = "2px";
var border_style = "solid";
var border_color = "#555";
var row_color_a = "#dddddd";
var row_color_b = "#eeeeee";
var heading_row_color = "#cccccc";

////////////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#custom_fonts", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(i, new_row_flag)
{
	var font_ctl = "font" + i;
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	var font = document.getElementById(font_ctl).value;
	var	src = document.getElementById(src_ctl).value;
	if (new_row_flag == "-new font-")
		font = "-new font-";
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_1_MSG + " <b>" + font + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_2_MSG + " <b>" + src + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_3_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteFont(font, src); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteFont(font, src)
{
	popup_msg.HidePopupMsg();
	if (font != "-new font-")
		$.post( "delete_font.php", { font: font, src: src } ).done(CompleteDeleteFont) ;
	else RetrieveFonts();
}
function CompleteDeleteFont(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	popup_msg.status_msg = MANAGE_CUSTOM_FONTS_DELETE_FONT_COMPLETE_MSG
	popup_msg.ShowPopupMsg();
	RetrieveFonts();
}

//////////////////////////////////////////////////////////////////////////////////////
function ValidateForm(i)
{
	var font_ctl = "font" + i;
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	
	var long_txt_field = "long_txt_field";
	if (document.getElementById(src_type_url_ctl).checked === true)
		long_txt_field = "extra_long_txt_field";
	document.getElementById(font_ctl).className = "med_txt_field";
	document.getElementById(src_ctl).className = long_txt_field;
	document.getElementById(file_browse_ctl).className = "file_browse";
	var bResult = true;
	if (document.getElementById(font_ctl).value == "")	{
		document.getElementById(font_ctl).className = "med_txt_field highlight";
		document.getElementById(font_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_FONT_ERR;
		bResult = false;
	}
	if ((document.getElementById(file_browse_ctl).value == "") && (document.getElementById(src_ctl).value == "") && (document.getElementById(src_type_upload_ctl).checked === true))	{
		document.getElementById(file_browse_ctl).className = "file_browse highlight";
		document.getElementById(file_browse_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_UPLOAD_ERR;
		bResult = false;
	}
	if ((document.getElementById(src_ctl).value == "") && (document.getElementById(src_type_url_ctl).checked === true))	{
		document.getElementById(src_ctl).className = long_txt_field + " highlight";
		document.getElementById(src_ctl).focus();
		popup_msg.status_msg = MANAGE_FONTS_NO_URL_ERR;
		bResult = false;
	}
	if (bResult != true)	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 4000;
		popup_msg.ShowPopupMsg();
	}
	return bResult;
}

function UpdateFont(i)
{
	var font_ctl = "font" + i;
	var src_ctl = "src" + i;
	var old_font_ctl = "old_font" + i;
	var old_src_ctl = "old_src" + i;
	var src_type_upload_ctl = "src_type_upload" + i;
	var src_type_url_ctl = "src_type_url" + i;
	var stretch_ctl = "stretch" + i;
	var style_ctl = "style" + i;
	var weight_ctl = "weight" + i;

	unsaved_new_item = false;

	var font = document.getElementById(font_ctl).value;
	var src = document.getElementById(src_ctl).value;
	var old_font = document.getElementById(old_font_ctl).value;
	var old_src = document.getElementById(old_src_ctl).value;
	var stretch = document.getElementById(stretch_ctl).value;
	var style = document.getElementById(style_ctl).value;
	var weight = document.getElementById(weight_ctl).value;

	var src_type;
	if (document.getElementById(src_type_upload_ctl).checked)
		src_type = "upload";
	else
		src_type = "url";
	
	var ready = ValidateForm(i);

	if (ready == true)	{
		$.post( "save_font.php", { font: font, src: src, old_font: old_font, old_src: old_src, src_type: src_type, stretch: stretch, style: style, weight: weight } ).done(CompleteSaveFont) ;
	}
}
function CompleteSaveFont(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response > 0)	{
		popup_msg.status_msg = MANAGE_FONTS_FONT_SAVED_MSG;
		var code = "RetrieveFonts();";
		setTimeout(code, 3010);
	}
	else
		popup_msg.status_msg = MANAGE_FONTS_ERROR_SAVING_FONT_ERR;
	popup_msg.ShowPopupMsg();
}

function UpdateAll()
{
	for (var i = 0; i < nCount; i++)	{
		UpdateFont(i);
	}
}

////////////////////////////////////////////////////////////////////////////////////
function AddFont()
{
	if (unsaved_new_item === true)	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_FONTS_ADD_BEFORE_SAVE_NEW_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
		return;
	}

	if (self != top)
		window.parent.SetWorkSavedNotSaved(false);
	unsaved_new_item = true;

	var html = document.getElementById("FontsTable").innerHTML;
	var i = nCount;
	var srch_str;
	
	if ((browser == "Explorer") && (browser_version < 9))
		srch_str = "</TABLE>";
	else
		srch_str = "</table>";

	var html_arr = new Array();
	html_arr = html.split(srch_str);
	var html_top = html_arr[0];
	var html_bottom = html.substring(html_top.length);

	var bgclr = "#FFFF99";

	var new_row = new_row + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
		
	new_row = new_row + "<td valign='top'><input type='text' name='font" + i + "' id='font" + i + "' value='' class='med_txt_field' />\n<input type='hidden' name='old_font" + i + "' id='old_font" + i + "' value='-10000000' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	upload_checked = " checked='checked'";
	url_checked = "";
	upload_visible = "";
	url_visible = " style='display:none;'";

	new_row = new_row + "<form id='uploadForm" + i + "' enctype='multipart/form-data' method='post' action='upload_font.php'>\n";
	new_row = new_row + "<input type='file' name='file_browse" + i + "' id='file_browse" + i + "'" + upload_visible + " onChange=\"UploadFont(" + i + ");\" class='file_browse' />\n";
	new_row = new_row + "</form>\n";
	
	new_row = new_row + "<input type='text' value='' name='src" + i + "' id='src" + i + "' class='long_txt_field'" + url_visible + " />\n<input type='hidden' name='old_src" + i + "' id='old_src" + i + "' value='-1000000' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<input type='radio' name='src_type" + i + "' id='src_type_upload" + i + "' value='upload'" + upload_checked + " onClick=\"ShowHideFileBrowse('upload', " + i + ");\" /> " + EDIT_FAVICON_UPLOAD_BTN + "<br />\n";
	new_row = new_row + "<input type='radio' name='src_type" + i + "' id='src_type_url" + i + "' value='url'" + url_checked + " onClick=\"ShowHideFileBrowse('url', " + i + ");\" /> " + EDIT_MENU_ITEMS_URL + "\n";
	new_row = new_row + "</td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='stretch" + i + "' id='stretch" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + " selected='selected'";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='condensed'";
	new_row = new_row + ">" + CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='ultra-condensed'";
	new_row = new_row + ">" + ULTRA_CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='extra-condensed'";
	new_row = new_row + ">" + EXTRA_CONDENSED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='semi-condensed'";
	new_row = new_row + ">" + SEMI_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='expanded'";
	new_row = new_row + ">" + EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='semi-expanded'";
	new_row = new_row + ">" + SEMI_EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='extra-expanded'";
	new_row = new_row + ">" + EXTRA_EXPANDED_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='ultra-expanded'";
	new_row = new_row + ">" + ULTRA_EXPANDED_WORD + "<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";
	
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='style" + i + "' id='style" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + " selected='selected'";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='italic'";
	new_row = new_row + ">" + ITALIC_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='oblique'";
	new_row = new_row + ">" + OBLIQUE_WORD + "<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";
	
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='weight" + i + "' id='weight" + i + "'>\n";
	new_row = new_row + "<option value=''";
	new_row = new_row + ">" + _NOT_SELECTED_ + "<\/option>\n";
	
	new_row = new_row + "<option value='normal'";
	new_row = new_row + ">" + NORMAL_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='bold'";
	new_row = new_row + ">" + BOLD_WORD + "<\/option>\n";
	
	new_row = new_row + "<option value='100'";
	new_row = new_row + ">100<\/option>\n";
	
	new_row = new_row + "<option value='200'";
	new_row = new_row + ">200<\/option>\n";
	
	new_row = new_row + "<option value='300'";
	new_row = new_row + ">300<\/option>\n";
	
	new_row = new_row + "<option value='400'";
	new_row = new_row + ">400<\/option>\n";
	
	new_row = new_row + "<option value='500'";
	new_row = new_row + ">500<\/option>\n";
	
	new_row = new_row + "<option value='600'";
	new_row = new_row + ">600<\/option>\n";
	
	new_row = new_row + "<option value='700'";
	new_row = new_row + ">700<\/option>\n";
	
	new_row = new_row + "<option value='800'";
	new_row = new_row + ">800<\/option>\n";
	
	new_row = new_row + "<option value='900'";
	new_row = new_row + ">900<\/option>\n";
	new_row = new_row + "<\/select>\n</td>\n";

	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateFont(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm(" + i + ", '-new font-');\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<\/tr>\n";

	
	html = html_top + new_row + html_bottom;
	document.getElementById("FontsTable").innerHTML = html;
	nCount++;
	
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveFonts()
{
	$.post( "get_table.php", { table: "fonts", where: "websafe <> 1", order_by: "font, stretch, style, weight", no_prefix: 0 } ).done(PopulateTable) ;
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(table_str)
{
//alert(table_str);
	var rows = new Array();
	var fields = new Array();
	var bgclr, upload_checked, url_checked, upload_visible, url_visible, src_upload, src_url, src_str, long_txt_field;
	var font_str, stretch_str, style_str, weight_str, font_style_str;
	
	var output_str = "<table width='90%' align='center'>\n";
	output_str += "<tr bgcolor='" + heading_row_color + "' class='header_row'>\n";
	output_str += "<td class='header_row'><b>" + FONT_WORD + "<\/b><\/td>\n";
	output_str += "<td class='header_row'><b>" + SOURCE_WORD + "<\/b><\/td>\n";
	output_str += "<td class='header_row'><b>" + COPY_STYLE_TO_MOBILE_SOURCE_TYPE + "<\/b><\/td>\n";
	output_str += "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_STRETCH + "<\/b><\/td>\n";
	output_str += "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_STYLE + "<\/b><\/td>\n";
	output_str += "<td class='header_row'><b>" + MANAGE_CUSTOM_FONTS_WEIGHT + "<\/b><\/td>\n";
	output_str += "<td>&nbsp;<\/td>\n";
	output_str += "<td>&nbsp;<\/td>\n";
	output_str += "<\/tr>\n";

	if (table_str == "-no data-")
		var i = 0;
	else
	{
		var JSON_table = JSON.parse(table_str);

		for (var i in JSON_table)
		{
			var JSON_row = JSON_table[i];
			if (bgclr == row_color_a)
				bgclr = row_color_b;
			else
				bgclr = row_color_a;
				
			output_str += "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\" style=\"background-color: " + bgclr + "\";>\n";
			
			font_str = JSON_row.font;
			stretch_str = JSON_row.stretch;
			style_str = JSON_row.style;
			weight_str = JSON_row.weight;
			font_style_str = "font-family:" + font_str + ";font-size:20px;";
			if ((typeof stretch_str !== "undefined") && (stretch_str !== null) && (stretch_str != ""))
				font_style_str = font_style_str + "font-stretch:" + stretch_str + ";";
			if ((typeof style_str !== "undefined") && (style_str !== null) && (style_str != ""))
				font_style_str = font_style_str + "font-style:" + style_str + ";";
			if ((typeof weight_str !== "undefined") && (weight_str !== null) && (weight_str != ""))
				font_style_str = font_style_str + "font-weight:" + weight_str + ";";
				
			var group_style_first = "";
			var group_style_last = "";
			var group_style_middle = "";
			
			var group_start_style_first = " style=\"border-top: "+border_width+" "+border_style+" "+border_color+"; border-left: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_start_style_last = " style=\"border-top: "+border_width+" "+border_style+" "+border_color+"; border-right: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_start_style_middle = " style=\"border-top: "+border_width+" "+border_style+" "+border_color+";\"";
			
			var group_middle_style_first = " style=\"border-left: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_middle_style_last = " style=\"border-right: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_middle_style_middle = "";
			
			var group_end_style_first = " style=\"border-bottom: "+border_width+" "+border_style+" "+border_color+"; border-left: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_end_style_last = " style=\"border-bottom: "+border_width+" "+border_style+" "+border_color+"; border-right: "+border_width+" "+border_style+" "+border_color+";\"";
			var group_end_style_middle = " style=\"border-bottom: "+border_width+" "+border_style+" "+border_color+";\"";
			
			if (i == 0)	{
				if (JSON_table[parseInt(i) + 1].font == font_str)	{
					group_style_first += group_start_style_first;
					group_style_last += group_start_style_last;
					group_style_middle += group_start_style_middle;
				}
			}
			else if (i == JSON_table.length - 1)	{
				if (JSON_table[parseInt(i) - 1].font == font_str)	{
					group_style_first += group_end_style_first;
					group_style_last += group_end_style_last;
					group_style_middle += group_end_style_middle;
				}
			}
			else	{
				if ((JSON_table[parseInt(i) + 1].font == font_str) && (JSON_table[parseInt(i) - 1].font != font_str))	{
					group_style_first += group_start_style_first;
					group_style_last += group_start_style_last;
					group_style_middle += group_start_style_middle;
				}
				else if ((JSON_table[parseInt(i) + 1].font == font_str) && (JSON_table[parseInt(i) - 1].font == font_str))	{
					group_style_first += group_middle_style_first;
					group_style_last += group_middle_style_last;
					group_style_middle += group_middle_style_middle;
				}
				else if ((JSON_table[parseInt(i) + 1].font != font_str) && (JSON_table[parseInt(i) - 1].font == font_str))	{
					group_style_first += group_end_style_first;
					group_style_last += group_end_style_last;
					group_style_middle += group_end_style_middle;
				}
			}
				
			output_str += "<td valign='top'" + group_style_first + "><input type='text' name='font" + i + "' id='font" + i + "' value='" + font_str + "' class='med_txt_field' style='" + font_style_str + "' />\n<input type='hidden' name='old_font" + i + "' id='old_font" + i + "' value='" + font_str + "' />\n<\/td>\n";
			
			output_str += "<td valign='top'" + group_style_middle + ">\n";
			upload_checked = " checked='checked'";
			url_checked = "";
			upload_visible = "";
			src_visible = "";
			src_str = JSON_row.src;
			long_txt_field = "long_txt_field";
			if (src_str == "")
				src_visible = " style='display:none;'";
			else if ((src_str.toLowerCase().indexOf("http", 0) == 0) || ((src_str.substr(src_str.length - 4).toLowerCase() != ".ttf") && (src_str.substr(src_str.length - 4).toLowerCase() != ".otf") && (src_str.substr(src_str.length - 5).toLowerCase() != ".woff") && (src_str.substr(src_str.length - 6).toLowerCase() != ".woff2") && (src_str.substr(src_str.length - 4).toLowerCase() != ".svg") && (src_str.substr(src_str.length - 4).toLowerCase() != ".eot")))	{
				upload_checked = "";
				url_checked = " checked='checked'";
				upload_visible = " style='display:none;'";
				src_visible = "";
				long_txt_field = "extra_long_txt_field";
			}
			
			output_str += "<form id='uploadForm" + i + "' enctype='multipart/form-data' method='post' action='upload_font.php'>\n";
			output_str += "<input type='file' name='file_browse" + i + "' id='file_browse" + i + "'" + upload_visible + " onChange=\"UploadFont(" + i + ");\" class='file_browse' />\n";
			output_str += "</form>\n";

			output_str += "<input type='text' value=\"" + src_str + "\" name='src" + i + "' id='src" + i + "' class='" + long_txt_field + "'" + src_visible + " />\n<input type='hidden' name='old_src" + i + "' id='old_src" + i + "' value=\"" + src_str + "\" />\n<\/td>\n";
			
			output_str += "<td valign='top'" + group_style_middle + ">\n";
			output_str += "<input type='radio' name='src_type" + i + "' id='src_type_upload" + i + "' value='upload'" + upload_checked + " onClick=\"ShowHideFileBrowse('upload', " + i + ");\" /> " + EDIT_FAVICON_UPLOAD_BTN + "<br />\n";
			output_str += "<input type='radio' name='src_type" + i + "' id='src_type_url" + i + "' value='url'" + url_checked + " onClick=\"ShowHideFileBrowse('url', " + i + ");\" /> " + EDIT_MENU_ITEMS_URL + "\n";
			output_str += "</td>\n";
			
			output_str += "<td valign='top'" + group_style_middle + ">\n";
			output_str += "<select name='stretch" + i + "' id='stretch" + i + "'>\n";
			output_str += "<option value=''";
			if (stretch_str == "")
				output_str += " selected='selected'";
			output_str += ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str += "<option value='normal'";
			if (stretch_str == "normal")
				output_str += " selected='selected'";
			output_str += ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str += "<option value='condensed'";
			if (stretch_str == "condensed")
				output_str += " selected='selected'";
			output_str += ">" + CONDENSED_WORD + "<\/option>\n";
			
			output_str += "<option value='ultra-condensed'";
			if (stretch_str == "ultra-condensed")
				output_str += " selected='selected'";
			output_str += ">" + ULTRA_CONDENSED_WORD + "<\/option>\n";
			
			output_str += "<option value='extra-condensed'";
			if (stretch_str == "extra-condensed")
				output_str += " selected='selected'";
			output_str += ">" + EXTRA_CONDENSED_WORD + "<\/option>\n";
			
			output_str += "<option value='semi-condensed'";
			if (stretch_str == "semi-condensed")
				output_str += " selected='selected'";
			output_str += ">" + SEMI_WORD + "<\/option>\n";
			
			output_str += "<option value='expanded'";
			if (stretch_str == "expanded")
				output_str += " selected='selected'";
			output_str += ">" + EXPANDED_WORD + "<\/option>\n";
			
			output_str += "<option value='semi-expanded'";
			if (stretch_str == "semi-expanded")
				output_str += " selected='selected'";
			output_str += ">" + SEMI_EXPANDED_WORD + "<\/option>\n";
			
			output_str += "<option value='extra-expanded'";
			if (stretch_str == "extra-expanded")
				output_str += " selected='selected'";
			output_str += ">" + EXTRA_EXPANDED_WORD + "<\/option>\n";
			
			output_str += "<option value='ultra-expanded'";
			if (stretch_str == "ultra-expanded")
				output_str += " selected='selected'";
			output_str += ">" + ULTRA_EXPANDED_WORD + "<\/option>\n";
			output_str += "<\/select>\n</td>\n";
			
			
			output_str += "<td valign='top'" + group_style_middle + ">\n";
			output_str += "<select name='style" + i + "' id='style" + i + "'>\n";
			output_str += "<option value=''";
			if (style_str == "")
				output_str += " selected='selected'";
			output_str += ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str += "<option value='normal'";
			if (style_str == "normal")
				output_str += " selected='selected'";
			output_str += ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str += "<option value='italic'";
			if (style_str == "italic")
				output_str += " selected='selected'";
			output_str += ">" + ITALIC_WORD + "<\/option>\n";
			
			output_str += "<option value='oblique'";
			if (style_str == "oblique")
				output_str += " selected='selected'";
			output_str += ">" + OBLIQUE_WORD + "<\/option>\n";
			output_str += "<\/select>\n</td>\n";
			
			
			output_str += "<td valign='top'" + group_style_middle + ">\n";
			output_str += "<select name='weight" + i + "' id='weight" + i + "'>\n";
			output_str += "<option value=''";
			if (weight_str == "")
				output_str += " selected='selected'";
			output_str += ">" + _NOT_SELECTED_ + "<\/option>\n";
			
			output_str += "<option value='normal'";
			if (weight_str == "normal")
				output_str += " selected='selected'";
			output_str += ">" + NORMAL_WORD + "<\/option>\n";
			
			output_str += "<option value='bold'";
			if (weight_str == "bold")
				output_str += " selected='selected'";
			output_str += ">" + BOLD_WORD + "<\/option>\n";
			
			output_str += "<option value='100'";
			if (weight_str == "100")
				output_str += " selected='selected'";
			output_str += ">100<\/option>\n";
			
			output_str += "<option value='200'";
			if (weight_str == "200")
				output_str += " selected='selected'";
			output_str += ">200<\/option>\n";
			
			output_str += "<option value='300'";
			if (weight_str == "300")
				output_str += " selected='selected'";
			output_str += ">300<\/option>\n";
			
			output_str += "<option value='400'";
			if (weight_str == "400")
				output_str += " selected='selected'";
			output_str += ">400<\/option>\n";
			
			output_str += "<option value='500'";
			if (weight_str == "500")
				output_str += " selected='selected'";
			output_str += ">500<\/option>\n";
			
			output_str += "<option value='600'";
			if (weight_str == "600")
				output_str += " selected='selected'";
			output_str += ">600<\/option>\n";
			
			output_str += "<option value='700'";
			if (weight_str == "700")
				output_str += " selected='selected'";
			output_str += ">700<\/option>\n";
			
			output_str += "<option value='800'";
			if (weight_str == "800")
				output_str += " selected='selected'";
			output_str += ">800<\/option>\n";
			
			output_str += "<option value='900'";
			if (weight_str == "900")
				output_str += " selected='selected'";
			output_str += ">900<\/option>\n";
			output_str += "<\/select>\n</td>\n";
		
			output_str += "<td valign='top'" + group_style_middle + ">\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateFont(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str += "<td valign='top'" + group_style_last + ">\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm(" + i + ", '');\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str += "<\/tr>\n";
		}
		i++;
	}

	output_str += "<\/table>\n";
	
	document.getElementById("FontsTable").innerHTML = output_str;
	nCount = i;
}

///////////////////////////////////////////////////////////////////////////////////
function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	UpdateAll();
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	if (self != top)	{
		window.parent.SetWorkSavedNotSaved(true);
		window.parent.DoNextClick();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RunPostAjaxUploadScript()
{
	
}


function ShowHideFileBrowse(mode, i)
{
	var file_browse_el = "file_browse" + i;
	var src_el = "src" + i;
	var file_browse_el = document.getElementById(file_browse_el);
	var src_el = document.getElementById(src_el);
	if (mode == "upload")	{
		file_browse_el.style.display = "initial";
		if ((src_el.value == "") || (src_el.value.indexOf("http", 0) == 0))	{
			src_el.style.display = "none";
			src_el.className = "long_txt_field";
		}
		else	{
			src_el.style.display = "initial";
			src_el.className = "extra_long_txt_field";
		}
	}
	else	{
		file_browse_el.style.display = "none";
		src_el.style.display = "initial";
		src_el.className = "extra_long_txt_field";
	}
}

function UploadFont(i)
{
	var file_browse_ctl = "file_browse" + i;
	var src_ctl = "src" + i;
	var xhr = new XMLHttpRequest();
	
	var file_name = document.getElementById(file_browse_ctl).value;
	var file_parts = file_name.split(".");
	var file_ext = file_parts[file_parts.length - 1];
	file_ext = file_ext.toLowerCase();
	if ((file_ext != "ttf") && (file_ext != "otf") && (file_ext != "woff") && (file_ext != "woff2") && (file_ext != "svg")  && (file_ext != "eot")) {
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 5000;
		popup_msg.status_msg = MANAGE_CUSTOM_FONTS_ADDING_FONT_FILE_TYPE_ERR;
		popup_msg.ShowPopupMsg();
		return;
	}
	
	var path_parts = file_name.split("\\");
	var file_path = fonts_dir + path_parts[path_parts.length - 1];
	document.getElementById(src_ctl).value = file_path;

	var form_data = new FormData();
	form_data.append(file_browse_ctl, document.getElementById(file_browse_ctl).files[0]);
	form_data.append("file_browse_name", "file_browse" + i);
  /* event listners */
  xhr.upload.addEventListener("progress", uploadProgress, false);
  xhr.addEventListener("load", uploadComplete, false);
  xhr.addEventListener("error", uploadFailed, false);
  xhr.addEventListener("abort", uploadCanceled, false);

	xhr.open("POST", "upload_font.php", true);
	xhr.send(form_data);
}

function uploadProgress(evt) {
  if (evt.lengthComputable) {
    var percentComplete = Math.round(evt.loaded * 100 / evt.total);
    document.getElementById('progressNumber').innerHTML = percentComplete.toString() + '%';
  }
  else {
    document.getElementById('progressNumber').innerHTML = 'unable to compute';
  }
}

function uploadComplete(evt) {
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (evt.target.responseText != "")
		popup_msg.status_msg = evt.target.responseText;
	else
		popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOADED_MSG;
	popup_msg.ShowPopupMsg();
}

function uploadFailed(evt) {
  	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOAD_ERR;
	popup_msg.ShowPopupMsg();
}

function uploadCanceled(evt) {
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	popup_msg.status_msg = MANAGE_FONTS_FONT_UPLOAD_CANCEL_MSG;
	popup_msg.ShowPopupMsg();
}  

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {
}