////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/24/2016	ELL

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.versio

function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#manage_mega_menu", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
function PopulateMenuItems(menu)
{
	$.post( "populate_menu_items.php", { menu: menu } ).done(function( data ) { CompletePopulateMenuItems(data); } ) ;
}
function CompletePopulateMenuItems(data)
{
	if (data == "-no data-")
		return;
		
	var menu_items = data.split("@@@@@");
	var menu_item_select = document.getElementById("menu_item");
	menu_item_select.options.length = 0;
	var option =  document.createElement("option");
	option.value = "";
	option.text = "-not selected-";
	menu_item_select.add(option);
	for (var i = 0; i < menu_items.length; i++)
	{
		var JSON_row = JSON.parse(menu_items[i]);
		var option =  document.createElement("option");
		option.value = JSON_row.item_text;
		option.text = JSON_row.item_text;
		menu_item_select.add(option);
	}
}

function CheckRequirements()
{
	if ((document.getElementById("menu").value != "") && (document.getElementById("menu_item").value != ""))
		document.getElementById("create_btn").className = "button_console_add";
	else
		document.getElementById("create_btn").className = "button_console_add_disabled";
}

function CreateMegaMenu()
{
	if (document.getElementById("create_btn").className == "button_console_add_disabled")
		return;
		
	var menu = document.getElementById("menu").value;
	var menu_item = document.getElementById("menu_item").value;
	var page_name = "mm_" + menu_item;
	$.post( "create_mega_menu.php", { menu: menu, menu_item: menu_item, page_name: page_name } ).done(function( data ) { CompleteCreateMegaMenu(data, page_name); } ) ;
}
function CompleteCreateMegaMenu(data, page_name)
{
	if (data != "-page aleady exists-")
		window.location = "edit_page.php?page_name=" + page_name + "&mode=mega_menu&special=1&source=manage_mega_menu.php";
	else	{
		popup_msg.popup_msg_type = 1;
		popup_msg.status_msg = MEGA_MENU_PAGE_ALREADY_EXISTS_1_ERR + " <b>" + page_name + "</b> " + MEGA_MENU_PAGE_ALREADY_EXISTS_2_ERR;
		popup_msg.popup_timeout = 5000;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
	}
}

function SetEditorMode(mode)
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","set_editor_mode.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);
		
		if (mode.indexOf("style_mode") > -1)	{
			if (document.getElementById(mode).checked == true)
				params = "style_mode=" + document.getElementById(mode).value;
		}
		else if (document.getElementById(mode).checked == true)
			params = mode + "=1";
		else
			params = mode + "=0";
		
		xmlhttp.send(params);
	}
}

function UpdateMessage(xmlhttp)
{
	var status_msg;
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
			status_msg = "query complete";
		else if (xmlhttp.readyState==1)
			status_msg = "query read to send";
		else if (xmlhttp.readyState==2)
			status_msg = "query sent";
		else if (xmlhttp.readyState==3)
			status_msg = "query starting";
	}
	return (xmlhttp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved border area.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}