/////////////////////////////////////////////
// Manage Page Access Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/11/2012	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 8/3/2014	ELL
// Added Show Login Links Always checkboxes.
// Revised: 11/6/2014	ELL
// Overhauled individual user management areas at bottom as AJAX functions.
// Revised: 3/23/2016	ELL
// Added error checking when saving restirect page access.
// Added info links.
// 
// 
//
var max_rec = 50;
var page = 0;
var num_users = 0;
var total_pages = 0;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow(topic)
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#" + topic, "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}


function DeleteUserConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_1_MSG + " <b>" + document.getElementById("selectUserNameDelete").value + "</b>" + MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteUser(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}
function DeleteUser()
{
	var user_name = document.getElementById("selectUserNameDelete").value;
	var table = document.getElementById("table_delete_user").value;
	
	$.post( "delete_user.php", { user_name: user_name, table: table, no_prefix: 1 } ).done(CompleteDeleteUser) ;
}
function CompleteDeleteUser(data)
{
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = 2000;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_USER_DELETED_1_MSG + " <b>" + data + "</b> " + MANAGE_PAGE_ACCESS_USER_DELETED_2_MSG;
	popup_msg.ShowPopupMsg();
	
	var user_table = document.getElementById("table_delete_user").value;
	var user_sort = document.getElementById("user_sort").value;
	RetrieveUserLists(user_table, false, user_sort, 1);
}

function GeneratePassword(source)
{
	var password = "";
	var password_length = rand(6,10);
	var i;
	var assci_segment;
	
	for (i = 0; i < password_length; i++)
	{
		assci_segment = rand(1,3);
		if (assci_segment == 1)
			password = password + String.fromCharCode(rand(48,57));	// numeric
		else if (assci_segment == 2)
			password = password + String.fromCharCode(rand(65,90));	// alpha upper case
		else
			password = password + String.fromCharCode(rand(97,122));	// alpha lower case
	}
	password = password.replace('I', 'i');
	password = password.replace('O', 'o');
	password = password.replace('l', 'L');
	
	if (source == "new")
		var frm_obj = document.getElementById ('password_new_user');
	else
		var frm_obj = document.getElementById ('password_existing_user');
		
	frm_obj.value = password;
		
	return password;
}

// Equivalent to PHP rand(min, max);
function rand ( n, m )
{
  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );
}

//////////////////////////////////////////////////////////////////////////////////////////////////////

function DeleteAccessLevelConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_1_MSG + " <b>" + document.getElementById("access_level_remove").value + "</b>" + MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { AddRemoveAccessLevel('remove'); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdatePageRestriction(page_name, i)
{		
	var params = "";
	var login_required_ctl = "login_required" + i;
	var user_table_ctl = "user_table" + i;
	var access_level_ctl = "access_level" + i;
	var login_page_ctl = "login_page" + i;
	var show_login_links_ctl = "show_login_links" + i;
	
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	
	if ((document.getElementById(login_required_ctl).checked === true) && ((document.getElementById(user_table_ctl).value == _NOT_SELECTED_) || (document.getElementById(user_table_ctl).value == "")))	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_NO_TABLE_SELECTED_ERR;
		popup_msg.ShowPopupMsg();
		return -1;
	}
		
	if ((document.getElementById(login_required_ctl).checked === true) && ((document.getElementById(login_page_ctl).value == _NOT_SELECTED_) || (document.getElementById(login_page_ctl).value == "")))	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_NO_LOGIN_PAGE_SELECTED_ERR;
		popup_msg.ShowPopupMsg();
		return -1;
	}
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.ShowPopupMsg();
	
	var table_viability = 0;
	for (var j = 0; j < tables.length; j++)
	{
		if (tables[j][0] == document.getElementById(user_table_ctl).value)
			table_viability = tables[j][1];
	}
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_page_restriction.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Update");
		
		params = "page_name=" + page_name;
		params = params + "&login_required=" + document.getElementById(login_required_ctl).checked;
		if (document.getElementById(user_table_ctl).value != "")
			params = params + "&user_table=" + document.getElementById(user_table_ctl).value;
		if (document.getElementById(access_level_ctl).value != "")
			params = params + "&access_level=" + document.getElementById(access_level_ctl).value;
		if (document.getElementById(login_page_ctl).value != "")
			params = params + "&login_page=" + document.getElementById(login_page_ctl).value;
		params = params + "&show_login_links=" + document.getElementById(show_login_links_ctl).value;
		if (table_viability < 10)
			params = params + "&add_missing_fields=1";
		else
			params = params + "&add_missing_fields=0";
//		alert(params);
		xmlhttp.send(params);
	}
}


//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, Source)
{
	var query_complete_no_record = QUERY_COMPLETE_NO_RECORD_FOUND;
	var query_complete = "<b>" + QUERY_COMPLETE + "<\/b><br/>\n";
	var query_read_to_send = QUERY_READY_TO_SEND;
	var query_sent = QUERY_SENT;
	var query_starting = MANAGE_PAGE_ACCESS_LOCATING_PAGE_RESTRICTIONS_MSG;
	
	if (Source == "Update")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_PAGE_RESTRICTIONS_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_PAGE_RESTRICTIONS_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_UPDATING_PAGE_RESTRICTIONS_MSG;
	}
	else if (Source == "UpdateUserStatus")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_USER_STATUS_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_USER_STATUS_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_UPDATING_USER_STATUS_MSG;
	}
	else if (Source == "AddFields")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_MODIFY_TABLE_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_FIELDS_ADDED_TO_TABLE_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_ADDING_FIELDS_TO_TABLE_MSG;
	}
	else if (Source == "AssignWelcomeMessage")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_MODIFY_TABLE_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_WELCOME_MESSAGE_PAGE_ADDED_TO_TABLE_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_ADDING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG;
	}
	else if (Source == "AddRemoveAccessLevel")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_ADD_DELETE_ACCESS_LEVEL_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_ACESS_LEVEL_RECORDS_MODIFIED_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_CHANGING_ACCESS_LEVELS_MSG;
	}
	else if (Source == "PopulateAccessLevels")
		query_starting = MANAGE_PAGE_ACCESS_LOCATING_ACCESS_LEVELS_MSG;
	else if (Source == "PopulateUsers")
		query_starting = MANAGE_PAGE_ACCESS_LOCATING_USERS_MSG;

	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
//				alert(rows_str);
				if (rows_str == "-no data-")
					popup_msg.status_msg = query_complete_no_record;
				else
					popup_msg.status_msg = query_complete;

				if (Source == "Populate")
					PopulatePageTable(rows_str);
				else if (Source == "PopulateAccessLevels")
					PopulateAccessLevels(rows_str);
				else if (Source == "AddFields")
					alert(MANAGE_PAGE_ACCESS_REQUIRED_FIELDS_MSG);
				else if (Source == "AddRemoveAccessLevel")
					RetrieveAccessLevels(1);
				else if (Source == "PopulateUsers")
					PopulateUserLists(rows_str);

			}
			else
				popup_msg.status_msg = query_complete_no_record;

			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = query_read_to_send;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = query_sent;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = query_starting;
		
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////
function RetrievePages()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_RETRIEVING_PAGE_RESTRICTIONS_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_rows.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Populate");
		params = "table=page_data&order_by=page_name";
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulatePageTable(rows_str)
{
	var rows = new Array();

	var output_str = "<table width='100%' border='0' class='layout_box_table'>\n";
	output_str = output_str + "<tr><td colspan='5' class='sub_title'>" + MANAGE_PAGE_ACCESS_RESTRICT_PAGE_ACCESS + "</td></tr>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>" + PAGE_1ST_CAP_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_PAGE_ACCESS_REQUIRE_LOGIN + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + USER_TABLE_WORD + "<\/b> <div class='help_button_sm info_btn' id='help_button_selector' onClick=\"OpenHelpWindow('user_table');\">&nbsp;</div><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + ACCESS_LEVEL_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_PAGE_ACCESS_LOGIN_PAGE + "<\/b> <div class='help_button_sm info_btn' id='help_button_selector' onClick=\"OpenHelpWindow('login_page');\">&nbsp;</div><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_PAGE_ACCESS_SHOW_LOGIN_LINKS_ALWAYS + "<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	
	var class_str = "";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create rows for page restrictions.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
	
			output_str = output_str + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='" + JSON_row.ID + "'>\n";
			output_str = output_str + "<input type='hidden' name='page_name" + i + "' id='page_name" + i + "' value='" + JSON_row.page_name + "'>" + JSON_row.page_name + "<\/td>\n";
				
			output_str = output_str + "<td>\n";
			output_str = output_str + " <input type='checkbox' name='login_required" + i + "' id='login_required" + i + "'";
			if (JSON_row.login_required == 1)
				output_str = output_str + " checked='checked'";
			output_str = output_str + " />\n";
			output_str = output_str + "<\/td>\n";

			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='user_table" + i + "' id='user_table" + i + "'>\n";
			output_str = output_str + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
			for (j = 0; j < table_cnt; j++)
			{
				class_str = "";
				if (tables[j][1] < 10)
					class_str = " class='missing _fields' style='color: #FF0000;'";
				if (tables[j][0] == JSON_row.user_table)
					output_str = output_str + "<option value='" + tables[j][0] + "' selected='selected'" + class_str + ">" + tables[j][0] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + tables[j][0] + "'" + class_str + ">" + tables[j][0] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";

			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='access_level" + i + "' id='access_level" + i + "'>\n";
			output_str = output_str + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
			for (j = 0; j < access_level_cnt; j++)
			{
				if (access_levels[j] == JSON_row.AccessLevel)
					output_str = output_str + "<option value='" + access_levels[j] + "' selected='selected'>" + access_levels[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + access_levels[j] + "'>" + access_levels[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='login_page" + i + "' id='login_page" + i + "'>\n";
			output_str = output_str + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
			for (j = 0; j < login_page_cnt; j++)
			{
				if (login_pages[j] == JSON_row.login_page)
					output_str = output_str + "<option value='" + login_pages[j] + "' selected='selected'>" + login_pages[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + login_pages[j] + "'>" + login_pages[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td>\n";
			output_str = output_str + "<select name='show_login_links" + i + "' id='show_login_links" + i + "'>\n";
			output_str = output_str + "<option value='0'>" + _NOT_SELECTED_ + "<\/option>\n";
			if (JSON_row.show_login_links == 1)
				output_str = output_str + "<option value='1' selected='selected'>" + TOP_1ST_CAP_WORD + "<\/option>\n";
			else
				output_str = output_str + "<option value='1'>" + TOP_1ST_CAP_WORD + "<\/option>\n";
			if (JSON_row.show_login_links == 2)
				output_str = output_str + "<option value='2' selected='selected'>" + HEADER_1ST_CAP_WORD + "<\/option>\n";
			else
				output_str = output_str + "<option value='2'>" + HEADER_1ST_CAP_WORD + "<\/option>\n";
			output_str = output_str + "<\/select>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdatePageRestriction('" + JSON_row.page_name + "', " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";

		}
	}
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("PageRestrictionsTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RetrieveAccessLevels(update_page_table)
{
	update_page_table_mode = update_page_table;
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_RETRIEVING_ACCESS_LEVELS_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_rows.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "PopulateAccessLevels");
		params = "table=access_levels";
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateAccessLevels(rows_str)
{
	var rows = new Array();
	
	var output_str = "<select name='access_level_remove' id='access_level_remove'>\n";
	var output_str2 = "<select name='selectAccessLevel' id='selectAccessLevelNewUser'>\n";
	var output_str3 = "<select name='AccessLevel' id='selectAccessLevelEdit'>\n";
	output_str = output_str + "<option>" + _NOT_SELECTED_ + "</option>\n";
	output_str2 = output_str2 + "<option>" + _NOT_SELECTED_ + "</option>\n";
	output_str3 = output_str3 + "<option>" + _NOT_SELECTED_ + "</option>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			output_str = output_str + "<option value='" + JSON_row.access_level + "'>" + JSON_row.access_level + "</option>\n";
			output_str2 = output_str2 + "<option value='" + JSON_row.access_level + "'>" + JSON_row.access_level + "</option>\n";
			output_str3 = output_str3 + "<option value='" + JSON_row.access_level + "'>" + JSON_row.access_level + "</option>\n";
		}
	}
	output_str = output_str + "<\/select>\n";
	output_str2 = output_str2 + "<\/select>\n";
	output_str3 = output_str3 + "<\/select>\n";

	document.getElementById("AccessLevelRemoveDiv").innerHTML = output_str;
	document.getElementById("AccessLevelAddUserDiv").innerHTML = output_str2;
	document.getElementById("AccessLevelEditUserDiv").innerHTML = output_str3;

	if (update_page_table_mode == 1)
	{
		if (access_level_add != "-not set-")
		{
			access_levels[access_level_cnt] = access_level_add;
			access_level_cnt++;
			access_level_add = "-not set-";
		}
		else if (access_level_remove != "-not set-")
		{
			access_levels.splice(access_levels.indexOf(access_level_remove), 1);
			access_level_cnt--;
			access_level_remove = "-not set-";
		}
		RetrievePages();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RetrieveUserLists(user_table, start, user_sort, no_toggle_asc_desc)
{
	if ((user_table == "") || (user_table == "-not selected-"))	{
		document.getElementById("user_nav_row_top").style.display = "none";
		document.getElementById("user_nav_row_bot").style.display = "none";
		document.getElementById("UsersTable").innerHTML = "&nbsp;";
		return;
	}
	
	if ((typeof user_sort == "undefined") || (user_sort == ""))
		user_sort = document.getElementById("user_sort").value;
	else if (document.getElementById("user_sort").value != user_sort)	{
		document.getElementById("user_sort").value = user_sort;
		document.getElementById("user_sort_desc").value = 0;
	}
	else	{
		if ((typeof no_toggle_asc_desc == "undefined") || (no_toggle_asc_desc == "") || (no_toggle_asc_desc != 1))	{
			if (document.getElementById("user_sort_desc").value == 1)
				document.getElementById("user_sort_desc").value = 0;
			else	{
				document.getElementById("user_sort_desc").value = 1;
				if (user_sort.indexOf(","))	{
					var user_sort_parts = user_sort.split(",");
					user_sort = user_sort_parts[0] + " DESC, " + user_sort_parts[0] + " DESC";
				}
				else
					user_sort = user_sort + " DESC";
			}
		}
		else	{
			if (document.getElementById("user_sort_desc").value == 1)	{
				if (user_sort.indexOf(","))	{
					var user_sort_parts = user_sort.split(",");
					user_sort = user_sort_parts[0] + " DESC, " + user_sort_parts[0] + " DESC";
				}
				else
					user_sort = user_sort + " DESC";
			}
		}
	}
		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_RETRIEVING_USERS_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "PopulateUsers");
		params = "user_table=" + user_table + "&page=" + page + "&max_rec=" + max_rec + "&user_sort=" + user_sort;
		xmlhttp.send(params);
	}
	
	document.getElementById("user_table_for_users_table").value = user_table;
	document.getElementById("user_table_for_fields").value = user_table;
	document.getElementById("table_new_user").value = user_table;
	document.getElementById("table_existing_user").value = user_table;
	document.getElementById("table_edit").value = user_table;
	document.getElementById("table_delete_user").value = user_table;
	
	if (start)
		page = 0;
//	alert (params);
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateUserLists(rows_str)
{
//	alert(rows_str);
	var rows = new Array();
	
	var user_table = document.getElementById("user_table_for_users_table").value;

	var output_str = "<select name='selectUserName' id='selectUserNameExistingUser'>\n";
	var output_str2 = "<select name='selectUserName' id='selectUserNameDelete'>\n";
	var output_str3 = "<select name='user_name' id='selectUserNameEdit' onChange='GetUser(this.value);'>\n";
	var output_str4 =  "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
	output_str = output_str + "<option>" + _NOT_SELECTED_ + "</option>\n";
	output_str2 = output_str2 + "<option>" + _NOT_SELECTED_ + "</option>\n";
	output_str3 = output_str3 + "<option>" + _NOT_SELECTED_ + "</option>\n";
	output_str4 = output_str4 + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str4 = output_str4 + "<td class='header_row' onclick=\"RetrieveUserLists('" + user_table + "', false, 'UserID', 0);\"><b><div class='column_heading_w_sort' id='UserID_column_heading'>" + USER_WORD + "</div><\/b><\/td>\n";
	output_str4 = output_str4 + "<td class='header_row' onclick=\"RetrieveUserLists('" + user_table + "', false, 'first_name, last_name', 0);\"><b><div class='column_heading_w_sort' id='first_name_column_heading'>" + FIRST_NAME + "</div><\/b><\/td>\n";
	output_str4 = output_str4 + "<td class='header_row' onclick=\"RetrieveUserLists('" + user_table + "', false, 'last_name, first_name', 0);\"><b><div class='column_heading_w_sort' id='last_name_column_heading'>" + LAST_NAME + "</div><\/b><\/td>\n";
	
	output_str4 = output_str4 + "<td class='header_row'><b>" + ACTIVE_WORD + "<\/b><\/td>\n";
	output_str4 = output_str4 + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str4 = output_str4 + "</tr>\n";

	rows = rows_str.split("@@@@@");
	var i;
	if (rows[0] == "-no data-")	// If no pages yet (first time).
	{
		i = 0;
	}
	else if (rows[0] == "-not user access table-")	// Selected table needs is missing users-access fields.
	{
		i = 0;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_NO_LOGIN_FIELDS_IN_TABLE_ERR;
		popup_msg.ClearPopupMsgTimer();
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		if (page != 0)	{
			popup_msg.ShowPopupMsg();
			popup_msg.lockup_new_popups = true;
		}
	}	
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			try {
				var JSON_row = JSON.parse(rows[i]);
			}
			catch(err) {
//				alert(rows[i]);
				continue;
			}
			//alert(JSON_row);
			if (JSON_row.UserID)
			{
				if (JSON_row.UserID == last_user)
				{
					output_str = output_str + "<option value='" + JSON_row.UserID + "' selected='selected'>" + JSON_row.UserID + "</option>\n";
					output_str2 = output_str2 + "<option value='" + JSON_row.UserID + "' selected='selected'>" + JSON_row.UserID + "</option>\n";
					output_str3 = output_str3 + "<option value='" + JSON_row.UserID + "' selected='selected'>" + JSON_row.UserID + "</option>\n";
				}
				else
				{
					output_str = output_str + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
					output_str2 = output_str2 + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
					output_str3 = output_str3 + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
				}
				
				if (bgclr == "#dddddd")
					bgclr = "#eeeeee";
				else
					bgclr = "#dddddd";
			
				output_str4 = output_str4 + "<tr bgcolor='" + bgclr + "'>\n<td>" + JSON_row.UserID + "<input type='hidden' value='" + JSON_row.UserID + "' id='user_id" + i + "' name='user_id" + i + "' /></td>\n";
				
				if (JSON_row.first_name == null)
					JSON_row.first_name = "";
				if (JSON_row.last_name == null)
					JSON_row.last_name = "";
				output_str4 = output_str4 + "<td>" + JSON_row.first_name + "</td>\n";
				output_str4 = output_str4 + "<td>" + JSON_row.last_name + "</td>\n";
				
				output_str4 = output_str4 + "<td>\n<input type='checkbox' name='active" + i + "' id='active" + i + "'";
				if (JSON_row.Active == 1)
					output_str4 = output_str4 + " checked='checked'";
				output_str4 = output_str4 + " />\n</td>\n";
				
				output_str4 = output_str4 + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateUserStatus('" + JSON_row.UserID + "', " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
				
				output_str4 = output_str4 + "<td valign='top' style='text-decoration:none;'>\n<a href='#UserEdit'><img src='theme/" + theme + "/images/edit.png' border=0 alt='Update' name='Update' onClick=\"GetUser('" + JSON_row.UserID + "');\" style='cursor:pointer;' /></a>\n<\/td>\n";

			}
			if (JSON_row.welcome_message_page)
				document.getElementById("welcome_message_page").value = JSON_row.welcome_message_page;
			else
				document.getElementById("welcome_message_page").selectedIndex = 0;
		}
	}
	output_str = output_str + "<\/select>\n";
	output_str2 = output_str2 + "<\/select>\n";
	output_str3 = output_str3 + "<\/select>\n";
	output_str4 = output_str4 + "</tr>\n</table>\n";
	
	document.getElementById("UsersChangePassword").innerHTML = output_str;
	document.getElementById("UsersDelete").innerHTML = output_str2;
	document.getElementById("UsersEdit").innerHTML = output_str3;
	document.getElementById("UsersTable").innerHTML = output_str4;

	///////////////////////////////////////////
	GetNumUsers();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function UpdateUserStatus(UserID, i)
{		
	var params = "";
	var user_id_ctl = "user_id" + i;
	var active_ctl = "active" + i;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_user_status.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "UpdateUserStatus");
		
		params = "UserID=" + document.getElementById(user_id_ctl).value;
		params = params + "&Active=" + document.getElementById(active_ctl).checked;
		params = params + "&user_table=" + document.getElementById("user_table_for_users_table").value;
		//alert(params);
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function AddFieldsToTable()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_ADDING_LOGIN_FIELDS_TO_TABLE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","add_login_fields.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AddFields");
		
		params = "user_table=" + document.getElementById("user_table_for_fields").value;
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function AssignWelcomeMessagePageToTable()
{		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_ASSIGNING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","assign_welcome_message_to_table.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AssignWelcomeMessage");
		
		params = "user_table=" + document.getElementById("user_table_for_fields").value;
		params = params + "&welcome_message_page=" + document.getElementById("welcome_message_page").value;
		xmlhttp.send(params);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
function AddRemoveAccessLevel(action)
{		
	if (action == "add")
	{
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_ADDING_ACCESS_LEVEL_MSG;
	}
	else
	{
		popup_msg.HidePopupMsg();
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_REMOVING_ACCESS_LEVEL_MSG;
	}
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","add_remove_access_level.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "AddRemoveAccessLevel");
		
		params = "action=" + action;
		if (action == "add")
		{
			params = params + "&access_level=" + document.getElementById("access_level_add").value;
			access_level_add = document.getElementById("access_level_add").value;
		}
		else
		{
			params = params + "&access_level=" + document.getElementById("access_level_remove").value;
			access_level_remove = document.getElementById("access_level_remove").value;
		}
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////
function moveFirst()
{
	page = 0;
	var user_table = document.getElementById("user_table_for_fields").value;
	var user_sort = document.getElementById("user_sort").value;
	RetrieveUserLists(user_table, false, user_sort, 1);
}

function movePrev()
{
	page = Math.max(0, (page - 1));
	var user_table = document.getElementById("user_table_for_fields").value;
	var user_sort = document.getElementById("user_sort").value;
	RetrieveUserLists(user_table, false, user_sort, 1);
}

function moveNext()
{
	page = Math.min(total_pages, (page + 1));
	var user_table = document.getElementById("user_table_for_fields").value;
	var user_sort = document.getElementById("user_sort").value;
	RetrieveUserLists(user_table, false, user_sort, 1);
}

function moveLast()
{
	page = total_pages;
	var user_table = document.getElementById("user_table_for_fields").value;
	var user_sort = document.getElementById("user_sort").value;
	RetrieveUserLists(user_table, false, user_sort, 1);
}

function GetNumUsers()
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	var user_table = document.getElementById("user_table_for_fields").value;

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_num_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = FinishGetNumUsers(xmlhttp);
		params = "user_table=" + user_table;
		xmlhttp.send(params);
//		alert(params);
	}
	
	var user_sort = document.getElementById("user_sort").value;
	var user_sort_desc = document.getElementById("user_sort_desc").value;
	document.getElementById("UserID_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort.png')";
	document.getElementById("first_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort.png')";
	document.getElementById("last_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort.png')";
	if (user_sort == "UserID")	{
		if (user_sort_desc == 1)
			document.getElementById("UserID_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_desc.png')";
		else
			document.getElementById("UserID_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_asc.png')";
	}
	else if (user_sort == "first_name, last_name")	{
		if (user_sort_desc == 1)
			document.getElementById("first_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_desc.png')";
		else
			document.getElementById("first_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_asc.png')";
	}
	else if (user_sort == "last_name, first_name")	{
		if (user_sort_desc == 1)
			document.getElementById("last_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_desc.png')";
		else
			document.getElementById("last_name_column_heading").style.backgroundImage = "url('theme/" + theme + "/images/icon_sort_asc.png')";
	}
}

function FinishGetNumUsers(xmlhttp)	{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				num_users = xmlhttp.responseText;
				if (num_users == "-no data-")
					num_users = 0;
			}
			else
				num_users = 0;
			total_pages = Math.ceil(num_users/max_rec) - 1;
			ShowHidePageBtns();
		}
	}
	return (xmlhttp);
}

function ShowHidePageBtns()
{
	if (total_pages < 1)
	{
		document.getElementById("user_nav_row_top").style.display = "none";
		document.getElementById("user_nav_row_bot").style.display = "none";
	}
	else
	{
		document.getElementById("user_nav_row_top").style.display = "table-row";
		document.getElementById("user_nav_row_bot").style.display = "table-row";
	}

	if (page < 1)
	{
		document.getElementById("first_top").src = "./theme/" + theme + "/images/First_disabled.gif";
		document.getElementById("prev_top").src = "./theme/" + theme + "/images/Previous_disabled.gif";
		document.getElementById("first_bot").src = "./theme/" + theme + "/images/First_disabled.gif";
		document.getElementById("prev_bot").src = "./theme/" + theme + "/images/Previous_disabled.gif";
		document.getElementById("first_top").style.cursor = "default";
		document.getElementById("prev_top").style.cursor = "default";
		document.getElementById("first_bot").style.cursor = "default";
		document.getElementById("prev_bot").style.cursor = "default";
	}
	else
	{
		document.getElementById("first_top").src = "./theme/" + theme + "/images/First.gif";
		document.getElementById("prev_top").src = "./theme/" + theme + "/images/Previous.gif";
		document.getElementById("first_bot").src = "./theme/" + theme + "/images/First.gif";
		document.getElementById("prev_bot").src = "./theme/" + theme + "/images/Previous.gif";
		document.getElementById("first_top").style.cursor = "pointer";
		document.getElementById("prev_top").style.cursor = "pointer";
		document.getElementById("first_bot").style.cursor = "pointer";
		document.getElementById("prev_bot").style.cursor = "pointer";
	}
	
	if (page == total_pages)
	{
		document.getElementById("next_top").src = "./theme/" + theme + "/images/Next_disabled.gif";
		document.getElementById("last_top").src = "./theme/" + theme + "/images/Last_disabled.gif";
		document.getElementById("next_bot").src = "./theme/" + theme + "/images/Next_disabled.gif";
		document.getElementById("last_bot").src = "./theme/" + theme + "/images/Last_disabled.gif";
		document.getElementById("next_top").style.cursor = "default";
		document.getElementById("last_top").style.cursor = "default";
		document.getElementById("next_bot").style.cursor = "default";
		document.getElementById("last_bot").style.cursor = "default";
	}
	else
	{
		document.getElementById("next_top").src = "./theme/" + theme + "/images/Next.gif";
		document.getElementById("last_top").src = "./theme/" + theme + "/images/Last.gif";
		document.getElementById("next_bot").src = "./theme/" + theme + "/images/Next.gif";
		document.getElementById("last_bot").src = "./theme/" + theme + "/images/Last.gif";
		document.getElementById("next_top").style.cursor = "pointer";
		document.getElementById("last_top").style.cursor = "pointer";
		document.getElementById("next_bot").style.cursor = "pointer";
		document.getElementById("last_bot").style.cursor = "pointer";
	}
	
	var rcrd_start = (page * max_rec) + 1;
	var rcrd_end = Math.min(rcrd_start - 1 + max_rec, num_users);
	document.getElementById("page_num_top").innerHTML = page + 1;
	document.getElementById("total_pages_top").innerHTML = total_pages + 1;
	document.getElementById("rcrd_start_top").innerHTML = rcrd_start;
	document.getElementById("rcrd_end_top").innerHTML = rcrd_end;
	document.getElementById("total_rcrds_top").innerHTML = num_users;
	document.getElementById("page_num_bot").innerHTML = page + 1;
	document.getElementById("total_pages_bot").innerHTML = total_pages + 1;
	document.getElementById("rcrd_start_bot").innerHTML = rcrd_start;
	document.getElementById("rcrd_end_bot").innerHTML = rcrd_end;
	document.getElementById("total_rcrds_bot").innerHTML = num_users;
}

/////////////////////////////////////////////////////////////////////////////////////////
function AddUser()
{
	var user_name = document.getElementById('user_name_new_user').value;
	var password = document.getElementById('password_new_user').value;
	var AccessLevel = document.getElementById('selectAccessLevelNewUser').value;
	var email = document.getElementById('email_new_user').value;
	var first_name = document.getElementById('first_name_new_user').value;
	var last_name = document.getElementById('last_name_new_user').value;
	var table = document.getElementById('table_new_user').value;
	var website_user = 1;

	$.post( "add_user.php", { user_name: user_name, password: password, AccessLevel: AccessLevel, email: email, first_name: first_name, last_name: last_name, table: table, website_user: website_user, no_prefix: 1 } ).done(CompleteAddUser) ;
}
function CompleteAddUser(data)
{
	if (data == "-no data-")
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_NEW_USER_NOT_ADDED_ERR;
	else
	{
		var field_pairs = data.split("@@@@@");
		var fields = new Array();
		var pail = new Array();
		for(var i in field_pairs)
		{
			pair = field_pairs[i].split("=");
			fields[pair[0]] = pair[1];
		}
	
		popup_msg.status_msg = MANAGE_PAGE_ACCESS_NEW_USER_CREATED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_PAGE_ACCESS_NEW_USER_CREATED_2_MSG + " <b>" + fields['password'] + "</b> " + MANAGE_PAGE_ACCESS_NEW_USER_CREATED_3_MSG + " <b>" + fields['AccessLevel'] + "</b>";
		if ((fields['first_name'] != "") || (fields['last_name'] != ""))
			popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_PAGE_ACCESS_NEW_USER_CREATED_4_MSG + " <b>" + fields['first_name'] + " " + fields['last_name'] + "</b>";
		if (fields['email'] != "")
			popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_PAGE_ACCESS_NEW_USER_CREATED_5_MSG + " <b>" + fields['email'] + "</b>";
	}
		
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	if (data != "-no data-")
	{
		document.getElementById('user_name_new_user').value = "";
		document.getElementById('password_new_user').value = "";
		document.getElementById('email_new_user').value = "";
		document.getElementById('first_name_new_user').value = "";
		document.getElementById('last_name_new_user').value = "";
		
		var user_table = document.getElementById("table_new_user").value;
		var user_sort = document.getElementById("user_sort").value;
		RetrieveUserLists(user_table, false, user_sort, 1);
	}
}

function ChangePassword()
{
	var user_name = document.getElementById('selectUserNameExistingUser').value;
	var password = document.getElementById('password_existing_user').value;
	var table = document.getElementById('table_existing_user').value;
	var website_user = 1;
	
	$.post( "change_password.php", { user_name: user_name, password: password, table: table, website_user: website_user, no_prefix: 1 } ).done(CompleteChangePassword) ;
}
function CompleteChangePassword(data)
{
	var field_pairs = data.split("@@@@@");
	var fields = new Array();
	var pair = new Array();
	for(var i in field_pairs)
	{
		pair = field_pairs[i].split("=");
		fields[pair[0]] = pair[1];
	}
	
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_2_MSG + " <b>" + fields['password'] + "</b>";
	popup_msg.ShowPopupMsg();
}

function ModifyUser()
{
	$.ajax({type:'POST', url: 'modify_user.php', data:$('#formModifyUser').serialize(), success: function(response) {
		CompleteModifyUser(response);
	}});
}
function CompleteModifyUser(data)
{
	var field_pairs = data.split("@@@@@");
	var fields = new Array();
	var pair = new Array();
	for(var i in field_pairs)
	{
		pair = field_pairs[i].split("=");
		fields[pair[0]] = pair[1];
	}
	
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = 5000;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_USER_CHANGED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_PAGE_ACCESS_USER_CHANGED_2_MSG + " <b>" + fields['AccessLevel'] + "</b>";
	if ((fields['first_name'] != "") || (fields['last_name'] != ""))
		popup_msg.status_msg = popup_msg.status_msg + MANAGE_PAGE_ACCESS_USER_CHANGED_3_MSG + " <b>" + fields['first_name'] + " " + fields['last_name'] + "</b>";
	if (fields['email'] != "")
		popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_PAGE_ACCESS_USER_CHANGED_4_MSG + " <b>" + fields['email'] + "</b>";
	popup_msg.ShowPopupMsg();
}

function GetUser(user_name)
{
	var table = document.getElementById('table_edit').value;
	if ((table != "") && (user_name != ""))	{
		$.post( "get_rows.php", { table: table, where: "`UserID` = '" + user_name + "'", no_prefix: 1 } ).done(PopulateUser) ;
		document.getElementById("selectUserNameEdit").value = user_name;
	}
}
function PopulateUser(data)
{
	if (data == "-no data-")
		alert(MANAGE_PAGE_ACCESS_NO_DATA_FOUND_FOR_USER_ERR);
	else
	{
		if (data.indexOf("@@@@@") > -1)	{
			var rows = data.split("@@@@@");
			data = rows[0];
		}
		var JSON_row = JSON.parse(data);
		document.getElementById("selectAccessLevelEdit").value = JSON_row.AccessLevel;
		document.getElementById("email_edit").value = JSON_row.email;
		document.getElementById("first_name_edit").value = JSON_row.first_name;
		document.getElementById("last_name_edit").value = JSON_row.last_name;
		document.getElementById("selectUserNameExistingUser").value = JSON_row.UserID;
		document.getElementById("selectUserNameDelete").value = JSON_row.UserID;
		
		var html = "";
		var prop_str;
		for (var property in JSON_row)
		{
			if (JSON_row.hasOwnProperty(property)) {
				if ((property != "id") && (property != "password") && (property != "UserID") && (property != "first_name") && (property != "last_name") && (property != "email") && (property != "subject") && (property != "user_table") && (property != "AccessLevel") && (property != "created") && (property != "Active") && (property != "Session") && (property != "IP") && (property != "welcome_message_page") && (property != "preferred_phone") && (property != "best_time") && (property != "acct_id") && (property != "Password"))	{
					prop_str = property.replace(/_/g, " ");
					prop_str = titleCase(prop_str);
					if (JSON_row[property] == null)
						JSON_row[property] = "";
					html = html + " " + prop_str + ": <input name='" + property + "' id='" + property + "' value='" + JSON_row[property] + "' />\n";
				}
			}
		}
		document.getElementById("additional_user_fields").style.display = "table-cell";
		document.getElementById("additional_user_fields").innerHTML = html;
	}
}

function titleCase(str) {
   var splitStr = str.toLowerCase().split(' ');
   for (var i = 0; i < splitStr.length; i++) {
       // You do not need to check if i is larger than splitStr length, as your for does that for you
       // Assign it back to the array
       splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);     
   }
   // Directly return the joined string
   return splitStr.join(' '); 
}

function convertType(elem)
{
	var input = document.createElement('input');
	input.id = elem.id;
	input.value = elem.value;
	input.onfocus = elem.onfocus;
	input.onblur = elem.onblur;
	input.className = elem.className;
	if (elem.type == 'text' )
	  { input.type = 'password'; }
	else
	  { input.type = 'text'; }
	
	elem.parentNode.replaceChild(input, elem);         
	return input;
}

function convertToTxt(elem)
{
	var input = document.createElement('input');
	input.id = elem.id;
	input.value = elem.value;
	input.onfocus = elem.onfocus;
	input.onblur = elem.onblur;
	input.className = elem.className;
	if (elem.type == 'text' )
	  { return elem; }
	else
	  { input.type = 'text'; }
	
	elem.parentNode.replaceChild(input, elem);         
	return input;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}