////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/4/2016	ELL
// Revised: 2/5/2018	ELL
// Filtered out fonts style sheet as this is created soley under custom fonts management and thus should not be edited in the CSS editor, 
// has no attributes that should be altered, and has no reason to be modified for mobile.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.versio

function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#manage_style_sheet_attrib", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
function GetStyleSheetAttrib(name, curr_btn)
{
	if (curr_btn != -1)
	{
		var style_sheet_btns = document.getElementsByName("style_sheet_btn");
		for (var i = 0; i < style_sheet_btns.length; i++)
		{
			style_sheet_btns[i].className = "button_sub_level_1 btn_wide_w_borders";
		}
		curr_btn.className = "button_sub_level_1 down_sub btn_wide_w_borders";
	}
	
	var where = "name = '" + name + "'";
	document.getElementById("style_sheet").value = name;
	$.post( "get_rows.php", { table: "style_sheets", where: where, order_by: "name" } ).done(function( data ) { CompleteGetStyleSheetAttrib(data); } ) ;
}
function CompleteGetStyleSheetAttrib(data)
{
	if (data == "-no data-")
		return;
		
	var JSON_row = JSON.parse(data);
	document.getElementById("charset").value = JSON_row.charset;
	document.getElementById("import").value = JSON_row['import'];
	document.getElementById("media_type_modifier").value = JSON_row.media_type_modifier;
	document.getElementById("media_type").value = JSON_row.media_type;
	document.getElementById("media_feature").value = JSON_row.media_feature;
	document.getElementById("media_feature_value").value = JSON_row.media_feature_value;
	
	EnableUpdateBtn(false);
}

function SaveStyleSheetAttributes()
{
	if (document.getElementById("btn_save_attributes").className == "button_console_save_disabled")
		return;
		
	$.ajax({type:'POST', url: 'save_style_sheet_attrib.php', data:$('#frmStyleSheetAttrib').serialize(), success: function(response) {
		CompleteSaveStyleSheetAttributes(response);
	}});
}
function CompleteSaveStyleSheetAttributes(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response == 1)
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_SAVE_SUCCESS_MSG;
	else
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_SAVE_ERROR_ERR;
	popup_msg.ShowPopupMsg();
}

function EnableUpdateBtn(bEnable)
{
	if (bEnable)
		document.getElementById("btn_save_attributes").className = "button_console_save";
	else
		document.getElementById("btn_save_attributes").className = "button_console_save_disabled";
}
function EnableDisableAddBtn()
{
	if ((document.getElementById("name").value != "") && (document.getElementById("description").value != ""))
		document.getElementById("btn_add_style_sheet").className = "button_console_add";
	else
		document.getElementById("btn_add_style_sheet").className = "button_console_add_disabled";
}
function EnableDisableDeleteBtn()
{
	if (document.getElementById("style_sheet_delete").value != "")
		document.getElementById("btn_delete_style_sheet").className = "button_console_delete";
	else
		document.getElementById("btn_delete_style_sheet").className = "button_console_delete_disabled";
}
function EnableDisableRenameBtn()
{
	if ((document.getElementById("style_sheet_old_name").value != "") && (document.getElementById("style_sheet_new_name").value != ""))	{
		document.getElementById("btn_rename_style_sheet").className = "button_console_edit";
		document.getElementById("btn_copy_style_sheet").className = "button_console_copy";
	}
	else	{
		document.getElementById("btn_rename_style_sheet").className = "button_console_edit_disabled";
		document.getElementById("btn_copy_style_sheet").className = "button_console_copy_disabled";
	}
}
function SetMobileLabelStyle(style_sheet_type)
{
	if (style_sheet_type == "mobile")
		document.getElementById("mobile_label").style.color = "#000";
	else
		document.getElementById("mobile_label").style.color = "#DDD";
}

function PopulateDescription(old_name_select)
{
	var old_name = old_name_select.value;
	var old_desc = old_name_select.options[old_name_select.selectedIndex].text;
	old_desc_arr = old_desc.split(" (");
	old_desc = old_desc_arr[0];
	var old_exclude = old_desc_arr[2];
	old_exclude = old_exclude.replace(")", "");
	var old_show_custom_styles = old_desc_arr[3];
	old_show_custom_styles = old_show_custom_styles.replace(")", "");
	var custom = old_desc_arr[4];
	custom = custom.replace(")", "");

	document.getElementById("style_sheet_new_name").value = old_name;
	document.getElementById("new_description").value = old_desc;
	if (old_exclude == 1)
		document.getElementById("new_exclude").checked = true;
	else
		document.getElementById("new_exclude").checked = false;
	if (old_show_custom_styles == 1)
		document.getElementById("new_show_custom_styles").checked = true;
	else
		document.getElementById("new_show_custom_styles").checked = false;
		
	EnableDisableRenameBtn();
	
	if (custom == 1)
		document.getElementById("btn_rename_style_sheet").className = "button_console_edit";
	else
		document.getElementById("btn_rename_style_sheet").className = "button_console_edit_disabled";
}

function AddStyleSheet()
{
	if (document.getElementById("btn_add_style_sheet").className == "button_console_add_disabled")
		return;
	
	var name = document.getElementById("name").value;
	var description = document.getElementById("description").value;
	var style_sheet_types = document.getElementById("style_sheet_types").value;
	var exclude = 0;
	if (document.getElementById("exclude").checked === true)
		exclude = 1;
		
	$.post( "add_style_sheet.php", { name: name, description: description, style_sheet_types: style_sheet_types, exclude: exclude } ).done(function( data ) { CompleteAddStyleSheet(data); } ) ;
}
function CompleteAddStyleSheet(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data > 0)
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_ADD_SUCCESS_MSG;
	else if (data == "-style sheet already exists-")
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_ADD_SHEET_ALREADY_EXISTS_ERR;
	else
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_ADD_ERROR_ERR;
	popup_msg.ShowPopupMsg();
	
	PopulateDeleteStyleSheetList(sort_alpha);
	PopulateRenameStyleSheetList(sort_alpha);
	PopulateStyleSheetBtns(sort_alpha);
	
	document.getElementById("name").value = "";
	document.getElementById("description").value = "";
}

function DeleteStyleSheetConfirm()
{
	if (document.getElementById("btn_delete_style_sheet").className == "button_console_delete_disabled")
		return;
		
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	var delete_style_sheet = document.getElementById("style_sheet_delete").value;
	popup_msg.popup_msg_cell = MANAGE_STYLE_SHEET_ATT_DELETE_CONFIRM_MSG + " <b>" + delete_style_sheet + "</b> " + EDITOR_STYLE_SHEET;
	document.getElementById("popup_button_2_span").onclick = function() { DeleteStyleSheet(delete_style_sheet); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}
function DeleteStyleSheet(delete_style_sheet)
{
	popup_msg.HidePopupMsg();
	$.post( "delete_style_sheet.php", { name: delete_style_sheet } ).done(function( data ) { CompleteDeleteStyleSheet(data); } ) ;
}
function CompleteDeleteStyleSheet(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data == 1)
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_DELETE_SUCCESS_MSG;
	else
		popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_DELETE_ERROR_ERR;
	popup_msg.ShowPopupMsg();
	
	PopulateStyleSheetBtns(sort_alpha);
	PopulateDeleteStyleSheetList(sort_alpha);
	PopulateRenameStyleSheetList(sort_alpha);
}

function RenameCopyStyleSheet(mode)
{
	if (mode == "rename")	{
		if (document.getElementById("btn_rename_style_sheet").className == "button_console_edit_disabled")
			return;
	}
	else if (mode == "copy")	{
		if (document.getElementById("btn_copy_style_sheet").className == "button_console_copy_disabled")
			return;
	}
	else
		return;
		
	var old_name = document.getElementById("style_sheet_old_name").value;
	var new_name = document.getElementById("style_sheet_new_name").value;
	var new_desc = document.getElementById("new_description").value;
	var new_exclude = 0;
	if (document.getElementById("new_exclude").checked === true)
		new_exclude = 1;
	var new_show_custom_styles = 0;
	if (document.getElementById("new_show_custom_styles").checked === true)
		new_show_custom_styles = 1;

	$.post( "copy_rename_style_sheet.php", { old_name: old_name, new_name: new_name, new_desc: new_desc, new_exclude: new_exclude, new_show_custom_styles: new_show_custom_styles, mode: mode } ).done(function( data ) { CompleteRenameCopyStyleSheet(data, mode); } ) ;
}
function CompleteRenameCopyStyleSheet(data, mode)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data > 0)	{
		if (mode == "rename")
			popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_RENAME_SUCCESS_MSG;
		else
			popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_COPY_SUCCESS_MSG;
	}
	else	{
		if (mode == "rename")
			popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_RENAME_ERROR_ERR;
		else
			popup_msg.status_msg = MANAGE_STYLE_SHEET_ATT_COPY_ERROR_ERR;
	}
	popup_msg.ShowPopupMsg();
	
	PopulateStyleSheetBtns(sort_alpha);
	PopulateDeleteStyleSheetList(sort_alpha);
	PopulateRenameStyleSheetList(sort_alpha);
}

function PopulateStyleSheetBtns(sort_alpha)
{
	var sort_order = "sort_order";
	if (sort_alpha == 1)
		sort_order = "name";
		
	$.post( "get_rows.php", { table: "style_sheets", where: "`name` <> 'fonts'", order_by: sort_order } ).done(function( data ) { CompletePopulateStyleSheetBtns(data); } ) ;
}
function CompletePopulateStyleSheetBtns(data)
{
	if (data == "-no data-")
		return;
	
	var rows = data.split("@@@@@");
	var html = "<div class='button_heading_sub_level_1 btn_wide'><div class='button_heading_text_sub_level_1 btn_text_wide'>" + MANAGE_STYLE_SHEET_ATT_HEADING + "</div><div class='button_heading_help' id='button_heading_help' onClick='OpenHelpWindow();'>&nbsp;</div></div>\n";

	var JSON_row;
	var name;
	var description;
	var selected;
	for (var i = 0; i < rows.length; i++)
	{
		JSON_row = JSON.parse(rows[i]);
		name = JSON_row.name;
		description = JSON_row.description;

		if (name == last_style_sheet_edited)
			selected = " down_sub";
		else
			selected = "";
			
		html = html + "<div class='button_sub_level_1 btn_wide_w_borders" + selected + "' onClick=\"GetStyleSheetAttrib('" + name + "', this);\" name='style_sheet_btn'><span class='button_text_sub_level_1 btn_text_wide'>" + description + "</span></div>\n";
	}
	
	document.getElementById("sub_level_1_buttons").innerHTML = html;
}

function PopulateDeleteStyleSheetList(sort_alpha)
{
	var sort_order = "sort_order";
	if (sort_alpha == 1)
		sort_order = "name";
		
	$.post( "get_rows.php", { table: "style_sheets", where: "custom = 1", order_by: sort_order } ).done(function( data ) { CompletePopulateDeleteStyleSheetList(data); } ) ;
}
function CompletePopulateDeleteStyleSheetList(data)
{
	if (data == "-no data-")
		return;
	
	var rows = data.split("@@@@@");
	var style_sheet_delete_select = document.getElementById("style_sheet_delete");
	style_sheet_delete_select.options.length = 0;
	var opt = document.createElement('option');
	opt.value = "";
	opt.text = _NOT_SELECTED_;
	style_sheet_delete_select.add(opt);
	var JSON_row;
	var name;
	var description;
	for (var i = 0; i < rows.length; i++)
	{
		JSON_row = JSON.parse(rows[i]);
		name = JSON_row.name;
		description = JSON_row.description + " (" + name + ")";
		var opt = document.createElement('option');
		opt.value = name;
		opt.text = description;
		style_sheet_delete_select.add(opt);
	}
}

function PopulateRenameStyleSheetList(sort_alpha)
{
	var sort_order = "custom DESC, sort_order";
	if (sort_alpha == 1)
		sort_order = "custom DESC, name";
		
	if (document.getElementById("show_all").checked == true)
		$.post( "get_rows.php", { table: "style_sheets", order_by: sort_order } ).done(function( data ) { CompletePopulateRenameStyleSheetList(data); } ) ;
	else
		$.post( "get_rows.php", { table: "style_sheets", where: "custom = 1", order_by: sort_order } ).done(function( data ) { CompletePopulateRenameStyleSheetList(data); } ) ;
}
function CompletePopulateRenameStyleSheetList(data)
{
	if (data == "-no data-")
		return;
	
	var rows = data.split("@@@@@");
	var style_sheet_old_name_select = document.getElementById("style_sheet_old_name");
	style_sheet_old_name_select.options.length = 0;
	var opt = document.createElement('option');
	opt.value = "";
	opt.text = _NOT_SELECTED_;
	style_sheet_old_name_select.add(opt);
	var JSON_row;
	var name;
	var description;
	for (var i = 0; i < rows.length; i++)
	{
		JSON_row = JSON.parse(rows[i]);
		name = JSON_row.name;
		description = JSON_row.description + " (" + name + ") (" + JSON_row.exclude + ") (" + JSON_row.show_custom_styles + ") (" + JSON_row.custom + ")";
		var opt = document.createElement('option');
		opt.value = name;
		opt.text = description;
		style_sheet_old_name_select.add(opt);
	}
}

function ChangeStyleSheetSort(bAlpha)
{
	sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;
		
	PopulateStyleSheetBtns(sort_alpha);
	PopulateDeleteStyleSheetList(sort_alpha);
	PopulateRenameStyleSheetList(sort_alpha);
}

function InitializeConsole()
{
	PopulateStyleSheetBtns(sort_alpha);
	PopulateDeleteStyleSheetList(sort_alpha);
	PopulateRenameStyleSheetList(sort_alpha);
	GetStyleSheetAttrib(last_style_sheet_edited, -1);
	GetStyleSheetSortOrder();
}

function CheckName(name_el)
{
	var name = name_el.value;
	name = name.toLowerCase();
	name = name.replace(/ /g, "_");
	name = name.replace(/-/g, "_");
	name_el.value = name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetStyleSheetSortOrder()
{
	$.post( "get_rows.php", { table: "style_sheets", fields: "name, description, custom, sort_order", order_by: "sort_order" } ).done(BuildStyleSheetSortOrderTable) ;
}
function BuildStyleSheetSortOrderTable(data)
{
	var row_delim = "@@@@@";
	var rows = data.split(row_delim);
	var JSON_row;

	var bgcolor = "#E5E5E5";
	
	var html_sort = "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
  	html_sort = html_sort + "<tr>\n";
    html_sort = html_sort + "<td colspan='4' class='sub_title' style='padding-left:5px;'>" + MANAGE_STYLE_SHEET_SET_SORT_ORDER + "</td>\n";
  	html_sort = html_sort + "</tr>\n";
  	html_sort = html_sort + "<tr bgcolor='#CCCCCC'>\n";
  	html_sort = html_sort + "<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
    html_sort = html_sort + "<td><b>" + MANAGE_STYLE_SHEET_NAME_DESCRIPTION + ":</b></td>\n";
    html_sort = html_sort + "<td><b>" + SORT_ORDER + ":</b></td>\n";
    html_sort = html_sort + "<td><b>" + CUSTOM_WORD + ":</b></td>\n";
  	html_sort = html_sort + "</tr>\n";
  
	for (var i = 0; i < rows.length; i++)
	{
		JSON_row = JSON.parse(rows[i]);
		
		html_sort = html_sort + "<tr bgcolor='" + bgcolor + "'>\n<td>&nbsp;</td>\n";
		html_sort = html_sort + "<td>" + JSON_row.name + " / " + JSON_row.description + "<input type='hidden' name='style_sheet_" + i + "' value='" + JSON_row.name + "'></td>\n";
		html_sort = html_sort + "<td><input type='text' name='sort_order_" + i + "' value='" + JSON_row.sort_order + "'></td>\n";
		if (JSON_row.custom == 1)
			html_sort = html_sort + "<td>&radic;</td>\n</tr>\n";
		else
			html_sort = html_sort + "<td>&nbsp;</td>\n</tr>\n";
		if (bgcolor == "#E5E5E5")
			bgcolor = "#DDDDDD";
		else
			bgcolor = "#E5E5E5";
	}
	
	html_sort = html_sort + "<tr><td colspan='4'>&nbsp;\n";
  	html_sort = html_sort + "</td></tr>\n";
  	html_sort = html_sort + "<tr>\n";
    html_sort = html_sort + "<td colspan='4' align='center'>\n";
    html_sort = html_sort + "<div class='button_console_save' style='width:110px;' onClick='SetSortOrder();'><span class='button_console_text_w_icon'>" + UPDATE_WORD + "</span></div>\n";
    html_sort = html_sort + "</td>\n";
  	html_sort = html_sort + "</tr>\n";
	html_sort = html_sort + "</table>\n";
	
	document.getElementById("style_sheet_sort_div").innerHTML = html_sort;
}

function SetSortOrder()
{
	$.ajax({type:'POST', url: 'set_style_sheet_sort_order.php', data:$('#formSortStyleSheets').serialize(), success: function(response) {
		CompleteSetSortOrder(response);
	}});
}
function CompleteSetSortOrder(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (response == 1)
		popup_msg.status_msg = CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG;
	else
		popup_msg.status_msg = CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR;
	popup_msg.ShowPopupMsg();
	
	GetStyleSheetSortOrder();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved border area.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}