<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 5/1/2015	ELL
//
function RunSQL($sql_string, $dbh, $table_prefix, $show_progress = false, $rows_affected_msg = "row(s) affected.")
{
//	$sql_string = stripslashes($sql_string);
	$sql_string_arr = array();
	$line_arr = array();
	// Split SQL input into lines.
	$line_arr = preg_split("[\n|\r]", $sql_string);
	$sql_string_arr[0] = "";
	$j = 0;
	$find_start = true;
	$got_script = false;
	$got_php = false;
	$got_style = false;
	// Search for commands and assemble into SQL command array.
	for ($i = 0; $i < count($line_arr); $i++)
	{
		// Test for comment line.
		$curr_line = trim($line_arr[$i]);
		if ($find_start)
		{
			$first_chars = substr($curr_line, 0, 2);
			if (($first_chars == "--") || ($first_chars == "//") || ($first_chars == "/*") || ($first_chars == ""))
				continue;
				
			$got_select = false;
			if (strtoupper(substr($curr_line, 0, 6)) == "SELECT")
				$got_select = true;
		}
		$find_start = false;
		
		// It is possible for a line to end with a semicolon (;) if records contain JavaScript or PHP.  Need to turn off looking end of SQL command
		// if script or PHP is found until end of script or PHP is also found.  Otherwise we run the risk of trying to run only part of a record insert
		// which usually results in an SQL syntax error.
		if (!$got_script)
		{
			if (stripos($curr_line, "<script") !== false)
				$got_script = true;
		}
		if ($got_script)
		{
			if (stripos($curr_line, "</script>") !== false)
				$got_script = false;
		}
		
		if (!$got_php)
		{
			if (stripos($curr_line, "<?php") !== false)
				$got_php = true;
		}
		if ($got_php)
		{
			if (stripos($curr_line, "?>") !== false)
				$got_php = false;
		}
		
		if (!$got_style)
		{
			if (stripos($curr_line, "<style") !== false)
				$got_style = true;
		}
		if ($got_style)
		{
			if (stripos($curr_line, "</style>") !== false)
				$got_style = false;
		}
		
		
		// Build SQL command.
		$sql_string_arr[$j] = $sql_string_arr[$j] . $line_arr[$i];
		
		// Look for end of command.
		if ((!$got_script) && (!$got_php) && (!$got_style))
		{
			$last_char = substr($curr_line, (strlen($curr_line) - 1), 1);
			if ($last_char == ";")	// Got end of SQL command.
			{
				// Check for other possible reasons that ; is at end of line.
				$last_6_chars = substr($curr_line, (strlen($curr_line) - 7), 6);
				if (stripos($curr_line, "&") === false) // Looks like ; is not do to & code, good to go.
				{
					$j++;
					$sql_string_arr[$j] = "";
					$find_start = true;
				}
			}
		}
	}
	// Run SQL commands one at a time.
	for ($i = 0; $i < count($sql_string_arr); $i++)
	{
		if (strlen($sql_string_arr[$i]) > 2)
		{
			if ($table_prefix != "bwb_")
			{
				$sql_string_arr[$i] = str_replace("bwb_dbh", "@@@link_retention@@@", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("\$bwb_", "@@@var_retention@@@", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("bwb_", $table_prefix, $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("@@@var_retention@@@", "\$bwb_", $sql_string_arr[$i]);
				$sql_string_arr[$i] = str_replace("@@@link_retention@@@", "bwb_dbh", $sql_string_arr[$i]);
			}
			if ($show_progress)	{
				echo "SQL: " . htmlentities(substr($sql_string_arr[$i], 0, 100));
				if (strlen($sql_string_arr[$i]) > 100)
					echo "...";
				echo "<br /><br />\n";
			}

			try	{
				if (($got_select == true) || ($got_select == 1))
					$result = $dbh->query($sql_string_arr[$i]);
				else
					$result = $dbh->exec($sql_string_arr[$i]);
			} catch (Exception $e) {
				echo $e->getMessage() . "<br />\n";
			}

			if ($show_progress)
			{
				if (is_array($result))	{
					echo "<pre>\n";
					print_r($result);
					echo "\n</pre>\n";
				}
				elseif (is_object($result))	{
					while($row = $result->fetch(PDO::FETCH_ASSOC))
					{
						foreach($row as $field => $val)
						{
							echo "<b>" . $field . "</b> = " . htmlentities($val) . "<br />\n";
						}
					}
				}
				elseif ($result > 0)
					echo $result . " " . $rows_affected_msg . "<br />\n";
				elseif ($result === 0)
					echo RUN_SQL_QUERY_SUCCESS_MSG . "<br />\n";
				else	{
					$err_arr = $dbh->errorInfo();
					echo $err_arr[2] . " (SQL error: " . $err_arr[0] . ", PDO error: " . $err_arr[1] . ")<br />\n";
				}
					
				if ($i < (count($sql_string_arr) - 1))
					echo "<br />-------------------------------------------------------------------------------<br />\n";
			}
		}
	}
	return $result;
}
?>