<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/28/2013	ELL
// Revised: 11/21/2014	ELL
// Off-loaded JavaScript.
// Revised: 21/1/2014	ELL
// Added edit is source view checkbox.
// Revised: 4/28/2016	ELL
// Added ability to use either desktop styles or mobile styles.
// Revised: 7/18/2019	ELL
// Added auto-create of default border areas if not exist.
// 

	include ("check_session.php");

	$last_border_edited = $_SESSION['last_border_edited'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Border Area Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<script src="js/ajax.js"> </script>
<script type="text/javascript" src="js/manage_border_area_select.js"></script>

<style>
#editor_options_div	{
<?php if (($access_level == "admin") || ($access_level == "power_user"))	{	?>
	display:block;
	position:absolute;
	top:50px;
	left:400px;
<?php	} else	echo "	display:none;\n";	?>
}

#btn_manage_custom_border_areas	{
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px -1px;
}
</style>

<script>
<?php	echo "	var http = '$http';\n";	?>
</script>
</head>

<body>
 <div id="sub_level_1_buttons">
	 	
            <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo EDIT_BORDER_AREA_SELECT_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
		<?php
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name NOT LIKE 'mm_%' ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$default_header_found = false;
			$default_top_found = false;
			$default_left_found = false;
			$default_right_found = false;
			$default_bottom_found = false;
			$default_footer_found = false;
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$page_name = $row["page_name"];
				if ($page_name == "header")
					$default_header_found = true;
				elseif ($page_name == "top")
					$default_top_found = true;
				elseif ($page_name == "left")
					$default_left_found = true;
				elseif ($page_name == "right")
					$default_right_found = true;
				elseif ($page_name == "bottom")
					$default_bottom_found = true;
				elseif ($page_name == "footer")
					$default_footer_found = true;

				if ($page_name == $last_border_edited)
					$selected = " down_sub";
				else
					$selected = "";
					
				echo "<div class='button_sub_level_1$selected' onClick=\"window.location='edit_page.php?page_name=$page_name&mode=border&special=1';\"><span class='button_text_sub_level_1'>$page_name</span></div>\n";
			}
			
			$body_html = "\n<p>" . CREATE_PAGE_DEFAULT_CONTENT . "</p>\n<!-- Page Content Divider -->\n";
			if (!$default_header_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=header&mode=border&special=1';\"><span class='button_text_sub_level_1'>header</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='header', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
			if (!$default_top_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=top&mode=border&special=1';\"><span class='button_text_sub_level_1'>top</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='top', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
			if (!$default_left_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=left&mode=border&special=1';\"><span class='button_text_sub_level_1'>left</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='left', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
			if (!$default_right_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=right&mode=border&special=1';\"><span class='button_text_sub_level_1'>right</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='right', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
			if (!$default_bottom_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=bottom&mode=border&special=1';\"><span class='button_text_sub_level_1'>bottom</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='bottom', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
			if (!$default_footer_found)	{
				echo "<div class='button_sub_level_1' onClick=\"window.location='edit_page.php?page_name=footer&mode=border&special=1';\"><span class='button_text_sub_level_1'>footer</span></div>\n";
				
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='footer', page_content='" . $body_html . "'";
				$cnt = $bwb_dbh->exec($query);
			}
		?>

		<div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_BORDER_AREA_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
        
        <div class='button_sub_level_1' onClick="window.location='manage_border_area.php';" id="btn_manage_custom_border_areas"><span class='button_text_sub_level_1' style="left:40px;"><?php echo MANAGE_BORDER_AREA_BTN; ?></span></div>
</div>
     
     <div id="editor_options_div">
    <span class="bold"><?php echo EDIT_PAGE_SELECT_OPTIONS_HEADING; ?></span><br /><br />
    <input type="checkbox" id="editor_mode" name="editor_mode" onChange="SetEditorMode('editor_mode');" <?php if (isset($_SESSION['editor_mode']) && ($_SESSION['editor_mode'] == 1)) echo "checked='checked'"; ?> />
    <?php echo EDIT_PAGE_SELECT_SOURCE_VIEW_OPTION; ?><br /><br />
    <?php echo EDIT_PAGE_SELECT_DEVICE_EMULATION; ?>:<br />
    <input type="radio" id="style_mode[0]" name="style_mode" value="desktop" onChange="SetEditorMode('style_mode[0]');" <?php if (!isset($_SESSION['style_mode']) || ($_SESSION['style_mode'] == "desktop")) echo "checked='checked'"; ?> />
    <?php echo DESKTOP_WORD; ?><br />
    <input type="radio" id="style_mode[1]" name="style_mode" value="mobile" onChange="SetEditorMode('style_mode[1]');" <?php if (isset($_SESSION['style_mode']) && ($_SESSION['style_mode'] == "mobile")) echo "checked='checked'"; ?> />
    <?php echo MOBILE_WORD; ?><br />
    <input type="radio" id="style_mode[2]" name="style_mode" value="touchscreen" onChange="SetEditorMode('style_mode[2]');" <?php if (isset($_SESSION['style_mode']) && ($_SESSION['style_mode'] == "touchscreen")) echo "checked='checked'"; ?> />
    <?php echo TOUCHSCREEN_WORD; ?><br /><br />
    </div>
</body>
</html>