<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	7/14/2017	ELL
// 

	include ("check_session.php");

	$style_sheet = $_REQUEST['style_sheet'];
	$class = $_REQUEST['class'];
	
	$search = array("PERIOD", "POUND", "SPACE", "COMMA", "GREATERTHAN", "GREATERTHAN", "PLUS", "TILDA");
	$replace = array(".", "#", " ", ",", ">", "&gt;", "+", "~");
	$class = str_replace($search, $replace, $class);
	
	if (isset($_REQUEST['attrib_sort_method']) && ($_REQUEST['attrib_sort_method'] != ""))	{
		$attrib_sort_method = $_REQUEST['attrib_sort_method'];
		$_SESSION['attrib_sort_method'] = $attrib_sort_method;
	}
	elseif (isset($_SESSION['attrib_sort_method']) && ($_SESSION['attrib_sort_method'] != ""))
		$attrib_sort_method = $_SESSION['attrib_sort_method'];
	else
		$attrib_sort_method = 0;
		
	$query = "SELECT description FROM " . BWB_TABLE_PREFIX . "site_classes WHERE style_sheet = '" . $style_sheet . "' AND class = '" . $class . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$description = $row["description"];
?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Edit Blog Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style>
	#manage_important_heading	{	width: 300px;	}
	#manage_important_heading_help	{	left: 260px;	}
	
	#important_back_btn	{
		width:210px;
		position:absolute;
		top:50px;
		right:100px;
	}
	
	#attrib_sort_div	{
		position: absolute;
		top: 65px;
		left: 350px;
	}
	
	#class_and_desc_div	{
		position: absolute;
		top: 25px;
		left: 450px;
		font-size:16px;
	}
	.class_span	{
		font-size:18px;
		font-weight:bold;
	}
</style>

<script src="js/jquery.min.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/manage_important_css.js"></script>

<script>
	var style_sheet = "<?php echo $style_sheet; ?>";
	var class_str = "<?php echo $class; ?>";
<?php
	echo "	var EDIT_CSS_UPDATE_COMPLETE_MSG = \"" . EDIT_CSS_UPDATE_COMPLETE_MSG . "\";\n";
	echo "	var JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR = \"" . JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . "\";\n";
	
	echo "	var http = '$http';\n";
?>
</script>

</head>

<body>
<div id="sub_level_1_buttons">

        <div class="button_heading_sub_level_1" id="manage_important_heading"><div class="button_heading_text_sub_level_1"><?php echo IMPORTANT_HEADING; ?></div><div class="button_heading_help" id="manage_important_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
		<?php
			$exceptions = array();
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css_important_field_exceptions";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$exceptions[] = $row["field_name"];
			}
			
			$important_attribs = array();
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css_important WHERE style_sheet = '" . $style_sheet . "' AND `class` = '" . $class . "'";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$important_attribs[] = $row["attribute"];
			}
			
			$field_to_attrib = array();
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css_field_to_attrib";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$field_to_attrib[$row["field_name"]] = $row["attribute"];
			}
			
			$attribs = array();
			$query = "SHOW COLUMNS FROM " . BWB_TABLE_PREFIX . "site_css";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				if (in_array($row["Field"], $important_attribs))
					$btn_class = 'button_sub_level_1_remove';
				else
					$btn_class = 'button_sub_level_1_add';
				
				if (!in_array($row["Field"], $exceptions))
					$attribs[$row["Field"]] = $btn_class;
			}

			if ($attrib_sort_method == 1)
				ksort($attribs);
				
			foreach ($attribs as $attrib => $button_class)
			{
				if (isset($field_to_attrib[$attrib]))
					$attrib_str = $field_to_attrib[$attrib];
				else
					$attrib_str = str_replace("_", "-", $attrib);
				echo "<div class='$button_class' onClick=\"AddRemoveAttrib('$attrib', this);\"><span class='button_text_sub_level_1_add'>$attrib_str</span></div>\n";
			}
		?>
</div>

<div id="attrib_sort_div">
<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha" name="sort_alpha" <?php if ($attrib_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
</div>

<div id="class_and_desc_div">
<?php echo "<span class='class_span'>" . $class . "</span> ----- " . $description . " ----- (" . $style_sheet . " " . STYLE_SHEET_WORD . ")"; ?>
</div>

  <div class='button_console_go_back' id="important_back_btn" onClick="window.location.href='edit_css.php?style_sheet=<?php echo $style_sheet; ?>'"><span class='button_console_text_w_icon'><?php echo CLASSES_BACK_TO_EDIT_CSS; ?></span></div>

<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
</script>
</body>
</html>