<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/26/2018	ELL
// Main content created by Steffen Becker
// 
	include ("check_session.php");
	
	$file_name = $_REQUEST['file_name'];
	
	$doc_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == "")
		$css_dir = $doc_root . "/" . BWB_CSS_DIR . "/";
	else
		$css_dir = $doc_root . "/" . BWB_BASE_DIR . "/" . BWB_CSS_DIR . "/";
		
	if ($file_name == "*")	{
		$bkup_dir = $css_dir . "bkup" . time();
		if (!file_exists($bkup_dir))
			mkdir($bkup_dir, 0755);
		$bkup_dir .= "/";
	}
	
	$cssFiles = array();
	if (isset($file_name) && ($file_name != "") && ($file_name != "*"))	{
		$cssFiles[] = $file_name;
	}
	elseif (isset($file_name) && ($file_name == "*"))	{
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			if (file_exists($css_dir . $row['name'] . ".css"))
				$cssFiles[] = $row['name'] . ".css";
		}
	}

/**
 * This function takes a css-string and compresses it, removing
 * unneccessary whitespace, colons, removing unneccessary px/em
 * declarations etc.
 *
 * @param string $css
 * @return string compressed css content
 * @author Steffen Becker
 */
function minifyCss($css) {
  // some of the following functions to minimize the css-output are directly taken
  // from the awesome CSS JS Booster: https://github.com/Schepp/CSS-JS-Booster
  // all credits to Christian Schaefer: http://twitter.com/derSchepp
  // remove comments
  $css = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);
  // backup values within single or double quotes
  preg_match_all('/(\'[^\']*?\'|"[^"]*?")/ims', $css, $hit, PREG_PATTERN_ORDER);
  for ($i=0; $i < count($hit[1]); $i++) {
    $css = str_replace($hit[1][$i], '##########' . $i . '##########', $css);
  }
  // remove traling semicolon of selector's last property
  $css = preg_replace('/;[\s\r\n\t]*?}[\s\r\n\t]*/ims', "}\r\n", $css);
  // remove any whitespace between semicolon and property-name
  $css = preg_replace('/;[\s\r\n\t]*?([\r\n]?[^\s\r\n\t])/ims', ';$1', $css);
  // remove any whitespace surrounding property-colon
  $css = preg_replace('/[\s\r\n\t]*:[\s\r\n\t]*?([^\s\r\n\t])/ims', ':$1', $css);
  // remove any whitespace surrounding selector-comma
  $css = preg_replace('/[\s\r\n\t]*,[\s\r\n\t]*?([^\s\r\n\t])/ims', ',$1', $css);
  // remove any whitespace surrounding opening parenthesis
  $css = preg_replace('/[\s\r\n\t]*{[\s\r\n\t]*?([^\s\r\n\t])/ims', '{$1', $css);
  // remove any whitespace between numbers and units
  $css = preg_replace('/([\d\.]+)[\s\r\n\t]+(px|em|pt|%)/ims', '$1$2', $css);
  // shorten zero-values
  $css = preg_replace('/([^\d\.]0)(px|em|pt|%)/ims', '$1', $css);
  // constrain multiple whitespaces
  $css = preg_replace('/\p{Zs}+/ims',' ', $css);
  // remove newlines
  $css = str_replace(array("\r\n", "\r", "\n"), '', $css);
  // Restore backupped values within single or double quotes
  for ($i=0; $i < count($hit[1]); $i++) {
    $css = str_replace('##########' . $i . '##########', $hit[1][$i], $css);
  }
  return $css;
}
// execute it
foreach($cssFiles as $file) {
	if ($file_name == "*")
		copy($css_dir . $file, $bkup_dir . $file);
	else	{
		if (file_exists($file_name))
		{
			$bkup_file_name = $css_dir . "." . $file . (time() + 1);
			if (!copy($css_dir . $file, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
	}
	$cssContents = '';
	$cssContents = file_get_contents($css_dir . $file);
	file_put_contents($css_dir . $file, minifyCss($cssContents));
}
if ($supress_msg != 1)
	echo 1;
?>