<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/26/2018	ELL
// Main content created by Rodrigo Alves
// 
	include ("check_session.php");
	
	$file_name = $_REQUEST['file_name'];
	$_SESSION['last_file_minified'] = $file_name;
	
	$doc_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == "")
		$scripts_dir = $doc_root . "/" . BWB_SCRIPTS_DIR;
	else
		$scripts_dir = $doc_root . "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR;
	
	$src_dir = $scripts_dir . "/src";
	if (!file_exists($src_dir))
		mkdir($src_dir, 0755);
	$src_dir .= "/";
	
	$jsFiles = array();
	if (isset($file_name) && ($file_name != ""))	{
		$jsFiles[] = $file_name;
	}
	elseif (isset($file_name) && ($file_name == "*"))
	{
		if ($handle = opendir($scripts_dir))
		{
			while (false !== ($file = readdir($handle)))
			{
				if (!is_dir($scripts_dir . "/" . $file))
				{
					if ((strpos($file, ".", 0) !== 0) && (strtolower(substr($file, strlen($file) - 3)) == ".js"))
						$jsFiles[] = $file;
				}
			}
			closedir($handle);
		}
		sort($jsFiles);
	}
	$scripts_dir .= "/";

// JavaScript Minifier
function minifyJs($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#\s*("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')\s*|\s*\/\*(?!\!|@cc_on)(?>[\s\S]*?\*\/)\s*|\s*(?<![\:\=])\/\/.*(?=[\n\r]|$)|^\s*|\s*$#',
            // Remove white-space(s) outside the string and regex
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/)|\/(?!\/)[^\n\r]*?\/(?=[\s.,;]|[gimuy]|$))|\s*([!%&*\(\)\-=+\[\]\{\}|;:,.<>?\/])\s*#s',
            // Remove the last semicolon
            '#;+\}#',
            // Minify object attribute(s) except JSON attribute(s). From `{'foo':'bar'}` to `{foo:'bar'}`
            '#([\{,])([\'])(\d+|[a-z_][a-z0-9_]*)\2(?=\:)#i',
            // --ibid. From `foo['bar']` to `foo.bar`
            '#([a-z0-9_\)\]])\[([\'"])([a-z_][a-z0-9_]*)\2\]#i'
        ),
        array(
            '$1',
            '$1$2',
            '}',
            '$1$3',
            '$1.$3'
        ),
    $input);
}
// execute it
foreach($jsFiles as $file) {
	if (!file_exists($src_dir . $file) && file_exists($scripts_dir . $file))
		copy($scripts_dir . $file, $src_dir . $file);
	elseif (file_exists($src_dir . $file) && !file_exists($scripts_dir . $file))
		copy($src_dir . $file, $scripts_dir . $file);
	
	if (file_exists($scripts_dir . $file))	{
		$bkup_file_name = $scripts_dir . "." . $file . time();
		if (!copy($scripts_dir . $file, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}

	if (($miniy_from_editor != 1) || ($action == "publish"))	{
		$jsContents = '';
		$jsContents = file_get_contents($src_dir . $file);
		file_put_contents($scripts_dir . $file, minifyJs($jsContents));
	}
}

if ($miniy_from_editor != 1)
	echo 1;
?>