<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	5/129/2018	ELL

/* 
This module may be customized to add plugins to the CKEditor.  To start, unzip the plugin you want to add, and FTP the files to /ckeditor/plugins/.  Make sure all of the plugin files stay inside of their own plugin folder.  i.e. Easy Image would be uploaded to /ckeditor/plugins/easyimage/. You can download the plugins here: https://ckeditor.com/cke4/addons/plugins/all.  Next, add your plugin to the comma-separated list in CKEDITOR.config.extraPlugins.  In cases where you are replacing a built-in plugin with a new plugin, you will also need to remove the plugin being replaced using CKEDITOR.config.removePlugins. In the case of the Easy Image plugin, you will need to remove the 'image' plugin.

In the case of Easy Image, you will also need to obtain a URL token and an upload token. You can obtain those tokens here: https://docs.ckeditor.com/cs/latest/guides/easy-image/quick-start.html.

This module is used in the editors that have both a design view mode and a code view mode.  This includes the page editor and the border area editor.  For customizing the editors for head code, custom CSS, and direct file editing, see ckeditor_plugins_no_design_view.php.

Below is an example for Easy Image (you will need to use your own tokens):
	CKEDITOR.config.extraPlugins = 'zoom,letterspacing,codemirror,easyimage';
	CKEDITOR.config.removePlugins = 'image';
	CKEDITOR.config.cloudServices_tokenUrl =  'https://16600.cke-cs.com/token/dev/nTYDBnd18iUufeKU00Ed58FQPZh9IBxnYSzKaLaxuagmcav9Y1szsEXff0Pc';
	CKEDITOR.config.cloudServices_uploadUrl = 'https://16600.cke-cs.com/easyimage/upload/';
	
To return the editor to the original Breeze functionality, the code is simply:
	CKEDITOR.config.extraPlugins = 'zoom,letterspacing,codemirror';
*/
?>
<script>
	CKEDITOR.config.extraPlugins = 'zoom,letterspacing,codemirror';
</script>
<?php ?>