/////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/20/2018	ELL
// 
//

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

////////////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#events_calender#manage_categories", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(category, id, i)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_EVENT_CATEGORIES_DELETE_CONFIRM_MSG_1 + " <b>" + category + "</b> " + MANAGE_EVENT_CATEGORIES_DELETE_CONFIRM_MSG_1;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteCategory(id); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteCategory(id)
{
	popup_msg.HidePopupMsg();
	if (id != -1)
		$.post( "delete_event_location_category.php", { id: id } ).done(CompleteDeleteCategory) ;
	else RetrieveCategories();
}
function CompleteDeleteCategory()
{
	RetrieveCategories();
}

//////////////////////////////////////////////////////////////////////////////////////
function ValidateForm(i)
{
	var category_ctl = "category" + i;
	var category_string_ctl = "category_string" + i;
	
	document.getElementById(category_ctl).className = "med_txt_field";
	document.getElementById(category_string_ctl).className = "long_txt_field";
	var bResult = true;
	if (document.getElementById(category_ctl).value == "")	{
		document.getElementById(category_ctl).className = "med_txt_field highlight";
		document.getElementById(category_ctl).focus();
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 4000;
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ERROR_NO_CATEGORY_ERR;
		popup_msg.ShowPopupMsg();
		bResult = false;
	}
	if (document.getElementById(category_string_ctl).value == "")	{
		document.getElementById(category_string_ctl).className = "long_txt_field highlight";
		document.getElementById(category_string_ctl).focus();
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 4000;
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ERROR_NO_CATEGORY_STR_ERR;
		popup_msg.ShowPopupMsg();
		bResult = false;
	}
	return bResult;
}

function UpdateCategory(id, i)
{
	if (update_all)
	{
		UpdateAll();
		return;
	}

	var category_ctl = "category" + i;
	var category_string_ctl = "category_string" + i;
	var event_type_ctl = "event_type" + i;
	var location_type_ctl = "location_type" + i;
	var sort_order_ctl = "sort_order" + i;
	
	if (id == -1)
		unsaved_new_item = false;

	var category = document.getElementById(category_ctl).value;
	var category_string = document.getElementById(category_string_ctl).value;
	var event_type = 0;
	if (document.getElementById(event_type_ctl).checked == true)
		event_type = 1;
	var location_type = 0;
	if (document.getElementById(location_type_ctl).checked == true)
		location_type = 1;
	var sort_order = document.getElementById(sort_order_ctl).value;

	var ready = ValidateForm(i);
	if (ready == true)	{
		$.post( "save_event_location_category.php", { id: id, category: category, category_string: category_string, event_type: event_type, location_type: location_type, sort_order: sort_order } ).done(CompleteSaveCategory) ;
	}
}
function CompleteSaveCategory(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response == 1)	{
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ALL_SAVED_MSG;
		var code = "RetrieveCategories();";
		setTimeout(code, 3010);
	}
	else
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ERROR_SAVING_CATEGORIES_ERR;
	popup_msg.ShowPopupMsg();
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateAll()
{
	var ready = true;
	var cnt = document.getElementById("nCount").value;

	for (i = 0; i < cnt; i++)
	{
		if (ValidateForm(i) == false)
			ready = false;
	}

	if (ready == true)	{
		$.ajax({type:'POST', url: 'save_event_location_categories.php', data:$('#frmCategoryAttributes').serialize(), success: function(response) {
			CompleteUpdateAll(response);
		}});
	}

	unsaved_new_item = false;
	window.parent.SetWorkSavedNotSaved(true);
}
function CompleteUpdateAll(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response == 1)	{
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_SAVED_MSG;
		var code = "RetrieveCategories();";
		setTimeout(code, 3010);
	}
	else
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ERROR_SAVING_CATEGORY_ERR;
	popup_msg.ShowPopupMsg();
}

////////////////////////////////////////////////////////////////////////////////////
function AddCategory(i)
{
	if (unsaved_new_item === true)	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = MANAGE_EVENT_CATEGORIES_ADD_BEFORE_SAVE_NEW_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
		return;
	}

	update_all = true;
	window.parent.SetWorkSavedNotSaved(false);
	unsaved_new_item = true;

	var html = document.getElementById("CategoriesTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var d = 0;
	var srch_str;
	
	if ((browser == "Explorer") && (browser_version < 9))
		srch_str = "<TR id=row" + i;
	else
		srch_str = "<tr id=\"row" + i + "\"";
		
	var html_arr = new Array();
	html_arr = html.split(srch_str);
	var html_top = html_arr[0];
	var html_bottom = html.substring(html_top.length);

	var bgclr = "#FFFF99";
	var new_row = "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
	
	
	new_row = new_row + "<td valign='top'><input type='hidden' name='id" + i + "' id='id" + i + "' value='-1'>\n";
	new_row = new_row + "<input type='text' name='category" + i + "' id='category" + i + "' value='' onchange=\"SetElementValue('category" + i + "', -1);\" onmouseout=\"SetElementVal('category" + i + "');\" onkeypress=\"SetCurrentItem('category" + i + "', -1);\" class='med_txt_field' /><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<input type='text' name='category_string" + i + "' id='category_string" + i + "' value='' onchange=\"SetElementValue('category_string" + i + "', -1);\" onmouseout=\"SetElementVal('category_string" + i + "');\" onkeypress=\"SetCurrentItem('category_string" + i + "', -1);\" class='long_txt_field' /><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<input type='checkbox' name='event_type" + i + "' id='event_type" + i + "' value='1' checked='checked' /><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<input type='checkbox' name='location_type" + i + "' id='location_type" + i + "' value='1' checked='checked' /><\/td>\n";
		
	new_row = new_row + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='' />\n";
	new_row = new_row + "<img src='../../theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateCategory(-1, " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddCategory(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	d = parseInt(i) + 1;
	new_row = new_row + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/arrow-down.png' border=0 alt='Move Down' name='MoveDown' id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('', -1, " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<\/tr>\n";

	var n = i - 1;
	var rplc_str;
	for (var j = cnt; j >= i; j--)
	{
		k = j + 1;
		srch_str = "row" + j;
		rplc_str = "row" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "id" + j;
		rplc_str = "id" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "category" + j;
		rplc_str = "category" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "category_string" + j;
		rplc_str = "category_string" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "sort_order" + j;
		rplc_str = "sort_order" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "UpdateCategory(-1, " + j;
		rplc_str = "UpdateCategory(-1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "AddCategory(" + j;
		rplc_str = "AddCategory(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "DeleteConfirm('', -1, " + j;
		rplc_str = "DeleteConfirm('', -1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveUp" + j;
		rplc_str = "MoveUp" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveDown" + j;
		rplc_str = "MoveDown" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItem(" + j;
		rplc_str = "MoveItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItemDown(" + j;
		rplc_str = "MoveItemDown(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
	}
	html = html_top + new_row + html_bottom;
	document.getElementById("CategoriesTable").innerHTML = html;
	cnt++;
	document.getElementById("nCount").value = cnt;
	
	if (n == 0)
	{
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById("MoveUp1").style.display = "table-row";
	}
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveCategories()
{	
	$.post( "../../get_rows.php", { table: "event_location_categories", order_by: "sort_order", no_prefix: 0 } ).done(PopulateTable) ;
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(rows_str)
{
	var rows = new Array();
	var fields = new Array();
	var d = 0;
	var tmp, checked;
	
	var output_str = "<table width='90%' align='center'>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_EVENT_CATEGORIES_CATEGORY + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_EVENT_CATEGORIES_CATEGORY_STRING + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_EVENT_CATEGORIES_EVENT_TYPE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_EVENT_CATEGORIES_LOCATION_TYPE + "<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	
	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no menu items yet (first time).
		var i = 0;
	else	// Create rows for menu items.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
					
			output_str = output_str + "<td valign='top'><input type='hidden' name='id" + i + "' id='id" + i + "' value='" + JSON_row.id + "'>\n";
			output_str = output_str + "<input type='text' name='category" + i + "' id='category" + i + "' value='" + JSON_row.category + "' onchange=\"SetElementValue('category" + i + "', -1);\" onmouseout=\"SetElementVal('category" + i + "');\" onkeypress=\"SetCurrentItem('category" + i + "', -1);\" class='med_txt_field' /><\/td>\n";
			
			output_str = output_str + "<td valign='top'><input type='text' name='category_string" + i + "' id='category_string" + i + "' value='" + JSON_row.category_string + "' onchange=\"SetElementValue('category_string" + i + "', -1);\" onmouseout=\"SetElementVal('category_string" + i + "');\" onkeypress=\"SetCurrentItem('category_string" + i + "', -1);\" class='long_txt_field' /><\/td>\n";
			
			checked = "";
			if (JSON_row.event_type == 1)
				checked = " checked='checked'";
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<input type='checkbox' name='event_type" + i + "' id='event_type" + i + "' value='1'" + checked + " /><\/td>\n";
			
			checked = "";
			if (JSON_row.location_type == 1)
				checked = " checked='checked'";
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<input type='checkbox' name='location_type" + i + "' id='location_type" + i + "' value='1'" + checked + " /><\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='" + JSON_row.sort_order + "' />\n";
			
			output_str = output_str + "<img src='../../theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateCategory(" + JSON_row.id + ", " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddCategory(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			d = parseInt(i) + 1;
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/arrow-down.png' border=0 alt='Move Down' name='MoveDown'  id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			tmp = JSON_row.category;
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('" + tmp + "', " + JSON_row.id + ", " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";
		}
		i++;
	}
	if (bgclr == "#dddddd")
		bgclr = "#eeeeee";
	else
		bgclr = "#dddddd";
	output_str = output_str + "<tr id=\"row" + i + "\" bgcolor='" + bgclr + "'>\n";
	output_str = output_str + "<td colspan='5'>&nbsp;<\/td>\n";
	output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddCategory(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	output_str = output_str + "<td colspan='3'>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("CategoriesTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
	
	if (rows[0] != "-no data-")
	{
		var LastMoveDown = "MoveDown" + (i - 1);
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
	}
}

///////////////////////////////////////////////////////////////////////////////////
function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	UpdateAll();
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

////////////////////////////////////////////////////////////////////////////////////////
function MoveItem(i)
{
	update_all = true;
	window.parent.SetWorkSavedNotSaved(false);
	
	var html = document.getElementById("CategoriesTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var t = i - 1;
	var b = i + 1;
	var srch_str_t;
	var srch_str_b;
	var srch_str_i;
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		srch_str_t = "<TR id=row" + t;
		srch_str_b = "<TR id=row" + b;
		srch_str_i = "<TR id=row" + i;
	}
	else
	{
		srch_str_t = "<tr id=\"row" + t + "\"";
		srch_str_b = "<tr id=\"row" + b + "\"";
		srch_str_i = "<tr id=\"row" + i + "\"";
	}
	
	// Get top part of table.
	var html_top = html.substring(0, html.indexOf(srch_str_t));
	
	// Get bottom part of table.
	var html_bottom = html.substring(html.indexOf(srch_str_b));
	
	// Get row to move down.
	var html_move_down = html.substring(html_top.length, html.indexOf(srch_str_i));
	
	// Get row to move up.
	var html_move_up = html.substring(html_top.length + html_move_down.length, html.indexOf(srch_str_b));
	
	var rplc_str;
	srch_str = "row" + t;
	rplc_str = "row" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "id" + t;
	rplc_str = "id" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "category" + t;
	rplc_str = "category" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "category_string" + t;
	rplc_str = "category_string" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "event_type" + t;
	rplc_str = "event_type" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "location_type" + t;
	rplc_str = "location_type" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "sort_order" + t;
	rplc_str = "sort_order" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "UpdateCategory(-1, " + t;
	rplc_str = "UpdateCategory(-1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "AddCategory(" + t;
	rplc_str = "AddCategory(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "DeleteConfirm('', -1, " + t;
	rplc_str = "DeleteConfirm('', -1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveUp" + t;
	rplc_str = "MoveUp" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveDown" + t;
	rplc_str = "MoveDown" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItem(" + t;
	rplc_str = "MoveItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItemDown(" + i;
	rplc_str = "MoveItemDown(" + b;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	
	var topclr = "#aaffaa";
	var botclr = "#ffaaaa";
	var bgclr1 = "#dddddd";
	var bgclr2 = "#eeeeee";
	html_move_up = html_move_up.replace(bgclr1,topclr);
	html_move_up = html_move_up.replace(bgclr2,topclr);
	html_move_down = html_move_down.replace(bgclr1,botclr);
	html_move_down = html_move_down.replace(bgclr2,botclr);
			
	html = html_top + html_move_up + html_move_down + html_bottom;
	
	var cnt_1 = cnt - 1;
	var cnt_2 = cnt - 2;
	LastMoveDown = "MoveDown" + cnt_1;
	NextToLastMoveDown = "MoveDown" + cnt_2;
	
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		// This next block of code is intenended to fix an id attribute issue with IE, but does not work.
		srch_str = "id=" + LastMoveDown;
		rplc_str = "id='" + LastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		srch_str = "id=" + NextToLastMoveDown;
		rplc_str = "id='" + NextToLastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		html = html.replace("id=MoveUp0","id=\"MoveUp0\"");
		html = html.replace("id=MoveUp1","id=\"MoveUp1\"");
		
		// Note the order in which the HTML is added to the element.
		document.getElementById("CategoriesTable").innerHTML = html;
		
		// Since the trick above for fixing the ids did not work, just update everthing now which will refresh the page.
		UpdateAll();
	}
	else
	{
		// Note the order in which the HTML is added to the element.
		document.getElementById("CategoriesTable").innerHTML = html;
		
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById(NextToLastMoveDown).style.display = "table-row";
		document.getElementById("MoveUp1").style.display = "table-row";
	}
}

function MoveItemDown(i)
{
	MoveItem(i);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function SetElementValue(el_id, el_id_2)
{
	var html = document.getElementById("CategoriesTable").innerHTML;

	if (el_id != -1)	{
		var val = document.getElementById(el_id).value;
		var srch = "id=\"" + el_id;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id;
			pos1 = html.indexOf(srch, 0);
		}
		srch = "value=";
		var pos2 = html.indexOf(srch, pos1);
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2);
		if (pos3 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		var pos4 = html.indexOf(srch, pos3 + 1);
		var html_start = html.substr(0, pos2);
		var html_end = html.substr(pos4 + 1);
		html = html_start + "value='" + val + "'" + html_end;
	}

	if (el_id_2 != -1)	{
		var val = document.getElementById(el_id_2).value;
		var srch = "id=\"" + el_id_2;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id_2;
			pos1 = html.indexOf(srch, 0);
		}
		// Get position of next id to compare in case nothing is selected.
		srch = "id=";
		var pos5 = html.indexOf(srch, pos1 + 1);
		// First remove selected option.
		srch = "selected="
		var pos2 = html.indexOf(srch, pos1);
		if ((pos2 < pos5) && (pos2 > -1))	{	// If not true, then nothing selected.
			var html_start = html.substr(0, pos2);
			var html_end = html.substr(pos2 + 19);
			html = html_start + html_end;
		}
		// Now go ahead and insert selected option.
		srch = "value=\"" + val;
		pos2 = html.indexOf(srch, pos1);
		if (pos2 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "value='" + val;
			pos2 = html.indexOf(srch, pos1);
		}
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2 + 7);
		if (pos3 == -1)	{
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		srch = ">"
		var pos4 = html.indexOf(srch, pos3);
		html_start = html.substr(0, pos3 + 1);
		html_end = html.substr(pos4);
		html = html_start + " selected='selected'" + html_end;
	}
	
	document.getElementById("CategoriesTable").innerHTML = html;

	curr_item_under_edit = "";
}

function SetElementVal(el_id)
{
	if (el_id == curr_item_under_edit)	{
		SetElementValue(el_id, -1);
	}
}

function SetCurrentItem(el_id)
{
	curr_item_under_edit = el_id;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}