////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/30/2018
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;
var nic_editor1;
var block_CheckSearchResults = false;

if ((browser == "Explorer") && (browser_version <= 7))
	var inherit = "";
else
	var inherit = "inherit";
	
var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var cur_year;
var cur_month;

var location_name = new Array();
var address = new Array();
var address2 = new Array();
var city = new Array();
var state = new Array();
var country = new Array();
var postal_code = new Array();
var country = new Array();
var phone = new Array();
var phone2 = new Array();
var fax = new Array();
var email = new Array();
var contact_first = new Array();
var contact_middle = new Array();
var contact_last = new Array();
var website = new Array();
var web_link_text = new Array();
var notes = new Array();
var location_categories = new Array();

var top_offset = -50;
var left_offset = -300;
var scroll_threshold = 200;

var close_edit_form = false;
	
//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#events_calender#edit_schedule", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else
		return false;
}

//////////////////////////////////////////////////////////////////////////////////////
function ShowHideRecurring(chk_ctl)
{
	if (chk_ctl.checked == true)	{
		document.getElementById("recurring_event_block").style.display = inherit;
		if (document.getElementById("event_end_date").value = "0000-00-00")
			document.getElementById("event_end_date").value = "";
	}
	else
		document.getElementById("recurring_event_block").style.display = "none";
}

//////////////////////////////////////////////////////////////////////////////////////////////
function SelectEvent(event_id)
{
	EditEvent();
	document.getElementById("event_id").value = event_id;
							
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_RETRIEVING_EVENT_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	document.getElementById("edit_table").style.display = "table";
	document.getElementById("select_event_row_1").style.display = "none";
	document.getElementById("select_event_row_2").style.display = "none";
	document.getElementById("select_event_row_3").style.display = "table-cell";
	document.getElementById("select_event_row_3").innerHTML = CALENDAR_EVENTS_EDIT_EVENT_MSG + ":";
	document.getElementById("filter_table").style.display = "none";
	document.getElementById("hr1").style.display = "none";
	
	if (!nic_editor1)
		nic_editor1 = new nicEditor({iconsPath : 'js/nicEditorIcons.gif', fullPanel : true}).panelInstance('event_description');
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_event.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "SelectEvent");

		params = "event_id=" + event_id;
		
		xmlhttp.send(params);
	}
	
	document.getElementById("save_btn").style.display = "block";
	document.getElementById("delete_btn").style.display = "block";
	document.getElementById("close_btn_div").style.right = "5px";
	document.getElementById("close_btn_div").style.top = "2px";
}

function SearchLocations(search_str, e)
{
	if (e === false)
		block_CheckSearchResults = false;
	else if ((e.keyCode != 9) && (e.keyCode != 13))
		block_CheckSearchResults = false;
//	alert("SearchLocations" + block_CheckSearchResults);
	
	if (search_str.length > 5)
	{
		var params = "";
			
		var xmlhttp;
		xmlhttp = getXmlHttpRequestObject();
		if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
		{
			xmlhttp.open("POST","search_locations.php",true);
			xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xmlhttp = UpdateMessage(xmlhttp, "SearchLocations");
	
			params = "search_str=" + search_str;
			params = params + "&filter_city_location_search=" + document.getElementById('filter_city_location_search').value;
			xmlhttp.send(params);
		}
	}
	else if (search_str.length == 1)
	{
//		alert(search_str);
		PopulateLocationCities("full_list");
		document.getElementById('filter_city_location_search').value = '-not selected-';
	}
}

function FilterLocationSearch()
{
	SearchLocations(document.getElementById('location_search').value, false);
}

function UpdateMessage(xmlhttp, source)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
				response = xmlhttp.responseText;
			else
				response = RECORD_NOT_FOUND;
				
			if (source == "SelectEvent")	{
				PopulateEvent(response);
				status_msg = CALENDAR_EVENTS_POPULATING_EVENT_COMPLETED_MSG;
			}
			else if (source == "GetLocation")	{
				PopulateLocation(response);
				status_msg = CALENDAR_EVENTS_POPULATING_LOCATION_COMPLETED_MSG;
			}
			else if (source == "SearchLocations")	{
				DisplayLocationSearchResults(response);
				status_msg = CALENDAR_EVENTS_SEARCH_LOCATION_COMPLETED_MSG;
			}
			else if (source == "GetLocationID")	{
				document.getElementById("location_id").value = response;
				status_msg = CALENDAR_EVENTS_GET_LOCATION_ID_COMPLETED_MSG;
			}
			else if (source == "SaveNewLocation")	{
				setTimeout("SaveEvent3(" + response + ");", 10);
				status_msg = CALENDAR_EVENTS_SAVE_NEW_LOCATION_COMPLETED_MSG;
			}
			else if (source == "SaveEvent3")	{
				if (close_edit_form)
					CloseEditForm();
				else
					setTimeout("SelectEvent(" + response + ");", 10);
				setTimeout("ChangeMonthYear(0, 0);", 500);
				status_msg = CALENDAR_EVENTS_SAVE_EVENT_COMPLETED_MSG;
			}
			else if (source == "GetLocationCities")	{
				PopulateLocationCities(response);
				status_msg = CALENDAR_EVENTS_LOCATION_CITY_LIST_UPDATED_MSG;
			}
			else if (source == "Filter")	{
				FilterEventsList(response);
				status_msg = CALENDAR_EVENTS_EVENTS_LIST_UPDATED_MSG;
			}
				
			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			status_msg = QUERY_READY_TO_SEND;
		else if (xmlhttp.readyState==2)
			status_msg = QUERY_SENT;
		else if (xmlhttp.readyState==3)
			status_msg = QUERYING;
		
		if ((source != "GetLocationID") && (source != "SearchLocations") && (source != "GetLocationCities"))	{
			popup_msg.status_msg = status_msg;
			popup_msg.ShowPopupMsg();
		}
	}
	return (xmlhttp);
}

function DisplayLocationSearchResults(locations)
{
	if (locations.indexOf("::") < 0)
		document.getElementById('search_result').innerHTML = response;
	else
	{
		var locations_arr = locations.split("::");
		var html = "<div class='search_results_popup'>\n";
		var hr = "";
		var location;
		for (var i = 0; i < locations_arr.length; i++)
		{
			location = locations_arr[i].replace("'", "\\'");
			location_display = locations_arr[i].replace("'", "&#39;");
			html = html + hr + "<div onclick=\"document.getElementById('search_result').innerHTML = '" + location + "'; GetLocationCitiesTimer('" + location + "');\">" + location_display + "</div>\n";
			hr = "<hr />";
		}
		html = html + "\n</div>";
		document.getElementById('search_result').innerHTML = html;
		block_CheckSearchResults = true;
//		alert("DisplayLocationSearchResults" + block_CheckSearchResults);
	}
}

function GetLocationCitiesTimer(location_name)
{
	document.getElementById("new_location_block").style.display = "none";
	if (location_name != "")	{
		location_name2 = location_name.replace("&#39;", "'");
		location_name2 = location_name2.replace("&amp;", "&");
		document.getElementById("location_search").value = location_name2;
	}
	location_name = location_name.replace("\\'", "SINGLEQUOTE");
	location_name = location_name.replace("'", "SINGLEQUOTE");
	location_name = location_name.replace("&", "AMPERSAND");
	mTimer = setTimeout("GetLocationCities('" + location_name + "');", 10);
}

function PopulateEvent(event_rcd)
{
	popup_msg.status_msg = CALENDAR_EVENTS_POPULATING_EVENT_MSG;
	popup_msg.ShowPopupMsg();
	
	var JSON_row = JSON.parse(event_rcd);
	
	var event_id = parseInt(JSON_row.event_id);
	var select_event_el = document.getElementById('select_event');
	var select_event_options = select_event_el.options;
	var select_event_arr = new Array();
	var category_id;
	for (var i = 0; i < select_event_options.length; i++)
		select_event_arr[i] = parseInt(select_event_options[i].value);
	if (select_event_arr.indexOf(event_id) < 0)
	{
		var opt = document.createElement("option");
		opt.text = JSON_row.event_name + " - " + JSON_row.event_start_date;
		opt.value = event_id;
		select_event_el.appendChild(opt);
		select_event_el.selectedIndex = select_event_el.options.length - 1;
	}
	else
		select_event_el.selectedIndex = select_event_arr.indexOf(event_id);
	document.getElementById("event_id").value = event_id;
	
	document.getElementById("group_id").value = JSON_row.group_id;
	if (JSON_row.group_id > 0)
		document.getElementById("delete_group_btn").style.display = "block";
	else
		document.getElementById("delete_group_btn").style.display = "none";
	
	document.getElementById("event_name").value = JSON_row.event_name;

	var checkboxes = document.getElementById('event_categories_cell').getElementsByTagName('input');
	for (i = 0; i < checkboxes.length; i++) {
		checkboxes[i].checked = false;
	}
	if ((JSON_row.event_categories != null) && (JSON_row.event_categories != ""))
	{
		var event_categories = JSON_row.event_categories.split(",");
		for (var z in event_categories)
		{
			category_id = event_categories[z] + "_event_cat";
			if (ElExists(category_id))
				document.getElementById(category_id).checked = true;
		}
	}
	document.getElementById("event_start_date").value = JSON_row.event_start_date;
	if (JSON_row.recurrence == 1)	{
		document.getElementById("recurrence").checked = true;
		document.getElementById("recurring_event_block").style.display = inherit;
	}
	else	{
		document.getElementById("recurrence").checked = false;
		document.getElementById("recurring_event_block").style.display = "none";
	}
	document.getElementById("event_end_date").value = JSON_row.event_end_date;
	
	//--------------------------------------------------------------------------------
	var recurrence_freq = JSON_row.recurrence_freq;
	document.getElementById("recurrence_freq").value = recurrence_freq;
	var result = ShowHideRecurrenceRows(recurrence_freq);
//	document.getElementById("recurrence_interval").value = JSON_row.recurrence_interval;
	document.getElementById("recurrence_byweekno").value = JSON_row.recurrence_byweekno;
		
	var recurrence_byday = JSON_row.recurrence_byday;
	if (recurrence_freq == "monthly")
		document.getElementById("recurrence_byday").value = recurrence_byday;
	else if (recurrence_freq == "weekly")
	{
		document.getElementById("recurrence_byday").value = "";
		var radios = document.getElementsByName("recurrence_bydays");
		for( i = 0; i < radios.length; i++ ) {
			if (i == 6)	// Compensate for Sunday being last in list, but first day of week.
				j = 0;
			else
				j = i+ 1;
			if (recurrence_byday.indexOf(j.toString()) > -1)
				radios[i].checked = true;
			else
				radios[i].checked = false;
		}
	}
	else
		document.getElementById("recurrence_byday").value = "";
	
	document.getElementById("recurrence_days").value = JSON_row.recurrence_days;
	//--------------------------------------------------------------------------------
	
	var start_time = JSON_row.event_start_time;
	var start_time_arr = start_time.split(":");
	if (parseInt(start_time_arr[0]) > 12)	{
		document.getElementById("event_start_time_hrs").value = (parseInt(start_time_arr[0]) - 12).toString();
		document.getElementById("event_start_time_ampm").value = "pm";
	}
	else if (parseInt(start_time_arr[0]) == 0)	{
		document.getElementById("event_start_time_hrs").value = "12";
		document.getElementById("event_start_time_ampm").value = "am";
	}
	else if (parseInt(start_time_arr[0]) == 12)	{
		document.getElementById("event_start_time_hrs").value = (parseInt(start_time_arr[0])).toString();
		document.getElementById("event_start_time_ampm").value = "pm";
	}
	else	{
		document.getElementById("event_start_time_hrs").value = (parseInt(start_time_arr[0])).toString();
		document.getElementById("event_start_time_ampm").value = "am";
	}
	document.getElementById("event_start_time_min").value = start_time_arr[1];
	
	var end_time = JSON_row.event_end_time;
	var end_time_arr = end_time.split(":");
	if (parseInt(end_time_arr[0]) > 12)	{
		document.getElementById("event_end_time_hrs").value = (parseInt(end_time_arr[0]) - 12).toString();
		document.getElementById("event_end_time_ampm").value = "pm";
	}
	else if (parseInt(end_time_arr[0]) == 0)	{
		document.getElementById("event_end_time_hrs").value = "12";
		document.getElementById("event_end_time_ampm").value = "am";
	}
	else if (parseInt(end_time_arr[0]) == 12)	{
		document.getElementById("event_end_time_hrs").value = (parseInt(end_time_arr[0])).toString();
		document.getElementById("event_end_time_ampm").value = "pm";
	}
	else	{
		document.getElementById("event_end_time_hrs").value = (parseInt(end_time_arr[0])).toString();
		document.getElementById("event_end_time_ampm").value = "am";
	}
	document.getElementById("event_end_time_min").value = end_time_arr[1];
	
	if (JSON_row.event_all_day == 1)
		document.getElementById("event_all_day").checked = true;
	else
		document.getElementById("event_all_day").checked = false;
	document.getElementById("location_id").value = JSON_row.location_id;
	document.getElementById("event_description").value = JSON_row.event_description;
	nicEditors.findEditor('event_description').setContent(JSON_row.event_description);
	document.getElementById("event_status").value = JSON_row.event_status;
	document.getElementById("event_owner").value = JSON_row.event_owner;
	
	if (JSON_row.event_active == 1)
		document.getElementById("event_active").checked = true;
	else
		document.getElementById("event_active").checked = false;
	
	if (JSON_row.event_private == 1)
		document.getElementById("event_private").checked = true;
	else
		document.getElementById("event_private").checked = false;
	
	if ((JSON_row.location_id) > 0)	{
		GetLocation(JSON_row.location_id);
		document.getElementById("new_location_block").style.display = "none";
	}
	else
	{
		document.getElementById("new_location_block").style.display = inherit;
		document.getElementById("location_location_name").value = "";
		document.getElementById("search_result").innerHTML = CALENDAR_EVENTS_LOCATION_NOT_FOUND;
		document.getElementById("location_search").value = "";
		document.getElementById("location_address").value = "";
		document.getElementById("location_address2").value = "";
		document.getElementById("city_select").selectedIndex = 0;
		document.getElementById("location_city").value = "";
		document.getElementById("state_select").selectedIndex = 0;
		document.getElementById("location_state").value = "";
		document.getElementById("country_select").selectedIndex = 0;
		document.getElementById("location_country").value = "";
		document.getElementById("location_postal_code").value = "";
	}
}

function GetLocation(location_id)
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_RETRIEVING_LOCATION_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_location.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "GetLocation");

		params = "location_id=" + location_id;
		xmlhttp.send(params);
	}
}

function PopulateLocation(location_rcd)
{
	popup_msg.status_msg = CALENDAR_EVENTS_POPULATING_LOCATION_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	
	var JSON_row = JSON.parse(location_rcd);
	document.getElementById("location_location_name").value = JSON_row.location_name;
	document.getElementById("search_result").innerHTML = JSON_row.location_name;
	var location_name = JSON_row.location_name;
	location_name = location_name.replace("&#39;", "'");
	location_name = location_name.replace("&amp;", "&");
	document.getElementById("location_search").value = location_name;
	document.getElementById("location_address").value = JSON_row.address;
	document.getElementById("location_address2").value = JSON_row.address2;
	document.getElementById("city_select").value = JSON_row.city;
	document.getElementById("location_city").value = JSON_row.city;
	document.getElementById("filter_city_location_search").value = JSON_row.city;
	document.getElementById("location_postal_code").value = JSON_row.postal_code;
}

function CheckSearchResults(source)
{
//	alert("CheckSearchResults: " + block_CheckSearchResults);
	if (block_CheckSearchResults !== true)
	{
		var location_name = document.getElementById('search_result').innerHTML;
	
		if ((location_name == "Location not found") || (location_name == "Record not found"))	{
			if (source != 'link')
				document.getElementById("new_location_block").style.display = inherit;
	//		document.getElementById("location_search").value = "";
			PopulateLocationCities("full_list");
		}
		else	{
			if (location_name.indexOf("::") < 0)	{
				document.getElementById("new_location_block").style.display = "none";
				if (location_name != "")	{
					location_name2 = location_name.replace("&#39;", "'");
					location_name2 = location_name2.replace("&amp;", "&");
					document.getElementById("location_search").value = location_name2;
				}
				if ((source == 'name') || (source == 'link'))
					GetLocationCities(location_name);
				else if (source == 'city')
				{
					var city = document.getElementById("filter_city_location_search").value;
					if ((location_name != "") && (city != "-not selected-"))	{
						var result = GetLocationID(location_name, city);
					}
				}
			}
		}
		if (source == 'link')
		{
			if (document.getElementById("new_location_block").style.display == "none")	{
				document.getElementById("new_location_block").style.display = inherit;
				document.getElementById("location_id").value = "";
			}
			else
				document.getElementById("new_location_block").style.display = "none";
		}
	}
}

function CheckSearchResultsAgain()
{
	var location_name = document.getElementById('search_result').innerHTML;
	var city = document.getElementById("filter_city_location_search").value;
	if ((location_name != "") && (city != "-not selected-") && (location_name != "Location not found") && (location_name != "Record not found"))	{
		var result = GetLocationID(location_name, city);
	}
}

function GetLocationCities(location_name)
{
	popup_msg.status_msg = CALENDAR_EVENTS_GETTING_LOCATION_CITIES_MSG;
	popup_msg.popup_timeout = 2000;
//	popup_msg.ShowPopupMsg();
	
	var params = "";
	
	location_name = location_name.replace("\\'", "SINGLEQUOTE");
	location_name = location_name.replace("'", "SINGLEQUOTE");
	location_name = location_name.replace("&", "AMPERSAND");
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_location_cities.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "GetLocationCities");
		
		params = "location_name=" + location_name;
		xmlhttp.send(params);
	}
}

function PopulateLocationCities(location_cities)
{
	popup_msg.status_msg = CALENDAR_EVENTS_UPDATING_LOCATION_CITIES_MSG;
	popup_msg.popup_timeout = 2000;
//	popup_msg.ShowPopupMsg();
	
	var sel = document.getElementById('filter_city_location_search');
	sel.options.length = 0;

	if ((location_cities == "full_list") || (location_cities == "-no data-"))
	{
		sel.options[sel.options.length] = new Option(CALENDAR_EVENTS_SELECT_CITY, '-not selected-');	
		for (var i = 0; i < cities.length; i++)
		{
			sel.options[sel.options.length] = new Option(cities[i], cities[i]);	
		}
	}
	else
	{
		var JSON_row = JSON.parse(location_cities);
		for (var i = 0; i < JSON_row.length; i++)
		{
			sel.options[sel.options.length] = new Option(JSON_row[i], JSON_row[i]);	
		}
	}
}

function MoveLocationName()
{
	if (document.getElementById("location_search").value != "")	{
		document.getElementById("location_location_name").value = document.getElementById("location_search").value;
		document.getElementById("location_search").value = "";
	}
}

//////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{
    document.getElementById("recurring_event_block").style.display = "none";
    document.getElementById("new_location_block").style.display = "none";
	document.getElementById("save_btn").style.display = "none";
	document.getElementById("delete_btn").style.display = "none";
	document.getElementById("delete_group_btn").style.display = "none";
	document.getElementById("cloak_div").style.display = "none";
	document.getElementById("edit_table").style.display = "none";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
function SaveEvent(bClose)
{
	if (!CheckFields())
		return;
		
	var categories = "";
	var comma = "";
	var el_name, category;
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_SAVING_EVENT_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	if (document.getElementById("event_start_time").value == "")
		BuildTimeStr('event_start_time_hrs', 'event_start_time_min', 'event_start_time_ampm', 'event_start_time');
	if (document.getElementById("event_end_time").value == "")
		BuildTimeStr('event_end_time_hrs', 'event_end_time_min', 'event_end_time_ampm', 'event_end_time');

	var checkboxes = document.getElementById('event_categories_cell').getElementsByTagName('input');
	for (var i = 0; i < checkboxes.length; i++) {
		if (checkboxes[i].checked == true)	{
			el_name = checkboxes[i].getAttribute("name");
			category = el_name.replace("_event_cat", "");
			categories = categories + comma + category;
			comma = ",";
		}
	}
	document.getElementById("event_categories").value = categories;
	
	if ((document.getElementById("search_result").innerHTML != "Location not found") && (document.getElementById("search_result").innerHTML != "Record not found"))	{
		var result = GetLocationID(document.getElementById("location_search").value, document.getElementById("filter_city_location_search").value);
		mTimer = setTimeout("SaveEvent2();", 500);
	}
	else
		SaveEvent2();
		
	close_edit_form = bClose;
}

function SaveEvent2()
{	
	if ((document.getElementById("location_location_name").value != "") && (document.getElementById("location_location_name").value != null) && (document.getElementById('location_id').value < 1))
		SaveNewLocation();
	else	{
		location_id = document.getElementById('location_id').value;
		SaveEvent3(location_id);
	}
}

function SaveEvent3(location_id)
{	
	if (location_id != "")
		document.getElementById('location_id').value = location_id;

	var params = "";	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_event.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "SaveEvent3");

		params = "event_id=" + document.getElementById("event_id").value;
		var event_name = document.getElementById("event_name").value
		event_name = event_name.replace(/\&/g, "AMPERSAND");
		params = params + "&event_name=" + event_name;
		params = params + "&event_categories=" + document.getElementById("event_categories").value;
		params = params + "&event_start_date=" + document.getElementById("event_start_date").value;
		if (document.getElementById("recurrence").checked == true)
			params = params + "&recurrence=1";
		else
			params = params + "&recurrence=0";
		params = params + "&event_end_date=" + document.getElementById("event_end_date").value;
		
		var recurrence_freq = document.getElementById("recurrence_freq").value;
		params = params + "&recurrence_freq=" + recurrence_freq;
//		params = params + "&recurrence_interval=" + document.getElementById("recurrence_interval").value;
		if (document.getElementById("recurrence_byweekno").value != "")
			params = params + "&recurrence_byweekno=" + document.getElementById("recurrence_byweekno").value;
		else
			params = params + "&recurrence_byweekno=0";
		var recurrence_byday = "";
		var delim = "";
		if (recurrence_freq == "monthly")
		{
			if (document.getElementById("recurrence_byday").value != "")	{
				recurrence_byday = document.getElementById("recurrence_byday").value;
				delim = ",";
			}
		}
		else if (recurrence_freq == "weekly")
		{
			var radios = document.getElementsByName("recurrence_bydays");
			for( i = 0; i < radios.length; i++ ) {
				if( radios[i].checked ) {
					recurrence_byday = recurrence_byday + delim + radios[i].value;
					delim = ",";
				}
			}
		}
		else
			recurrence_byday = "-1";
		params = params + "&recurrence_byday=" + recurrence_byday;
		if (document.getElementById("recurrence_days").value != "")
			params = params + "&recurrence_days=" + document.getElementById("recurrence_days").value;
		else
			params = params + "&recurrence_days=0";
		
		var event_start_time = "00:00:00";
		var event_end_time = "00:00:00";
		if (document.getElementById("event_start_time").value != "")
			event_start_time = document.getElementById("event_start_time").value;
		if (document.getElementById("event_end_time").value != "")
			event_end_time = document.getElementById("event_end_time").value;
		params = params + "&event_start_time=" + event_start_time;
		params = params + "&event_end_time=" + event_end_time;
		
		if (document.getElementById("event_all_day").checked == true)
			params = params + "&event_all_day=1";
		else
			params = params + "&event_all_day=0";
			
		var event_description = document.getElementById("event_description").value
		event_description = event_description.replace(/\&/g, "AMPERSAND");
		params = params + "&event_description=" + event_description;
		if (document.getElementById("event_status").value != "")
			params = params + "&event_status=" + document.getElementById("event_status").value;
		else
			params = params + "&event_status=0";
		params = params + "&event_owner=" + document.getElementById("event_owner").value;
		
		params = params + "&location_id=" + document.getElementById("location_id").value;
		
		if (document.getElementById("event_active").checked == true)
			params = params + "&event_active=1";
		else
			params = params + "&event_active=0";

		if (document.getElementById("event_private").checked == true)
			params = params + "&event_private=1";
		else
			params = params + "&event_private=0";

		xmlhttp.send(params);
	}
}

function GetLocationID(location_name, city)
{
	var params = "";
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_location_id.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "GetLocationID");
		
		location_name = location_name.replace(/\&/g, "AMPERSAND");
		params = "location_name=" + location_name;
		params = params + "&city=" + city;

		xmlhttp.send(params);
	}
	return(params);
}

function SaveNewLocation()
{
	var params = "";
	var comma = "";
	var category, el_name;
	var categories = "";

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_SAVING_NEW_LOCATION_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_new_location.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "SaveNewLocation");

		var location_name = document.getElementById("location_location_name").value
		location_name = location_name.replace(/\'/g, "&#39;");
		location_name = location_name.replace(/\&/g, "AMPERSAND");
		params = "location_name=" + location_name;
		params = params + "&address=" + document.getElementById("location_address").value;
		arams = params + "&address2=" + document.getElementById("location_address2").value;
		params = params + "&city=" + document.getElementById("location_city").value;
		params = params + "&state=" + document.getElementById("location_state").value;
		params = params + "&country=" + document.getElementById("location_country").value;
		params = params + "&postal_code=" + document.getElementById("location_postal_code").value;
		var checkboxes = document.getElementById('location_categories_cell').getElementsByTagName('input');
		for (var i = 0; i < checkboxes.length; i++) {
			if (checkboxes[i].checked == true)	{
				el_name = checkboxes[i].getAttribute("name");
				category = el_name.replace("_location_cat", "");
				categories = categories + comma + category;
				comma = ",";
			}
		}

		params = params + "&location_categories=" + categories;
		params = params + "&phone=" + document.getElementById("location_phone").value;
		params = params + "&website=" + document.getElementById("location_website").value;
		params = params + "&web_link_text=" + document.getElementById("location_web_link_text").value;
		params = params + "&email=" + document.getElementById("location_email").value;
		params = params + "&event_owner=" + document.getElementById("event_owner").value;

		xmlhttp.send(params);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function Filter()
{
	//document.getElementById("frmFilter").submit();
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_FILTERING_EVENTS_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","filter_events.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Filter");

		params = "filter_event_name=" + document.getElementById("filter_event_name").value;
		params = params + "&filter_city=" + document.getElementById("filter_city").value;
		params = params + "&filter_location=" + document.getElementById("filter_location").value;
		params = params + "&filter_date=" + document.getElementById("filter_date").value;
		if (document.getElementById("show_children").checked == true)
			params = params + "&show_children=1";
		else
			params = params + "&show_children=0";
		if (document.getElementById("show_pending").checked == true)
			params = params + "&show_pending=1";
		else
			params = params + "&show_pending=0";
		
		xmlhttp.send(params);
	}
}

function FilterEventsList(filtered_events)
{
//alert(filtered_events);
	var row_delim = "::::";
	var col_delim = ":::";
//	var query_delim = "|||||";
	
//	var query = filtered_events.split(query_delim);
//	filtered_events = query[0];
//	alert(query[1]);
	var filtered_events_rows = filtered_events.split(row_delim);
	var filtered_events_cols;
	var select_event_el = document.getElementById('select_event');
	select_event_el.options.length = 0;
	select_event_el.options[select_event_el.options.length] = new Option("-not selected-", "");
	var event_name;
	for (var i = 0; i < filtered_events_rows.length; i++)
	{
		filtered_events_cols = filtered_events_rows[i].split(col_delim);
		if (filtered_events_cols != "Record not found")	{
			if (filtered_events_cols[1] != null)	{
				event_name = filtered_events_cols[1].replace("&#39;", "'");
				event_name = event_name.replace("\\", "");
			}
			else
				event_name = "";
			select_event_el.options[select_event_el.options.length] = new Option(event_name + " - " + filtered_events_cols[2], filtered_events_cols[0]);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(delete_type, event_id, event_name)
{
	if (event_id == '-from edit form-')	{
		event_id = document.getElementById("select_event").value;
		event_name = document.getElementById("event_name").value;
	}

	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	if (delete_type == 'group')
		popup_msg.popup_msg_cell = CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_1_MSG + " <b>" + event_name + "</b> " + CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_2_MSG;
	else
		popup_msg.popup_msg_cell = CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_1_MSG + " <b>" + event_name + "</b> " + CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteEvent(delete_type, event_id); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	popup_msg.popup_timeout = -1;
}

function DeleteEvent(delete_type, event_id)
{
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_DELETING_EVENT_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	popup_msg.HidePopupMsg();
//	var groupstr = "";
	var group_id = -1;
	if (delete_type == "group")
//		groupstr = "&group_id=" + document.getElementById("group_id").value;
		group_id = document.getElementById("group_id").value;
//	var url = "delete_event.php?event_id=" + event_id + groupstr + "&filter_city=" + filter_city + "&filter_event_name=" + filter_event_name + "&filter_location=" + filter_location;
//	window.location = url;
	
	$.post( "delete_event.php", { event_id: event_id, group_id: group_id  } ).done(function( data ) { CompleteDeleteEvent(data); } ) ;
}
function CompleteDeleteEvent(data)
{
	popup_msg.popup_msg_type = 1;
	if (data == 1)
		popup_msg.status_msg = CALENDAR_EVENTS_EVENT_DELETED_MSG;
	else
		popup_msg.status_msg = CALENDAR_EVENTS_COULD_NOT_DELETE_EVENT_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	LoadCalender(cur_year, cur_month);
}

function CreateEvent(event_start_date)
{
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_CLEARING_FORM_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	document.getElementById("cloak_div").style.display = "block";
	document.getElementById("frmEvent").reset();
	document.getElementById("event_id").value = -1;
	document.getElementById("new_location_block").style.display = "none";
	document.getElementById("location_search").value = "";
	document.getElementById("search_result").innerHTML = CALENDAR_EVENTS_LOCATION_NOT_FOUND;
	document.getElementById("event_status").value = 0;
	document.getElementById("event_active").checked = true;
	document.getElementById("event_private").checked = false;
	document.getElementById("location_id").value = "";
	
	document.getElementById("select_event_row_1").style.display = "none";
	document.getElementById("select_event_row_2").style.display = "none";
	document.getElementById("select_event_row_3").style.display = "table-cell";
	document.getElementById("select_event_row_3").innerHTML = CALENDAR_EVENTS_CREATE_NEW_EVENT + ":";
	document.getElementById("filter_table").style.display = "none";
	document.getElementById("save_btn").style.display = "block";
	document.getElementById("delete_btn").style.display = "none";
	document.getElementById("delete_group_btn").style.display = "none";
	document.getElementById("hr1").style.display = "none";
	document.getElementById("edit_table").style.display = "table";
	document.getElementById("close_btn_div").style.right = "5px";
	document.getElementById("close_btn_div").style.top = "2px";
	document.getElementById("search_btn_div").style.display = "none";

	if (event_start_date != "-not set-")
		document.getElementById("event_start_date").value = event_start_date;

	if (!nic_editor1)
		nic_editor1 = new nicEditor({iconsPath : 'js/nicEditorIcons.gif', fullPanel : true}).panelInstance('event_description');
	else
		nicEditors.findEditor('event_description').setContent("");
		
	PopulateLocationCities("full_list");
	
	if ((window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0) > scroll_threshold)
		AnimateScroll();
}

function EditEvent()
{
	document.getElementById("cloak_div").style.display = "block";
	document.getElementById("frmEvent").reset();
	document.getElementById("new_location_block").style.display = "none";
	document.getElementById("location_search").value = "";
	document.getElementById("search_result").innerHTML = CALENDAR_EVENTS_LOCATION_NOT_FOUND;
	document.getElementById("event_status").value = 0;
	
	document.getElementById("select_event_row_1").style.display = inherit;
	document.getElementById("select_event_row_2").style.display = inherit;
	document.getElementById("select_event_row_3").style.display = "none";
	document.getElementById("filter_table").style.display = "table";
	document.getElementById("save_btn").style.display = "block";
	document.getElementById("delete_btn").style.display = "block";
	document.getElementById("hr1").style.display = inherit;
	document.getElementById("edit_table").style.display = "none";
	
	document.getElementById("close_btn_div").style.right = "5px";
	document.getElementById("close_btn_div").style.top = "100px";
	document.getElementById("search_btn_div").style.display = "none";
	
	if ((window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0) > scroll_threshold)
		AnimateScroll();
}

var bottom;
var from_height;
var step;
var to_height;
var code = "AnimateScroll();";
	
function AnimateScroll()
{
	if (to_height > 0)
	{
		to_height = to_height - step;
		window.scrollTo(from_height, to_height);
		setTimeout(code, 10);
		from_height = to_height;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function BuildTimeStr(hrs_ctl_str, min_ctl_str, ampm_ctl_str, time_ctl_str)
{
	var hrs_ctl = document.getElementById(hrs_ctl_str);
	var min_ctl = document.getElementById(min_ctl_str);
	var ampm_ctl = document.getElementById(ampm_ctl_str);
	var time_ctl = document.getElementById(time_ctl_str);
	
	var hrs = parseInt(hrs_ctl.value, 10);
	var minutes = min_ctl.value;
	var ampm = ampm_ctl.value;
	var hrs_str = "";
	if ((ampm == "pm") && (hrs < 12))	{
		hrs = hrs + 12;
		hrs_str = hrs.toString();
	}
	else if (hrs < 10)
		hrs_str = "0" + hrs.toString();
	else if ((hrs == 12) && (ampm == "am"))
		hrs_str = "00";
	else
		hrs_str = hrs.toString();
	
	var time_str = hrs_str + ":" + minutes + ":00";
	time_ctl.value = time_str;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
function ShowHideRecurrenceRows(recurrence_freq)
{
	document.getElementById("recurrence_weekly_row").style.display = "none";
	document.getElementById("recurrence_monthly_row").style.display = "none";
	document.getElementById("recurrence_yearly_row").style.display = "none";
//	if (recurrence_freq == "daily")
//		document.getElementById("recurrence_units").innerHTML = "day(s)"
//	else if (recurrence_freq == "weekly")	{
	if (recurrence_freq == "weekly")	{
		document.getElementById("recurrence_weekly_row").style.display = "table-row";
//		document.getElementById("recurrence_units").innerHTML = "week on"
	}
	else if (recurrence_freq == "monthly")	{
		document.getElementById("recurrence_monthly_row").style.display = inherit;
//		document.getElementById("recurrence_units").innerHTML = "month on the"
	}
	else if (recurrence_freq == "yearly")	{
		document.getElementById("recurrence_yearly_row").style.display = inherit;
//		document.getElementById("recurrence_units").innerHTML = "year"
	}
	
	return (true);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
function CheckFields()
{
	if (document.getElementById("event_name").value == "")	{
		alert(CALENDAR_EVENTS_ENTER_NAME_MSG);
		return false;
	}
	if (document.getElementById("event_start_date").value == "")	{
		alert(CALENDAR_EVENTS_ENTER_START_DATE_MSG);
		return false;
	}
	if ((document.getElementById("recurrence").checked == true) && (document.getElementById("event_end_date").value == ""))	{
			alert(CALENDAR_EVENTS_PLEASE_ENTER_AN_END_DATE_MSG);
			return false;
	}
//	if (nicEditors.findEditor('event_description').getContent() == "")	{
//		alert(CALENDAR_EVENTS_PLEASE_ENTER_DESCRIPTION_MSG);
//		return false;
//	}
//	else
		document.getElementById("event_description").value = nicEditors.findEditor('event_description').getContent();
	
	if (((document.getElementById("location_id").value == "") || (document.getElementById("location_id").value == -1)) && (document.getElementById("location_name").value == ""))
	{
		alert(CALENDAR_EVENTS_PLEASE_ENTER_LOCATION_MSG)
		return false;
	}
	
	if (((document.getElementById("location_id").value == "") || (document.getElementById("location_id").value == -1)) && (document.getElementById("location_location_name").value != ""))
	{
		if (document.getElementById("location_address").value == "")	{
			alert(CALENDAR_EVENTS_PLEASE_ENTER_ADDRESS_MSG);
			return false;
		}
		if ((document.getElementById("location_city").value == "-not selected-") || (document.getElementById("location_city").value == ""))	{
			alert(CALENDAR_EVENTS_PLEASE_SELECT_CITY_MSG);
			return false;
		}
		if (document.getElementById("location_postal_code").value == "")	{
			alert(CALENDAR_EVENTS_PLEASE_ENTER_ZIP_MSG);
			return false;
		}
	}
	
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function daysInMonth (month, year) {
	// 0 = January, 11 = December
	month++;
	// 1 = January, 12 = December, 0 returns 31
    return new Date(year, month, 0).getDate();
}

function getMonthName(month_num)
{
	var month = new Array();
	month[0] = "January";
	month[1] = "February";
	month[2] = "March";
	month[3] = "April";
	month[4] = "May";
	month[5] = "June";
	month[6] = "July";
	month[7] = "August";
	month[8] = "September";
	month[9] = "October";
	month[10] = "November";
	month[11] = "December";
	return(month[month_num]);
}

function LoadCalender(year, month)
{
	cur_year = year;
	cur_month = month;
	
	var d = new Date(year, month, 1, 0,0,0,0);
	var n = d.getDay();
	var days_in_mth = daysInMonth(month, year);
	var today = new Date();
	var month_num = today.getMonth() + 1;
	var month_str, day_str;
	if (month_num < 10)
		month_str = "0" + month_num;
	else
		month_str = month_num;
	var day_num = today.getDate();
	if (day_num < 10)
		day_str = "0" + day_num;
	else
		day_str = day_num;
	var today_str = today.getFullYear() + "-" + month_str + "-" + day_str;
	
	document.getElementById("head_month_name").innerHTML = getMonthName(month);
	document.getElementById("head_year").innerHTML = year;
	
	var j = 1;
	var last_cell = 41;
	var day_id_str, sq_id_str, event_id_str;
	var date_str, html;
	var pre_month_num, pre_year, pre_days_in_mth, pre_day, post_day;
	for (var i = 0; i < 42; i++)
	{
		day_id_str = "day_" + i;
		sq_id_str = "sq_" + i;
		event_id_str = "event_" + i;
		if ((i >= n) && (j <= days_in_mth))	{
			document.getElementById(day_id_str).innerHTML = j;
			document.getElementById(sq_id_str).className = "calendar_td available";
			
			month_num = month + 1;
			if (month_num < 10)
				month_str = "0" + month_num;
			else
				month_str = month_num;
			if (j < 10)
				date_str = year + "-" + month_str + "-" + "0" + j;
			else
				date_str = year + "-" + month_str + "-" + j;

			if (date_str == today_str)	{
				document.getElementById(sq_id_str).className = document.getElementById(sq_id_str).className + " calendar_curr_day";
				document.getElementById(sq_id_str).className = document.getElementById(sq_id_str).className.replace("available", "");
			}
			
			html = "<div class='add_event_btn_div'><img src='../../theme/" + theme + "/images/plus.png' class='add_event_btn' onClick=\"CreateEvent('" + date_str + "');\" alt='" + ADD_WORD + "' /></div>\n";
			document.getElementById(event_id_str).innerHTML = html;
			
			j++;
			last_cell = i;
		}
		else if (i < n)	{
			pre_month_num = month - 1;
			if (pre_month_num < 0)	{
				pre_month_num = 11;
				pre_year = year - 1;
			}
			else
				pre_year = year;
			pre_days_in_mth = daysInMonth(pre_month_num, pre_year);
			pre_day = pre_days_in_mth - n + i + 1;
		
			document.getElementById(day_id_str).innerHTML = pre_day;
			document.getElementById(sq_id_str).className = "calendar_td";
			document.getElementById(event_id_str).innerHTML = "";
		}
		else if (j > days_in_mth)	{
			post_day = i - days_in_mth - n + 1;
		
			document.getElementById(day_id_str).innerHTML = post_day;
			document.getElementById(sq_id_str).className = "calendar_td";
			document.getElementById(event_id_str).innerHTML = "";
		}
	}
	
	if (last_cell < 35)
		document.getElementById("overflow_row").style.display = "none";
	else
		document.getElementById("overflow_row").style.display = "table-row";
		
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: 1, return_part: "month" } ).done(function( data ) { LoadCalender2(data, year, month, days_in_mth, n); } ) ;
	
	LoadCalendarEvents(year, month, n);
}

function LoadCalender2(data, year, month, days_in_mth, n)
{
	var jc_month_string = data;
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: days_in_mth, return_part: "month" } ).done(function( data ) { LoadCalender3(data, year, month, days_in_mth, n, jc_month_string); } ) ;
}

function LoadCalender3(data, year, month, days_in_mth, n, jc_month_string)
{
	var jc_month_string_2 = data;
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: 1, return_part: "year" } ).done(function( data ) { LoadCalender4(data, year, month, days_in_mth, n, jc_month_string, jc_month_string_2); } ) ;
}

function LoadCalender4(data, year, month, days_in_mth, n, jc_month_string, jc_month_string_2)
{
	var jc_year = data;
	if (jc_month_string != jc_month_string_2)
		document.getElementById("head_jc_month_names").innerHTML = jc_month_string + " - " + jc_month_string_2;
	else
		document.getElementById("head_jc_month_names").innerHTML = jc_month_string;
	document.getElementById("head_jc_year").innerHTML = jc_year;
	
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: 1, return_part: "month" } ).done(function( data ) { LoadCalenderDay(data, year, month, 1, days_in_mth, n); } ) ;
}

function LoadCalenderDay(data, year, month, day, days_in_mth, n)
{
	var jc_month_string = data;
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "day" } ).done(function( data ) { LoadCalenderDay2(data, year, month, day, days_in_mth, n, jc_month_string); } ) ;
}

function LoadCalenderDay2(data, year, month, day, days_in_mth, n, jc_month_string)
{
	var jc_day = data;
	var jc_date_str = jc_day + " " + jc_month_string;
	var i = parseInt(day) + parseInt(n) - 1;
	var hebrew_day_id_str = "hebrew_day_" + i;
	document.getElementById(hebrew_day_id_str).innerHTML = jc_date_str;
	
	day++;
	if (day <= days_in_mth)
		$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "month" } ).done(function( data ) { LoadCalenderDay(data, year, month, day, days_in_mth, n); } ) ;
	else if (n > 1)	{
		month = month - 1;
		if (month < 0)	{
			month = 11;
			year = year - 1;
		}
		days_in_mth = daysInMonth(month, year);
		day = days_in_mth - n + 1;
		$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "month" } ).done(function( data ) { LoadCalenderDayPre(data, year, month, day, days_in_mth, n, 0); } ) ;
	}
}

function LoadCalenderDayPre(data, year, month, day, days_in_mth, n, j)
{
	var jc_month_string = data;
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "day" } ).done(function( data ) { LoadCalenderDayPre2(data, year, month, day, days_in_mth, n, j, jc_month_string); } ) ;
}

function LoadCalenderDayPre2(data, year, month, day, days_in_mth, n, j, jc_month_string)
{
	var jc_day = data;
	var jc_date_str = jc_day + " " + jc_month_string;
	var hebrew_day_id_str = "hebrew_day_" + j;
	document.getElementById(hebrew_day_id_str).innerHTML = jc_date_str;
	
	j++;
	day++;
	if (j < n)
		$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "month" } ).done(function( data ) { LoadCalenderDayPre(data, year, month, day, days_in_mth, n, j); } ) ;
	else	{
		month = month + 1;
		if (month > 11)	{
			month = 0;
			year = year + 1;
		}
		days_in_mth = daysInMonth(month, year);
		if (days_in_mth + n < 41)
		{
			month = month + 1;
			if (month > 12)	{
				month = 1;
				year = year + 1;
			}
			j = days_in_mth + n;
			$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: 1, return_part: "month" } ).done(function( data ) { LoadCalenderDayPost(data, year, month, 1, j); } ) ;
		}
	}
}

function LoadCalenderDayPost(data, year, month, day, j)
{
	var jc_month_string = data;
	$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "day" } ).done(function( data ) { LoadCalenderDayPost2(data, year, month, day, j, jc_month_string); } ) ;
}

function LoadCalenderDayPost2(data, year, month, day, j, jc_month_string)
{
	var jc_day = data;
	var jc_date_str = jc_day + " " + jc_month_string;
	var hebrew_day_id_str = "hebrew_day_" + j;
	document.getElementById(hebrew_day_id_str).innerHTML = jc_date_str;
	
	j++;
	day++;
	if (j < 42)
		$.post( "get_hebrew_date.php", { year: year, month: month + 1, day: day, return_part: "month" } ).done(function( data ) { LoadCalenderDayPost(data, year, month, day, j); } ) ;
}

function LoadCalendarEvents(year, month, n)
{
	$.post( "get_events.php", { year: year, month: month + 1 } ).done(function( data ) { CompleteLoadCalenderEvents(data, year, month, n); } ) ;
}

function CompleteLoadCalenderEvents(data, year, month, n)
{
	var	event_id_str = "";
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")	{
		popup_msg.status_msg = CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG;
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 2;
		popup_msg.popup_timeout = 2000;
		popup_msg.ShowPopupMsg();
	}
	else	{
		var event_start_date, day, cell, event_start_time, event_end_time, start_time_arr, end_time_arr, start_am_pm, end_am_pm, html, last_day;
		var event_name, event_description, URL, target;
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			event_start_date = JSON_row.event_start_date;
			day = parseInt(event_start_date.substr(event_start_date.length - 2));
			cell = day + n - 1;
			
			if (!JSON_row.event_name)
				event_name = "";
			else
				event_name = JSON_row.event_name.replace("'", "&#39;");
			if (!JSON_row.event_description)
				event_description = "";
			else
				event_description = JSON_row.event_description.replace("'", "&#39;");
			if (!JSON_row.URL)
				URL = "";
			else
				URL = JSON_row.URL;
			if (!JSON_row.target)
				target = "";
			else
				target = JSON_row.target;
				
			location_name[i] = JSON_row.location_name;
			if ((JSON_row.location_name != null) && (JSON_row.location_name != ""))	{
				location_name[i] = JSON_row.location_name;
				address[i] = JSON_row.address;
				address2[i] = JSON_row.address2;
				city[i] = JSON_row.city;
				state[i] = JSON_row.state;
				country[i] = JSON_row.country;
				postal_code[i] = JSON_row.postal_code;
				country[i] = JSON_row.country;
				phone[i] = JSON_row.phone;
				phone2[i] = JSON_row.phone2;
				fax[i] = JSON_row.fax;
				email[i] = JSON_row.email;
				contact_first[i] = JSON_row.contact_first;
				contact_middle[i] = JSON_row.contact_middle;
				contact_last[i] = JSON_row.contact_last;
				website[i] = JSON_row.website;
				web_link_text[i] = JSON_row.web_link_text;
				notes[i] = JSON_row.notes;
				if ((JSON_row.location_categories != null) && (JSON_row.location_categories != ""))
				{
					var location_category = new Array();
					location_category = JSON_row.location_categories.split(",");
					for (var z in location_category)
					{
						location_category[z] = location_category[z].replace(/_-/g, " ");
						location_category[z] = location_category[z].charAt(0).toUpperCase() + location_category[z].slice(1);
					}
					var location_categories_str = location_category.join(", ");
					location_categories[i] = location_categories_str;
				}
				else
					location_categories[i] = "";
			}

			start_time_arr = JSON_row.event_start_time.split(":");
			if (parseInt(start_time_arr[0]) > 12)	{
				start_time_arr[0] = parseInt(start_time_arr[0]) - 12;
				start_am_pm = " pm";
			}
			else	{
				start_time_arr[0] = parseInt(start_time_arr[0]);
				if (parseInt(start_time_arr[0]) == 12)
					start_am_pm = " pm";
				else if (parseInt(start_time_arr[0]) == 0)	{
					start_am_pm = " am";
					start_time_arr[0] = "12";
				}
				else
					start_am_pm = " am";
			}
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			end_time_arr = JSON_row.event_end_time.split(":");
			if (parseInt(end_time_arr[0]) > 12)	{
				end_time_arr[0] = parseInt(end_time_arr[0]) - 12;
				end_am_pm = " pm";
			}
			else	{
				end_time_arr[0] = parseInt(end_time_arr[0]);
				if (parseInt(end_time_arr[0]) == 12)
					end_am_pm = " pm";
				else if (parseInt(end_time_arr[0]) == 0)	{
					end_am_pm = " am";
					end_time_arr[0] = "12";
				}
				else
					end_am_pm = " am";
			}
			if (start_am_pm == end_am_pm)
				start_am_pm = "";
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			if (JSON_row.event_end_time != "")
				event_end_time = " - " + end_time_arr[0] + ":" + end_time_arr[1] + end_am_pm;
			else
				event_end_time = "";
			
			event_id_str = "event_" + cell;
			if (day == last_day)
				html = document.getElementById(event_id_str).innerHTML + "\n<hr class='event_divider' />\n";
			else
				html = "";
			html = html + "<div style='cursor:pointer;' onClick='SelectEvent(" + JSON_row.event_id + ");'>\n";
			html = html + "<div class='edit_event_btn_div'><img src='../../theme/" + theme + "/images/edit.png' class='edit_event_btn' alt='" + EDIT_WORD + "' /></div>\n";
			
			html = html + "<div class='calendar_event_name'>" + event_name + "</div>";
			if ((event_description != "") && (event_description != "<br>") && (event_description != "\n<br>\n") && (event_description != "<br>\n"))
				html = html + "<div class='calendar_event_description'>" + event_description + "</div>";
			html = html + "<div class='start_end_time'>" + event_start_time + event_end_time + "</div>\n";
			html = html + "</div>\n";
			
			if ((URL[i] != null) && (URL[i] != ""))
				html = html + "<div class='event_url'><a href='" + URL + "' target='_blank'>" + URL + "</a></div>\n";
			
			event_name = event_name.replace("&#39;", "");
			html = html + "<div class='delete_event_btn_div'><img src='../../theme/" + theme + "/images/delete.png' class='delete_event_btn' onclick=\"DeleteConfirm('single', " + JSON_row.event_id + ", '" + event_name + "');\" alt='" + EDITOR_DELETE + "' /></div>\n";
			
			html = html + "<div class='copy_event_btn_div'><img src='../../theme/" + theme + "/images/icon_Copy_Pg_mo.png' class='copy_event_btn' onclick=\"CopyEvent(" + JSON_row.event_id + ");\" alt='" + COPY_WORD + "' /></div>\n";

			if ((location_name[i] != null) && (location_name[i] != ""))
				html = html + "<div class='location_link' onclick='ShowLocationInfo(" + i + ");'>Location</div>\n";
			else
				html = html + "<br />\n";
			
			if (html.indexOf("CreateEvent") < 0)
				html = html + "<div class='add_event_btn_div'><img src='../../theme/" + theme + "/images/plus.png' class='add_event_btn' onClick=\"CreateEvent('" + event_start_date + "');\" alt='" + ADD_WORD + "' /></div>\n";
			document.getElementById(event_id_str).innerHTML = html;
			
			last_day = day;
		}
	}
	LoadPreCalendarEvents(year, month, n);
}

function LoadPreCalendarEvents(year, month, n)
{
	month = month - 1;
	if (month < 0)	{
		month = 11;
		year = year - 1;
	}
	var days_in_mth = daysInMonth(month, year);
	var start_day = days_in_mth - n;
	$.post( "get_events.php", { year: year, month: month + 1, start_day: start_day, end_day: days_in_mth  } ).done(function( data ) { CompleteLoadPreCalenderEvents(data, year, month, n, start_day, days_in_mth); } ) ;
}

function CompleteLoadPreCalenderEvents(data, year, month, n, start_day, end_day)
{
	var event_id_str = "";
	
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")	{
		popup_msg.status_msg = CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG;
//		popup_msg.top_offset = 100;
//		popup_msg.left_offset = 320;
//		popup_msg.popup_msg_type = 2;
//		popup_msg.popup_timeout = 2000;
//		popup_msg.ShowPopupMsg();
	}
	else	{
		var event_start_date, day, cell, event_start_time, event_end_time, start_time_arr, end_time_arr, start_am_pm, end_am_pm, html, last_day;
		var event_name, event_description, URL, target;
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			event_start_date = JSON_row.event_start_date;
			day = parseInt(event_start_date.substr(event_start_date.length - 2));
			cell = n - (end_day - day) - 1;
			
			if (!JSON_row.event_name)
				event_name = "";
			else
				event_name = JSON_row.event_name;
			if (!JSON_row.event_description)
				event_description = "";
			else
				event_description = JSON_row.event_description;
			if (!JSON_row.URL)
				URL = "";
			else
				URL = JSON_row.URL;
			if (!JSON_row.target)
				target = "";
			else
				target = JSON_row.target;
				
			location_name[parseInt(i) + 1000000] = JSON_row.location_name;
			if ((JSON_row.location_name != null) && (JSON_row.location_name != ""))	{
				location_name[parseInt(i) + 1000000] = JSON_row.location_name;
				address[parseInt(i) + 1000000] = JSON_row.address;
				address2[parseInt(i) + 1000000] = JSON_row.address2;
				city[parseInt(i) + 1000000] = JSON_row.city;
				state[parseInt(i) + 1000000] = JSON_row.state;
				country[parseInt(i) + 1000000] = JSON_row.country;
				postal_code[parseInt(i) + 1000000] = JSON_row.postal_code;
				country[parseInt(i) + 1000000] = JSON_row.country;
				phone[parseInt(i) + 1000000] = JSON_row.phone;
				phone2[parseInt(i) + 1000000] = JSON_row.phone2;
				fax[parseInt(i) + 1000000] = JSON_row.fax;
				email[parseInt(i) + 1000000] = JSON_row.email;
				contact_first[parseInt(i) + 1000000] = JSON_row.contact_first;
				contact_middle[parseInt(i) + 1000000] = JSON_row.contact_middle;
				contact_last[parseInt(i) + 1000000] = JSON_row.contact_last;
				website[parseInt(i) + 1000000] = JSON_row.website;
				web_link_text[parseInt(i) + 1000000] = JSON_row.web_link_text;
				notes[parseInt(i) + 1000000] = JSON_row.notes;

				if ((JSON_row.location_categories != null) && (JSON_row.location_categories != ""))
				{
					var location_category = new Array();
					location_category = JSON_row.location_categories.split(",");
					for (var z in location_category)
					{
						location_category[z] = location_category[z].replace(/_-/g, " ");
						location_category[z] = location_category[z].charAt(0).toUpperCase() + location_category[z].slice(1);
					}
					var location_categories_str = location_category.join(", ");
					location_categories[parseInt(i) + 1000000] = location_categories_str;
				}
				else
					location_categories[parseInt(i) + 1000000] = "";
			}

			start_time_arr = JSON_row.event_start_time.split(":");
			if (parseInt(start_time_arr[0]) > 12)	{
				start_time_arr[0] = parseInt(start_time_arr[0]) - 12;
				start_am_pm = " pm";
			}
			else	{
				start_time_arr[0] = parseInt(start_time_arr[0]);
				if (parseInt(start_time_arr[0]) == 12)
					start_am_pm = " pm";
				else
					start_am_pm = " am";
			}
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			end_time_arr = JSON_row.event_end_time.split(":");
			if (parseInt(end_time_arr[0]) > 12)	{
				end_time_arr[0] = parseInt(end_time_arr[0]) - 12;
				end_am_pm = " pm";
			}
			else	{
				end_time_arr[0] = parseInt(end_time_arr[0]);
				if (parseInt(end_time_arr[0]) == 12)
					end_am_pm = " pm";
				else
					end_am_pm = " am";
			}
			if (start_am_pm == end_am_pm)
				start_am_pm = "";
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			if (JSON_row.event_end_time != "")
				event_end_time = " - " + end_time_arr[0] + ":" + end_time_arr[1] + end_am_pm;
			else
				event_end_time = "";

			event_id_str = "event_" + cell;
			if (day == last_day)
				html = document.getElementById(event_id_str).innerHTML + "\n<hr class='event_divider' />\n";
			else
				html = "";
				
			html = html + "<div style='cursor:pointer;' onClick='SelectEvent(" + JSON_row.event_id + ");'><div class='calendar_event_name'>" + event_name + "</div>";
			if ((event_description != "") && (event_description != "<br>") && (event_description != "\n<br>\n") && (event_description != "<br>\n"))
				html = html + "<div class='calendar_event_description'>" + event_description + "</div>";
			html = html + "<div class='start_end_time'>" + event_start_time + event_end_time + "</div></div>\n";
			
			if ((URL[i] != null) && (URL[i] != ""))
				html = html + "<div class='event_url'><a href='" + URL + "' target='_blank'>" + URL + "</a></div>\n";
			if ((location_name[parseInt(i) + 1000000] != null) && (location_name[parseInt(i) + 1000000] != ""))
				html = html + "<div class='location_link' onclick=\"ShowLocationInfo(" + (parseInt(i) + 1000000).toString() + ");\">Location</div>\n";
			else
				html = html + "<br />\n";
			if (ElExists(event_id_str))
				document.getElementById(event_id_str).innerHTML = html;
			
			last_day = day;
		}
	}
	
	LoadPostCalendarEvents(year, month, n);
}

function LoadPostCalendarEvents(year, month, n)
{
	month = month + 1;
	if (month > 11)	{
		month = 0;
		year = year + 1;
	}
	var days_in_mth = daysInMonth(month, year);
	month = month + 1;
	if (month > 11)	{
		month = 0;
		year = year + 1;
	}
	var end_day = 42 - days_in_mth - n;
	$.post( "get_events.php", { year: year, month: month + 1, start_day: 1, end_day: end_day  } ).done(function( data ) { CompleteLoadPostCalenderEvents(data, year, month, n, 1, end_day, days_in_mth); } ) ;
}

function CompleteLoadPostCalenderEvents(data, year, month, n, start_day, end_day, days_in_mth)
{
	var event_id_str = "";
	
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")	{
		popup_msg.status_msg = CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG;
//		popup_msg.top_offset = 100;
//		popup_msg.left_offset = 320;
//		popup_msg.popup_msg_type = 2;
//		popup_msg.popup_timeout = 2000;
//		popup_msg.ShowPopupMsg();
	}
	else	{
		var event_start_date, day, cell, event_start_time, event_end_time, start_time_arr, end_time_arr, start_am_pm, end_am_pm, html, last_day;
		var event_name, event_description, URL, target;
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			event_start_date = JSON_row.event_start_date;
			day = parseInt(event_start_date.substr(event_start_date.length - 2));
			cell = n + days_in_mth + day - 1;
			
			if (!JSON_row.event_name)
				event_name = "";
			else
				event_name = JSON_row.event_name;
			if (!JSON_row.event_description)
				event_description = "";
			else
				event_description = JSON_row.event_description;
			if (!JSON_row.URL)
				URL = "";
			else
				URL = JSON_row.URL;
			if (!JSON_row.target)
				target = "";
			else
				target = JSON_row.target;
				
			location_name[parseInt(i) + 2000000] = JSON_row.location_name;
			if ((JSON_row.location_name != null) && (JSON_row.location_name != ""))	{
				location_name[parseInt(i) + 2000000] = JSON_row.location_name;
				address[parseInt(i) + 2000000] = JSON_row.address;
				address2[parseInt(i) + 2000000] = JSON_row.address2;
				city[parseInt(i) + 2000000] = JSON_row.city;
				state[parseInt(i) + 2000000] = JSON_row.state;
				country[parseInt(i) + 2000000] = JSON_row.country;
				postal_code[parseInt(i) + 2000000] = JSON_row.postal_code;
				country[parseInt(i) + 2000000] = JSON_row.country;
				phone[parseInt(i) + 2000000] = JSON_row.phone;
				phone2[parseInt(i) + 2000000] = JSON_row.phone2;
				fax[parseInt(i) + 2000000] = JSON_row.fax;
				email[parseInt(i) + 2000000] = JSON_row.email;
				contact_first[parseInt(i) + 2000000] = JSON_row.contact_first;
				contact_middle[parseInt(i) + 2000000] = JSON_row.contact_middle;
				contact_last[parseInt(i) + 2000000] = JSON_row.contact_last;
				website[parseInt(i) + 2000000] = JSON_row.website;
				web_link_text[parseInt(i) + 2000000] = JSON_row.web_link_text;
				notes[parseInt(i) + 2000000] = JSON_row.notes;
				if ((JSON_row.location_categories != null) && (JSON_row.location_categories != ""))
				{
					var location_category = new Array();
					location_category = JSON_row.location_categories.split(",");
					for (var z in location_category)
					{
						location_category[z] = location_category[z].replace(/_-/g, " ");
						location_category[z] = location_category[z].charAt(0).toUpperCase() + location_category[z].slice(1);
					}
					var location_categories_str = location_category.join(", ");
					location_categories[parseInt(i) + 2000000] = location_categories_str;
				}
				else
					location_categories[parseInt(i) + 2000000] = "";
			}

			start_time_arr = JSON_row.event_start_time.split(":");
			if (parseInt(start_time_arr[0]) > 12)	{
				start_time_arr[0] = parseInt(start_time_arr[0]) - 12;
				start_am_pm = " pm";
			}
			else	{
				start_time_arr[0] = parseInt(start_time_arr[0]);
				if (parseInt(start_time_arr[0]) == 12)
					start_am_pm = " pm";
				else
					start_am_pm = " am";
			}
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			end_time_arr = JSON_row.event_end_time.split(":");
			if (parseInt(end_time_arr[0]) > 12)	{
				end_time_arr[0] = parseInt(end_time_arr[0]) - 12;
				end_am_pm = " pm";
			}
			else	{
				end_time_arr[0] = parseInt(end_time_arr[0]);
				if (parseInt(end_time_arr[0]) == 12)
					end_am_pm = " pm";
				else
					end_am_pm = " am";
			}
			if (start_am_pm == end_am_pm)
				start_am_pm = "";
			event_start_time = start_time_arr[0] + ":" + start_time_arr[1]  + start_am_pm;
			if (JSON_row.event_end_time != "")
				event_end_time = " - " + end_time_arr[0] + ":" + end_time_arr[1] + end_am_pm;
			else
				event_end_time = "";
			
			event_id_str = "event_" + cell;
			if (day == last_day)
				html = document.getElementById(event_id_str).innerHTML + "\n<hr class='event_divider' />\n";
			else
				html = "";

			html = html + "<div style='cursor:pointer;' onClick='SelectEvent(" + JSON_row.event_id + ");'><div class='calendar_event_name'>" + event_name + "</div>";
			if ((event_description != "") && (event_description != "<br>") && (event_description != "\n<br>\n") && (event_description != "<br>\n"))
				html = html + "<div class='calendar_event_description'>" + event_description + "</div>";
			html = html + "<div class='start_end_time'>" + event_start_time + event_end_time + "</div></div>\n";
			
			if ((URL[i] != null) && (URL[i] != ""))
				html = html + "<div class='event_url'><a href='" + URL + "' target='_blank'>" + URL + "</a></div>\n";
			if ((location_name[parseInt(i) + 2000000] != null) && (location_name[parseInt(i) + 2000000] != ""))
				html = html + "<div class='location_link' onclick='ShowLocationInfo(" + (parseInt(i) + 2000000).toString() + ");'>Location</div>\n";
			else
				html = html + "<br />\n";
			document.getElementById(event_id_str).innerHTML = html;
			
			last_day = day;
		}
	}
}

function ChangeMonthYear(month_change, year_change)
{
	var year = cur_year + year_change;
	var month = cur_month + month_change;
	if (month < 0)	{
		month = 11;
		year--;
	}
	else if (month > 11)	{
		month = 0;
		year++;
	}
	LoadCalender(year, month)
}

function ShowHideHebrewDates()
{
	if (document.getElementById("head_jc_month_names").style.display == "none")
	{
		document.getElementById("head_jc_month_names").style.display = "inline";
		document.getElementById("head_jc_year").style.display = "inline";
		document.getElementById("hebrew_date_comma").style.display = "inline";
		var hebrew_day_id;
		for (var i = 0; i < 42; i++)
		{
			hebrew_day_id = "hebrew_day_" + i;
			document.getElementById(hebrew_day_id).style.display = "inline";
		}
		document.getElementById("show_hide_hebrew_dates_img").alt = CALENDAR_EVENTS_HIDE_HEBREW_DATES;
	}
	else
	{
		document.getElementById("head_jc_month_names").style.display = "none";
		document.getElementById("head_jc_year").style.display = "none";
		document.getElementById("hebrew_date_comma").style.display = "none";
		var hebrew_day_id;
		for (var i = 0; i < 42; i++)
		{
			hebrew_day_id = "hebrew_day_" + i;
			document.getElementById(hebrew_day_id).style.display = "none";
		}
		document.getElementById("show_hide_hebrew_dates_img").alt = CALENDAR_EVENTS_SHOW_HEBREW_DATES;
	}
}

function ShowBtnAction()
{
	document.getElementById("btn_action_label").innerHTML = document.getElementById("show_hide_hebrew_dates_img").alt;
	document.getElementById("btn_action_label").style.display = "block";
}
function HideBtnAction()
{
	document.getElementById("btn_action_label").style.display = "none";
}

function ShowLocationInfo(i)
{
	var ntop, nleft;
	ntop = tempY + top_offset;
	nleft = tempX + left_offset;
	var categories = new Array();
	var categories_str = "";
	var comma = "";

	var strtop = ntop + "px";
	var strleft = nleft + "px";
	document.getElementById("location_info").style.top = strtop;
	document.getElementById("location_info").style.left = strleft;

	document.getElementById("location_name").innerHTML = location_name[i];
	document.getElementById("address").innerHTML = address[i];
	document.getElementById("address2").innerHTML = address2[i];
	document.getElementById("city").innerHTML = city[i];
	document.getElementById("state").innerHTML = state[i];
	document.getElementById("country").innerHTML = country[i];
	document.getElementById("postal_code").innerHTML = postal_code[i];
	document.getElementById("country").innerHTML = country[i];
	document.getElementById("phone").innerHTML = phone[i];
	document.getElementById("phone2").innerHTML = phone2[i];
	document.getElementById("fax").innerHTML = fax[i];
	document.getElementById("email").innerHTML = email[i];
	document.getElementById("contact_first").innerHTML = contact_first[i];
	document.getElementById("contact_middle").innerHTML = contact_middle[i];
	document.getElementById("contact_last").innerHTML = contact_last[i];
	if ((web_link_text[i] != null) && ((web_link_text[i] != "")))
		document.getElementById("website").innerHTML = web_link_text[i];
	else
		document.getElementById("website").innerHTML = website[i];
	document.getElementById("website").href = website[i];
	document.getElementById("notes").innerHTML = notes[i];

	categories = location_categories[i].split(",");
	for (var j in categories)
	{
		categories_str = categories_str + comma + categories[j].replace(/_/g, " ");
		comma = ", ";
	}
	document.getElementById("location_categories").innerHTML = categories_str;
	
	var address_str = "";
	if ((address[i] != null) && (address[i] != ""))
		address_str = address[i].replace(/ /g, "+");
	if ((address2[i] != null) && (address2[i] != ""))
		address_str = address_str + "+" + address2[i].replace(/ /g, "+");
	if ((city[i] != null) && (city[i] != ""))
		address_str = address_str + "+" + city[i].replace(/ /g, "+");
	if ((state[i] != null) && (state[i] != ""))
		address_str = address_str + "+" + state[i].replace(/ /g, "+");
	if ((country[i] != null) && (country[i] != ""))
		address_str = address_str + "+" + country[i].replace(/ /g, "+");

	if ((address_str != null) && (address_str != ""))	{
		document.getElementById("location_map").style.display = "block";
		var map_url = "https://www.google.com/maps/search/?api=1&query=" + address_str;
		document.getElementById("location_map").href = map_url;
	}
	else
		document.getElementById("location_map").style.display = "none";
		
	document.getElementById("location_info").style.display = "block";
}

function HideLocationInfo()
{
	document.getElementById("location_info").style.display = "none";
}

function CloseEditForm()
{
	document.getElementById("cloak_div").style.display = "none";
	bottom = document.body.scrollHeight;
	from_height = bottom;
	step = parseInt(bottom/100);
	to_height = bottom;
}

function EditCategories()
{
	window.location = "manage_event_location_categories.php";
}

function PopulateCategories(cat_type)
{
	var where = "";
	if (cat_type == "event")
		where = "event_type = 1";
	else if (cat_type == "location")
		where = "location_type = 1";
		
	$.post( "../../get_rows.php", { table: "event_location_categories", where: where, order_by: "sort_order", no_prefix: 0 } ).done(function( data ) { CompletePopulateCategories(data, cat_type); } ) ;
}
function CompletePopulateCategories(data, cat_type)
{
	var rows = new Array();
	var html = "";
	var cat_name_suffix, target_cell, categories_heading_row, categories_row;
	if (cat_type == "location")	{
		cat_name_suffix = "_location_cat";
		target_cell = "location_categories_cell";
		categories_heading_row = "location_categories_heading_row";
		categories_row = "location_categories_row";
	}
	else	{
		cat_name_suffix = "_event_cat";
		target_cell = "event_categories_cell";
		categories_heading_row = "event_categories_heading_row";
		categories_row = "event_categories_row";
	}
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")	{
		popup_msg.status_msg = CALENDAR_EVENTS_NO_CATEGORIES_FOUND_MSG;
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 500;
		popup_msg.ShowPopupMsg();
		
		if (ElExists(categories_heading_row))
			document.getElementById(categories_heading_row).style.display = "none";
		document.getElementById(categories_row).style.display = "none";
	}
	else
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			html = html + "<div class='category_chkbox'><input id='" + JSON_row.category + cat_name_suffix + "' name='" + JSON_row.category + cat_name_suffix + "' type='checkbox' value='" + JSON_row.category + "' /> " + JSON_row.category_string + "</div>\n";
		}

		document.getElementById(target_cell).innerHTML = html;
		
		if (ElExists(categories_heading_row))
			document.getElementById(categories_heading_row).style.display = "table-row";
		document.getElementById(categories_row).style.display = "table-row";
	}
}

function CopyEvent(event_id)
{
	SelectEvent(event_id);
	var code = "CompleteCopyEvent();";
	setTimeout(code, 1000);
}
function CompleteCopyEvent()
{
	document.getElementById("event_id").value = -1;
	document.getElementById("event_start_date").value = "";
	document.getElementById("event_end_date").value = "";
}


function InitializeCalendarGrid()
{
	var d = new Date();
	var month = d.getMonth();
	var year = d.getFullYear();
	LoadCalender(year, month);
	ShowHideHebrewDates();
}

function InitializeConsole()
{
	popup_msg.HidePopupMsg();
	InitializeCalendarGrid();
	InitializeForm();
	PopulateCategories("event");
	PopulateCategories("location");
	CheckForBATLoginTable();
	
	bottom = document.body.scrollHeight;
	from_height = bottom;
	step = parseInt(bottom/100);
	to_height = bottom;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}