////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/30/2018
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;
var nic_editor1;

if ((browser == "Explorer") && (browser_version <= 7))
	var inherit = "";
else
	var inherit = "inherit";
	
var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var filter_city = "-not selected-";
var show_pending = 0;

var top_offset = -50;
var left_offset = -300;
var scroll_threshold = 200;
	
//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open(http + "breezewebsitebuilder.com/docs/cms/help.html#events_calender#edit_locations", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else
		return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////
function SelectLocation(location_id)
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_RETRIEVING_LOCATION_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	document.getElementById("action_heading").innerHTML = MANAGE_LOCATION_EDIT_LOCATION + ":";
	document.getElementById("delete_btn").style.display = "block";
	
	if (!nic_editor1)
		nic_editor1 = new nicEditor({iconsPath : 'js/nicEditorIcons.gif', fullPanel : true}).panelInstance('location_description');
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_location.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "SelectLocation");

		params = "location_id=" + location_id;
		xmlhttp.send(params);
	}
	
	document.getElementById("delete_btn").style.display = "block";
}

function UpdateMessage(xmlhttp, source)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
				response = xmlhttp.responseText;
			else
				response = RECORD_NOT_FOUND;
//alert(response);
			if (source == "SelectLocation")	{
				PopulateLocation(response);
				status_msg = MANAGE_LOCATION_POPULATE_LOCATION_COMPLETED_MSG;
			}
			else if (source == "SaveLocation")	{
				mTimer = setTimeout("SelectLocation(" + response + ");", 10);
				status_msg = "Save location completed.";
			}
			else if (source == "Filter")	{
				FilterLocationsList(response);
				status_msg = "Locations list updated.";
			}
				
			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			status_msg = QUERY_READY_TO_SEND;
		else if (xmlhttp.readyState==2)
			status_msg = QUERY_SENT;
		else if (xmlhttp.readyState==3)
			status_msg = QUERYING;
		
		popup_msg.status_msg = status_msg;
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

function PopulateLocation(location_rcd)
{
	popup_msg.status_msg = CALENDAR_EVENTS_POPULATING_LOCATION_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	
	var JSON_row = JSON.parse(location_rcd);
		
	var location_id = parseInt(JSON_row.location_id);

	document.getElementById("location_id").value = location_id;
	
	location_name = JSON_row.location_name.replace("&#39;", "'");
	document.getElementById("location_name").value = location_name;
	document.getElementById("address").value = JSON_row.address;
	document.getElementById("address2").value = JSON_row.address2;
	document.getElementById("city_select").value = JSON_row.city;
	document.getElementById("city").value = JSON_row.city;
	document.getElementById("state_select").value = JSON_row.state;
	document.getElementById("state").value = JSON_row.state;
	document.getElementById("country_select").value = JSON_row.country;
	document.getElementById("country").value = JSON_row.country;
	document.getElementById("postal_code").value = JSON_row.postal_code;
	document.getElementById("phone").value = JSON_row.phone;
	document.getElementById("phone2").value = JSON_row.phone2;
	document.getElementById("fax").value = JSON_row.fax;
	document.getElementById("website").value = JSON_row.website;
	document.getElementById("web_link_text").value = JSON_row.web_link_text;
	document.getElementById("email").value = JSON_row.email;
	document.getElementById("location_description").value = JSON_row.location_description;
	nicEditors.findEditor('location_description').setContent(JSON_row.location_description);
	document.getElementById("location_status").value = JSON_row.location_status;
	document.getElementById("location_owner").value = JSON_row.location_owner;
		
	var checkboxes = document.getElementById('location_categories_cell').getElementsByTagName('input');
	for (i = 0; i < checkboxes.length; i++) {
		checkboxes[i].checked = false;
	}
	if ((JSON_row.location_categories != null) && (JSON_row.location_categories != ""))
	{
		var category_id;
		var location_categories = JSON_row.location_categories.split(",");
		for (var z in location_categories)
		{
			category_id = location_categories[z] + "_location_cat";
			if (ElExists(category_id))
				document.getElementById(category_id).checked = true;
		}
	}
		
	if (JSON_row.location_active == 1)
		document.getElementById("location_active").checked = true;
	else
		document.getElementById("location_active").checked = false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////
function SaveLocation(bClose)
{
	if (!CheckFields())
		return;
		
	var params = "";
	var categories = "";
	var comma = "";
	var el_name, category;
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_LOCATION_SAVING_LOCATION_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var checkboxes = document.getElementById('location_categories_cell').getElementsByTagName('input');
	for (var i = 0; i < checkboxes.length; i++) {
		if (checkboxes[i].checked == true)	{
			el_name = checkboxes[i].getAttribute("name");
			category = el_name.replace("_location_cat", "");
			categories = categories + comma + category;
			comma = ",";
		}
	}
	document.getElementById("location_categories").value = categories;
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_location.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "SaveLocation");

		var location_id = document.getElementById("location_id").value;
		if (location_id == "")
			location_id = -1;
		params = "location_id=" + location_id;
		var location_name = document.getElementById("location_name").value
		location_name = location_name.replace(/\'/g, "&#39;");
		location_name = location_name.replace(/\&/g, "AMPERSAND");
		params = params + "&location_name=" + location_name;
		params = params + "&address=" + document.getElementById("address").value;
		params = params + "&address2=" + document.getElementById("address2").value;
		params = params + "&city=" + document.getElementById("city").value;
		params = params + "&state=" + document.getElementById("state").value;
		params = params + "&country=" + document.getElementById("country").value;
		params = params + "&postal_code=" + document.getElementById("postal_code").value;
		params = params + "&phone=" + document.getElementById("phone").value;
		params = params + "&phone2=" + document.getElementById("phone2").value;
		params = params + "&fax=" + document.getElementById("fax").value;
		params = params + "&website=" + document.getElementById("website").value;
		params = params + "&web_link_text=" + document.getElementById("web_link_text").value;
		params = params + "&email=" + document.getElementById("email").value;
		var location_description = document.getElementById("location_description").value
		location_description = location_description.replace(/\&/g, "AMPERSAND");
		params = params + "&location_description=" + location_description;
		params = params + "&location_status=" + document.getElementById("location_status").value;
		params = params + "&location_categories=" + categories;
		params = params + "&location_owner=" + document.getElementById("location_owner").value;
		if (document.getElementById("location_active").checked == true)
			params = params + "&location_active=1";
		else
			params = params + "&location_active=0";
		
		xmlhttp.send(params);
	}
	
	if (bClose)
		CloseEditForm();
		
	RetrieveLocations();
	GetLocationCities();
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function Filter()
{
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_LOCATION_FILTERING_LOCATIONS_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();

	filter_city = document.getElementById("filter_city").value
	show_pending = 0;
	if (document.getElementById("show_pending").checked == true)
		show_pending = 1;
	RetrieveLocations();
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(location_id, location_name)
{
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_1_MSG + " <b>" + location_name + "</b> " + MANAGE_LOCATION_DELETE_LOCATION_MSG_2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteLocation(location_id); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	popup_msg.popup_timeout = -1;
}

function DeleteLocation(location_id)
{
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_LOCATION_DELETING_LOCATION_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	popup_msg.HidePopupMsg();
	
	$.post( "delete_location.php", { location_id: location_id } ).done(function( data ) { CompleteDeleteLocation(data); } ) ;
}
function CompleteDeleteLocation(data, location_id)
{
	RetrieveLocations();
}

/////////////////////////////////////////////////////////////////////////////////////////////////
function CreateLocation()
{
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_LOCATION_CLEARING_FORM_NOW_LOCATION_MSG;
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	document.getElementById("frmLocation").reset();
	
	document.getElementById("cloak_div").style.display = "block";
	document.getElementById("action_heading").innerHTML = MANAGE_LOCATION_CREATE_NEW_LOCATION + ": ";
	document.getElementById("delete_btn").style.display = "none";
	document.getElementById("location_status").value = 0;
	document.getElementById("location_active").checked = true;
	
	if (!nic_editor1)
		nic_editor1 = new nicEditor({iconsPath : 'js/nicEditorIcons.gif', fullPanel : true}).panelInstance('location_description');
	else
		nicEditors.findEditor('location_description').setContent("");
		
	GetLocationCities();
		
	if ((window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0) > scroll_threshold)
		AnimateScroll();
}

function EditLocation()
{
	document.getElementById("frmLocation").reset();
	
	document.getElementById("cloak_div").style.display = "block";
	document.getElementById("delete_btn").style.display = "block";
	
	if ((window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0) > scroll_threshold)
		AnimateScroll();
}

var bottom;
var from_height;
var step;
var to_height;
var code = "AnimateScroll();";
	
function AnimateScroll()
{
	if (to_height > 0)
	{
		to_height = to_height - step;
		window.scrollTo(from_height, to_height);
		setTimeout(code, 10);
		from_height = to_height;
	}
}

function PopulateCategories(cat_type)
{
	var where = "";
	if (cat_type == "event")
		where = "event_type = 1";
	else if (cat_type == "location")
		where = "location_type = 1";
		
	$.post( "../../get_rows.php", { table: "event_location_categories", where: where, order_by: "sort_order", no_prefix: 0 } ).done(function( data ) { CompletePopulateCategories(data, cat_type); } ) ;
}
function CompletePopulateCategories(data, cat_type)
{
	var rows = new Array();
	var html = "";
	var cat_name_suffix, target_cell, categories_heading_row, categories_row;
	if (cat_type == "location")	{
		cat_name_suffix = "_location_cat";
		target_cell = "location_categories_cell";
		categories_heading_row = "location_categories_heading_row";
		categories_row = "location_categories_row";
	}
	else	{
		cat_name_suffix = "_event_cat";
		target_cell = "event_categories_cell";
		categories_heading_row = "event_categories_heading_row";
		categories_row = "event_categories_row";
	}
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")	{
		popup_msg.status_msg = CALENDAR_EVENTS_NO_CATEGORIES_FOUND_MSG;
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 2;
		popup_msg.popup_timeout = 2000;
		popup_msg.ShowPopupMsg();
		
		if (ElExists(categories_heading_row))
			document.getElementById(categories_heading_row).style.display = "none";
		document.getElementById(categories_row).style.display = "none";
	}
	else
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			html = html + "<div class='category_chkbox'><input id='" + JSON_row.category + cat_name_suffix + "' name='" + JSON_row.category + cat_name_suffix + "' type='checkbox' value='" + JSON_row.category + "' /> " + JSON_row.category_string + "</div>\n";
		}

		document.getElementById(target_cell).innerHTML = html;
		
		if (ElExists(categories_heading_row))
			document.getElementById(categories_heading_row).style.display = "table-row";
		document.getElementById(categories_row).style.display = "table-row";
	}
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveLocations()
{
	var where = "";
	var and = "";
	if (filter_city != "-not selected-")	{
		where = "(city = '" + filter_city + "')";
		and = " AND ";
	}
		
	if (show_pending == 1)
		where = where + and + "(location_status = 0)";
		
	var order_by = "location_name, city";
	$.post( "../../get_rows.php", { table: "locations", where: where, order_by: order_by, no_prefix: 0 } ).done(PopulateTable) ;
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(rows_str)
{
	var rows = new Array();
	var tmp, location_id, location_name, location_description, address, city, state, country, phone, email, website, location_categories, categories_str, comma;
	var categories = new Array();
	var bgclr = "#eeeeee";
	
	var output_str = "<table width='90%' align='center'>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>" + CALENDAR_EVENTS_LOCATION + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + DESCRIPTION_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_LOCATION_ADDRESS + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + CALENDAR_EVENTS_CITY + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + CALENDAR_EVENTS_STATE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + CALENDAR_EVENTS_COUNTRY + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_LOCATION_PHONE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_LOCATION_EMAIL + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + MANAGE_LOCATION_WEBSITE + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + CALENDAR_EVENTS_CATEGORIES + "<\/b><\/td>\n";
	if (show_status)
		output_str = output_str + "<td class='header_row'><b>" + STATUS_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + ACTIVE_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	
	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no locations yet (first time).
		var i = 0;
	else	// Create rows for locations.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
			
			location_id = JSON_row.location_id;
			location_name = JSON_row.location_name;
			if (JSON_row.location_description != null)
				location_description = JSON_row.location_description;
			else
				location_description = "";
			if (JSON_row.address != null)
				address = JSON_row.address;
			else
				address = "";
			if (JSON_row.city != null)
				city = JSON_row.city;
			else
				city = "";
			if (JSON_row.state != null)
				state = JSON_row.state;
			else
				state = "";
			if (JSON_row.country != null)
				country = JSON_row.country;
			else
				country = "";
			if (JSON_row.phone != null)
				phone = JSON_row.phone;
			else
				phone = "";
			if (JSON_row.email != null)
				email = JSON_row.email;
			else
				email = "";
			if (JSON_row.website != null)	{
				website = JSON_row.website;
				if (website.indexOf("http") < 0)
					website = http + website;
			}
			else
				website = "";
			if (JSON_row.location_categories != null)	{
				location_categories = JSON_row.location_categories;
				categories = location_categories.split(",");
				categories_str = "";
				comma = "";
				for (j in categories)
				{
					categories_str = categories_str + comma + categories[j].charAt(0).toUpperCase() + categories[j].slice(1);
					comma = ", ";
				}
			}
			else
				location_categories = "";
					
			output_str = output_str + "<td valign='top'>\n<input type='hidden' name='location_id" + i + "' id='location_id" + i + "' value='" + location_id + "'>\n";
			output_str = output_str + location_name + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + location_description + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + address + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + city + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + state + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + country + "<\/td>\n";
			output_str = output_str + "<td valign='top'>" + phone + "<\/td>\n";
			
			if (email != "")
				output_str = output_str + "<td valign='top'><a href='mailto:" + email + "' />" + email + "<\/a><\/td>\n";
			else
				output_str = output_str + "<td valign='top'>&nbsp;<\/td>\n";
				
			if ((website != "") && (website != "http://") && (website != "https://"))
				output_str = output_str + "<td valign='top'><a href='" + website + "' target='_blank' />" + website + "<\/a><\/td>\n";
			else
				output_str = output_str + "<td valign='top'>&nbsp;<\/td>\n";
			output_str = output_str + "<td valign='top'>" + categories_str + "<\/td>\n";
			
			if (show_status)	{
				var status;
				if (JSON_row.location_status == 0)
					status = PENDING_WORD;
				else if (JSON_row.location_status == 1)
					status = PUBLISHED_WORD;
				else if (JSON_row.location_status == -1)
					status = DECLINED_WORD;
				output_str = output_str + "<td valign='top'>" + status + "<\/td>\n";
			}
			
			output_str = output_str + "<td valign='top'>" + JSON_row.location_active + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/edit.png' border=0 alt='Edit' name='Edit' onClick=\"EditLocation(); SelectLocation(" + JSON_row.location_id + ", " + i + ");\" style='cursor:pointer; margin-right:15px; margin-left:5px; text-align:center;' />\n<\/td>\n";
			
			tmp = JSON_row.location_name;
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			output_str = output_str + "<td valign='top'>\n<img src='../../theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm(" + location_id + ", '" + tmp + "');\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";
		}
		i++;
	}
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("LocationsTable").innerHTML = output_str;
}

//////////////////////////////////////////////////////////////////////////////////
function GetLocationCities()
{
	$.post( "get_location_cities.php", { location_name: "-all locations-" } ).done(PopulateLocationCities) ;
}

function PopulateLocationCities(location_cities)
{
	var sel = document.getElementById('filter_city');
	sel.options.length = 0;
	var sel2 = document.getElementById('city_select');
	sel2.options.length = 0;

	sel.options[sel.options.length] = new Option(MANAGE_LOCATIONS_ALL_CITIES, '-not selected-');
	sel2.options[sel2.options.length] = new Option(_NOT_SELECTED_, '-not selected-');

	if (location_cities != "-no data-")
	{
		var JSON_row = JSON.parse(location_cities);
		for (var i = 0; i < JSON_row.length; i++)
		{
			if (filter_city == JSON_row[i])
				sel.options[sel.options.length] = new Option(JSON_row[i], JSON_row[i], true, true);
			else
				sel.options[sel.options.length] = new Option(JSON_row[i], JSON_row[i]);
			if (JSON_row[i] == document.getElementById("city").value)
				sel2.options[sel2.options.length] = new Option(JSON_row[i], JSON_row[i], true, true);
			else
				sel2.options[sel2.options.length] = new Option(JSON_row[i], JSON_row[i]);
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{
	document.getElementById("delete_btn").style.display = "none";
	document.getElementById("cloak_div").style.display = "none";
}

function InitializeConsole()
{
	popup_msg.HidePopupMsg();
	RetrieveLocations();
	InitializeForm();
	PopulateCategories("location");
	GetLocationCities();
}

function CloseEditForm()
{
	document.getElementById("cloak_div").style.display = "none";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
function CheckFields()
{
	if (document.getElementById("location_name").value == "")	{
		alert(MANAGE_LOCATION_PLEASE_ENTER_NAME_MSG);
		return false;
	}
//	if (nicEditors.findEditor('location_description').getContent() == "")	{
//		alert("Please enter a description for your location.");
//		return false;
//	}
//	else
		document.getElementById("location_description").value = nicEditors.findEditor('location_description').getContent();
	
	if (document.getElementById("address").value == "")	{
		alert(MANAGE_LOCATION_PLEASE_ENTER_ADDRESS_MSG);
		return false;
	}
	if (document.getElementById("city").value == "")	{
		alert(MANAGE_LOCATION_PLEASE_ENTER_CITY_MSG);
		return false;
	}
	if (document.getElementById("postal_code").value == "")	{
		alert(MANAGE_LOCATION_PLEASE_ENTER_ZIP_MSG);
		return false;
	}
	return true;
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}