<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/30/2018
//
	
	include ("check_session.php");
	
	$filter_city = $_REQUEST['filter_city'];
	$filter_event_name = addslashes($_REQUEST['filter_event_name']);
	$filter_location = $_REQUEST['filter_location'];
	$filter_date = $_REQUEST['filter_date'];
	if ((!isset($filter_date)) || ($filter_date == ""))
		$filter_date = date("Y-m-d");
	if (isset($_REQUEST['show_children']))
		$show_children = 1;
	else
		$show_children = 0;
	if (isset($_REQUEST['show_pending']))
		$show_pending = 1;
	else
		$show_pending = 0;
		
	$query = "SELECT `language_folder` FROM " . BWB_TABLE_PREFIX . "plugins WHERE `name` = 'Calendar Grid v2'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$language_folder = $row['language_folder'];
		
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if ((defined("BWB_LANG")) && (file_exists($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php")))
		include_once ($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php");
	else
		include_once ($document_root . "/" . $language_folder . "/en.php");
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Event Management Console</title>

<link rel="stylesheet" href="../../theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manage_events.css" type="text/css">
<link rel="stylesheet" type="text/css" href="js/pikaday.css" />
<link rel="shortcut icon" href="/images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

#search_btn_div	{
	position: absolute;
	top: 2px;
	right: 300px;
	cursor: pointer;
}

#search_btn_div img	{	height: 28px;	}
</style>

<script src="../../js/ajax.js"> </script>
<script src="../../js/mouse_position.js"></script>
<script src="../../js/popup_msg.js"> </script>
<script src="../../js/browser_detect.js"> </script>
<script src="../../js/jquery.min.js"></script>
<script src="js/event_to_bat_functions.js"> </script>
<script src="js/manage_events.js"> </script>
<script src="../../js/ajaxupload.js"></script>
<script src="js/nicEdit.js"></script>

<script>
	var events = new Array();
	var cities = new Array();
<?php
	echo "	var theme = '$theme';\n\n";
	echo "	var CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG = \"" . CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SHOW_HEBREW_DATES = \"" . CALENDAR_EVENTS_SHOW_HEBREW_DATES . "\";\n";
	echo "	var CALENDAR_EVENTS_HIDE_HEBREW_DATES = \"" . CALENDAR_EVENTS_HIDE_HEBREW_DATES . "\";\n";
	echo "	var EDIT_WORD = \"" . EDIT_WORD . "\";\n";
	echo "	var ADD_WORD = \"" . ADD_WORD . "\";\n";
	echo "	var EDITOR_DELETE = \"" . EDITOR_DELETE . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";	
	echo "	var CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG = \"" . CALENDAR_EVENTS_NO_RECORDS_FOUND_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_1_MSG = \"" . CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_1_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_2_MSG = \"" . CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_2_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DATE_FORMAT_MSG = \"" . CALENDAR_EVENTS_DATE_FORMAT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_COULD_NOT_DELETE_EVENT_MSG = \"" . CALENDAR_EVENTS_COULD_NOT_DELETE_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_LOCATING_EVENTS_MSG = \"" . CALENDAR_EVENTS_LOCATING_EVENTS_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_EVENT_DELETED_MSG = \"" . CALENDAR_EVENTS_EVENT_DELETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DELETING_EVENT_MSG = \"" . CALENDAR_EVENTS_DELETING_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_COULD_NOT_UPDATE_EVENT_MSG = \"" . CALENDAR_EVENTS_COULD_NOT_UPDATE_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_EVENT_UPDATED_MSG = \"" . CALENDAR_EVENTS_EVENT_UPDATED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_UPDATING_EVENT_MSG = \"" . CALENDAR_EVENTS_UPDATING_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_COULD_NOT_UPDATE_USER_LISTS_MSG = \"" . CALENDAR_EVENTS_COULD_NOT_UPDATE_USER_LISTS_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_USER_LIST_UPDATED_MSG = \"" . CALENDAR_EVENTS_USER_LIST_UPDATED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_UPDATING_USER_LIST_MSG = \"" . CALENDAR_EVENTS_UPDATING_USER_LIST_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_MEMORY_LIMIT_ERR = \"" . CALENDAR_EVENTS_MEMORY_LIMIT_ERR . "\";\n";
	echo "	var CALENDAR_EVENTS_STARTING_USER_QUERY_MSG = \"" . CALENDAR_EVENTS_STARTING_USER_QUERY_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_1_MSG = \"" . CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_1_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_2_MSG = \"" . CALENDAR_EVENTS_DELETE_ALL_EVENTS_CONFIRM_2_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_RETRIEVING_EVENT_MSG = \"" . CALENDAR_EVENTS_RETRIEVING_EVENT_MSG . "\";\n";
	echo "	var RECORD_NOT_FOUND = \"" . RECORD_NOT_FOUND . "\";\n";
	echo "	var CALENDAR_EVENTS_POPULATING_EVENT_COMPLETED_MSG = \"" . CALENDAR_EVENTS_POPULATING_EVENT_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_POPULATING_LOCATION_COMPLETED_MSG = \"" . CALENDAR_EVENTS_POPULATING_LOCATION_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SEARCH_LOCATION_COMPLETED_MSG = \"" . CALENDAR_EVENTS_SEARCH_LOCATION_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_GET_LOCATION_ID_COMPLETED_MSG = \"" . CALENDAR_EVENTS_GET_LOCATION_ID_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_NEW_LOCATION_COMPLETED_MSG = \"" . CALENDAR_EVENTS_SAVE_NEW_LOCATION_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_EVENT_COMPLETED_MSG = \"" . CALENDAR_EVENTS_SAVE_EVENT_COMPLETED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_LOCATION_CITY_LIST_UPDATED_MSG = \"" . CALENDAR_EVENTS_LOCATION_CITY_LIST_UPDATED_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_EVENTS_LIST_UPDATED_MSG = \"" . CALENDAR_EVENTS_EVENTS_LIST_UPDATED_MSG . "\";\n";
	echo "	var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
	echo "	var CALENDAR_EVENTS_POPULATING_EVENT_MSG = \"" . CALENDAR_EVENTS_POPULATING_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_RETRIEVING_LOCATION_MSG = \"" . CALENDAR_EVENTS_RETRIEVING_LOCATION_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_POPULATING_LOCATION_MSG = \"" . CALENDAR_EVENTS_POPULATING_LOCATION_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_GETTING_LOCATION_CITIES_MSG = \"" . CALENDAR_EVENTS_GETTING_LOCATION_CITIES_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_UPDATING_LOCATION_CITIES_MSG = \"" . CALENDAR_EVENTS_UPDATING_LOCATION_CITIES_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVING_EVENT_MSG = \"" . CALENDAR_EVENTS_SAVING_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVING_NEW_LOCATION_MSG = \"" . CALENDAR_EVENTS_SAVING_NEW_LOCATION_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_FILTERING_EVENTS_MSG = \"" . CALENDAR_EVENTS_FILTERING_EVENTS_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_CLEARING_FORM_MSG = \"" . CALENDAR_EVENTS_CLEARING_FORM_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_LOCATION_NOT_FOUND = \"" . CALENDAR_EVENTS_LOCATION_NOT_FOUND . "\";\n";
	echo "	var CALENDAR_EVENTS_CREATE_NEW_EVENT = \"" . CALENDAR_EVENTS_CREATE_NEW_EVENT . "\";\n";
	echo "	var CALENDAR_EVENTS_LOCATION_NOT_FOUND = \"" . CALENDAR_EVENTS_LOCATION_NOT_FOUND . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_ENTER_AN_END_DATE_MSG = \"" . CALENDAR_EVENTS_PLEASE_ENTER_AN_END_DATE_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_ENTER_DESCRIPTION_MSG = \"" . CALENDAR_EVENTS_PLEASE_ENTER_DESCRIPTION_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_SELECT_CATEGORY_MSG = \"" . CALENDAR_EVENTS_PLEASE_SELECT_CATEGORY_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_ENTER_LOCATION_MSG = \"" . CALENDAR_EVENTS_PLEASE_ENTER_LOCATION_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_ENTER_ADDRESS_MSG = \"" . CALENDAR_EVENTS_PLEASE_ENTER_ADDRESS_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_SELECT_CITY_MSG = \"" . CALENDAR_EVENTS_PLEASE_SELECT_CITY_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_PLEASE_ENTER_ZIP_MSG = \"" . CALENDAR_EVENTS_PLEASE_ENTER_ZIP_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_NO_CATEGORIES_FOUND_MSG = \"" . CALENDAR_EVENTS_NO_CATEGORIES_FOUND_MSG . "\";\n";
	echo "	var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
	echo "	var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
	echo "	var QUERYING = \"" . QUERYING . "\";\n";
	echo "	var CALENDAR_EVENTS_ENTER_NAME_MSG = \"" . CALENDAR_EVENTS_ENTER_NAME_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_ENTER_START_DATE_MSG = \"" . CALENDAR_EVENTS_ENTER_START_DATE_MSG . "\";\n";
	echo "	var COPY_WORD = \"" . COPY_WORD . "\";\n";
	echo "	var CALENDAR_EVENTS_EDIT_EVENT_MSG = \"" . CALENDAR_EVENTS_EDIT_EVENT_MSG . "\";\n";
	echo "	var CALENDAR_EVENTS_SELECT_CITY = \"" . CALENDAR_EVENTS_SELECT_CITY . "\";\n";
	echo "	var EDIT_CSS_UPDATE_COMPLETE_MSG = \"" . EDIT_CSS_UPDATE_COMPLETE_MSG . "\";\n";
	echo "	var EDIT_PAGE_NO_CHANGE = \"" . EDIT_PAGE_NO_CHANGE . "\";\n";
	echo "	var EDIT_PAGE_UPDATE_FAILED = \"" . EDIT_PAGE_UPDATE_FAILED . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_1 = \"" . CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_1 . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_2 = \"" . CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_2 . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_3 = \"" . CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_3 . "\";\n";
	echo "	var CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_4 = \"" . CALENDAR_EVENTS_SAVE_TO_BAT_RESULT_MSG_4 . "\";\n";
	
	$events = array();
	
	echo "	var filter_city = '$filter_city';\n";
	echo "	var filter_event_name = '$filter_event_name';\n";
	echo "	var filter_location = '$filter_location';\n";
	echo "	var filter_date = '$filter_date';\n";
	echo "	var show_children = $show_children;\n";
	
	echo "	var http = '$http';\n";
	
	if ($show_children != 1)	{
		$children_where = " AND ((events.group_id IS NULL) OR (events.group_id = events.event_id))";
		$children_where2 = " AND ((group_id IS NULL) OR (group_id = event_id))";
	}
	else	{
		$children_where = "";
		$children_where2 = "";
	}
	
	// City AND Event AND Location
	if ((isset($filter_city)) && ($filter_city != "") && ($filter_city != "-not selected-") && (isset($filter_event_name)) && ($filter_event_name != "") && (isset($filter_location)) && ($filter_location != "") && ($filter_location != "-not selected-"))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id WHERE (T2.location_city = '$filter_city') AND (T2.location_name = '$filter_location') AND (T1.event_name LIKE '%$filter_event_name%') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// City AND Event AND NOT Location
	elseif ((isset($filter_city)) && ($filter_city != "") && ($filter_city != "-not selected-") && (isset($filter_event_name)) && ($filter_event_name != "") && ((!isset($filter_location)) || ($filter_location == "") || ($filter_location == "-not selected-")))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id WHERE (T2.location_city = '$filter_city') AND (T1.event_name LIKE '%$filter_event_name%') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// NOT City AND Event AND NOT Location
	elseif (((!isset($filter_city)) || ($filter_city == "") || ($filter_city == "-not selected-")) && (isset($filter_event_name)) && ($filter_event_name != "") && ((!isset($filter_location)) || ($filter_location == "") || ($filter_location == "-not selected-")))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events WHERE (event_name LIKE '%$filter_event_name%') AND (DATEDIFF(event_start_date, '$filter_date') >= 0)$children_where2 ORDER BY event_start_date";
		
	// NOT City AND Event AND Location
	elseif (((!isset($filter_city)) || ($filter_city == "") || ($filter_city == "-not selected-")) && (isset($filter_event_name)) && ($filter_event_name != "") && (isset($filter_location)) && ($filter_location != "") && ($filter_location != "-not selected-"))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id WHERE (T2.location_name = '$filter_location') AND (T1.event_name LIKE '%$filter_event_name%') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// NOT City AND NOT Event AND Location
	elseif (((!isset($filter_city)) || ($filter_city == "") || ($filter_city == "-not selected-")) && ((!isset($filter_event_name)) || ($filter_event_name == "")) && (isset($filter_location)) && ($filter_location != "") && ($filter_location != "-not selected-"))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id WHERE (T2.location_name = '$filter_location') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// City AND NOT Event AND Location
	elseif ((isset($filter_city)) && ($filter_city != "") && ($filter_city != "-not selected-") && ((!isset($filter_event_name)) || ($filter_event_name == "")) && (isset($filter_location)) && ($filter_location != "") && ($filter_location != "-not selected-"))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id WHERE (T2.location_name = '$filter_location') AND (T2.location_city = '$filter_city') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// City AND NOT Event AND NOT Location
	elseif ((isset($filter_city)) && ($filter_city != "") && ($filter_city != "-not selected-") && ((!isset($filter_event_name)) || ($filter_event_name == "")) && ((!isset($filter_location)) || ($filter_location == "") || ($filter_location == "-not selected-")))
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "locations T2 ON T1.location_id = T2.location_id WHERE (T2.location_city = '$filter_city') AND (DATEDIFF(T1.event_start_date, '$filter_date') >= 0)$children_where";
		
	// No filtering
	else
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events WHERE DATEDIFF(event_start_date, '$filter_date') >= 0$children_where2 ORDER BY event_name, event_start_date";
		
//		echo $query;
		
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{		
		$events[$row['event_id']] = $row["event_name"] . " - " . $row["event_start_date"];
		echo "	events[" . $row['event_id'] . "] = '" .  addslashes($row["event_name"]) . " - " . $row["event_start_date"] . "';\n";
	}
	
	$cities = array();
	$locations = array();
	$i = 0;
	$query = "SELECT `location_id`, `city`, `location_name` FROM `" . BWB_TABLE_PREFIX . "locations` ORDER BY `city`";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_town = trim($row["city"]);
		if (!in_array($tmp_town, $cities) && ($tmp_town != ""))	{
			$cities[] = $tmp_town;
			echo "	cities[" . $i . "] = '" .  $tmp_town . "';\n";
			$i++;
		}
		$tmp_location = trim($row["location_name"]);
		if (!in_array($tmp_location, $locations) && ($tmp_location != ""))	{
			$locations[$row['location_id']] = $tmp_location;
		}
	}

	sort($cities);
	sort($locations);
?>

</script>
</head>

<body id="workspace_body" onLoad="InitializeConsole();">
<!----------------------------------------------------------------------------------------------------------------------------------------->
<!----------------------------------------------------------------------------------------------------------------------------------------->
<!----------------------------------------------------------------------------------------------------------------------------------------->
<div class="button_heading_sub_level_1" id="manage_events_heading"><div class="button_heading_text_sub_level_1"><?php echo CALENDAR_EVENTS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>

<DIV CLASS="pagebreak">
<div class="calendar_div">
<table class="calendar_table">
<tr class="calendar_tr_head">
	<td colspan="7">
    <table class="calendar_nav_table">
    	<tr>
        	<td align="left" class="calendar_td_head">
				<div onClick="ChangeMonthYear(0, -1);" class="month_year_nav_btn">
            <span class="calendar_nav_links">&lt;&lt;</span>
				</div>
            </td>
            <td align="left" class="calendar_td_head">
	          <div onClick="ChangeMonthYear(-1, 0);" class="month_year_nav_btn">
            <span class="calendar_nav_links">&lt;</span>
				</div>
            </td>
    		<td align="center" class="calendar_td_head">
	            <span class="calendar_nav_links calendar_month_year">
				<span id="head_month_name">$month_name</span>, <span id="head_year">$year_string</span>
                </span>
                <br><span class='calendar_hebrew_header'>
                <span id="head_jc_month_names">$jc_month_string - $jc_month_string_2</span><span id="hebrew_date_comma">, </span><span id="head_jc_year">$jc_year</span>
                </span>
            </td>
            <td align="right" class="calendar_td_head">
               <div onClick="ChangeMonthYear(1, 0);" class="month_year_nav_btn">
            <span class="calendar_nav_links">&gt;</span>
				</div>
            </td>
            <td align="right" class="calendar_td_head">
				<div onClick="ChangeMonthYear(0, 1);" class="month_year_nav_btn">
            <span class="calendar_nav_links">&gt;&gt;</span>
            	</div>
            </td>
    	</tr>
    </table>
    </td>
</tr>
<tr class="calendar_tr_head2">
	<td class="calendar_td_head2">S</td>
	<td class="calendar_td_head2">M</td>
	<td class="calendar_td_head2">T</td>
	<td class="calendar_td_head2">W</td>
	<td class="calendar_td_head2">T</td>
	<td class="calendar_td_head2">F</td>
	<td class="calendar_td_head2">S</td>
</tr>
<tr class="calendar_tr">
	<td class='calendar_td' id="sq_0">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_0">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_0">&nbsp;</div>
            <div id="event_0">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_1">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_1">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_1">&nbsp;</div>
            <div id="event_1">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_2">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_2">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_2">&nbsp;</div>
            <div id="event_2">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_3">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_3">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_3">&nbsp;</div>
            <div id="event_3">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_4">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_4">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_4">&nbsp;</div>
            <div id="event_4">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_5">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_5">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_5">&nbsp;</div>
            <div id="event_5">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_6">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_6">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_6">&nbsp;</div>
            <div id="event_6">&nbsp;</div>
        </div>
    </td>
</tr>
<tr class="calendar_tr">
	<td class='calendar_td' id="sq_7">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_7">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_7">&nbsp;</div>
            <div id="event_7">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_8">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_8">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_8">&nbsp;</div>
            <div id="event_8">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_9">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_9">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_9">&nbsp;</div>
            <div id="event_9">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_10">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_10">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_10">&nbsp;</div>
            <div id="event_10">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_11">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_11">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_11">&nbsp;</div>
            <div id="event_11">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_12">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_12">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_12">&nbsp;</div>
            <div id="event_12">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_13">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_13">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_13">&nbsp;</div>
            <div id="event_13">&nbsp;</div>
        </div>
    </td>
</tr>
<tr class="calendar_tr">
	<td class='calendar_td' id="sq_14">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_14">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_14">&nbsp;</div>
            <div id="event_14">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_15">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_15">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_15">&nbsp;</div>
            <div id="event_15">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_16">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_16">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_16">&nbsp;</div>
            <div id="event_16">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_17">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_17">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_17">&nbsp;</div>
            <div id="event_17">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_18">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_18">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_18">&nbsp;</div>
            <div id="event_18">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_19">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_19">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_19">&nbsp;</div>
            <div id="event_19">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_20">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_20">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_20">&nbsp;</div>
            <div id="event_20">&nbsp;</div>
        </div>
    </td>
</tr>
<tr class="calendar_tr">
	<td class='calendar_td' id="sq_21">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_21">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_21">&nbsp;</div>
            <div id="event_21">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_22">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_22">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_22">&nbsp;</div>
            <div id="event_22">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_23">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_23">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_23">&nbsp;</div>
            <div id="event_23">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_24">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_24">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_24">&nbsp;</div>
            <div id="event_24">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_25">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_25">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_25">&nbsp;</div>
            <div id="event_25">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_26">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_26">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_26">&nbsp;</div>
            <div id="event_26">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_27">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_27">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_27">&nbsp;</div>
            <div id="event_27">&nbsp;</div>
        </div>
    </td>
</tr>
<tr class="calendar_tr">
	<td class='calendar_td' id="sq_28">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_28">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_28">&nbsp;</div>
            <div id="event_28">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_29">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_29">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_29">&nbsp;</div>
            <div id="event_29">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_30">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_30">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_30">&nbsp;</div>
            <div id="event_30">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_31">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_31">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_31">&nbsp;</div>
            <div id="event_31">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_32">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_32">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_32">&nbsp;</div>
            <div id="event_32">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_33">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_33">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_33">&nbsp;</div>
            <div id="event_33">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_34">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_34">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_34">&nbsp;</div>
            <div id="event_34">&nbsp;</div>
        </div>
    </td>
</tr>
<tr class="calendar_tr" id="overflow_row">
	<td class='calendar_td' id="sq_35">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_35">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_35">&nbsp;</div>
            <div id="event_35">&nbsp;</div>
        </div>
    </td>
	<td class='calendar_td' id="sq_36">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_36">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_36">&nbsp;</div>
            <div id="event_36">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_37">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_37">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_37">&nbsp;</div>
            <div id="event_37">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_38">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_38">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_38">&nbsp;</div>
            <div id="event_38">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_39">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_39">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_39">&nbsp;</div>
            <div id="event_39">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_40">
        <div class='calendar_event'>
            <div class='calendar_day' id="day_40">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_40">&nbsp;</div>
            <div id="event_40">&nbsp;</div>
        </div>
    </td>
    <td class='calendar_td' id="sq_41">
		<div class='calendar_event'>
            <div class='calendar_day' id="day_41">&nbsp;</div><div class='calendar_hebrew' id="hebrew_day_41">&nbsp;</div>
            <div id="event_41">&nbsp;</div>
        </div>
    </td>
</tr>
</table>
<div id="show_hide_hebrew_dates_btn" onClick="ShowHideHebrewDates();" onMouseOver="ShowBtnAction();" onMouseOut="HideBtnAction();"><img src="/manage/theme/<?php echo $theme; ?>/images/icon_eye_sm_mo.png" alt="<?php echo CALENDAR_EVENTS_SHOW_HEBREW_DATES; ?>" id="show_hide_hebrew_dates_img" /><div id="btn_action_label" style="display:none;">&nbsp;</div></div>
</div>
</DIV>

<!----------------------------------------------------------------------------------------------------------------------------------------->
<!----------------------------------------------------------------------------------------------------------------------------------------->
<!----------------------------------------------------------------------------------------------------------------------------------------->

<div style="width:1140px; margin-left:auto; margin-right:auto; padding-bottom:5px;">
	<div class='button_console' id="manage_locations_btn" onClick="window.location = 'manage_locations.php';"><span class='button_console_text_w_icon'><?php echo MANAGE_LOCATIONS_BTN; ?></span></div>
    <div class='button_console' id="manage_categories_btn" onClick="EditCategories();"><span class='button_console_text_w_icon'><?php echo MANAGE_EVENT_CATEGORIES_BTN; ?></span></div>
     <div class='button_console_settings' id="edit_bat_login_btn" onClick="EditBatLogin();"><span class='button_console_text_w_icon'><?php echo EDIT_BAT_LOGIN_BTN; ?></span></div>
    <div class='button_console_add_sm' id="create_event_btn" onClick="CreateEvent('-not set-');"><span class='button_console_text_w_sm_icon'><?php echo ucfirst(NEW_WORD); ?></span></div>
    <div class='button_console_save_sm' id="edit_event_btn" onClick='EditEvent();' id="edit_btn"><span class='button_console_text_w_sm_icon'><?php echo EDIT_WORD; ?></span></div>
</div>

<div id="cloak_div">
<div id="search_btn_div">
	<img src="../../theme/<?php echo $theme; ?>/images/icon_search.png" alt="<?php echo CLOSE_WORD; ?>" onClick="EditEvent();" />
</div>
<div id="close_btn_div">
	<img src="../../theme/<?php echo $theme; ?>/images/close-button.png" alt="<?php echo CLOSE_WORD; ?>" onClick="CloseEditForm();" />
</div>
<form action="manage_events.php" id="frmFilter" method="post" name="frmFilter">
    <table id="filter_table">
     <tbody>
      <tr>
        <td colspan="3" class="sub_title"><?php echo CALENDAR_EVENTS_SELECT_FILTERING_OPTIONS; ?>:</td>
      </tr>
      <tr>
        <td><?php echo EVENT_WORD; ?>:</td>
        <td><?php echo CALENDAR_EVENTS_CITY; ?>:</td>
        <td><?php echo CALENDAR_EVENTS_LOCATION_BUSINESS; ?>:</td>
        <td><?php echo CALENDAR_EVENTS_ON_OR_AFTER; ?>:</td>
        <td><?php echo CALENDAR_EVENTS_SHOW_CHILD_EVENTS; ?> &nbsp;</td>
        <?php 
			if ($_SERVER['SERVER_NAME'] == "beearoundtown.com")
        		echo "	<td>" . CALENDAR_EVENTS_SHOW_PENDING . " &nbsp;</td>\n";
        ?>
      </tr>
      <tr>
        <td>
         <input type="text" name='filter_event_name' id='filter_event_name' onBlur="Filter();" value="<?php echo $filter_event_name; ?>" />        
        </td>
        <td>
         <select name='filter_city' id='filter_city' onChange="Filter();">
         <option value='-not selected-'><?php echo CALENDAR_EVENTS_SELECT_CITY; ?></option>
<?php
foreach ($cities as $key => $val)
{
	if ($val == $filter_city)
		echo "<option value='$val' selected='selected'>$val</option>\n";
	else
		echo "<option value='$val'>$val</option>\n";
}
?>   
          </select>                
         </td>
         <td>
         <select name='filter_location' id='filter_location' onChange="Filter();">
         <option value='-not selected-'><?php echo CALENDAR_EVENTS_SELECT_LOCATION; ?></option>
<?php
foreach ($locations as $key => $val)
{
	if ($val == $filter_location)
		echo "<option value='$val' selected='selected'>$val</option>\n";
	else
		echo "<option value='$val'>$val</option>\n";
}
?>   
          </select>                
         </td>
         <td style="position:relative;">
         <input type="date" name="filter_date" id="filter_date" onBlur="mTimer = setTimeout('Filter()', 1000);" onChange="Filter();" value="<?php echo $filter_date; ?>" />
         <div style="position:absolute; display:block; top:22px; left:0px; width:210px; height:240px;" onMouseOut="Filter();">&nbsp;</div>
         </td>
         <td>
         <input type="checkbox" name="show_children" id="show_children" <?php if ($show_children) echo "checked='checked'"; ?> onChange="Filter();" />
         <?php if ($_SERVER['SERVER_NAME'] == "beearoundtown.com")	{	?>
         </td>
         <td>
         <input type="checkbox" name="show_pending" id="show_pending" <?php if ($show_pending) echo "checked='checked'"; ?> onChange="Filter();" />
         <?php }	else	{	?>
         	<input type="hidden" name="show_pending" id="show_pending" value="0" />
         <?php }	?>
         </td>
      </tr>
     </tbody>
   </table>
</form>
<hr id="hr1" />
               
<form action="save_event.php" id="frmEvent" method="post" name="frmEvent">
   <table>
    <tbody>
       <tr id="select_event_row_1">
        <td colspan="2" class="sub_title"><?php echo CALENDAR_EVENTS_SELECT_EVENT; ?>:</td>
      </tr>
      <tr id="select_event_row_2">
        <td colspan="2">
          <select name='select_event' id='select_event' onChange="SelectEvent(this.value); document.getElementById('search_btn_div').style.display = 'block';">
          <option value=''><?php echo _NOT_SELECTED_; ?></option>
<?php
foreach ($events as $key => $val)
{
	$val = str_replace("&#39;", "'", stripslashes($val));
	if ($event_id == $val)
		echo "<option value='$key' selected='selected'>$val</option>\n";
	else
		echo "<option value='$key'>$val</option>\n";
}
?>
          </select>
         </td>
        </tr>
        <tr><td colspan="2" class="sub_title" style="display:none;" id="select_event_row_3"><?php echo CALENDAR_EVENTS_CREATE_NEW_EVENT; ?>:</td></tr>
       </tbody>
     </table>
     <hr class="form_divider" />
     <table id="edit_table">
       <tbody>
        <tr id="event_categories_heading_row">
          <td colspan="2" class="bold">
            &nbsp;<?php echo CALENDAR_EVENTS_CATEGORIES; ?>
          </td>
        </tr>
        <tr id="event_categories_row">
            <td colspan="2">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td id="event_categories_cell">&nbsp;
                        
                        </td>
                    </tr>
                </tbody>
            </table>
         </td>
        </tr>
        <tr>
          <td colspan="2">
           <table width="100%" border="0"><tr>
            <td><strong><span style="color:#FF0000;">*</span></strong> <span class="bold"><?php echo CALENDAR_EVENTS_EVENT_NAME; ?></span>:</td>
            <td><input name="event_name" id="event_name" style="width:400px;" type="text" /> <span class="small_message">(<?php echo CALENDAR_EVENTS_EXAMPLE; ?>)</span></td>
            </tr></table>
          </td>
        </tr>
        <tr>
            <td colspan="2">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td class="bold"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_EVENT_DATE; ?>: </td>
                        <td width="200"><input id="event_start_date" name="event_start_date" type="date" /></td>
                        <td><?php echo CALENDAR_EVENTS_IS_RECURRING_EVENT; ?> <input id="recurrence" name="recurrence" onClick="ShowHideRecurring(this);" type="checkbox" value="1" /> <?php echo YES_WORD; ?></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td colspan="2">
            <div class="dashed_border" id="recurring_event_block">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td width="150"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_END_DATE; ?>: </td>
                        <td colspan="2"><input id="event_end_date" name="event_end_date" type="date" /></td>
                    </tr>
                    <tr>
                       <td><?php echo CALENDAR_EVENTS_THIS_EVENT_REPEATS; ?>:</td>
                       <td>
                        <select id="recurrence_freq" name="recurrence_freq" onChange="ShowHideRecurrenceRows(this.value);">
                        <option selected="selected" value="daily"><?php echo CALENDAR_EVENTS_DAILY; ?></option>
                        <option value="weekly"><?php echo CALENDAR_EVENTS_WEEKLY; ?></option>
                        <option value="monthly"><?php echo CALENDAR_EVENTS_MONTHLY; ?></option>
                        <option value="yearly"><?php echo CALENDAR_EVENTS_YEARLY; ?></option>
                        </select>
                       </td>
                    </tr>
                    <!--
                    <tr>
                        <td class="bold">Each Event Lasts:</td>
                        <td><input id="recurrence_interval" name="recurrence_interval" size="10" type="text" /> <span id="recurrence_units">day(s)</span></td>
                    </tr>
                    -->
                    <tr id="recurrence_weekly_row" style="display:none;">
                        <td colspan="2" width="100%">
                        <input name="recurrence_bydays" value="1" type="checkbox"> <?php echo CALENDAR_EVENTS_MON; ?>&nbsp; <input name="recurrence_bydays" value="2" type="checkbox"> <?php echo CALENDAR_EVENTS_TUE; ?>&nbsp; <input name="recurrence_bydays" value="3" type="checkbox"> <?php echo CALENDAR_EVENTS_WED; ?>&nbsp; <input name="recurrence_bydays" value="4" type="checkbox"> <?php echo CALENDAR_EVENTS_THU; ?>&nbsp; <input name="recurrence_bydays" value="5" type="checkbox"> <?php echo CALENDAR_EVENTS_FRI; ?>&nbsp; <input name="recurrence_bydays" value="6" type="checkbox"> <?php echo CALENDAR_EVENTS_SAT; ?>&nbsp; <input name="recurrence_bydays" value="0" type="checkbox"> <?php echo CALENDAR_EVENTS_SUN; ?>&nbsp; 		
                        </td>
                    </tr>
                    <tr id="recurrence_monthly_row" style="display:none;">
                    <td colspan="2">
                    <select id="recurrence_byweekno" name="recurrence_byweekno">
                        <option value="1"><?php echo CALENDAR_EVENTS_FIRST; ?></option>
                        <option value="2"><?php echo CALENDAR_EVENTS_SECOND; ?></option>
                        <option value="3"><?php echo CALENDAR_EVENTS_THIRD; ?></option>
                        <option value="4"><?php echo CALENDAR_EVENTS_FOURTH; ?></option>
                        <option value="5"><?php echo CALENDAR_EVENTS_LAST; ?></option>
                    </select>
                    <select id="recurrence_byday" name="recurrence_byday">
                        <option value="1"><?php echo CALENDAR_EVENTS_MON; ?></option>
                        <option value="2"><?php echo CALENDAR_EVENTS_TUE; ?></option>
                        <option value="3"><?php echo CALENDAR_EVENTS_WED; ?></option>
                        <option value="4"><?php echo CALENDAR_EVENTS_THU; ?></option>
                        <option value="5"><?php echo CALENDAR_EVENTS_FRI; ?></option>
                        <option value="6"><?php echo CALENDAR_EVENTS_SAT; ?></option>
                        <option value="0" selected="selected"><?php echo CALENDAR_EVENTS_SUN; ?></option>
                    </select>
					of each month
                    </td>
                 </tr>
                 <tr id="recurrence_yearly_row" style="display:none;">
                    <td colspan="2">
                        <?php echo CALENDAR_EVENTS_EACH_EVENT_SPANS_DAYS_1; ?> <input id="recurrence_days" size="8" maxlength="8" name="recurrence_days" value="0" type="text"> <?php echo CALENDAR_EVENTS_EACH_EVENT_SPANS_DAYS_2; ?>
                    </td>
                 </tr>
                </tbody>
               </table>
             </div>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="bold"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_EVENT_TIME; ?>: </td>
        </tr>
        <tr>
            <td colspan="2">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td colspan="2"><?php echo CALENDAR_EVENTS_START_TIME; ?>:</td>
                        <td colspan="2"><?php echo CALENDAR_EVENTS_END_TIME; ?>:</td>
                    </tr>
                    <tr>
                        <td width="190">
                        <select id="event_start_time_hrs" name="event_start_time_hrs" onChange="BuildTimeStr('event_start_time_hrs', 'event_start_time_min', 'event_start_time_ampm', 'event_start_time');">
                        	<option value="1">01</option>
                            <option value="2">02</option>
                            <option value="3">03</option>
                            <option value="4">04</option>
                            <option value="5">05</option>
                            <option value="6">06</option>
                            <option value="7">07</option>
                            <option value="8">08</option>
                            <option value="9">09</option>
                            <option value="10">10</option>
                            <option value="11">11</option>
                            <option value="12">12</option>
                        </select>
                            :
                        <select id="event_start_time_min" name="event_start_time_min" onChange="BuildTimeStr('event_start_time_hrs', 'event_start_time_min', 'event_start_time_ampm', 'event_start_time');">
                        	<option value="00">00</option>
                            <option value="15">15</option>
                            <option value="30">30</option>
                            <option value="45">45</option>
                        </select>
                        <select id="event_start_time_ampm" name="event_start_time_ampm" onChange="BuildTimeStr('event_start_time_hrs', 'event_start_time_min', 'event_start_time_ampm', 'event_start_time');">
                        	<option value="am"><?php echo CALENDAR_EVENTS_AM; ?></option>
                            <option value="pm"><?php echo CALENDAR_EVENTS_PM; ?></option>
                        </select>
                        <input id="event_start_time" name="event_start_time" type="hidden" />
                        </td>
                        <td align="center" width="70"><?php echo TO_WORD; ?></td>
                        <td width="190">
                        <select id="event_end_time_hrs" name="event_end_time_hrs" onChange="BuildTimeStr('event_end_time_hrs', 'event_end_time_min', 'event_end_time_ampm', 'event_end_time');">
                        	<option value="1">01</option>
                            <option value="2">02</option>
                            <option value="3">03</option>
                            <option value="4">04</option>
                            <option value="5">05</option>
                            <option value="6">06</option>
                            <option value="7">07</option>
                            <option value="8">08</option>
                            <option value="9">09</option>
                            <option value="10">10</option>
                            <option value="11">11</option>
                            <option value="12">12</option>
                        </select>
                            :
                        <select id="event_end_time_min" name="event_end_time_min" onChange="BuildTimeStr('event_end_time_hrs', 'event_end_time_min', 'event_end_time_ampm', 'event_end_time');">
                        	<option value="00">00</option>
                            <option value="15">15</option>
                            <option value="30">30</option>
                            <option value="45">45</option>
                        </select>
                        <select id="event_end_time_ampm" name="event_end_time_ampm" onChange="BuildTimeStr('event_end_time_hrs', 'event_end_time_min', 'event_end_time_ampm', 'event_end_time');">
                        	<option value="am"><?php echo CALENDAR_EVENTS_AM; ?></option>
                            <option value="pm"><?php echo CALENDAR_EVENTS_PM; ?></option>
                        </select>
                        <input id="event_end_time" name="event_end_time"type="hidden" />
                        </td>
                        <td><input id="event_all_day" name="event_all_day" type="checkbox" value="1" /> <?php echo CALENDAR_EVENTS_ALL_DAY_EVENT; ?></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td class="bold" colspan="2"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_LOCATION; ?>: </td>
        </tr>
        <tr>
            <td colspan="2"><em><?php echo CALENDAR_EVENTS_TYPING_LOCATION_SEARCH_1; ?> <a style="cursor:pointer; text-decoration:underline;" onClick="CheckSearchResults('link');"><?php echo CALENDAR_EVENTS_TYPING_LOCATION_SEARCH_2; ?></a>.</em></td>
        </tr>
        <tr>
          <td colspan="2">
           <table border="0" width="100%">
            <tr>
            <td>
            <div id="location_search_div">
            <div id="child_search_div"><input id="location_search" name="location_name" onBlur="CheckSearchResults('name');" onKeyPress="SearchLocations(this.value, event);" size="50" type="text" AUTOCOMPLETE="OFF" /></div>
            </div>
            <input id="location_id" name="location_id" type="hidden" />
            </td>
            <td>
            <!--<select name='filter_city_location_search' id='filter_city_location_search' onChange="FilterLocationSearch();" onblur="CheckSearchResults();">-->
            <select name='filter_city_location_search' id='filter_city_location_search' onBlur="CheckSearchResults('city');">
         	<option value='-not selected-'><?php echo CALENDAR_EVENTS_SELECT_CITY; ?></option>
<?php
foreach ($cities as $key => $val)
{
	if ($val == $filter_city)
		echo "<option value='$val' selected='selected'>$val</option>\n";
	else
		echo "<option value='$val'>$val</option>\n";
}
?>
          	</select>      
            </td>
            <td id="search_result"><?php echo CALENDAR_EVENTS_LOCATION_NOT_FOUND; ?></td>
           </tr>
          </table>
         </td>
        </tr>
        <tr>
            <td colspan="2">
            <div class="dashed_border" id="new_location_block">
            <div id="child_div">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td colspan="2"><span class="mail_form_large_text"><?php echo CALENDAR_EVENTS_CREATE_NEW_LOCATION; ?>: </span></td>
                    </tr>
                    <tr>
                        <td><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_BUSINESS_NAME; ?>: </td>
                        <td><input id="location_location_name" name="location_name" type="text" style="width:320px;" onFocus="MoveLocationName();" /></td>
                    </tr>
                    <tr>
                        <td><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_BUSINESS_ADDRESS; ?>: </td>
                        <td><input id="location_address" name="address" style="width:320px;" type="text" /></td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                        <td><input id="location_address2" name="address2" style="width:320px;" type="text" /></td>
                    </tr>
                    <tr>
                        <td style="vertical-align:top;"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_CITY; ?>: </td>
                        <td>
                        <select id="city_select" name="city_select" size="1" onChange="document.getElementById('location_city').value = this.value;">
                        <option><?php echo _NOT_SELECTED_; ?></option>
<?php
foreach ($cities as $key => $val)
{
	if (isset($val) &&($val != "") && ($val != " "))
		echo "			<option value='$val'>$val</option>\n";
}
?>  
                        </select>
                        <br />
                        <input id="location_city" name="city" style="width:320px;" type="text" />
                      	</td>
                    </tr>
                    <tr>
                        <td style="vertical-align:top;"><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_STATE; ?>: </td>
                        <td>
                        	<select name="state_select" id="state_select" onChange="document.getElementById('location_state').value = this.value;">
                            <option><?php echo _NOT_SELECTED_; ?></option>
                            <option value="AL">Alabama</option>
                            <option value="AK">Alaska</option>
                            <option value="AZ">Arizona</option>
                            <option value="AR">Arkansas</option>
                            <option value="CA">California</option>
                            <option value="CO">Colorado</option>
                            <option value="CT">Connecticut</option>
                            <option value="DE">Delaware</option>
                            <option value="DC">Dist of Columbia</option>
                            <option value="FL">Florida</option>
                            <option value="GA">Georgia</option>
                            <option value="HI">Hawaii</option>
                            <option value="ID">Idaho</option>
                            <option value="IL">Illinois</option>
                            <option value="IN">Indiana</option>
                            <option value="IA">Iowa</option>
                            <option value="KS">Kansas</option>
                            <option value="KY">Kentucky</option>
                            <option value="LA">Louisiana</option>
                            <option value="ME">Maine</option>
                            <option value="MD">Maryland</option>
                            <option value="MA">Massachusetts</option>
                            <option value="MI">Michigan</option>
                            <option value="MN">Minnesota</option>
                            <option value="MS">Mississippi</option>
                            <option value="MO">Missouri</option>
                            <option value="MT">Montana</option>
                            <option value="NE">Nebraska</option>
                            <option value="NV">Nevada</option>
                            <option value="NH">New Hampshire</option>
                            <option value="NJ">New Jersey</option>
                            <option value="NM">New Mexico</option>
                            <option value="NY">New York</option>
                            <option value="NC">North Carolina</option>
                            <option value="ND">North Dakota</option>
                            <option value="OH">Ohio</option>
                            <option value="OK">Oklahoma</option>
                            <option value="OR">Oregon</option>
                            <option value="PA">Pennsylvania</option>
                            <option value="RI">Rhode Island</option>
                            <option value="SC">South Carolina</option>
                            <option value="SD">South Dakota</option>
                            <option value="TN">Tennessee</option>
                            <option value="TX">Texas</option>
                            <option value="UT">Utah</option>
                            <option value="VT">Vermont</option>
                            <option value="VA">Virginia</option>
                            <option value="WA">Washington</option>
                            <option value="WV">West Virginia</option>
                            <option value="WI">Wisconsin</option>
                            <option value="WY">Wyoming</option>
                            </select>
                            <br />
			              <input id="location_state" name="state" style="width:320px;" type="text" />
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align:top;">&nbsp; <?php echo CALENDAR_EVENTS_COUNTRY; ?>: </td>
                        <td>
                            <select name="country_select" id="country_select" onChange="document.getElementById('location_country').value = this.value;">
                                <option value=""><?php echo _NOT_SELECTED_; ?></option>
                                <option value="AF">Afghanistan</option>
                                <option value="AL">Albania</option>
                                <option value="DZ">Algeria</option>
                                <option value="AS">American Samoa</option>
                                <option value="AD">Andorra</option>
                                <option value="AG">Angola</option>
                                <option value="AI">Anguilla</option>
                                <option value="AG">Antigua &amp; Barbuda</option>
                                <option value="AR">Argentina</option>
                                <option value="AA">Armenia</option>
                                <option value="AW">Aruba</option>
                                <option value="AU">Australia</option>
                                <option value="AT">Austria</option>
                                <option value="AZ">Azerbaijan</option>
                                <option value="BS">Bahamas</option>
                                <option value="BH">Bahrain</option>
                                <option value="BD">Bangladesh</option>
                                <option value="BB">Barbados</option>
                                <option value="BY">Belarus</option>
                                <option value="BE">Belgium</option>
                                <option value="BZ">Belize</option>
                                <option value="BJ">Benin</option>
                                <option value="BM">Bermuda</option>
                                <option value="BT">Bhutan</option>
                                <option value="BO">Bolivia</option>
                                <option value="BL">Bonaire</option>
                                <option value="BA">Bosnia &amp; Herzegovina</option>
                                <option value="BW">Botswana</option>
                                <option value="BR">Brazil</option>
                                <option value="BC">British Indian Ocean Ter</option>
                                <option value="BN">Brunei</option>
                                <option value="BG">Bulgaria</option>
                                <option value="BF">Burkina Faso</option>
                                <option value="BI">Burundi</option>
                                <option value="KH">Cambodia</option>
                                <option value="CM">Cameroon</option>
                                <option value="CA">Canada</option>
                                <option value="IC">Canary Islands</option>
                                <option value="CV">Cape Verde</option>
                                <option value="KY">Cayman Islands</option>
                                <option value="CF">Central African Republic</option>
                                <option value="TD">Chad</option>
                                <option value="CD">Channel Islands</option>
                                <option value="CL">Chile</option>
                                <option value="CN">China</option>
                                <option value="CI">Christmas Island</option>
                                <option value="CS">Cocos Island</option>
                                <option value="CO">Colombia</option>
                                <option value="CC">Comoros</option>
                                <option value="CG">Congo</option>
                                <option value="CK">Cook Islands</option>
                                <option value="CR">Costa Rica</option>
                                <option value="CT">Cote D'Ivoire</option>
                                <option value="HR">Croatia</option>
                                <option value="CU">Cuba</option>
                                <option value="CB">Curacao</option>
                                <option value="CY">Cyprus</option>
                                <option value="CZ">Czech Republic</option>
                                <option value="DK">Denmark</option>
                                <option value="DJ">Djibouti</option>
                                <option value="DM">Dominica</option>
                                <option value="DO">Dominican Republic</option>
                                <option value="TM">East Timor</option>
                                <option value="EC">Ecuador</option>
                                <option value="EG">Egypt</option>
                                <option value="SV">El Salvador</option>
                                <option value="GQ">Equatorial Guinea</option>
                                <option value="ER">Eritrea</option>
                                <option value="EE">Estonia</option>
                                <option value="ET">Ethiopia</option>
                                <option value="FA">Falkland Islands</option>
                                <option value="FO">Faroe Islands</option>
                                <option value="FJ">Fiji</option>
                                <option value="FI">Finland</option>
                                <option value="FR">France</option>
                                <option value="GF">French Guiana</option>
                                <option value="PF">French Polynesia</option>
                                <option value="FS">French Southern Ter</option>
                                <option value="GA">Gabon</option>
                                <option value="GM">Gambia</option>
                                <option value="GE">Georgia</option>
                                <option value="DE">Germany</option>
                                <option value="GH">Ghana</option>
                                <option value="GI">Gibraltar</option>
                                <option value="GB">Great Britain</option>
                                <option value="GR">Greece</option>
                                <option value="GL">Greenland</option>
                                <option value="GD">Grenada</option>
                                <option value="GP">Guadeloupe</option>
                                <option value="GU">Guam</option>
                                <option value="GT">Guatemala</option>
                                <option value="GN">Guinea</option>
                                <option value="GY">Guyana</option>
                                <option value="HT">Haiti</option>
                                <option value="HW">Hawaii</option>
                                <option value="HN">Honduras</option>
                                <option value="HK">Hong Kong</option>
                                <option value="HU">Hungary</option>
                                <option value="IS">Iceland</option>
                                <option value="IN">India</option>
                                <option value="ID">Indonesia</option>
                                <option value="IA">Iran</option>
                                <option value="IQ">Iraq</option>
                                <option value="IR">Ireland</option>
                                <option value="IM">Isle of Man</option>
                                <option value="IL">Israel</option>
                                <option value="IT">Italy</option>
                                <option value="JM">Jamaica</option>
                                <option value="JP">Japan</option>
                                <option value="JO">Jordan</option>
                                <option value="KZ">Kazakhstan</option>
                                <option value="KE">Kenya</option>
                                <option value="KI">Kiribati</option>
                                <option value="NK">Korea North</option>
                                <option value="KS">Korea South</option>
                                <option value="KW">Kuwait</option>
                                <option value="KG">Kyrgyzstan</option>
                                <option value="LA">Laos</option>
                                <option value="LV">Latvia</option>
                                <option value="LB">Lebanon</option>
                                <option value="LS">Lesotho</option>
                                <option value="LR">Liberia</option>
                                <option value="LY">Libya</option>
                                <option value="LI">Liechtenstein</option>
                                <option value="LT">Lithuania</option>
                                <option value="LU">Luxembourg</option>
                                <option value="MO">Macau</option>
                                <option value="MK">Macedonia</option>
                                <option value="MG">Madagascar</option>
                                <option value="MY">Malaysia</option>
                                <option value="MW">Malawi</option>
                                <option value="MV">Maldives</option>
                                <option value="ML">Mali</option>
                                <option value="MT">Malta</option>
                                <option value="MH">Marshall Islands</option>
                                <option value="MQ">Martinique</option>
                                <option value="MR">Mauritania</option>
                                <option value="MU">Mauritius</option>
                                <option value="ME">Mayotte</option>
                                <option value="MX">Mexico</option>
                                <option value="MI">Midway Islands</option>
                                <option value="MD">Moldova</option>
                                <option value="MC">Monaco</option>
                                <option value="MN">Mongolia</option>
                                <option value="MS">Montserrat</option>
                                <option value="MA">Morocco</option>
                                <option value="MZ">Mozambique</option>
                                <option value="MM">Myanmar</option>
                                <option value="NA">Nambia</option>
                                <option value="NU">Nauru</option>
                                <option value="NP">Nepal</option>
                                <option value="AN">Netherland Antilles</option>
                                <option value="NL">Netherlands (Holland, Europe)</option>
                                <option value="NV">Nevis</option>
                                <option value="NC">New Caledonia</option>
                                <option value="NZ">New Zealand</option>
                                <option value="NI">Nicaragua</option>
                                <option value="NE">Niger</option>
                                <option value="NG">Nigeria</option>
                                <option value="NW">Niue</option>
                                <option value="NF">Norfolk Island</option>
                                <option value="NO">Norway</option>
                                <option value="OM">Oman</option>
                                <option value="PK">Pakistan</option>
                                <option value="PW">Palau Island</option>
                                <option value="PS">Palestine</option>
                                <option value="PA">Panama</option>
                                <option value="PG">Papua New Guinea</option>
                                <option value="PY">Paraguay</option>
                                <option value="PE">Peru</option>
                                <option value="PH">Philippines</option>
                                <option value="PO">Pitcairn Island</option>
                                <option value="PL">Poland</option>
                                <option value="PT">Portugal</option>
                                <option value="PR">Puerto Rico</option>
                                <option value="QA">Qatar</option>
                                <option value="ME">Republic of Montenegro</option>
                                <option value="RS">Republic of Serbia</option>
                                <option value="RE">Reunion</option>
                                <option value="RO">Romania</option>
                                <option value="RU">Russia</option>
                                <option value="RW">Rwanda</option>
                                <option value="NT">St Barthelemy</option>
                                <option value="EU">St Eustatius</option>
                                <option value="HE">St Helena</option>
                                <option value="KN">St Kitts-Nevis</option>
                                <option value="LC">St Lucia</option>
                                <option value="MB">St Maarten</option>
                                <option value="PM">St Pierre &amp; Miquelon</option>
                                <option value="VC">St Vincent &amp; Grenadines</option>
                                <option value="SP">Saipan</option>
                                <option value="SO">Samoa</option>
                                <option value="AS">Samoa American</option>
                                <option value="SM">San Marino</option>
                                <option value="ST">Sao Tome &amp; Principe</option>
                                <option value="SA">Saudi Arabia</option>
                                <option value="SN">Senegal</option>
                                <option value="SC">Seychelles</option>
                                <option value="SL">Sierra Leone</option>
                                <option value="SG">Singapore</option>
                                <option value="SK">Slovakia</option>
                                <option value="SI">Slovenia</option>
                                <option value="SB">Solomon Islands</option>
                                <option value="OI">Somalia</option>
                                <option value="ZA">South Africa</option>
                                <option value="ES">Spain</option>
                                <option value="LK">Sri Lanka</option>
                                <option value="SD">Sudan</option>
                                <option value="SR">Suriname</option>
                                <option value="SZ">Swaziland</option>
                                <option value="SE">Sweden</option>
                                <option value="CH">Switzerland</option>
                                <option value="SY">Syria</option>
                                <option value="TA">Tahiti</option>
                                <option value="TW">Taiwan</option>
                                <option value="TJ">Tajikistan</option>
                                <option value="TZ">Tanzania</option>
                                <option value="TH">Thailand</option>
                                <option value="TG">Togo</option>
                                <option value="TK">Tokelau</option>
                                <option value="TO">Tonga</option>
                                <option value="TT">Trinidad &amp; Tobago</option>
                                <option value="TN">Tunisia</option>
                                <option value="TR">Turkey</option>
                                <option value="TU">Turkmenistan</option>
                                <option value="TC">Turks &amp; Caicos Is</option>
                                <option value="TV">Tuvalu</option>
                                <option value="UG">Uganda</option>
                                <option value="UA">Ukraine</option>
                                <option value="AE">United Arab Emirates</option>
                                <option value="GB">United Kingdom</option>
                                <option value="US">United States of America</option>
                                <option value="UY">Uruguay</option>
                                <option value="UZ">Uzbekistan</option>
                                <option value="VU">Vanuatu</option>
                                <option value="VS">Vatican City State</option>
                                <option value="VE">Venezuela</option>
                                <option value="VN">Vietnam</option>
                                <option value="VB">Virgin Islands (Brit)</option>
                                <option value="VA">Virgin Islands (USA)</option>
                                <option value="WK">Wake Island</option>
                                <option value="WF">Wallis &amp; Futana Is</option>
                                <option value="YE">Yemen</option>
                                <option value="ZR">Zaire</option>
                                <option value="ZM">Zambia</option>
                                <option value="ZW">Zimbabwe</option>
                                </select>
                            <br />
                          <input id="location_country" name="country" style="width:320px;" type="text" />
                        </td>
                    </tr>
                    <tr>
                        <td><strong><span style="color:#FF0000;">*</span></strong> <?php echo CALENDAR_EVENTS_ZIP_CODE; ?>: </td>
                        <td><input id="location_postal_code" name="postal_code" style="width:80px;" type="text" /></td>
                    </tr>
                    <tr>
                        <td>&nbsp;&nbsp; <?php echo CALENDAR_EVENTS_BIZ_PHONE; ?>: </td>
                        <td><input id="location_phone" name="phone" type="text" style="width:140px;" /></td>
                    </tr>                    
                    <tr>
                        <td>&nbsp;&nbsp; <?php echo CALENDAR_EVENTS_WEB_ADDRESS; ?>: </td>
                        <td><input id="location_website" name="website" style="width:320px;" type="text" /></td>
                    </tr>
                    <tr>
                        <td>&nbsp;&nbsp; <?php echo CALENDAR_EVENTS_WEB_ADDRESS_TEXT; ?>: </td>
                        <td><input id="location_web_link_text" name="web_link_text" style="width:320px;" type="text" /></td>
                    </tr>
                    <tr>
                        <td>&nbsp;&nbsp; <?php echo CALENDAR_EVENTS_EMAIL; ?>: </td>
                        <td><input id="location_email" name="email" style="width:320px;" type="text" /></td>
                    </tr>
                    <tr id="location_categories_row">
                        <td>&nbsp;&nbsp; <?php echo CALENDAR_EVENTS_CATEGORIES; ?>: </td>
                        <td id="location_categories_cell">&nbsp;</td>
                    </tr>
                </tbody>
            </table>
            </div>
            </div>
            </td>
        </tr>
        <tr>
            <td class="bold" colspan="2">&nbsp;&nbsp;  <?php echo CALENDAR_EVENTS_EVENT_DESCRIPTION; ?>: </td>
        </tr>
        <tr>
            <td colspan="2" bgcolor="#FFFFFF" onClick="mTimer3 = setTimeout('CheckSearchResultsAgain();', 2000);"><textarea name="event_description" id="event_description" rows="5" style="width:100%;"></textarea></td>
        </tr>
        <tr>
        	<td colspan="2">
                <table width="100%">
                <tr>
                 <td class="bold" style="width:25%; text-align:right;"><?php echo ACTIVE_WORD; ?>: </td>
                <td style="width:25%;"><input type="checkbox" name="event_active" id="event_active" value="1" /></td>
                <td class="bold" style="text-align:right;"><?php echo CALENDAR_EVENTS_PRIVATE; ?>: </td>
                <td>
                <input type="checkbox" name="event_private" id="event_private" value="1" />
                <?php	if ($_SERVER['SERVER_NAME'] == "beearoundtown.com")	{	?>
                </td>
                <td class="bold" style="width:25%; text-align:right;"><?php echo STATUS_WORD; ?>: </td>
                <td style="width:25%;">
                <select name="event_status" id="event_status">
                <option value="0"><?php echo PENDING_WORD; ?></option>
                <option value="1"><?php echo PUBLISHED_WORD; ?></option>
                <option value="-1"><?php echo DECLINED_WORD; ?></option>
                </select>
                <?php }	else	{	?>
                <input type="hidden" name="event_status" id="event_status" value="0" />
                <?php }	?>
                </td>
                </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td colspan="2">
            <table border="0" width="100%">
                <tbody>
                    <tr>
                        <td align="left" width="120">
                        <div class='button_console_delete_sm' style='width:100px;' onClick="DeleteConfirm('single', '-from edit form-', '-from edit form-');" id="delete_btn"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_DELETE; ?></span></div>
                        </td>
                        <td align="left">
                        <div class='button_console_delete_sm' style='width:120px;' onClick="DeleteConfirm('group', '-from edit form-', '-from edit form-');" id="delete_group_btn"><span class='button_console_text_w_sm_icon'><?php echo CALENDAR_EVENTS_DELETE_GROUP; ?></span></div>
                        </td>
                        <td align="right">
                        <div class='button_console_save_sm' style='width:100px;' onclick='SaveEvent(false);' id="save_btn"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_SAVE; ?></span></div>
                        </td>
                        <td align="right">
                        <div class='button_console_save_sm' style='width:170px;' onclick='SaveEvent(true);' id="save_close_btn"><span class='button_console_text_w_sm_icon'><?php echo CALENDAR_EVENTS_SAVE_AND_CLOSE; ?></span></div>
                        </td>
                         <td align="right">
                        <div class='button_console_save_sm' style='width:210px;' onclick='SaveEventToBat();' id="save_to_bat_btn"><span class='button_console_text_w_sm_icon'><?php echo CALENDAR_EVENTS_SAVE_TO_BAT; ?></span></div>
                        </td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
    </tbody>
</table>
<input type="hidden" name="event_id" id="event_id" value="<?php echo $event_id; ?>" />
<input id="group_id" name="group_id" type="hidden" />
<input id="event_categories" name="event_categories" type="hidden" />
<input type="hidden" name="event_owner" id="event_owner" value="<?php echo $userid; ?>" />
</form>
</div>

<div id="edit_bat_login_frm_div">
<form name="frmBATLogin" id="frmBATLogin" action="save_bat_login.php" method="post">
<table>
	<tr><td colspan="2" style="text-align:justify; padding-bottom:20px;"><?php echo CALENDAR_EVENTS_BAT_LOGIN_FRM_INFO; ?></td></tr>
	<tr><td style="text-align:right;"><?php echo CALENDAR_EVENTS_BAT_USERID; ?>: </td><td><input type="text" name="user_name" id="user_name" /></td></tr>
    <tr><td style="text-align:right;"><?php echo PASSWORD_WORD; ?>: </td><td><input type="password" name="password" id="password" /></td></tr>
    <tr><td colspan="2"><div class='button_console_save_sm' onclick='SaveBATLogin();' id="save_bat_login_btn"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_SAVE; ?></span></div></td></tr>
</table>
<div id="close_btn_div_bat_login"><img src="../../theme/<?php echo $theme; ?>/images/close-button.png" alt="<?php echo CLOSE_WORD; ?>" onClick="document.getElementById('edit_bat_login_frm_div').style.display = 'none';" /></div>
</form>
</div>

<?php
include("location_info.html");
include("../../lib/popup_msg.html");
?>

</body>
</html>