////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	2/6/2021	ELL
// 

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ReadGetVar(variable)
{
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	   var pair = vars[i].split("=");
	   if(pair[0] == variable)	{
		   return pair[1];
	   }
	}
	return("");
}

function replaceAll(txt, search_str, replace_str) {
	return txt.replace(new RegExp(search_str, 'g'),replace_str);
}

function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else if ((document.getElementsByName(el) != null) && (typeof document.getElementsByName(el) != "undefined") && (document.getElementsByName(el).length > 0))
		return document.getElementsByName(el).length;
	else
		return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{
	document.getElementById("frmMailForm").action = "save_form_record.php";
	
	document.getElementById("recaptcha_row").innerHTML = "";
	document.getElementById("recaptcha2_row").innerHTML = "";
	document.getElementById("mollomcaptcha_row").innerHTML = "";
	
	var address_block = document.getElementsByClassName("address_block");
	address_block[0].innerHTML = "";
	
	var mail_form_headings = document.getElementsByClassName("mail_form_heading");
	for (var i in mail_form_headings)	{
		mail_form_headings[i].innerHTML = "";
	}
	
	document.getElementById("submit_btn").style.display = "none";
	document.getElementById("form_btn_txt").innerHTML = mode;
	
	///////////////////////////////////////////////////
	// Set class on required fields to .required_field
	var use_classic_required_field_marks = 0;
	if (ElExists("use_classic_required_field_marks"))
		use_classic_required_field_marks = document.getElementById("use_classic_required_field_marks").value;
		
	var required_fields_str = document.getElementById("required_fields").value;
	var required_fields = required_fields_str.split(",");
	var field_name, required_mark_id;
	for (i = 0; i < required_fields.length; i++)
	{
		field_name = required_fields[i].trim();
		required_mark_id = "required_mark_" + field_name;
		if (field_name != "")
		{
			if (use_classic_required_field_marks != 1)
			{
				if (ElExists(field_name) === true)
					document.getElementById(field_name).className = document.getElementById(field_name).className + " required_field";
				else if ((document.getElementsByName(field_name) != null) && (typeof document.getElementsByName(field_name) != "undefined"))	{
					if ((document.getElementsByName(field_name).item(0).type != null) && (typeof document.getElementsByName(field_name).item(0).type != "undefined") && (document.getElementsByName(field_name).item(0).type == "radio"))	{
						if (ElExists(field_name + "_div") === true)
							document.getElementById(field_name + "_div").className = document.getElementById(field_name + "_div").className + " required_field";
					}
				}
	
				if (ElExists(field_name) === true)	{
					if ((document.getElementById(field_name).type != null) && (typeof document.getElementById(field_name).type != "undefined") && (document.getElementById(field_name).type == "checkbox"))	{
						if (ElExists(field_name + "_div" === true))
							document.getElementById(field_name + "_div").className = document.getElementById(field_name + "_div").className + " required_field";
					}
				}
			}
			
			if ((ElExists(required_mark_id) === true) && (use_classic_required_field_marks > 0))
				document.getElementById(required_mark_id).innerHTML = "*";
		}
	}
	if ((ElExists("email_required") === true) && (document.getElementById("email_required").value == 1))	{
		if (use_classic_required_field_marks != 1)	{
			if (ElExists('email') === true)
				document.getElementById("email").className = document.getElementById("email").className + " required_field";
			if (ElExists('email_confirm') === true)
				document.getElementById("email_confirm").className = document.getElementById("email_confirm").className + " required_field";
		}
		if (use_classic_required_field_marks > 0)	{
			if (ElExists('required_mark_email') === true)
				document.getElementById("required_mark_email").innerHTML = "*";
			if (ElExists('required_mark_email_confirm') === true)
				document.getElementById("required_mark_email_confirm").innerHTML = "*";
		}
	}
	if ((ElExists("password_required") === true) && (document.getElementById("password_required").value == 1))	{
		if (use_classic_required_field_marks != 1)	{
			if (ElExists('password') === true)
				document.getElementById("password").className = document.getElementById("password").className + " required_field";
			if (ElExists('password_confirm') === true)
				document.getElementById("password_confirm").className = document.getElementById("password_confirm").className + " required_field";
		}
		if (use_classic_required_field_marks > 0)	{
			if (ElExists('required_mark_password') === true)
				document.getElementById("required_mark_password").innerHTML = "*";
			if (ElExists('required_mark_password_confirm') === true)
				document.getElementById("required_mark_password_confirm").innerHTML = "*";
		}
	}
	
	// Clear all hard-coded required asteriks for non-required fields.
	if (document.getElementsByClassName("required_mark").length > 0)	{
		var required_mark_el = document.getElementsByClassName("required_mark");
		var required_mark_id, field_name;
		for (i = 0; i < required_mark_el.length; i++)
		{
			if (typeof required_mark_el[i] !== 'undefined')	{
				required_mark_id = required_mark_el[i].id;
				if ((typeof required_mark_id !== 'undefined') && (required_mark_id != ""))	{
					field_name = required_mark_id.replace("required_mark_", "");
					if (required_fields.indexOf(field_name) < 0)
						required_mark_el[i].innerHTML = "";
					if (((field_name == "email") || (field_name == "email_confirm")) && (ElExists("email_required") === true) && (document.getElementById("email_required").value == 1))
						required_mark_el[i].innerHTML = "*";
					if (((field_name == "password") || (field_name == "password_confirm")) && (ElExists("password_required") === true) && (document.getElementById("password_required").value == 1))
						required_mark_el[i].innerHTML = "*";
				}
			}
		}
	}
	
	// Hide all reqired asterik marks if not using them.
	if (use_classic_required_field_marks == 0)	{
		var elems = document.getElementsByTagName('*');
		var matchClass = "required_mark";
		for (i in elems) {
			if((' ' + elems[i].className + ' ').indexOf(' ' + matchClass + ' ') > -1) {
				if (use_classic_required_field_marks == 0)
					elems[i].style.display = "none";
			}
		}
	}

	if (document.getElementsByClassName("required_box").length > 0)	{
		var required_box_el = document.getElementsByClassName("required_box");
		if (typeof required_box_el[0] !== 'undefined')	{
			if (use_classic_required_field_marks == 1)
				required_box_el[0].style.visibility = "hidden";
			else
				required_box_el[0].style.visibility = "visible";
		}
	}
	
	if ((use_classic_required_field_marks > 0) && (document.getElementsByClassName("required_msg").length > 0))	{
		var required_msg_el = document.getElementsByClassName("required_msg");
		if (typeof required_msg_el[0] !== 'undefined')	{
			var required_msg = required_msg_el[0].innerHTML;
			required_msg = required_msg.replace(/\*/, "");
			required_msg_el[0].innerHTML = required_msg;
		}
	}
	////////////////////////////////////////////////////////////////////////////
	
	if (mode == "Update")	{
		var update_record_html = false;
		var update_record_key_html = false;
		if (ElExists("update_record"))
			document.getElementById("update_record").value = "1";
		else
			update_record_html = true;
			
		if (ElExists("update_record_key"))
			document.getElementById("update_record_key").value = "id";
		else
			update_record_key_html = true;
			
		if (update_record_html || update_record_key_html)	{
			var html = document.getElementById("content_div").innerHTML;
		
			if (update_record_html && update_record_key_html)
				html = html.replace("</form>", "<input type='hidden' name='update_record' id='update_record' value='1' />\n<input type='hidden' name='update_record_key' id='update_record_key' value='id' />\n");
			else if (update_record_html)
				html = html.replace("</form>", "<input type='hidden' name='update_record' id='update_record' value='1' />\n");
			else
				html = html.replace("</form>", "<input type='hidden' name='update_record_key' id='update_record_key' value='id' />\n");
				
			if ((typeof id != "undefined") && !isNaN(id))
				html += "<input type='hidden' name='id' id='id' value='" + id + "' />\n"
				
			html += "</form>";
			
			document.getElementById("content_div").innerHTML = html;
		}

		///////////////////////////////////////////////////////////////////////////
		LoadRecord();
//		setTimeout("LoadRecord();", 200);
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////
function LoadRecord()
{
	var where = "id = " + id;
	$.post( "../get_rows.php", { table: table, no_prefix: 1, where: where } ).done(PopulateForm) ;
}

//////////////////////////////////////////////////////////////////////////////////////////////////
function PopulateForm(row_str)
{
//alert(row_str);
	var fields = new Array();
	var values = new Array();
	var el;
	
	if (row_str == "-no data-")
		alert("No data found");
	else
	{
		var JSON_row = JSON.parse(row_str);
		var j = 0;
		for (var key in JSON_row) {
		   fields[j] = key;
		   values[j] = JSON_row[key];
		   j++;
		}

		for (var i = 0; i <= fields.length ; i++)	{
			if (ElExists(fields[i]) === true)	{
				el = document.getElementById(fields[i]);

				if ((fields[i].indexOf("upload_file") > -1) || (fields[i].indexOf("password") > -1))
					continue;
				if (el.type == "checkbox")	{
					if ((el.type == "checkbox") && (values[i] != 0) && (values[i] != false))
						el.checked = true;
					else
						el.checked = false;
				}
				else	{
					el.value = values[i];
					if ((fields[i] == "email") && (ElExists("email_confirm") === true))
						document.getElementById("email_confirm").value = values[i];
				}
			}
			else if (ElExists(fields[i]) === false)
				continue;
			else if (!isNaN(ElExists(fields[i])))	{
				var els = document.getElementsByName(fields[i]);
				if (els[0].type == "radio")	{
					for (var k in els)	{
						if (els[k].value = values[i])	{
							els[k].checked = true;
							break;
						}
					}
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
function CheckForm()
{
	if (ElExists('required_fields'))
	{
		var required_fields_str = document.getElementById("required_fields").value;
		var required_fields = required_fields_str.split(",");
		var field_name;
		var OKtoSend = true;
		var el;
		var class_name;
		var radio_checked;
		document.getElementById("ErrRequired").style.display = "none";
		document.getElementById("ErrEmailBlank").style.display = "none";
		document.getElementById("ErrEmailNoMatch").style.display = "none";
		if (ElExists('ErrPassBlank'))
			document.getElementById("ErrPassBlank").style.display = "none";
		if (ElExists('ErrPassNoMatch'))
			document.getElementById("ErrPassNoMatch").style.display = "none";
		if (ElExists('ErrTooShort'))
			document.getElementById("ErrTooShort").style.display = "none";
		if (ElExists('ErrTooWeak'))
			document.getElementById("ErrTooWeak").style.display = "none";
		for (var i = 0; i < required_fields.length; i++)
		{
			field_name = required_fields[i].trim();
			if (field_name != "")	{
				el = document.getElementById(field_name);
				
				if ((el == null) || (typeof el == "undefined"))	// If radio botton group, select first element by name instead.
					el = document.getElementsByName(field_name).item(0);
	
				if (((el.type == "text") || (el.type == "textarea") || (el.type == "select-one") || (el.type == "select-multiple")) && ((el.value == "") || (el.value == "-not selected-")))
					OKtoSend = false;
				else if (el.type == "radio")	{
					radio_checked = false;
					el = document.getElementById(field_name + "_div");	// Set element back to radio group div.
					for (var j = 0; j < document.getElementsByName(field_name).length; j++)
					{
						if (document.getElementsByName(field_name).item(j).checked == true)
							radio_checked = true;
					}
					if (!radio_checked)
						OKtoSend = false;
				}
				else if ((el.type == "checkbox") && (el.checked == false))	{
					OKtoSend = false;
					class_name = document.getElementById(field_name + "_div").className;
					class_name = class_name.replace(" required_field", "");
					document.getElementById(field_name + "_div").className = class_name + " field_highlight";
				}
				else	{	// Clear previous highlights.
					class_name = el.className;
					class_name = class_name.replace(" field_highlight", "");
					el.className = class_name + " required_field";
				}
	
				if (!OKtoSend)	{
					class_name = el.className;
					class_name = class_name.replace(" required_field", "");
					el.className = class_name + " field_highlight";
					el.focus();
				}
			}
		}
		if (!OKtoSend)
			document.getElementById("ErrRequired").style.display = "block";
	}

	if (ElExists('email_required') && (document.getElementById("email_required").value == 1))	{
		if (ElExists('email') && ((document.getElementById('email').value == "") || (document.getElementById('email').value != document.getElementById('email_confirm').value)))	{
			class_name = document.getElementById('email').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
			if (document.getElementById('email').value == "")
				document.getElementById("ErrEmailBlank").style.display = "block";
			else
				document.getElementById("ErrEmailNoMatch").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("email").focus();
				OKtoSend = false;
			}
		}
		else if (ElExists('email'))	{	// Clear previous highlights.
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("email").className = class_name + " required_field";
		}
		if (ElExists('email_confirm') && ((document.getElementById('email_confirm').value == "") || (document.getElementById('email').value != document.getElementById('email_confirm').value)))	{
			class_name = document.getElementById('email_confirm').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email_confirm").className = class_name + " field_highlight";
			if (document.getElementById('email_confirm').value == "")
				document.getElementById("ErrEmailBlank").style.display = "block";
			else
				document.getElementById("ErrEmailNoMatch").style.display = "block";
			OKtoSend = false;
		}
		else if (ElExists('email_confirm'))	{	// Clear previous highlights.
			class_name = document.getElementById("email_confirm").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("email_confirm").className = class_name + " required_field";
		}
	}
	
	if (ElExists('password_required') && (document.getElementById("password_required").value == 1))	{
		if (ElExists('password') && ((document.getElementById('password').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value)))	{
			class_name = document.getElementById('password').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
			if (document.getElementById('password').value == "")
				document.getElementById("ErrPassBlank").style.display = "block";
			else
				document.getElementById("ErrPassNoMatch").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
		else if (ElExists('password'))	{	// Clear previous highlights.
				class_name = document.getElementById("password").className;
				class_name = class_name.replace(" field_highlight", "");
				document.getElementById("password").className = class_name + " required_field";
			}
		if (ElExists('password_confirm') && ((document.getElementById('password_confirm').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value)))	{
			class_name = document.getElementById('password_confirm').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password_confirm").className = class_name + " field_highlight";
			if (document.getElementById('password').value == "")
				document.getElementById("ErrPassBlank").style.display = "block";
			else
				document.getElementById("ErrPassNoMatch").style.display = "block";
			OKtoSend = false;
		}
		else if (ElExists('password_confirm'))	{	// Clear previous highlights.
			class_name = document.getElementById("password_confirm").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("password_confirm").className = class_name + " required_field";
		}
	}
	
	if ((ElExists('password_length')) && (document.getElementById('password_length').value > 0) && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		var password_length = document.getElementById('password_length').value;
		if (document.getElementById('password').value.length < password_length)	{
			if (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm"))
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			if (ElExists("password_length_msg"))
				document.getElementById("password_length_msg").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}

	if ((ElExists('password_strength')) && (document.getElementById('password_strength').value != "") && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		
		var password_strength = document.getElementById('password_strength').value;
		if (ElExists("password_strength_msg"))	{
			if (password_strength == "medium")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning both letters and numbers.";
			else if (password_strength == "strong")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
		}

		if (((document.getElementById('password').value.match(/(?:[A-Za-z].*?\d|\d.*?[A-Za-z])/) == null) && (password_strength == "medium")) || ((document.getElementById('password').value.match(/(?=.*\d)(?=.*[a-zA-Z])(?=.*\W)/) == null) && (password_strength == "strong")))	{
			if  (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm"))
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			document.getElementById("ErrTooWeak").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}
		
	return OKtoSend;
}

function SubmitForm(frmID)
{
	if (CheckForm())
		document.getElementById(frmID).submit();
}