<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/6/2016	ELL
// 
// 
// 
include ("check_session.php");
define("MAX_IMG_SIZE", 20000000);	// in bytes
define("MAX_EXEC_TIME", 300);	// in seconds

ini_set("max_execution_time", MAX_EXEC_TIME);
ini_set("upload_max_filesize", strval(intval(MAX_IMG_SIZE/1000000)) . "M");
ini_set("post_max_size", strval(intval(MAX_IMG_SIZE/1000000) + 1) . "M");

$img_cnt = count($_FILES["fileToUpload"]["name"]);
$uploadOk = 1;

$doc_root = getenv('DOCUMENT_ROOT');
if (BWB_BASE_DIR == '')
	$userfiles = '';
else
	$userfiles = "/" . BWB_BASE_DIR;
$orig_image_path = $doc_root . $userfiles . "/" . BWB_IMAGE_DIR . "/gallery/orig";
	
$target_dir = $orig_image_path . "/";

$allowed_ext = array("jpg", "png", "gif", "jpeg", "JPG", "PNG", "GIF", "JPEG", "Jpg", "Png", "Gif", "Jpeg");

for ($i = 0; $i < $img_cnt; $i++)
{
	$target_file = $target_dir . basename($_FILES["fileToUpload"]["name"][$i]);
	$imageFileType = pathinfo($target_file, PATHINFO_EXTENSION);
	// Check if image file is a actual image or fake image
	$check = getimagesize($_FILES["fileToUpload"]["tmp_name"][$i]);
	if ($_FILES["fileToUpload"]["error"][$i] == 1)	{
		$uploadOk = -4;
	}
	elseif ($check === false) {
	//	echo "File is not an image.";
		$uploadOk = -1;
	}
	
	// Check if file already exists
	if (file_exists($target_file)) {
	//    echo "File already exists.";
		$target_file = str_replace("." . $imageFileType, "", $target_file) . time() . "." . $imageFileType;
	}

	// Check file size
	if ($_FILES["fileToUpload"]["size"][$i] > MAX_IMG_SIZE) {
	//    echo "Sorry, your file is too large.";
		$uploadOk = -2;
	}
	
	// Allow certain file formats
	if(!in_array($imageFileType, $allowed_ext)) {
	//    echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
		$uploadOk = -1;
	}
	
	// Check if $uploadOk is set to 0 by an error
	if ($uploadOk == 1) {
		if (!move_uploaded_file($_FILES["fileToUpload"]["tmp_name"][$i], $target_file)) {
	//        echo "Sorry, there was an error uploading your file.";
			$uploadOk = -3;
		}
	}
}

header("Location: manage_gallery.php?result=$uploadOk");
?>