<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/15/2018	ELL
// 
	include ("check_session.php");
		
	$query = "SELECT `language_folder` FROM " . BWB_TABLE_PREFIX . "plugins WHERE `name` = 'View Form Tables'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$language_folder = $row['language_folder'];
	
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if ((defined("BWB_LANG")) && (file_exists($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php")))
		include_once ($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php");
	else
		include_once ($document_root . "/" . $language_folder . "/en.php");
	
	$manage_image_dir = "/manage/theme/" . $theme . "/images/";
	$rel_manage_image_dir = "../theme/" . $theme . "/images/";
	
	$server_name = $_SERVER['SERVER_NAME'];
?>
<!DOCTYPE HTML>
<html>
<head>
<title>View Form Tables | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="../theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="../images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

.header_row	{
	padding-left:5px;
	padding-right:5px;
}

.button_heading_sub_level_1	{	margin-left: 5%;	}

.marked_read	{	
	color:#999;
	font-style: italic;
}

#filter_read_msg_div	{	display:none;	}

#print_btn	{
	width: 35px;
	height: 35px;
	position: absolute;
	display: none;
	right: 5%;
	top: 0px;
	background-image: url(../theme/<?php echo $theme; ?>/images/icon_print.png);
	background-position: center;
	background-repeat: no-repeat;
	background-color: #ACACAC;
	cursor: pointer;
	 border-radius: 4px;
}
#print_btn:hover	{
	background-image: url(../theme/<?php echo $theme; ?>/images/icon_print_mo.png);
	background-position: center;
	background-color: #D9D9D9;
}

#records_per_page	{
	display: none;
	margin-left: 10%;
}

@media print {
   #print_btn, #help_button, #filter_read_msg_div, #edit_menus_heading, #form_name, #form_name_label, #user_nav_row_top, #user_nav_row_bot, #records_per_page  { display:none; }
   #FormTable { display:table; }
   #FormTable td { border:thin #666 solid; }
}

.table_view_img	{
	height: 100px;
}

#edit_record_form	{
	top: 0px;
	right: 20px;
/*	width: 80%;
	height: 90%;	*/
	position: absolute;
	display: none;
	z-index: 1000;
	background-color: #EEE;
	overflow: auto;
	box-shadow: 8px 8px 5px #888;
}

#main_div	{
	text-align: center;
	position: relative;
}

#add_btn	{
	width: 150px;
	float: right;
	margin-right: 50px;
	display: none;
}
</style>

<script src="../js/jquery.min.js"></script>
<script src="../js/browser_detect.js"></script>
<script src="../js/mouse_position.js"></script>
<script src="../js/popup_msg.js"></script>
<script src="js/view_form_tables.js"></script>

<script>
	var bgclr = "#eeeeee";
<?php
	echo "\n	var theme = '" . $theme . "';\n\n";
	
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var DELETE_RECORD_1_MSG = \"" . DELETE_RECORD_1_MSG . "\";\n";
	echo "	var DELETE_RECORD_2_MSG = \"" . DELETE_RECORD_2_MSG . "\";\n";
	
	echo "	var http = '$http';\n";
	echo "	var server_name = '$server_name';\n";
?>
</script>

</head>

<body onLoad="initializeConsole();" id="workspace_body">

<div class="button_heading_sub_level_1" id="edit_menus_heading"><div class="button_heading_text_sub_level_1"><?php echo VIEW_FORM_TABLES_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
    
<div id="main_div">

<span class="bold" id="form_name_label"><?php echo VIEW_FORM_TABLES_SELECT_TABLE; ?>: </span>
<select id="form_name" name="form_name" onChange="sort_field = ''; RetrieveTable(this.value);">
	<option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$tables_found = array();
	$table_and_page_names = array();
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{				
		$page_name = $row["page_name"];
		$page_content = $row["page_content"];
		if ((strpos($page_content, 'table_name') > 0) && (strpos($page_content, '<form') > 0))	{
			$table_name_name = strpos($page_content, 'table_name');
			$table_name_start_1 = strpos($page_content, 'value="', $table_name_name);
			$table_name_start_2 = strpos($page_content, "value='", $table_name_name);
			$table_name_start_3 = strpos($page_content, 'value=\\"', $table_name_name);
			$table_name_start_4 = strpos($page_content, "value=\\'", $table_name_name);
			if ((($table_name_start_1 < $table_name_start_2) && ($table_name_start_2 > 0)) || (($table_name_start_2 == false) && ($table_name_start_3 == false) && ($table_name_start_4 == false) && ($table_name_start_1 > 0)))	{
				$table_name_start = $table_name_start_1;
				$value_delim = '"';
			}
			elseif ((($table_name_start_2 < $table_name_start_1) && ($table_name_start_1 > 0)) || (($table_name_start_1 == false) && ($table_name_start_3 == false) && ($table_name_start_4 == false) && ($table_name_start_2 > 0)))	{
				$table_name_start = $table_name_start_2;
				$value_delim = "'";
			}
			elseif ((($table_name_start_3 < $table_name_start_4) && ($table_name_start_4 > 0)) || (($table_name_start_1 == false) && ($table_name_start_2 == false) && ($table_name_start_4 == false) && ($table_name_start_3 > 0)))	{
				$table_name_start = $table_name_start_3;
				$value_delim = '\\"';
			}
			elseif ((($table_name_start_4 < $table_name_start_3) && ($table_name_start_3 > 0)) || (($table_name_start_1 == false) && ($table_name_start_2 == false) && ($table_name_start_2 == false) && ($table_name_start_4 > 0)))	{
				$table_name_start = $table_name_start_4;
				$value_delim = "\\'";
			}
			$table_name_start = strpos($page_content, $value_delim, $table_name_start) + strlen($value_delim);
			$table_name_end = strpos($page_content, $value_delim, $table_name_start);
			$table_name = substr($page_content, $table_name_start, ($table_name_end - $table_name_start));
			if (!in_array($table_name, $tables_found))	{
				$tables_found[] = $table_name;
				$table_and_page_names[$table_name] = $page_name;
			}
			else	{
				$table_and_page_names[$table_name] = $table_and_page_names[$table_name] . ", " . $page_name;
			}
		}
	}
	
	foreach ($table_and_page_names as $table_name => $page_name)
	{
		echo "<option value='$table_name'>$table_name (" . ucwords(str_replace("_", " ", $page_name)) . ")</option>\n";
	}
?>
</select>

<div id="records_per_page">
    <span class="small_message"><?php echo PER_PAGE; ?>:</span>
    <select onChange="ChangeRecordsPerPage(this.value);" class="small_message">
        <option value="25">25</option>
        <option value="50" selected='selected'>50</option>
        <option value="100">100</option>
        <option value="250">250</option>
        <option value="500">500</option>
        <option value="1000000">All</option>
    </select>
</div>

<div id="print_btn" onClick="PrintTable();">&nbsp;</div>

<table style="width: 100%;">   
   <tr>
    <td>  
     <table style="width: 800px; margin-left: 100px;">
      <tr id="user_nav_row_top">
        <td style="width:5%; text-align:center;">
         <img src="../theme/<?php echo $theme; ?>/images/First.gif" id="first_top" border="0" onClick="moveFirst();" style="cursor:pointer;" />
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Previous.gif" id="prev_top" border="0" onClick="movePrev();" style="cursor:pointer;" />
        </td>
        <td style="width:40%; text-align:center;" class="small_message">
            <?php echo SHOWING_RECORDS; ?> <span id="rcrd_start_top">&nbsp;</span> <?php echo THRU_WORD; ?> <span id="rcrd_end_top">&nbsp;</span> <?php echo OF_WORD; ?> <span id="total_rcrds_top">&nbsp;</span>
        </td>
        <td style="width:40%; text-align:center;" class="small_message">
        	<?php echo PAGE_1ST_CAP_WORD; ?> <span id="page_num_top">&nbsp;</span> <?php echo OF_WORD; ?> <span id="total_pages_top">&nbsp;</span>
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Next.gif" id="next_top" border="0" onClick="moveNext();" style="cursor:pointer;" />
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Last.gif" id="last_top" border="0" onClick="moveLast();" style="cursor:pointer;" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
	<tr><td><div id="FormTable" style="width:100%;">&nbsp;</div></td></tr>
   <tr>
    <td>  
     <table style="width: 800px; margin-left: 100px;">
      <tr id="user_nav_row_bot">
        <td style="width:5%; text-align:center;">
         <img src="../theme/<?php echo $theme; ?>/images/First.gif" id="first_bot" border="0" onClick="moveFirst();" style="cursor:pointer;" />
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Previous.gif" id="prev_bot" border="0" onClick="movePrev();" style="cursor:pointer;" />
        </td>
        <td style="width:40%; text-align:center;" class="small_message">
            <?php echo SHOWING_RECORDS; ?> <span id="rcrd_start_bot">&nbsp;</span> <?php echo THRU_WORD; ?> <span id="rcrd_end_bot">&nbsp;</span> <?php echo OF_WORD; ?> <span id="total_rcrds_bot">&nbsp;</span>
        </td>
        <td style="width:40%; text-align:center;" class="small_message">
        	<?php echo PAGE_1ST_CAP_WORD; ?> <span id="page_num_bot">&nbsp;</span> <?php echo OF_WORD; ?> <span id="total_pages_bot">&nbsp;</span>
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Next.gif" id="next_bot" border="0" onClick="moveNext();" style="cursor:pointer;" />
        </td>
        <td style="width:5%; text-align:center;">
          <img src="../theme/<?php echo $theme; ?>/images/Last.gif" id="last_bot" border="0" onClick="moveLast();" style="cursor:pointer;" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
</table>

<div id="filter_read_msg_div">
<input type="checkbox" name="filter_read_msg" id="filter_read_msg" value="1" onClick="RetrieveTable(document.getElementById('form_name').value);" />
<?php echo VIEW_FORM_TABLES_FILTER_READ; ?>
</div>

<iframe id="edit_record_form">
</iframe>

<div class="button_console_add" onClick="AddRecord();" id="add_btn"><span class="button_console_text_w_icon"><?php echo ADD_WORD; ?></span></div>

</div>

<?php include("../lib/popup_msg.html"); ?>

<script language='javascript' type='text/javascript'>
	popup_msg.HidePopupMsg();
</script>
</body>
</html>