<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/11/2012	ELL
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 6/11/2016	ELL
// Added simultaneous removal of mobile styles for plugin if they were provided.
// Revised: 6/19/2017	ELL
// Moved 'deployed' field to new table plugins_deployed.
// Revised: 4/29/2019	ELL
// Converted referenceing of deployed plugins from using 'plugin_id' to 'name'. This is because the SQL REPLACE command used to update aftermarket plugin records 
// causes the id field to increment in the 'plugins' table only, making it out-of-sync with the 'plugins_deployed' table.
// Revised: 10/2/2019	ELL
// Added removal of touchscreen CSS.
// 
//
	include ("check_session.php");

	$plugin_name = $_REQUEST['plugin_name'];
	
	// Find CSS tables and so forth to remove.
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `name`='$plugin_name'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$style_sheet = $row["style_sheet"];
	$plugin_id = $row['id'];
	
	// Remove style sheet from list.
	if (isset($style_sheet) && ($style_sheet != ""))
	{
		// Check for other plugins using the same style sheet and deployed.	
		$skip_remove = false;
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins AS T1 INNER JOIN " . BWB_TABLE_PREFIX . "plugins_deployed AS T2 ON T1.name=T2.name WHERE T1.style_sheet='" . $style_sheet . "' AND T1.name<>'" . $plugin_name . "'";
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			if ($row['deployed'] == 1)
				$skip_remove = true;
		}
		
		if (!$skip_remove)
		{
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name`='" . $style_sheet . "'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name`='" . $style_sheet . "_mobile'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name`='" . $style_sheet . "_touchscreen'";
			$cnt = $bwb_dbh->exec($query);
		
			// Delete classes and CSS from tables.
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet`='" . $style_sheet . "'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet`='" . $style_sheet . "_mobile'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_classes WHERE `style_sheet`='" . $style_sheet . "_touchscreen'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet`='" . $style_sheet . "'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet`='" . $style_sheet . "_mobile'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet`='" . $style_sheet . "_touchscreen'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE `name`='" . $style_sheet . "'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE `name`='" . $style_sheet . "_mobile'";
			$cnt = $bwb_dbh->exec($query);
			
			$query = "DELETE FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE `name`='" . $style_sheet . "_touchscreen'";
			$cnt = $bwb_dbh->exec($query);
		}
	}
	
	// Mark plugin as not being deployed.
	$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "plugins_deployed SET `plugin_id`=$plugin_id, `name`='$plugin_name', `deployed`=0";
	$cnt = $bwb_dbh->exec($query);
	
	$_SESSION['button_group'] = "other_functions";
	$_SESSION['button'] = "btn_users_site_options";
	$_SESSION['sub_button'] = "btn_show_recall_plugin";
	
?>
<script language="javascript" type="text/javascript">
	window.parent.location = "main.php";
</script>