<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 6/2/09 ELL
//  Added capability to restore special pages back into special pages table.
//  Also fixed bug of creating new records even though one was already there in page_data table.
// Revised: 1/12/12	ELL
// Added clearning of drafts upon restoring page.
// Revised: 2/9/2012	ELL
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 1/6/2015	ELL
// Fixed bug with page not restoring due to single quotes.

	include ("check_session.php");
		
	$ID = $_GET['ID'];
	$page_name = $_GET['page_name'];

	
	// Before we go any farther, back this puppy up!
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_bkup WHERE ID=$ID";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$page_content = addslashes(stripslashes($row["page_content"]));
	$revised = $row["revised"];
	$source =  $row["source"];
	if ($source == 0)
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name = '$page_name'";
		$result = $bwb_dbh->query($query);
		$num_results = $result->rowCount();
		if ($num_results > 0)
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data SET page_name='$page_name', page_content='$page_content', revised='$revised' WHERE page_name = '$page_name'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data SET page_name='$page_name', page_content='$page_content', revised='$revised'";
	}
	elseif ($source == 1)
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name = '$page_name'";
		$result = $bwb_dbh->query($query);
		$num_results = $result->rowCount();
		if ($num_results > 0)
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_name='$page_name', page_content='$page_content', revised='$revised' WHERE page_name = '$page_name'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='$page_name', page_content='$page_content', revised='$revised'";
	}
	elseif ($source == 2)
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "head WHERE head_name = '$page_name'";
		$result = $bwb_dbh->query($query);
		$num_results = $result->rowCount();
		if ($num_results > 0)
			$query = "UPDATE " . BWB_TABLE_PREFIX . "head SET head_name='$page_name', head_content='$page_content', revised='$revised' WHERE head_name = '$page_name'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "head SET head_name='$page_name', head_content='$page_content', revised='$revised'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	// Clear out draft page.
	$query = "DELETE FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$page_name' AND `source`=$source";
	$cnt = $bwb_dbh->exec($query);
	
	
	// And create actual page.
	if ($source == 0)	// But don't do look for page if it is special (top, bottom, left or right).
	{
		//Test to see if file already exists.
		$document_root = $_SERVER['DOCUMENT_ROOT'];
		if (BWB_BASE_DIR == '')
			$file_name = $document_root . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
		else
			$file_name = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $page_name . ".php";
	
		if (!file_exists($file_name))
		{
			//Get template from database.
			$query = "SELECT page_template FROM " . BWB_TABLE_PREFIX . "template";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$page_template = $row["page_template"];
			
			//Get meta-tags template from database.
			$query = "SELECT `meta_tags_template` FROM `" . BWB_TABLE_PREFIX . "meta_tags_template`";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$meta_tags_template = $row["meta_tags_template"];
			
			//Insert page name into template.
			$page_template = str_replace("xxx", $page_name, $page_template);
			// Put meta tags in.
			$page_template = str_replace("zzz", $meta_tags_template, $page_template);
			
			// Create file.
			$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
			$result = (fputs($fh, $page_template));
			fclose($fh) or die($php_errormsg);
			@chmod($file_name, 0755);
		}
	}
	
	header("Location: restore_page_select.php");
	
?>
