<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/26/2009		ELL
// Modified: 1/6/2010		ELL
// Added z-indexing to fix bug of sublevels not popping above main level upon hover.
// Modified: 1/7/2010		ELL
// Changed the way hover text color is handled.  Was able to add separate user-electable sublevel 2 hover text color.
// Added contlol of visited:hover text color so the visited menu links will be forced to same color as non-visited links for default
// whether mouse-out or hover.
// Added display block to ".top_level_li A" class to get link to encompass entire list-item area and not just text.
// Note: This fix also fixes the problem with IE7 not positioning submenu items properly.
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 1/10/2011	ELL
// Added preview mode.
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 7/21/2013	ELL
// Added background opacity.
// Revised: 3/10/2015	ELL
// Converted deprecated font stretch to letter spacing.
// Revised: 4/5/2015	ELL
// Added font size units.
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
// Revised: 10/3/2016	ELL
// Add display = block to .top_level_ax to cause click area to cover full button instead of just text.
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Modified: 3/23/2017	ELL
// Added ability to style button down states as well as complete implementation of background and item border colors in hover and active states.
// Revised: 8/29/2017	ELL
// Added background gradient capability.
// Revised: 9/12/2017	ELL
// Added ability to turn on or off text shadow for any of normal, hover and down states independently selectable in all 3 levels.
// Modified: 9/18/2017	ELL
// Added user modifiable menu z-index.
// Revised: 3/13/2018	ELL
// Added ability to specify sublevel 1 and sublevel 2 block borders independently.
// Revised: 10/12/2018	ELL
// Changed CSS field from "shadow" to "text_shadow" to match actual CSS term.
// Revised: 10/15/2018	ELL
// Added text-transform.
//
	include ("check_session.php");
	include ("lib/copy_table.php");
	include("lib/build_css_string.php");
		
	$operation = $_POST['operation'];
	$menu = $_REQUEST['menu'];
	$search = array("_mobile", "_touchscreen");
	$tmp = str_replace($search, "", $menu);
	$suffix = substr($tmp, 4);
	
	if ($operation == "Preview")
	{
		$style_sheet = "site_css_preview";
		$css_file = "site_preview.css";
		
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $style_sheet . "'";
		$cnt = $bwb_dbh->exec($query);
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "'";
		$result = $bwb_dbh->query($query);
		$comma = ", ";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $style_sheet . "'";
			foreach ($row as $field => $val)
			{
				if ($field != "style_sheet")	{
					$sql .= $comma . "`" . $field . "` = '" . $val . "'";
				}
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	else
	{
		$style_sheet = $menu;
		$css_file = $menu . ".css";
	}

	if (isset($_POST["top_level_font"])) $top_level_font = $_POST["top_level_font"];
	else $top_level_font = "-not selected-";
	if (isset($_POST["top_level_font_2"])) $top_level_font_2 = $_POST["top_level_font_2"];
	else $top_level_font_2 = "-not selected-";
	if (isset($_POST["top_level_font_3"])) $top_level_font_3 = $_POST["top_level_font_3"];
	else $top_level_font_3 = "-not selected-";
	if (is_numeric($_POST["top_level_font_size"])) $top_level_font_size = $_POST["top_level_font_size"];
	else $top_level_font_size = -1;
	if (isset($_POST["top_level_font_size_units"])) $top_level_font_size_units = $_POST["top_level_font_size_units"];
	else $top_level_font_size_units = "px";
	if (isset($_POST["top_level_weight"])) $top_level_weight = $_POST["top_level_weight"];
	else $top_level_weight = "-not selected-";
	if (isset($_POST["top_level_letter_spacing"])) $top_level_letter_spacing = $_POST["top_level_letter_spacing"];
	else $top_level_letter_spacing = -1000000;
	if (isset($_POST["top_level_letter_spacing_units"])) $top_level_letter_spacing_units = $_POST["top_level_letter_spacing_units"];
	else $top_level_letter_spacing_units = -1;	
	if (is_numeric($_POST["top_level_italic"])) $top_level_italic = $_POST["top_level_italic"];
	else $top_level_italic = 0;
	if (is_numeric($_POST["top_level_underline"])) $top_level_underline = $_POST["top_level_underline"];
	else $top_level_underline = 0;
	if (is_numeric($_POST["top_level_overline"])) $top_level_overline = $_POST["top_level_overline"];
	else $top_level_overline = 0;
	if (is_numeric($_POST["top_level_blink"])) $top_level_blink = $_POST["top_level_blink"];
	else $top_level_blink = 0;
	if (is_numeric($_POST["top_level_oblique"])) $top_level_oblique = $_POST["top_level_oblique"];
	else $top_level_oblique = 0;
	if (is_numeric($_POST["top_level_small_caps"])) $top_level_small_caps = $_POST["top_level_small_caps"];
	else $top_level_small_caps = 0;
	if (isset($_POST["top_level_text_transform"])) $top_level_text_transform = $_POST["top_level_text_transform"];
	else $top_level_text_transform = "-not selected-";
	if (is_numeric($_POST["top_level_shadow"])) $top_level_shadow = $_POST["top_level_shadow"];
	else $top_level_shadow = 0;
	if (is_numeric($_POST["top_level_shadow_hover"])) $top_level_shadow_hover = $_POST["top_level_shadow_hover"];
	else $top_level_shadow_hover = 0;
	if (is_numeric($_POST["top_level_shadow_down"])) $top_level_shadow_down = $_POST["top_level_shadow_down"];
	else $top_level_shadow_down = 0;
	if (isset($_POST["top_level_shadow_color"])) $top_level_shadow_color = $_POST["top_level_shadow_color"];
	else $top_level_shadow_color = "-not set-";
	if (is_numeric($_POST["top_level_shadow_x_offset"])) $top_level_shadow_x_offset = $_POST["top_level_shadow_x_offset"];
	else $top_level_shadow_x_offset = 0;
	if (is_numeric($_POST["top_level_shadow_y_offset"])) $top_level_shadow_y_offset = $_POST["top_level_shadow_y_offset"];
	else $top_level_shadow_y_offset = 0;
	if (is_numeric($_POST["top_level_shadow_blur"])) $top_level_shadow_blur = $_POST["top_level_shadow_blur"];
	else $top_level_shadow_blur = 0;
	if (isset($_POST["top_level_text_color"])) $top_level_text_color = $_POST["top_level_text_color"];
	else $top_level_text_color = "-not set-";
	
	if (isset($_POST["sub_level_1_font"])) $sub_level_1_font = $_POST["sub_level_1_font"];
	else $sub_level_1_font = "-not selected-";
	if (isset($_POST["sub_level_1_font_2"])) $sub_level_1_font_2 = $_POST["sub_level_1_font_2"];
	else $sub_level_1_font_2 = "-not selected-";
	if (isset($_POST["sub_level_1_font_3"])) $sub_level_1_font_3 = $_POST["sub_level_1_font_3"];
	else $sub_level_1_font_3 = "-not selected-";
	if (is_numeric($_POST["sub_level_1_font_size"])) $sub_level_1_font_size = $_POST["sub_level_1_font_size"];
	else $sub_level_1_font_size = -1;
	if (isset($_POST["sub_level_1_font_size_units"])) $sub_level_1_font_size_units = $_POST["sub_level_1_font_size_units"];
	else $sub_level_1_font_size_units = "px";
	if (isset($_POST["sub_level_1_weight"])) $sub_level_1_weight = $_POST["sub_level_1_weight"];
	else $sub_level_1_weight = "-not selected-";
	if (isset($_POST["sub_level_1_letter_spacing"])) $sub_level_1_letter_spacing = $_POST["sub_level_1_letter_spacing"];
	else $sub_level_1_letter_spacing = -1000000;
	if (isset($_POST["sub_level_1_letter_spacing_units"])) $sub_level_1_letter_spacing_units = $_POST["sub_level_1_letter_spacing_units"];
	else $sub_level_1_letter_spacing_units = -1;	
	if (is_numeric($_POST["sub_level_1_italic"])) $sub_level_1_italic = $_POST["sub_level_1_italic"];
	else $sub_level_1_italic = 0;
	if (is_numeric($_POST["sub_level_1_underline"])) $sub_level_1_underline = $_POST["sub_level_1_underline"];
	else $sub_level_1_underline = 0;
	if (is_numeric($_POST["sub_level_1_overline"])) $sub_level_1_overline = $_POST["sub_level_1_overline"];
	else $sub_level_1_overline = 0;
	if (is_numeric($_POST["sub_level_1_blink"])) $sub_level_1_blink = $_POST["sub_level_1_blink"];
	else $sub_level_1_blink = 0;
	if (is_numeric($_POST["sub_level_1_oblique"])) $sub_level_1_oblique = $_POST["sub_level_1_oblique"];
	else $sub_level_1_oblique = 0;
	if (is_numeric($_POST["sub_level_1_small_caps"])) $sub_level_1_small_caps = $_POST["sub_level_1_small_caps"];
	else $sub_level_1_small_caps = 0;
	if (isset($_POST["sub_level_1_text_transform"])) $sub_level_1_text_transform = $_POST["sub_level_1_text_transform"];
	else $sub_level_1_text_transform = "-not selected-";
	if (is_numeric($_POST["sub_level_1_shadow"])) $sub_level_1_shadow = $_POST["sub_level_1_shadow"];
	else $sub_level_1_shadow = 0;
	if (is_numeric($_POST["sub_level_1_shadow_hover"])) $sub_level_1_shadow_hover = $_POST["sub_level_1_shadow_hover"];
	else $sub_level_1_shadow_hover = 0;
	if (is_numeric($_POST["sub_level_1_shadow_down"])) $sub_level_1_shadow_down = $_POST["sub_level_1_shadow_down"];
	else $sub_level_1_shadow_down = 0;
	if (isset($_POST["sub_level_1_shadow_color"])) $sub_level_1_shadow_color = $_POST["sub_level_1_shadow_color"];
	else $sub_level_1_shadow_color = "-not set-";
	if (is_numeric($_POST["sub_level_1_shadow_x_offset"])) $sub_level_1_shadow_x_offset = $_POST["sub_level_1_shadow_x_offset"];
	else $sub_level_1_shadow_x_offset = 0;
	if (is_numeric($_POST["sub_level_1_shadow_y_offset"])) $sub_level_1_shadow_y_offset = $_POST["sub_level_1_shadow_y_offset"];
	else $sub_level_1_shadow_y_offset = 0;
	if (is_numeric($_POST["sub_level_1_shadow_blur"])) $sub_level_1_shadow_blur = $_POST["sub_level_1_shadow_blur"];
	else $sub_level_1_shadow_blur = 0;
	if (isset($_POST["sub_level_1_text_color"])) $sub_level_1_text_color = $_POST["sub_level_1_text_color"];
	else $sub_level_1_text_color = "-not set-";
	
	if (isset($_POST["sub_level_2_font"])) $sub_level_2_font = $_POST["sub_level_2_font"];
	else $sub_level_2_font = "-not selected-";
	if (isset($_POST["sub_level_2_font_2"])) $sub_level_2_font_2 = $_POST["sub_level_2_font_2"];
	else $sub_level_2_font_2 = "-not selected-";
	if (isset($_POST["sub_level_2_font_3"])) $sub_level_2_font_3 = $_POST["sub_level_2_font_3"];
	else $sub_level_2_font_3 = "-not selected-";
	if (is_numeric($_POST["sub_level_2_font_size"])) $sub_level_2_font_size = $_POST["sub_level_2_font_size"];
	else $sub_level_2_font_size = -1;
	if (isset($_POST["sub_level_2_font_size_units"])) $sub_level_2_font_size_units = $_POST["sub_level_2_font_size_units"];
	else $sub_level_2_font_size_units = "px";
	if (isset($_POST["sub_level_2_weight"])) $sub_level_2_weight = $_POST["sub_level_2_weight"];
	else $sub_level_2_weight = "-not selected-";
	if (isset($_POST["sub_level_2_letter_spacing"])) $sub_level_2_letter_spacing = $_POST["sub_level_2_letter_spacing"];
	else $sub_level_2_letter_spacing = -1000000;
	if (isset($_POST["sub_level_2_letter_spacing_units"])) $sub_level_2_letter_spacing_units = $_POST["sub_level_2_letter_spacing_units"];
	else $sub_level_2_letter_spacing_units = -1;	
	if (is_numeric($_POST["sub_level_2_italic"])) $sub_level_2_italic = $_POST["sub_level_2_italic"];
	else $sub_level_2_italic = 0;
	if (is_numeric($_POST["sub_level_2_underline"])) $sub_level_2_underline = $_POST["sub_level_2_underline"];
	else $sub_level_2_underline = 0;
	if (is_numeric($_POST["sub_level_2_overline"])) $sub_level_2_overline = $_POST["sub_level_2_overline"];
	else $sub_level_2_overline = 0;
	if (is_numeric($_POST["sub_level_2_blink"])) $sub_level_2_blink = $_POST["sub_level_2_blink"];
	else $sub_level_2_blink = 0;
	if (is_numeric($_POST["sub_level_2_oblique"])) $sub_level_2_oblique = $_POST["sub_level_2_oblique"];
	else $sub_level_2_oblique = 0;
	if (is_numeric($_POST["sub_level_2_small_caps"])) $sub_level_2_small_caps = $_POST["sub_level_2_small_caps"];
	else $sub_level_2_small_caps = 0;
	if (isset($_POST["sub_level_2_text_transform"])) $sub_level_2_text_transform = $_POST["sub_level_2_text_transform"];
	else $sub_level_2_text_transform = "-not selected-";
	if (is_numeric($_POST["sub_level_2_shadow"])) $sub_level_2_shadow = $_POST["sub_level_2_shadow"];
	else $sub_level_2_shadow = 0;
	if (is_numeric($_POST["sub_level_2_shadow_hover"])) $sub_level_2_shadow_hover = $_POST["sub_level_2_shadow_hover"];
	else $sub_level_2_shadow_hover = 0;
	if (is_numeric($_POST["sub_level_2_shadow_down"])) $sub_level_2_shadow_down = $_POST["sub_level_2_shadow_down"];
	else $sub_level_2_shadow_down = 0;
	if (isset($_POST["sub_level_2_shadow_color"])) $sub_level_2_shadow_color = $_POST["sub_level_2_shadow_color"];
	else $sub_level_2_shadow_color = "-not set-";
	if (is_numeric($_POST["sub_level_2_shadow_x_offset"])) $sub_level_2_shadow_x_offset = $_POST["sub_level_2_shadow_x_offset"];
	else $sub_level_2_shadow_x_offset = 0;
	if (is_numeric($_POST["sub_level_2_shadow_y_offset"])) $sub_level_2_shadow_y_offset = $_POST["sub_level_2_shadow_y_offset"];
	else $sub_level_2_shadow_y_offset = 0;
	if (is_numeric($_POST["sub_level_2_shadow_blur"])) $sub_level_2_shadow_blur = $_POST["sub_level_2_shadow_blur"];
	else $sub_level_2_shadow_blur = 0;
	if (isset($_POST["sub_level_2_text_color"])) $sub_level_2_text_color = $_POST["sub_level_2_text_color"];
	else $sub_level_2_text_color = "-not set-";
	
	if (isset($_POST["top_level_text_color_hover"])) $top_level_text_color_hover = $_POST["top_level_text_color_hover"];
	else $top_level_text_color_hover = "-not set-";
	if (isset($_POST["sub_level_1_text_color_hover"])) $sub_level_1_text_color_hover = $_POST["sub_level_1_text_color_hover"];
	else $sub_level_1_text_color_hover = "-not set-";
	if (isset($_POST["sub_level_2_text_color_hover"])) $sub_level_2_text_color_hover = $_POST["sub_level_2_text_color_hover"];
	else $sub_level_2_text_color_hover = "-not set-";
	if (isset($_POST["top_level_text_color_down"])) $top_level_text_color_down = $_POST["top_level_text_color_down"];
	else $top_level_text_color_down = "-not set-";
	if (isset($_POST["sub_level_1_text_color_down"])) $sub_level_1_text_color_down = $_POST["sub_level_1_text_color_down"];
	else $sub_level_1_text_color_down = "-not set-";
	if (isset($_POST["sub_level_2_text_color_down"])) $sub_level_2_text_color_down = $_POST["sub_level_2_text_color_down"];
	elseif (isset($_POST["sub_level_1_text_color_down"])) $sub_level_2_text_color_down = $_POST["sub_level_1_text_color_down"];
	else $sub_level_2_text_color_down = "-not set-";
	if (isset($_POST["top_level_text_color_active"])) $top_level_text_color_active = $_POST["top_level_text_color_active"];
	else $top_level_text_color_active = "-not set-";
	if (isset($_POST["sub_level_1_text_color_active"])) $sub_level_1_text_color_active = $_POST["sub_level_1_text_color_active"];
	else $sub_level_1_text_color_active = "-not set-";
	if (isset($_POST["sub_level_2_text_color_active"])) $sub_level_2_text_color_active = $_POST["sub_level_2_text_color_active"];
	elseif (isset($_POST["sub_level_1_text_color_active"])) $sub_level_2_text_color_active = $_POST["sub_level_1_text_color_active"];
	else $sub_level_2_text_color_active = "-not set-";
	
	if (isset($_POST["top_level_background_color"])) $top_level_background_color = $_POST["top_level_background_color"];
	else $top_level_background_color = "-not set-";
	if (isset($_POST["top_level_background_color_hover"])) $top_level_background_color_hover = $_POST["top_level_background_color_hover"];
	else $top_level_background_color_hover = "-not set-";
	if (isset($_POST["top_level_background_color_down"])) $top_level_background_color_down = $_POST["top_level_background_color_down"];
	else $top_level_background_color_down = "-not set-";
	if (isset($_POST["top_level_background_color_active"])) $top_level_background_color_active = $_POST["top_level_background_color_active"];
	else $top_level_background_color_active = "-not set-";
	
	if (isset($_POST["sub_level_1_background_color"])) $sub_level_1_background_color = $_POST["sub_level_1_background_color"];
	else $sub_level_1_background_color = "-not set-";
	if (isset($_POST["sub_level_1_background_color_hover"])) $sub_level_1_background_color_hover = $_POST["sub_level_1_background_color_hover"];
	else $sub_level_1_background_color_hover = "-not set-";
	if (isset($_POST["sub_level_1_background_color_down"])) $sub_level_1_background_color_down = $_POST["sub_level_1_background_color_down"];
	else $sub_level_1_background_color_down = "-not set-";
	if (isset($_POST["sub_level_1_background_color_active"])) $sub_level_1_background_color_active = $_POST["sub_level_1_background_color_active"];
	else $sub_level_1_background_color_active = "-not set-";
	
	if (isset($_POST["sub_level_2_background_color"])) $sub_level_2_background_color = $_POST["sub_level_2_background_color"];
	elseif (isset($_POST["sub_level_1_background_color"])) $sub_level_2_background_color = $_POST["sub_level_1_background_color"];
	else $sub_level_2_background_color = "-not set-";
	if (isset($_POST["sub_level_2_background_color_hover"])) $sub_level_2_background_color_hover = $_POST["sub_level_2_background_color_hover"];
	elseif (isset($_POST["sub_level_1_background_color_hover"])) $sub_level_2_background_color_hover = $_POST["sub_level_1_background_color_hover"];
	else $sub_level_2_background_color_hover = "-not set-";
	if (isset($_POST["sub_level_2_background_color_down"])) $sub_level_2_background_color_down = $_POST["sub_level_2_background_color_down"];
	elseif (isset($_POST["sub_level_1_background_color_down"])) $sub_level_2_background_color_down = $_POST["sub_level_1_background_color_down"];
	else $sub_level_2_background_color_down = "-not set-";
	if (isset($_POST["sub_level_2_background_color_active"])) $sub_level_2_background_color_active = $_POST["sub_level_2_background_color_active"];
	elseif (isset($_POST["sub_level_1_background_color_active"])) $sub_level_2_background_color_active = $_POST["sub_level_1_background_color_active"];
	else $sub_level_2_background_color_active = "-not set-";
	
	if (is_numeric($_POST["top_level_block_border_width"])) $top_level_block_border_width = $_POST["top_level_block_border_width"];
	else $top_level_block_border_width = -1;
	if (is_numeric($_POST["top_level_block_border_units"])) $top_level_block_border_units = $_POST["top_level_block_border_units"];
	else $top_level_block_border_units = 0;
	if (isset($_POST["top_level_block_border_color"])) $top_level_block_border_color = $_POST["top_level_block_border_color"];
	else $top_level_block_border_color = "-not set-";
	if (is_numeric($_POST["sub_level_1_block_border_width"])) $sub_level_1_block_border_width = $_POST["sub_level_1_block_border_width"];
	else $sub_level_1_block_border_width = -1;
	if (is_numeric($_POST["sub_level_1_block_border_units"])) $sub_level_1_block_border_units = $_POST["sub_level_1_block_border_units"];
	else $sub_level_1_block_border_units = 0;
	if (isset($_POST["sub_level_1_block_border_color"])) $sub_level_1_block_border_color = $_POST["sub_level_1_block_border_color"];
	else $sub_level_1_block_border_color = "-not set-";
	if (is_numeric($_POST["sub_level_2_block_border_width"])) $sub_level_2_block_border_width = $_POST["sub_level_2_block_border_width"];
	else $sub_level_2_block_border_width = -1;
	if (is_numeric($_POST["sub_level_2_block_border_units"])) $sub_level_2_block_border_units = $_POST["sub_level_2_block_border_units"];
	else $sub_level_2_block_border_units = 0;
	if (isset($_POST["sub_level_2_block_border_color"])) $sub_level_2_block_border_color = $_POST["sub_level_2_block_border_color"];
	else $sub_level_2_block_border_color = "-not set-";
	
	if (is_numeric($_POST["top_level_item_border_width"])) $top_level_item_border_width = $_POST["top_level_item_border_width"];
	else $top_level_item_border_width = -1;
	if (is_numeric($_POST["top_level_item_border_units"])) $top_level_item_border_units = $_POST["top_level_item_border_units"];
	else $top_level_item_border_units = 0;
	if (isset($_POST["top_level_item_border_color"])) $top_level_item_border_color = $_POST["top_level_item_border_color"];
	else $top_level_item_border_color = "-not set-";
	if (isset($_POST["top_level_item_border_color_hover"])) $top_level_item_border_color_hover = $_POST["top_level_item_border_color_hover"];
	else $top_level_item_border_color_hover = "-not set-";
	if (isset($_POST["top_level_item_border_color_down"])) $top_level_item_border_color_down = $_POST["top_level_item_border_color_down"];
	else $top_level_item_border_color_down = "-not set-";
	if (isset($_POST["top_level_item_border_color_active"])) $top_level_item_border_color_active = $_POST["top_level_item_border_color_active"];
	else $top_level_item_border_color_active = "-not set-";
	
	if (is_numeric($_POST["sub_level_1_item_border_width"])) $sub_level_1_item_border_width = $_POST["sub_level_1_item_border_width"];
	else $sub_level_1_item_border_width = -1;
	if (is_numeric($_POST["sub_level_1_item_border_units"])) $sub_level_1_item_border_units = $_POST["sub_level_1_item_border_units"];
	else $sub_level_1_item_border_units = 0;
	if (isset($_POST["sub_level_1_item_border_color"])) $sub_level_1_item_border_color = $_POST["sub_level_1_item_border_color"];
	else $sub_level_1_item_border_color = "-not set-";
	if (isset($_POST["sub_level_1_item_border_color_hover"])) $sub_level_1_item_border_color_hover = $_POST["sub_level_1_item_border_color_hover"];
	else $sub_level_1_item_border_color_hover = "-not set-";
	if (isset($_POST["sub_level_1_item_border_color_down"])) $sub_level_1_item_border_color_down = $_POST["sub_level_1_item_border_color_down"];
	else $sub_level_1_item_border_color_down = "-not set-";
	if (isset($_POST["sub_level_1_item_border_color_active"])) $sub_level_1_item_border_color_active = $_POST["sub_level_1_item_border_color_active"];
	else $sub_level_1_item_border_color_active = "-not set-";
	
	if (is_numeric($_POST["sub_level_2_item_border_width"])) $sub_level_2_item_border_width = $_POST["sub_level_2_item_border_width"];
	else $sub_level_2_item_border_width = -1;
	if (is_numeric($_POST["sub_level_2_item_border_units"])) $sub_level_2_item_border_units = $_POST["sub_level_2_item_border_units"];
	else $sub_level_2_item_border_units = 0;
	if (isset($_POST["sub_level_2_item_border_color"])) $sub_level_2_item_border_color = $_POST["sub_level_2_item_border_color"];
	elseif (isset($_POST["sub_level_1_item_border_color"])) $sub_level_2_item_border_color = $_POST["sub_level_1_item_border_color"];
	else $sub_level_2_item_border_color = "-not set-";
	if (isset($_POST["sub_level_2_item_border_color_hover"])) $sub_level_2_item_border_color_hover = $_POST["sub_level_2_item_border_color_hover"];
	elseif (isset($_POST["sub_level_1_item_border_color_hover"])) $sub_level_2_item_border_color_hover = $_POST["sub_level_1_item_border_color_hover"];
	else $sub_level_2_item_border_color_hover = "-not set-";
	if (isset($_POST["sub_level_2_item_border_color_down"])) $sub_level_2_item_border_color_down = $_POST["sub_level_2_item_border_color_down"];
	elseif (isset($_POST["sub_level_1_item_border_color_down"])) $sub_level_2_item_border_color_down = $_POST["sub_level_1_item_border_color_down"];
	else $sub_level_2_item_border_color_down = "-not set-";
	if (isset($_POST["sub_level_2_item_border_color_active"])) $sub_level_2_item_border_color_active = $_POST["sub_level_2_item_border_color_active"];
	elseif (isset($_POST["sub_level_1_item_border_color_active"])) $sub_level_2_item_border_color_active = $_POST["sub_level_1_item_border_color_active"];
	else $sub_level_2_item_border_color_active = "-not set-";
	
	if (is_numeric($_POST["top_level_block_border_top"])) $top_level_block_border_top = $_POST["top_level_block_border_top"];
	else $top_level_block_border_top = 0;
	if (is_numeric($_POST["top_level_block_border_bottom"])) $top_level_block_border_bottom = $_POST["top_level_block_border_bottom"];
	else $top_level_block_border_bottom = 0;
	if (is_numeric($_POST["top_level_block_border_left"])) $top_level_block_border_left = $_POST["top_level_block_border_left"];
	else $top_level_block_border_left = 0;
	if (is_numeric($_POST["top_level_block_border_right"])) $top_level_block_border_right = $_POST["top_level_block_border_right"];
	else $top_level_block_border_right = 0;
	$top_level_block_border_sides = ($top_level_block_border_top * 8) | ($top_level_block_border_bottom * 4) | ($top_level_block_border_left * 2) | $top_level_block_border_right;
	
	if (isset($_POST["sub_level_1_block_border_top"])) $sub_level_1_block_border_top = $_POST["sub_level_1_block_border_top"];
	else $sub_level_1_block_border_top = 0;
	if (isset($_POST["sub_level_1_block_border_bottom"])) $sub_level_1_block_border_bottom = $_POST["sub_level_1_block_border_bottom"];
	else $sub_level_1_block_border_bottom = 0;
	if (isset($_POST["sub_level_1_block_border_left"])) $sub_level_1_block_border_left = $_POST["sub_level_1_block_border_left"];
	else $sub_level_1_block_border_left = 0;
	if (isset($_POST["sub_level_1_block_border_right"])) $sub_level_1_block_border_right = $_POST["sub_level_1_block_border_right"];
	else $sub_level_1_block_border_right = 0;
	$sub_level_1_block_border_sides = ($sub_level_1_block_border_top * 8) | ($sub_level_1_block_border_bottom * 4) | ($sub_level_1_block_border_left * 2) | $sub_level_1_block_border_right;
	
	if (isset($_POST["sub_level_2_block_border_top"])) $sub_level_2_block_border_top = $_POST["sub_level_2_block_border_top"];
	else $sub_level_2_block_border_top = 0;
	if (isset($_POST["sub_level_2_block_border_bottom"])) $sub_level_2_block_border_bottom = $_POST["sub_level_2_block_border_bottom"];
	else $sub_level_2_block_border_bottom = 0;
	if (isset($_POST["sub_level_2_block_border_left"])) $sub_level_2_block_border_left = $_POST["sub_level_2_block_border_left"];
	else $sub_level_2_block_border_left = 0;
	if (isset($_POST["sub_level_2_block_border_right"])) $sub_level_2_block_border_right = $_POST["sub_level_2_block_border_right"];
	else $sub_level_2_block_border_right = 0;
	$sub_level_2_block_border_sides = ($sub_level_2_block_border_top * 8) | ($sub_level_2_block_border_bottom * 4) | ($sub_level_2_block_border_left * 2) | $sub_level_2_block_border_right;
	
	
	if (isset($_POST["top_level_block_border_style"])) $top_level_block_border_style = $_POST["top_level_block_border_style"];
	else $top_level_block_border_style = "-not selected-";
	if (isset($_POST["sub_level_1_block_border_style"])) $sub_level_1_block_border_style = $_POST["sub_level_1_block_border_style"];
	else $sub_level_1_block_border_style = "-not selected-";
	if (isset($_POST["sub_level_2_block_border_style"])) $sub_level_2_block_border_style = $_POST["sub_level_2_block_border_style"];
	else $sub_level_2_block_border_style = "-not selected-";
	if (isset($_POST["top_level_item_border_style"])) $top_level_item_border_style = $_POST["top_level_item_border_style"];
	else $top_level_item_border_style = "-not selected-";
	if (isset($_POST["sub_level_1_item_border_style"])) $sub_level_1_item_border_style = $_POST["sub_level_1_item_border_style"];
	else $sub_level_1_item_border_style = "-not selected-";
	if (isset($_POST["sub_level_2_item_border_style"])) $sub_level_2_item_border_style = $_POST["sub_level_2_item_border_style"];
	else $sub_level_2_item_border_style = "-not selected-";
	
	if (($sub_level_1_block_border_width == -1) && ($top_level_block_border_width > 0))
		$sub_level_1_block_border_style = "none";
		
	if (($sub_level_2_block_border_width == -1) && (($sub_level_1_block_border_width > 0) || ($top_level_block_border_width > 0)))
		$sub_level_2_block_border_style = "none";
	
	if (isset($_POST["top_level_item_border_top"])) $top_level_item_border_top = $_POST["top_level_item_border_top"];
	else $top_level_item_border_top = 0;
	if (isset($_POST["top_level_item_border_bottom"])) $top_level_item_border_bottom = $_POST["top_level_item_border_bottom"];
	else $top_level_item_border_bottom = 0;
	if (isset($_POST["top_level_item_border_left"])) $top_level_item_border_left = $_POST["top_level_item_border_left"];
	else $top_level_item_border_left = 0;
	if (isset($_POST["top_level_item_border_right"])) $top_level_item_border_right = $_POST["top_level_item_border_right"];
	else $top_level_item_border_right = 0;
	$top_level_item_border_sides = ($top_level_item_border_top * 8) | ($top_level_item_border_bottom * 4) | ($top_level_item_border_left * 2) | $top_level_item_border_right;
	
	if (isset($_POST["sub_level_1_item_border_top"])) $sub_level_1_item_border_top = $_POST["sub_level_1_item_border_top"];
	else $sub_level_1_item_border_top = 0;
	if (isset($_POST["sub_level_1_item_border_bottom"])) $sub_level_1_item_border_bottom = $_POST["sub_level_1_item_border_bottom"];
	else $sub_level_1_item_border_bottom = 0;
	if (isset($_POST["sub_level_1_item_border_left"])) $sub_level_1_item_border_left = $_POST["sub_level_1_item_border_left"];
	else $sub_level_1_item_border_left = 0;
	if (isset($_POST["sub_level_1_item_border_right"])) $sub_level_1_item_border_right = $_POST["sub_level_1_item_border_right"];
	else $sub_level_1_item_border_right = 0;
	$sub_level_1_item_border_sides = ($sub_level_1_item_border_top * 8) | ($sub_level_1_item_border_bottom * 4) | ($sub_level_1_item_border_left * 2) | $sub_level_1_item_border_right;
	
	if (isset($_POST["sub_level_2_item_border_top"])) $sub_level_2_item_border_top = $_POST["sub_level_2_item_border_top"];
	else $sub_level_2_item_border_top = 0;
	if (isset($_POST["sub_level_2_item_border_bottom"])) $sub_level_2_item_border_bottom = $_POST["sub_level_2_item_border_bottom"];
	else $sub_level_2_item_border_bottom = 0;
	if (isset($_POST["sub_level_2_item_border_left"])) $sub_level_2_item_border_left = $_POST["sub_level_2_item_border_left"];
	else $sub_level_2_item_border_left = 0;
	if (isset($_POST["sub_level_2_item_border_right"])) $sub_level_2_item_border_right = $_POST["sub_level_2_item_border_right"];
	else $sub_level_2_item_border_right = 0;
	$sub_level_2_item_border_sides = ($sub_level_2_item_border_top * 8) | ($sub_level_2_item_border_bottom * 4) | ($sub_level_2_item_border_left * 2) | $sub_level_2_item_border_right;
	
	if (is_numeric($_POST["top_level_background_opacity"]))	{
		$top_level_background_opacity = $_POST["top_level_background_opacity"];
		$top_level_rgba = 1;
	}
	else 	{
		$top_level_background_opacity = -1;
		$top_level_rgba = 0;
	}
	if (is_numeric($_POST["sub_level_1_background_opacity"]))	{
		$sub_level_1_background_opacity = $_POST["sub_level_1_background_opacity"];
		$sub_level_1_rgba = 1;
	}
	else	{
		$sub_level_1_background_opacity = -1;
		$sub_level_1_rgba = 0;
	}
	if (is_numeric($_POST["sub_level_2_background_opacity"]))	{
		$sub_level_2_background_opacity = $_POST["sub_level_2_background_opacity"];
		$sub_level_2_rgba = 1;
	}
	else	{
		$sub_level_2_background_opacity = -1;
		$sub_level_2_rgba = 0;
	}
	
	if (is_numeric($_POST["top_level_radius_top_left"])) $top_level_radius_top_left = $_POST["top_level_radius_top_left"];
	else $top_level_radius_top_left = 0;
	if (is_numeric($_POST["top_level_radius_top_left_units"])) $top_level_radius_top_left_units = $_POST["top_level_radius_top_left_units"];
	else $top_level_radius_top_left_units = 0;
	if (is_numeric($_POST["top_level_radius_top_right"])) $top_level_radius_top_right = $_POST["top_level_radius_top_right"];
	else $top_level_radius_top_right = 0;
	if (is_numeric($_POST["top_level_radius_top_right_units"])) $top_level_radius_top_right_units = $_POST["top_level_radius_top_right_units"];
	else $top_level_radius_top_right_units = 0;
	if (is_numeric($_POST["top_level_radius_bottom_right"])) $top_level_radius_bottom_right = $_POST["top_level_radius_bottom_right"];
	else $top_level_radius_bottom_right = 0;
	if (is_numeric($_POST["top_level_radius_bottom_right_units"])) $top_level_radius_bottom_right_units = $_POST["top_level_radius_bottom_right_units"];
	else $top_level_radius_bottom_right_units = 0;
	if (is_numeric($_POST["top_level_radius_bottom_left"])) $top_level_radius_bottom_left = $_POST["top_level_radius_bottom_left"];
	else $top_level_radius_bottom_left = 0;
	if (is_numeric($_POST["top_level_radius_bottom_left_units"])) $top_level_radius_bottom_left_units = $_POST["top_level_radius_bottom_left_units"];
	else $top_level_radius_bottom_left_units = 0;
	
	if (is_numeric($_POST["sub_level_1_radius_top_left"])) $sub_level_1_radius_top_left = $_POST["sub_level_1_radius_top_left"];
	else $sub_level_1_radius_top_left = 0;
	if (is_numeric($_POST["sub_level_1_radius_top_left_units"])) $sub_level_1_radius_top_left_units = $_POST["sub_level_1_radius_top_left_units"];
	else $sub_level_1_radius_top_left_units = 0;
	if (is_numeric($_POST["sub_level_1_radius_top_right"])) $sub_level_1_radius_top_right = $_POST["sub_level_1_radius_top_right"];
	else $sub_level_1_radius_top_right = 0;
	if (is_numeric($_POST["sub_level_1_radius_top_right_units"])) $sub_level_1_radius_top_right_units = $_POST["sub_level_1_radius_top_right_units"];
	else $sub_level_1_radius_top_right_units = 0;
	if (is_numeric($_POST["sub_level_1_radius_bottom_right"])) $sub_level_1_radius_bottom_right = $_POST["sub_level_1_radius_bottom_right"];
	else $sub_level_1_radius_bottom_right = 0;
	if (is_numeric($_POST["sub_level_1_radius_bottom_right_units"])) $sub_level_1_radius_bottom_right_units = $_POST["sub_level_1_radius_bottom_right_units"];
	else $sub_level_1_radius_bottom_right_units = 0;
	if (is_numeric($_POST["sub_level_1_radius_bottom_left"])) $sub_level_1_radius_bottom_left = $_POST["sub_level_1_radius_bottom_left"];
	else $sub_level_1_radius_bottom_left = 0;
	if (is_numeric($_POST["sub_level_1_radius_bottom_left_units"])) $sub_level_1_radius_bottom_left_units = $_POST["sub_level_1_radius_bottom_left_units"];
	else $sub_level_1_radius_bottom_left_units = 0;
	
	if (is_numeric($_POST["sub_level_2_radius_top_left"])) $sub_level_2_radius_top_left = $_POST["sub_level_2_radius_top_left"];
	else $sub_level_2_radius_top_left = 0;
	if (is_numeric($_POST["sub_level_2_radius_top_left_units"])) $sub_level_2_radius_top_left_units = $_POST["sub_level_2_radius_top_left_units"];
	else $sub_level_2_radius_top_left_units = 0;
	if (is_numeric($_POST["sub_level_2_radius_top_right"])) $sub_level_2_radius_top_right = $_POST["sub_level_2_radius_top_right"];
	else $sub_level_2_radius_top_right = 0;
	if (is_numeric($_POST["sub_level_2_radius_top_right_units"])) $sub_level_2_radius_top_right_units = $_POST["sub_level_2_radius_top_right_units"];
	else $sub_level_2_radius_top_right_units = 0;
	if (is_numeric($_POST["sub_level_2_radius_bottom_right"])) $sub_level_2_radius_bottom_right = $_POST["sub_level_2_radius_bottom_right"];
	else $sub_level_2_radius_bottom_right = 0;
	if (is_numeric($_POST["sub_level_2_radius_bottom_right_units"])) $sub_level_2_radius_bottom_right_units = $_POST["sub_level_2_radius_bottom_right_units"];
	else $sub_level_2_radius_bottom_right_units = 0;
	if (is_numeric($_POST["sub_level_2_radius_bottom_left"])) $sub_level_2_radius_bottom_left = $_POST["sub_level_2_radius_bottom_left"];
	else $sub_level_2_radius_bottom_left = 0;
	if (is_numeric($_POST["sub_level_2_radius_bottom_left_units"])) $sub_level_2_radius_bottom_left_units = $_POST["sub_level_2_radius_bottom_left_units"];
	else $sub_level_2_radius_bottom_left_units = 0;
	
	if (is_numeric($_POST["top_level_box_shadow_horizontal"])) $top_level_box_shadow_horizontal = $_POST["top_level_box_shadow_horizontal"];
	else $top_level_box_shadow_horizontal = -1000000;
	if (is_numeric($_POST["top_level_box_shadow_vertical"])) $top_level_box_shadow_vertical = $_POST["top_level_box_shadow_vertical"];
	else $top_level_box_shadow_vertical = -1000000;
	if (is_numeric($_POST["top_level_box_shadow_blur"])) $top_level_box_shadow_blur = $_POST["top_level_box_shadow_blur"];
	else $top_level_box_shadow_blur = -1;
	if (is_numeric($_POST["top_level_box_shadow_spread"])) $top_level_box_shadow_spread = $_POST["top_level_box_shadow_spread"];
	else $top_level_box_shadow_spread = -1000000;
	if (isset($_POST["top_level_box_shadow_color"]) && ($_POST["top_level_box_shadow_color"] != "")) $top_level_box_shadow_color = $_POST["top_level_box_shadow_color"];
	else $top_level_box_shadow_color = "-not set-";
	if (isset($_POST["top_level_box_shadow_inset"]) && ($_POST["top_level_box_shadow_inset"] != "")) $top_level_box_shadow_inset = $_POST["top_level_box_shadow_inset"];
	else $top_level_box_shadow_inset = 0;
	
	if (is_numeric($_POST["sub_level_1_box_shadow_horizontal"])) $sub_level_1_box_shadow_horizontal = $_POST["sub_level_1_box_shadow_horizontal"];
	else $sub_level_1_box_shadow_horizontal = -1000000;
	if (is_numeric($_POST["sub_level_1_box_shadow_vertical"])) $sub_level_1_box_shadow_vertical = $_POST["sub_level_1_box_shadow_vertical"];
	else $sub_level_1_box_shadow_vertical = -1000000;
	if (is_numeric($_POST["sub_level_1_box_shadow_blur"])) $sub_level_1_box_shadow_blur = $_POST["sub_level_1_box_shadow_blur"];
	else $sub_level_1_box_shadow_blur = -1;
	if (is_numeric($_POST["sub_level_1_box_shadow_spread"])) $sub_level_1_box_shadow_spread = $_POST["sub_level_1_box_shadow_spread"];
	else $sub_level_1_box_shadow_spread = -1000000;
	if (isset($_POST["sub_level_1_box_shadow_color"]) && ($_POST["sub_level_1_box_shadow_color"] != "")) $sub_level_1_box_shadow_color = $_POST["sub_level_1_box_shadow_color"];
	else $sub_level_1_box_shadow_color = "-not set-";
	if (isset($_POST["sub_level_1_box_shadow_inset"]) && ($_POST["sub_level_1_box_shadow_inset"] != "")) $sub_level_1_box_shadow_inset = $_POST["sub_level_1_box_shadow_inset"];
	else $sub_level_1_box_shadow_inset = 0;
	
	if (is_numeric($_POST["sub_level_2_box_shadow_horizontal"])) $sub_level_2_box_shadow_horizontal = $_POST["sub_level_2_box_shadow_horizontal"];
	else $sub_level_2_box_shadow_horizontal = -1000000;
	if (is_numeric($_POST["sub_level_2_box_shadow_vertical"])) $sub_level_2_box_shadow_vertical = $_POST["sub_level_2_box_shadow_vertical"];
	else $sub_level_2_box_shadow_vertical = -1000000;
	if (is_numeric($_POST["sub_level_2_box_shadow_blur"])) $sub_level_2_box_shadow_blur = $_POST["sub_level_2_box_shadow_blur"];
	else $sub_level_2_box_shadow_blur = -1;
	if (is_numeric($_POST["sub_level_2_box_shadow_spread"])) $sub_level_2_box_shadow_spread = $_POST["sub_level_2_box_shadow_spread"];
	else $sub_level_2_box_shadow_spread = -1000000;
	if (isset($_POST["sub_level_2_box_shadow_color"]) && ($_POST["sub_level_2_box_shadow_color"] != "")) $sub_level_2_box_shadow_color = $_POST["sub_level_2_box_shadow_color"];
	else $sub_level_2_box_shadow_color = "-not set-";
	if (isset($_POST["sub_level_2_box_shadow_inset"]) && ($_POST["sub_level_2_box_shadow_inset"] != "")) $sub_level_2_box_shadow_inset = $_POST["sub_level_2_box_shadow_inset"];
	else $sub_level_2_box_shadow_inset = 0;
	
	if (is_numeric($_POST["top_level_font_size_hover"])) $top_level_font_size_hover = $_POST["top_level_font_size_hover"];
	else $top_level_font_size_hover = -1;
	if (isset($_POST["top_level_font_size_hover_units"])) $top_level_font_size_hover_units = $_POST["top_level_font_size_hover_units"];
	else $top_level_font_size_hover_units = "px";
	if (isset($_POST["top_level_weight_hover"])) $top_level_weight_hover = $_POST["top_level_weight_hover"];
	else $top_level_weight_hover = "-not selected-";
	if (isset($_POST["top_level_letter_spacing_hover"])) $top_level_letter_spacing_hover = $_POST["top_level_letter_spacing_hover"];
	else $top_level_letter_spacing_hover = -1000000;
	if (isset($_POST["top_level_letter_spacing_hover_units"])) $top_level_letter_spacing_hover_units = $_POST["top_level_letter_spacing_hover_units"];
	else $top_level_letter_spacing_hover_units = -1;	
	if (is_numeric($_POST["top_level_italic_hover"])) $top_level_italic_hover = $_POST["top_level_italic_hover"];
	else $top_level_italic_hover = 0;
	if (is_numeric($_POST["top_level_underline_hover"])) $top_level_underline_hover = $_POST["top_level_underline_hover"];
	else $top_level_underline_hover = 0;
	if (is_numeric($_POST["top_level_overline_hover"])) $top_level_overline_hover = $_POST["top_level_overline_hover"];
	else $top_level_overline_hover = 0;
	if (is_numeric($_POST["top_level_blink_hover"])) $top_level_blink_hover = $_POST["top_level_blink_hover"];
	else $top_level_blink_hover = 0;
	if (is_numeric($_POST["top_level_oblique_hover"])) $top_level_oblique_hover = $_POST["top_level_oblique_hover"];
	else $top_level_oblique_hover = 0;
	if (is_numeric($_POST["top_level_small_caps_hover"])) $top_level_small_caps_hover = $_POST["top_level_small_caps_hover"];
	else $top_level_small_caps_hover = 0;
	if (isset($_POST["top_level_text_transform_hover"])) $top_level_text_transform_hover = $_POST["top_level_text_transform_hover"];
	else $top_level_text_transform_hover = "-not selected-";
	if (isset($_POST["top_level_shadow_color_hover"])) $top_level_shadow_color_hover = $_POST["top_level_shadow_color_hover"];
	else $top_level_shadow_color_hover = "-not set-";
	if (isset($_POST["top_level_box_shadow_color_hover"])) $top_level_box_shadow_color_hover = $_POST["top_level_box_shadow_color_hover"];
	else $top_level_box_shadow_color_hover = "-not set-";
	
	if (is_numeric($_POST["sub_level_1_font_size_hover"])) $sub_level_1_font_size_hover = $_POST["sub_level_1_font_size_hover"];
	else $sub_level_1_font_size_hover = -1;
	if (isset($_POST["sub_level_1_font_size_hover_units"])) $sub_level_1_font_size_hover_units = $_POST["sub_level_1_font_size_hover_units"];
	else $sub_level_1_font_size_hover_units = "px";
	if (isset($_POST["sub_level_1_weight_hover"])) $sub_level_1_weight_hover = $_POST["sub_level_1_weight_hover"];
	else $sub_level_1_weight_hover = "-not selected-";
	if (isset($_POST["sub_level_1_letter_spacing_hover"])) $sub_level_1_letter_spacing_hover = $_POST["sub_level_1_letter_spacing_hover"];
	else $sub_level_1_letter_spacing_hover = -1000000;
	if (isset($_POST["sub_level_1_letter_spacing_hover_units"])) $sub_level_1_letter_spacing_hover_units = $_POST["sub_level_1_letter_spacing_hover_units"];
	else $sub_level_1_letter_spacing_hover_units = -1;	
	if (is_numeric($_POST["sub_level_1_italic_hover"])) $sub_level_1_italic_hover = $_POST["sub_level_1_italic_hover"];
	else $sub_level_1_italic_hover = 0;
	if (is_numeric($_POST["sub_level_1_underline_hover"])) $sub_level_1_underline_hover = $_POST["sub_level_1_underline_hover"];
	else $sub_level_1_underline_hover = 0;
	if (is_numeric($_POST["sub_level_1_overline_hover"])) $sub_level_1_overline_hover = $_POST["sub_level_1_overline_hover"];
	else $sub_level_1_overline_hover = 0;
	if (is_numeric($_POST["sub_level_1_blink_hover"])) $sub_level_1_blink_hover = $_POST["sub_level_1_blink_hover"];
	else $sub_level_1_blink_hover = 0;
	if (is_numeric($_POST["sub_level_1_oblique_hover"])) $sub_level_1_oblique_hover = $_POST["sub_level_1_oblique_hover"];
	else $sub_level_1_oblique_hover = 0;
	if (is_numeric($_POST["sub_level_1_small_caps_hover"])) $sub_level_1_small_caps_hover = $_POST["sub_level_1_small_caps_hover"];
	else $sub_level_1_small_caps_hover = 0;
	if (isset($_POST["sub_level_1_text_transform_hover"])) $sub_level_1_text_transform_hover = $_POST["sub_level_1_text_transform_hover"];
	else $sub_level_1_text_transform_hover = "-not selected-";
	if (isset($_POST["sub_level_1_shadow_color_hover"])) $sub_level_1_shadow_color_hover = $_POST["sub_level_1_shadow_color_hover"];
	else $sub_level_1_shadow_color_hover = "-not set-";
	if (isset($_POST["sub_level_1_box_shadow_color_hover"])) $sub_level_1_box_shadow_color_hover = $_POST["sub_level_1_box_shadow_color_hover"];
	else $sub_level_1_box_shadow_color_hover = "-not set-";

	if (is_numeric($_POST["sub_level_2_font_size_hover"])) $sub_level_2_font_size_hover = $_POST["sub_level_2_font_size_hover"];
	else $sub_level_2_font_size_hover = -1;
	if (isset($_POST["sub_level_2_font_size_hover_units"])) $sub_level_2_font_size_hover_units = $_POST["sub_level_2_font_size_hover_units"];
	else $sub_level_2_font_size_hover_units = "px";
	if (isset($_POST["sub_level_2_weight_hover"])) $sub_level_2_weight_hover = $_POST["sub_level_2_weight_hover"];
	else $sub_level_2_weight_hover = "-not selected-";
	if (isset($_POST["sub_level_2_letter_spacing_hover"])) $sub_level_2_letter_spacing_hover = $_POST["sub_level_2_letter_spacing_hover"];
	else $sub_level_2_letter_spacing_hover = -1000000;
	if (isset($_POST["sub_level_2_letter_spacing_hover_units"])) $sub_level_2_letter_spacing_hover_units = $_POST["sub_level_2_letter_spacing_hover_units"];
	else $sub_level_2_letter_spacing_hover_units = -1;	
	if (is_numeric($_POST["sub_level_2_italic_hover"])) $sub_level_2_italic_hover = $_POST["sub_level_2_italic_hover"];
	else $sub_level_2_italic_hover = 0;
	if (is_numeric($_POST["sub_level_2_underline_hover"])) $sub_level_2_underline_hover = $_POST["sub_level_2_underline_hover"];
	else $sub_level_2_underline_hover = 0;
	if (is_numeric($_POST["sub_level_2_overline_hover"])) $sub_level_2_overline_hover = $_POST["sub_level_2_overline_hover"];
	else $sub_level_2_overline_hover = 0;
	if (is_numeric($_POST["sub_level_2_blink_hover"])) $sub_level_2_blink_hover = $_POST["sub_level_2_blink_hover"];
	else $sub_level_2_blink_hover = 0;
	if (is_numeric($_POST["sub_level_2_oblique_hover"])) $sub_level_2_oblique_hover = $_POST["sub_level_2_oblique_hover"];
	else $sub_level_2_oblique_hover = 0;
	if (is_numeric($_POST["sub_level_2_small_caps_hover"])) $sub_level_2_small_caps_hover = $_POST["sub_level_2_small_caps_hover"];
	else $sub_level_2_small_caps_hover = 0;
	if (isset($_POST["sub_level_2_text_transform_hover"])) $sub_level_2_text_transform_hover = $_POST["sub_level_2_text_transform_hover"];
	else $sub_level_2_text_transform_hover = "-not selected-";
	if (isset($_POST["sub_level_2_shadow_color_hover"])) $sub_level_2_shadow_color_hover = $_POST["sub_level_2_shadow_color_hover"];
	else $sub_level_2_shadow_color_hover = "-not set-";
	if (isset($_POST["sub_level_2_box_shadow_color_hover"])) $sub_level_2_box_shadow_color_hover = $_POST["sub_level_2_box_shadow_color_hover"];
	else $sub_level_2_box_shadow_color_hover = "-not set-";
	
	if (is_numeric($_POST["top_level_font_size_down"])) $top_level_font_size_down = $_POST["top_level_font_size_down"];
	else $top_level_font_size_down = -1;
	if (isset($_POST["top_level_font_size_down_units"])) $top_level_font_size_down_units = $_POST["top_level_font_size_down_units"];
	else $top_level_font_size_down_units = "px";
	if (isset($_POST["top_level_weight_down"])) $top_level_weight_down = $_POST["top_level_weight_down"];
	else $top_level_weight_down = "-not selected-";
	if (isset($_POST["top_level_letter_spacing_down"])) $top_level_letter_spacing_down = $_POST["top_level_letter_spacing_down"];
	else $top_level_letter_spacing_down = -1000000;
	if (isset($_POST["top_level_letter_spacing_down_units"])) $top_level_letter_spacing_down_units = $_POST["top_level_letter_spacing_down_units"];
	else $top_level_letter_spacing_down_units = -1;	
	if (is_numeric($_POST["top_level_italic_down"])) $top_level_italic_down = $_POST["top_level_italic_down"];
	else $top_level_italic_down = 0;
	if (is_numeric($_POST["top_level_underline_down"])) $top_level_underline_down = $_POST["top_level_underline_down"];
	else $top_level_underline_down = 0;
	if (is_numeric($_POST["top_level_overline_down"])) $top_level_overline_down = $_POST["top_level_overline_down"];
	else $top_level_overline_down = 0;
	if (is_numeric($_POST["top_level_blink_down"])) $top_level_blink_down = $_POST["top_level_blink_down"];
	else $top_level_blink_down = 0;
	if (is_numeric($_POST["top_level_oblique_down"])) $top_level_oblique_down = $_POST["top_level_oblique_down"];
	else $top_level_oblique_down = 0;
	if (is_numeric($_POST["top_level_small_caps_down"])) $top_level_small_caps_down = $_POST["top_level_small_caps_down"];
	else $top_level_small_caps_down = 0;
	if (isset($_POST["top_level_text_transform_down"])) $top_level_text_transform_down = $_POST["top_level_text_transform_down"];
	else $top_level_text_transform_down = "-not selected-";
	if (isset($_POST["top_level_shadow_color_down"])) $top_level_shadow_color_down = $_POST["top_level_shadow_color_down"];
	else $top_level_shadow_color_down = "-not set-";
	if (isset($_POST["top_level_box_shadow_color_down"])) $top_level_box_shadow_color_down = $_POST["top_level_box_shadow_color_down"];
	else $top_level_box_shadow_color_down = "-not set-";
	
	if (is_numeric($_POST["sub_level_1_font_size_down"])) $sub_level_1_font_size_down = $_POST["sub_level_1_font_size_down"];
	else $sub_level_1_font_size_down = -1;
	if (isset($_POST["sub_level_1_font_size_down_units"])) $sub_level_1_font_size_down_units = $_POST["sub_level_1_font_size_down_units"];
	else $sub_level_1_font_size_down_units = "px";
	if (isset($_POST["sub_level_1_weight_down"])) $sub_level_1_weight_down = $_POST["sub_level_1_weight_down"];
	else $sub_level_1_weight_down = "-not selected-";
	if (isset($_POST["sub_level_1_letter_spacing_down"])) $sub_level_1_letter_spacing_down = $_POST["sub_level_1_letter_spacing_down"];
	else $sub_level_1_letter_spacing_down = -1000000;
	if (isset($_POST["sub_level_1_letter_spacing_down_units"])) $sub_level_1_letter_spacing_down_units = $_POST["sub_level_1_letter_spacing_down_units"];
	else $sub_level_1_letter_spacing_down_units = -1;	
	if (is_numeric($_POST["sub_level_1_italic_down"])) $sub_level_1_italic_down = $_POST["sub_level_1_italic_down"];
	else $sub_level_1_italic_down = 0;
	if (is_numeric($_POST["sub_level_1_underline_down"])) $sub_level_1_underline_down = $_POST["sub_level_1_underline_down"];
	else $sub_level_1_underline_down = 0;
	if (is_numeric($_POST["sub_level_1_overline_down"])) $sub_level_1_overline_down = $_POST["sub_level_1_overline_down"];
	else $sub_level_1_overline_down = 0;
	if (is_numeric($_POST["sub_level_1_blink_down"])) $sub_level_1_blink_down = $_POST["sub_level_1_blink_down"];
	else $sub_level_1_blink_down = 0;
	if (is_numeric($_POST["sub_level_1_oblique_down"])) $sub_level_1_oblique_down = $_POST["sub_level_1_oblique_down"];
	else $sub_level_1_oblique_down = 0;
	if (is_numeric($_POST["sub_level_1_small_caps_down"])) $sub_level_1_small_caps_down = $_POST["sub_level_1_small_caps_down"];
	else $sub_level_1_small_caps_down = 0;
	if (isset($_POST["sub_level_1_text_transform_down"])) $sub_level_1_text_transform_down = $_POST["sub_level_1_text_transform_down"];
	else $sub_level_1_text_transform_down = "-not selected-";
	if (isset($_POST["sub_level_1_shadow_color_down"])) $sub_level_1_shadow_color_down = $_POST["sub_level_1_shadow_color_down"];
	else $sub_level_1_shadow_color_down = "-not set-";
	if (isset($_POST["sub_level_1_box_shadow_color_down"])) $sub_level_1_box_shadow_color_down = $_POST["sub_level_1_box_shadow_color_down"];
	else $sub_level_1_box_shadow_color_down = "-not set-";
	
	if (is_numeric($_POST["sub_level_2_font_size_down"])) $sub_level_2_font_size_down = $_POST["sub_level_2_font_size_down"];
	else $sub_level_2_font_size_down = -1;
	if (isset($_POST["sub_level_2_font_size_down_units"])) $sub_level_2_font_size_down_units = $_POST["sub_level_2_font_size_down_units"];
	else $sub_level_2_font_size_down_units = "px";
	if (isset($_POST["sub_level_2_weight_down"])) $sub_level_2_weight_down = $_POST["sub_level_2_weight_down"];
	else $sub_level_2_weight_down = "-not selected-";
	if (isset($_POST["sub_level_2_letter_spacing_down"])) $sub_level_2_letter_spacing_down = $_POST["sub_level_2_letter_spacing_down"];
	else $sub_level_2_letter_spacing_down = -1000000;
	if (isset($_POST["sub_level_2_letter_spacing_down_units"])) $sub_level_2_letter_spacing_down_units = $_POST["sub_level_2_letter_spacing_down_units"];
	else $sub_level_2_letter_spacing_down_units = -1;	
	if (is_numeric($_POST["sub_level_2_italic_down"])) $sub_level_2_italic_down = $_POST["sub_level_2_italic_down"];
	else $sub_level_2_italic_down = 0;
	if (is_numeric($_POST["sub_level_2_underline_down"])) $sub_level_2_underline_down = $_POST["sub_level_2_underline_down"];
	else $sub_level_2_underline_down = 0;
	if (is_numeric($_POST["sub_level_2_overline_down"])) $sub_level_2_overline_down = $_POST["sub_level_2_overline_down"];
	else $sub_level_2_overline_down = 0;
	if (is_numeric($_POST["sub_level_2_blink_down"])) $sub_level_2_blink_down = $_POST["sub_level_2_blink_down"];
	else $sub_level_2_blink_down = 0;
	if (is_numeric($_POST["sub_level_2_oblique_down"])) $sub_level_2_oblique_down = $_POST["sub_level_2_oblique_down"];
	else $sub_level_2_oblique_down = 0;
	if (is_numeric($_POST["sub_level_2_small_caps_down"])) $sub_level_2_small_caps_down = $_POST["sub_level_2_small_caps_down"];
	else $sub_level_2_small_caps_down = 0;
	if (isset($_POST["sub_level_2_text_transform_down"])) $sub_level_2_text_transform_down = $_POST["sub_level_2_text_transform_down"];
	else $sub_level_2_text_transform_down = "-not selected-";
	if (isset($_POST["sub_level_2_shadow_color_down"])) $sub_level_2_shadow_color_down = $_POST["sub_level_2_shadow_color_down"];
	else $sub_level_2_shadow_color_down = "-not set-";
	if (isset($_POST["sub_level_2_box_shadow_color_down"])) $sub_level_2_box_shadow_color_down = $_POST["sub_level_2_box_shadow_color_down"];
	else $sub_level_2_box_shadow_color_down = "-not set-";
	
	if (isset($_POST["top_level_shadow_color_active"])) $top_level_shadow_color_active = $_POST["top_level_shadow_color_active"];
	else $top_level_shadow_color_active = "-not set-";
	if (isset($_POST["top_level_box_shadow_color_active"])) $top_level_box_shadow_color_active = $_POST["top_level_box_shadow_color_active"];
	else $top_level_box_shadow_color_active = "-not set-";
	if (isset($_POST["sub_level_1_shadow_color_active"])) $sub_level_1_shadow_color_active = $_POST["sub_level_1_shadow_color_active"];
	else $sub_level_1_shadow_color_active = "-not set-";
	if (isset($_POST["sub_level_1_box_shadow_color_active"])) $sub_level_1_box_shadow_color_active = $_POST["sub_level_1_box_shadow_color_active"];
	else $sub_level_1_box_shadow_color_active = "-not set-";
	if (isset($_POST["sub_level_2_shadow_color_active"])) $sub_level_2_shadow_color_active = $_POST["sub_level_2_shadow_color_active"];
	else $sub_level_2_shadow_color_active = "-not set-";
	if (isset($_POST["sub_level_2_box_shadow_color_active"])) $sub_level_2_box_shadow_color_active = $_POST["sub_level_2_box_shadow_color_active"];
	else $sub_level_2_box_shadow_color_active = "-not set-";
	
	if (is_numeric($_POST["top_level_txt_color_hover_on_down"])) $top_level_txt_color_hover_on_down = $_POST["top_level_txt_color_hover_on_down"];
	else $top_level_txt_color_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_1_txt_color_hover_on_down"])) $sub_level_1_txt_color_hover_on_down = $_POST["sub_level_1_txt_color_hover_on_down"];
	else $sub_level_1_txt_color_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_2_txt_color_hover_on_down"])) $sub_level_2_txt_color_hover_on_down = $_POST["sub_level_2_txt_color_hover_on_down"];
	else $sub_level_2_txt_color_hover_on_down = 0;
	
	if (is_numeric($_POST["top_level_bkgd_color_hover_on_down"])) $top_level_bkgd_color_hover_on_down = $_POST["top_level_bkgd_color_hover_on_down"];
	else $top_level_bkgd_color_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_1_bkgd_color_hover_on_down"])) $sub_level_1_bkgd_color_hover_on_down = $_POST["sub_level_1_bkgd_color_hover_on_down"];
	else $sub_level_1_bkgd_color_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_2_bkgd_color_hover_on_down"])) $sub_level_2_bkgd_color_hover_on_down = $_POST["sub_level_2_bkgd_color_hover_on_down"];
	else $sub_level_2_bkgd_color_hover_on_down = 0;
	
	if (is_numeric($_POST["top_level_border_hover_on_down"])) $top_level_border_hover_on_down = $_POST["top_level_border_hover_on_down"];
	else $top_level_border_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_1_border_hover_on_down"])) $sub_level_1_border_hover_on_down = $_POST["sub_level_1_border_hover_on_down"];
	else $sub_level_1_border_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_2_border_hover_on_down"])) $sub_level_2_border_hover_on_down = $_POST["sub_level_2_border_hover_on_down"];
	else $sub_level_2_border_hover_on_down = 0;
	
	if (is_numeric($_POST["top_level_bkgd_gradient_hover_on_down"])) $top_level_bkgd_gradient_hover_on_down = $_POST["top_level_bkgd_gradient_hover_on_down"];
	else $top_level_bkgd_gradient_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_1_bkgd_gradient_hover_on_down"])) $sub_level_1_bkgd_gradient_hover_on_down = $_POST["sub_level_1_bkgd_gradient_hover_on_down"];
	else $sub_level_1_bkgd_gradient_hover_on_down = 0;
	if (is_numeric($_POST["sub_level_2_bkgd_gradient_hover_on_down"])) $sub_level_2_bkgd_gradient_hover_on_down = $_POST["sub_level_2_bkgd_gradient_hover_on_down"];
	else $sub_level_2_bkgd_gradient_hover_on_down = 0;
	
	
	if (is_numeric($_POST["top_level_gradient_type"])) $top_level_gradient_type = $_POST["top_level_gradient_type"];
	else $top_level_gradient_type = 0;
	if (is_numeric($_POST["top_level_gradient_angle"])) $top_level_gradient_angle = $_POST["top_level_gradient_angle"];
	else $top_level_gradient_angle = 0;
	if ($_POST["top_level_gradient_color_1"]) $top_level_gradient_color_1 = $_POST["top_level_gradient_color_1"];
	else $top_level_gradient_color_1 = "-not set-";
	if ($_POST["top_level_gradient_color_2"]) $top_level_gradient_color_2 = $_POST["top_level_gradient_color_2"];
	else $top_level_gradient_color_2 = "-not set-";
	if ($_POST["top_level_gradient_color_3"]) $top_level_gradient_color_3 = $_POST["top_level_gradient_color_3"];
	else $top_level_gradient_color_3 = "-not set-";
	if ($_POST["top_level_gradient_color_4"]) $top_level_gradient_color_4 = $_POST["top_level_gradient_color_4"];
	else $top_level_gradient_color_4 = "-not set-";
	if (is_numeric($_POST["top_level_gradient_opacity_1"])) $top_level_gradient_opacity_1 = $_POST["top_level_gradient_opacity_1"];
	else $top_level_gradient_opacity_1 = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_2"])) $top_level_gradient_opacity_2 = $_POST["top_level_gradient_opacity_2"];
	else $top_level_gradient_opacity_2 = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_3"])) $top_level_gradient_opacity_3 = $_POST["top_level_gradient_opacity_3"];
	else $top_level_gradient_opacity_3 = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_4"])) $top_level_gradient_opacity_4 = $_POST["top_level_gradient_opacity_4"];
	else $top_level_gradient_opacity_4 = 100;
	if (is_numeric($_POST["top_level_gradient_repeat"])) $top_level_gradient_repeat = $_POST["top_level_gradient_repeat"];
	else $top_level_gradient_repeat = 0;
	
	if (is_numeric($_POST["top_level_gradient_type_hover"])) $top_level_gradient_type_hover = $_POST["top_level_gradient_type_hover"];
	else $top_level_gradient_type_hover = 0;
	if (is_numeric($_POST["top_level_gradient_angle_hover"])) $top_level_gradient_angle_hover = $_POST["top_level_gradient_angle_hover"];
	else $top_level_gradient_angle_hover = 0;
	if ($_POST["top_level_gradient_color_1_hover"]) $top_level_gradient_color_1_hover = $_POST["top_level_gradient_color_1_hover"];
	else $top_level_gradient_color_1_hover = "-not set-";
	if ($_POST["top_level_gradient_color_2_hover"]) $top_level_gradient_color_2_hover = $_POST["top_level_gradient_color_2_hover"];
	else $top_level_gradient_color_2_hover = "-not set-";
	if ($_POST["top_level_gradient_color_3_hover"]) $top_level_gradient_color_3_hover = $_POST["top_level_gradient_color_3_hover"];
	else $top_level_gradient_color_3_hover = "-not set-";
	if ($_POST["top_level_gradient_color_4_hover"]) $top_level_gradient_color_4_hover = $_POST["top_level_gradient_color_4_hover"];
	else $top_level_gradient_color_4_hover = "-not set-";
	if (is_numeric($_POST["top_level_gradient_opacity_1_hover"])) $top_level_gradient_opacity_1_hover = $_POST["top_level_gradient_opacity_1_hover"];
	else $top_level_gradient_opacity_1_hover = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_2_hover"])) $top_level_gradient_opacity_2_hover = $_POST["top_level_gradient_opacity_2_hover"];
	else $top_level_gradient_opacity_2_hover = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_3_hover"])) $top_level_gradient_opacity_3_hover = $_POST["top_level_gradient_opacity_3_hover"];
	else $top_level_gradient_opacity_3_hover = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_4_hover"])) $top_level_gradient_opacity_4_hover = $_POST["top_level_gradient_opacity_4_hover"];
	else $top_level_gradient_opacity_4_hover = 100;
	if (is_numeric($_POST["top_level_gradient_repeat_hover"])) $top_level_gradient_repeat_hover = $_POST["top_level_gradient_repeat_hover"];
	else $top_level_gradient_repeat_hover = 0;
	
	if (is_numeric($_POST["top_level_gradient_type_down"])) $top_level_gradient_type_down = $_POST["top_level_gradient_type_down"];
	else $top_level_gradient_type_down = 0;
	if (is_numeric($_POST["top_level_gradient_angle_down"])) $top_level_gradient_angle_down = $_POST["top_level_gradient_angle_down"];
	else $top_level_gradient_angle_down = 0;
	if ($_POST["top_level_gradient_color_1_down"]) $top_level_gradient_color_1_down = $_POST["top_level_gradient_color_1_down"];
	else $top_level_gradient_color_1_down = "-not set-";
	if ($_POST["top_level_gradient_color_2_down"]) $top_level_gradient_color_2_down = $_POST["top_level_gradient_color_2_down"];
	else $top_level_gradient_color_2_down = "-not set-";
	if ($_POST["top_level_gradient_color_3_down"]) $top_level_gradient_color_3_down = $_POST["top_level_gradient_color_3_down"];
	else $top_level_gradient_color_3_down = "-not set-";
	if ($_POST["top_level_gradient_color_4_down"]) $top_level_gradient_color_4_down = $_POST["top_level_gradient_color_4_down"];
	else $top_level_gradient_color_4_down = "-not set-";
	if (is_numeric($_POST["top_level_gradient_opacity_1_down"])) $top_level_gradient_opacity_1_down = $_POST["top_level_gradient_opacity_1_down"];
	else $top_level_gradient_opacity_1_down = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_2_down"])) $top_level_gradient_opacity_2_down = $_POST["top_level_gradient_opacity_2_down"];
	else $top_level_gradient_opacity_2_down = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_3_down"])) $top_level_gradient_opacity_3_down = $_POST["top_level_gradient_opacity_3_down"];
	else $top_level_gradient_opacity_3_down = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_4_down"])) $top_level_gradient_opacity_4_down = $_POST["top_level_gradient_opacity_4_down"];
	else $top_level_gradient_opacity_4_down = 100;
	if (is_numeric($_POST["top_level_gradient_repeat_down"])) $top_level_gradient_repeat_down = $_POST["top_level_gradient_repeat_down"];
	else $top_level_gradient_repeat_down = 0;
	
	if (is_numeric($_POST["top_level_gradient_type_active"])) $top_level_gradient_type_active = $_POST["top_level_gradient_type_active"];
	else $top_level_gradient_type_active = 0;
	if (is_numeric($_POST["top_level_gradient_angle_active"])) $top_level_gradient_angle_active = $_POST["top_level_gradient_angle_active"];
	else $top_level_gradient_angle_active = 0;
	if ($_POST["top_level_gradient_color_1_active"]) $top_level_gradient_color_1_active = $_POST["top_level_gradient_color_1_active"];
	else $top_level_gradient_color_1_active = "-not set-";
	if ($_POST["top_level_gradient_color_2_active"]) $top_level_gradient_color_2_active = $_POST["top_level_gradient_color_2_active"];
	else $top_level_gradient_color_2_active = "-not set-";
	if ($_POST["top_level_gradient_color_3_active"]) $top_level_gradient_color_3_active = $_POST["top_level_gradient_color_3_active"];
	else $top_level_gradient_color_3_active = "-not set-";
	if ($_POST["top_level_gradient_color_4_active"]) $top_level_gradient_color_4_active = $_POST["top_level_gradient_color_4_active"];
	else $top_level_gradient_color_4_active = "-not set-";
	if (is_numeric($_POST["top_level_gradient_opacity_1_active"])) $top_level_gradient_opacity_1_active = $_POST["top_level_gradient_opacity_1_active"];
	else $top_level_gradient_opacity_1_active = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_2_active"])) $top_level_gradient_opacity_2_active = $_POST["top_level_gradient_opacity_2_active"];
	else $top_level_gradient_opacity_2_active = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_3_active"])) $top_level_gradient_opacity_3_active = $_POST["top_level_gradient_opacity_3_active"];
	else $top_level_gradient_opacity_3_active = 100;
	if (is_numeric($_POST["top_level_gradient_opacity_4_active"])) $top_level_gradient_opacity_4_active = $_POST["top_level_gradient_opacity_4_active"];
	else $top_level_gradient_opacity_4_active = 100;
	if (is_numeric($_POST["top_level_gradient_repeat_active"])) $top_level_gradient_repeat_active = $_POST["top_level_gradient_repeat_active"];
	else $top_level_gradient_repeat_active = 0;

	if (($top_level_gradient_color_1 == "-not set-") && ($top_level_gradient_color_2 == "-not set-") && ($top_level_gradient_color_3 == "-not set-") && ($top_level_gradient_color_4 == "-not set-"))
		$top_level_gradient_colors = "-not set-";
	else	{
		$comma = "";
		$top_level_gradient_color == "";
		if ($top_level_gradient_color_1 != "-not set-")	{
			$top_level_gradient_colors .= $top_level_gradient_color_1;
			$comma = ",";
		}
		if ($top_level_gradient_color_2 != "-not set-")	{
			$top_level_gradient_colors .= $comma . $top_level_gradient_color_2;
			$comma = ",";
		}
		if ($top_level_gradient_color_3 != "-not set-")	{
			$top_level_gradient_colors .= $comma . $top_level_gradient_color_3;
			$comma = ",";
		}
		if ($top_level_gradient_color_4 != "-not set-")	{
			$top_level_gradient_colors .= $comma . $top_level_gradient_color_4;
			$comma = ",";
		}
	}
	
	if (($top_level_gradient_opacity_1 == 100) && ($top_level_gradient_opacity_2 == 100) && ($top_level_gradient_opacity_3 == 100) && ($top_level_gradient_opacity_4 == 100))
		$top_level_gradient_opacities = "-not set-";
	else
		$top_level_gradient_opacities = $top_level_gradient_opacity_1 . "," . $top_level_gradient_opacity_2 . "," . $top_level_gradient_opacity_3 . "," . $top_level_gradient_opacity_4;
		
		
	if (($top_level_gradient_color_1_hover == "-not set-") && ($top_level_gradient_color_2_hover == "-not set-") && ($top_level_gradient_color_3_hover == "-not set-") && ($top_level_gradient_color_4_hover == "-not set-"))
		$top_level_gradient_colors_hover = "-not set-";
	else	{
		$comma = "";
		$top_level_gradient_color_hover == "";
		if ($top_level_gradient_color_1_hover != "-not set-")	{
			$top_level_gradient_colors_hover .= $top_level_gradient_color_1_hover;
			$comma = ",";
		}
		if ($top_level_gradient_color_2_hover != "-not set-")	{
			$top_level_gradient_colors_hover .= $comma . $top_level_gradient_color_2_hover;
			$comma = ",";
		}
		if ($top_level_gradient_color_3_hover != "-not set-")	{
			$top_level_gradient_colors_hover .= $comma . $top_level_gradient_color_3_hover;
			$comma = ",";
		}
		if ($top_level_gradient_color_4_hover != "-not set-")	{
			$top_level_gradient_colors_hover .= $comma . $top_level_gradient_color_4_hover;
			$comma = ",";
		}
	}
	
	if (($top_level_gradient_opacity_1_hover == 100) && ($top_level_gradient_opacity_2_hover == 100) && ($top_level_gradient_opacity_3_hover == 100) && ($top_level_gradient_opacity_4_hover == 100))
		$top_level_gradient_opacities_hover = "-not set-";
	else
		$top_level_gradient_opacities_hover = $top_level_gradient_opacity_1_hover . "," . $top_level_gradient_opacity_2_hover . "," . $top_level_gradient_opacity_3_hover . "," . $top_level_gradient_opacity_4_hover;
		
		
	if (($top_level_gradient_color_1_down == "-not set-") && ($top_level_gradient_color_2_down == "-not set-") && ($top_level_gradient_color_3_down == "-not set-") && ($top_level_gradient_color_4_down == "-not set-"))
		$top_level_gradient_colors_down = "-not set-";
	else	{
		$comma = "";
		$top_level_gradient_color_down == "";
		if ($top_level_gradient_color_1_down != "-not set-")	{
			$top_level_gradient_colors_down .= $top_level_gradient_color_1_down;
			$comma = ",";
		}
		if ($top_level_gradient_color_2_down != "-not set-")	{
			$top_level_gradient_colors_down .= $comma . $top_level_gradient_color_2_down;
			$comma = ",";
		}
		if ($top_level_gradient_color_3_down != "-not set-")	{
			$top_level_gradient_colors_down .= $comma . $top_level_gradient_color_3_down;
			$comma = ",";
		}
		if ($top_level_gradient_color_4_down != "-not set-")	{
			$top_level_gradient_colors_down .= $comma . $top_level_gradient_color_4_down;
			$comma = ",";
		}
	}
	
	if (($top_level_gradient_opacity_1_down == 100) && ($top_level_gradient_opacity_2_down == 100) && ($top_level_gradient_opacity_3_down == 100) && ($top_level_gradient_opacity_4_down == 100))
		$top_level_gradient_opacities_down = "-not set-";
	else
		$top_level_gradient_opacities_down = $top_level_gradient_opacity_1_down . "," . $top_level_gradient_opacity_2_down . "," . $top_level_gradient_opacity_3_down . "," . $top_level_gradient_opacity_4_down;
		
		
	if (($top_level_gradient_color_1_active == "-not set-") && ($top_level_gradient_color_2_active == "-not set-") && ($top_level_gradient_color_3_active == "-not set-") && ($top_level_gradient_color_4_active == "-not set-"))
		$top_level_gradient_colors_active = "-not set-";
	else	{
		$comma = "";
		$top_level_gradient_color_active == "";
		if ($top_level_gradient_color_1_active != "-not set-")	{
			$top_level_gradient_colors_active .= $top_level_gradient_color_1_active;
			$comma = ",";
		}
		if ($top_level_gradient_color_2_active != "-not set-")	{
			$top_level_gradient_colors_active .= $comma . $top_level_gradient_color_2_active;
			$comma = ",";
		}
		if ($top_level_gradient_color_3_active != "-not set-")	{
			$top_level_gradient_colors_active .= $comma . $top_level_gradient_color_3_active;
			$comma = ",";
		}
		if ($top_level_gradient_color_4_active != "-not set-")	{
			$top_level_gradient_colors_active .= $comma . $top_level_gradient_color_4_active;
			$comma = ",";
		}
	}
	
	if (($top_level_gradient_opacity_1_active == 100) && ($top_level_gradient_opacity_2_active == 100) && ($top_level_gradient_opacity_3_active == 100) && ($top_level_gradient_opacity_4_active == 100))
		$top_level_gradient_opacities_active = "-not set-";
	else
		$top_level_gradient_opacities_active = $top_level_gradient_opacity_1_active . "," . $top_level_gradient_opacity_2_active . "," . $top_level_gradient_opacity_3_active . "," . $top_level_gradient_opacity_4_active;
		
		
	if (is_numeric($_POST["sub_level_1_gradient_type"])) $sub_level_1_gradient_type = $_POST["sub_level_1_gradient_type"];
	else $sub_level_1_gradient_type = 0;
	if (is_numeric($_POST["sub_level_1_gradient_angle"])) $sub_level_1_gradient_angle = $_POST["sub_level_1_gradient_angle"];
	else $sub_level_1_gradient_angle = 0;
	if ($_POST["sub_level_1_gradient_color_1"]) $sub_level_1_gradient_color_1 = $_POST["sub_level_1_gradient_color_1"];
	else $sub_level_1_gradient_color_1 = "-not set-";
	if ($_POST["sub_level_1_gradient_color_2"]) $sub_level_1_gradient_color_2 = $_POST["sub_level_1_gradient_color_2"];
	else $sub_level_1_gradient_color_2 = "-not set-";
	if ($_POST["sub_level_1_gradient_color_3"]) $sub_level_1_gradient_color_3 = $_POST["sub_level_1_gradient_color_3"];
	else $sub_level_1_gradient_color_3 = "-not set-";
	if ($_POST["sub_level_1_gradient_color_4"]) $sub_level_1_gradient_color_4 = $_POST["sub_level_1_gradient_color_4"];
	else $sub_level_1_gradient_color_4 = "-not set-";
	if (is_numeric($_POST["sub_level_1_gradient_opacity_1"])) $sub_level_1_gradient_opacity_1 = $_POST["sub_level_1_gradient_opacity_1"];
	else $sub_level_1_gradient_opacity_1 = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_2"])) $sub_level_1_gradient_opacity_2 = $_POST["sub_level_1_gradient_opacity_2"];
	else $sub_level_1_gradient_opacity_2 = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_3"])) $sub_level_1_gradient_opacity_3 = $_POST["sub_level_1_gradient_opacity_3"];
	else $sub_level_1_gradient_opacity_3 = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_4"])) $sub_level_1_gradient_opacity_4 = $_POST["sub_level_1_gradient_opacity_4"];
	else $sub_level_1_gradient_opacity_4 = 100;
	if (is_numeric($_POST["sub_level_1_gradient_repeat"])) $sub_level_1_gradient_repeat = $_POST["sub_level_1_gradient_repeat"];
	else $sub_level_1_gradient_repeat = 0;
	
	if (is_numeric($_POST["sub_level_1_gradient_type_hover"])) $sub_level_1_gradient_type_hover = $_POST["sub_level_1_gradient_type_hover"];
	else $sub_level_1_gradient_type_hover = 0;
	if (is_numeric($_POST["sub_level_1_gradient_angle_hover"])) $sub_level_1_gradient_angle_hover = $_POST["sub_level_1_gradient_angle_hover"];
	else $sub_level_1_gradient_angle_hover = 0;
	if ($_POST["sub_level_1_gradient_color_1_hover"]) $sub_level_1_gradient_color_1_hover = $_POST["sub_level_1_gradient_color_1_hover"];
	else $sub_level_1_gradient_color_1_hover = "-not set-";
	if ($_POST["sub_level_1_gradient_color_2_hover"]) $sub_level_1_gradient_color_2_hover = $_POST["sub_level_1_gradient_color_2_hover"];
	else $sub_level_1_gradient_color_2_hover = "-not set-";
	if ($_POST["sub_level_1_gradient_color_3_hover"]) $sub_level_1_gradient_color_3_hover = $_POST["sub_level_1_gradient_color_3_hover"];
	else $sub_level_1_gradient_color_3_hover = "-not set-";
	if ($_POST["sub_level_1_gradient_color_4_hover"]) $sub_level_1_gradient_color_4_hover = $_POST["sub_level_1_gradient_color_4_hover"];
	else $sub_level_1_gradient_color_4_hover = "-not set-";
	if (is_numeric($_POST["sub_level_1_gradient_opacity_1_hover"])) $sub_level_1_gradient_opacity_1_hover = $_POST["sub_level_1_gradient_opacity_1_hover"];
	else $sub_level_1_gradient_opacity_1_hover = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_2_hover"])) $sub_level_1_gradient_opacity_2_hover = $_POST["sub_level_1_gradient_opacity_2_hover"];
	else $sub_level_1_gradient_opacity_2_hover = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_3_hover"])) $sub_level_1_gradient_opacity_3_hover = $_POST["sub_level_1_gradient_opacity_3_hover"];
	else $sub_level_1_gradient_opacity_3_hover = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_4_hover"])) $sub_level_1_gradient_opacity_4_hover = $_POST["sub_level_1_gradient_opacity_4_hover"];
	else $sub_level_1_gradient_opacity_4_hover = 100;
	if (is_numeric($_POST["sub_level_1_gradient_repeat_hover"])) $sub_level_1_gradient_repeat_hover = $_POST["sub_level_1_gradient_repeat_hover"];
	else $sub_level_1_gradient_repeat_hover = 0;
	
	if (is_numeric($_POST["sub_level_1_gradient_type_down"])) $sub_level_1_gradient_type_down = $_POST["sub_level_1_gradient_type_down"];
	else $sub_level_1_gradient_type_down = 0;
	if (is_numeric($_POST["sub_level_1_gradient_angle_down"])) $sub_level_1_gradient_angle_down = $_POST["sub_level_1_gradient_angle_down"];
	else $sub_level_1_gradient_angle_down = 0;
	if ($_POST["sub_level_1_gradient_color_1_down"]) $sub_level_1_gradient_color_1_down = $_POST["sub_level_1_gradient_color_1_down"];
	else $sub_level_1_gradient_color_1_down = "-not set-";
	if ($_POST["sub_level_1_gradient_color_2_down"]) $sub_level_1_gradient_color_2_down = $_POST["sub_level_1_gradient_color_2_down"];
	else $sub_level_1_gradient_color_2_down = "-not set-";
	if ($_POST["sub_level_1_gradient_color_3_down"]) $sub_level_1_gradient_color_3_down = $_POST["sub_level_1_gradient_color_3_down"];
	else $sub_level_1_gradient_color_3_down = "-not set-";
	if ($_POST["sub_level_1_gradient_color_4_down"]) $sub_level_1_gradient_color_4_down = $_POST["sub_level_1_gradient_color_4_down"];
	else $sub_level_1_gradient_color_4_down = "-not set-";
	if (is_numeric($_POST["sub_level_1_gradient_opacity_1_down"])) $sub_level_1_gradient_opacity_1_down = $_POST["sub_level_1_gradient_opacity_1_down"];
	else $sub_level_1_gradient_opacity_1_down = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_2_down"])) $sub_level_1_gradient_opacity_2_down = $_POST["sub_level_1_gradient_opacity_2_down"];
	else $sub_level_1_gradient_opacity_2_down = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_3_down"])) $sub_level_1_gradient_opacity_3_down = $_POST["sub_level_1_gradient_opacity_3_down"];
	else $sub_level_1_gradient_opacity_3_down = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_4_down"])) $sub_level_1_gradient_opacity_4_down = $_POST["sub_level_1_gradient_opacity_4_down"];
	else $sub_level_1_gradient_opacity_4_down = 100;
	if (is_numeric($_POST["sub_level_1_gradient_repeat_down"])) $sub_level_1_gradient_repeat_down = $_POST["sub_level_1_gradient_repeat_down"];
	else $sub_level_1_gradient_repeat_down = 0;
	
	if (is_numeric($_POST["sub_level_1_gradient_type_active"])) $sub_level_1_gradient_type_active = $_POST["sub_level_1_gradient_type_active"];
	else $sub_level_1_gradient_type_active = 0;
	if (is_numeric($_POST["sub_level_1_gradient_angle_active"])) $sub_level_1_gradient_angle_active = $_POST["sub_level_1_gradient_angle_active"];
	else $sub_level_1_gradient_angle_active = 0;
	if ($_POST["sub_level_1_gradient_color_1_active"]) $sub_level_1_gradient_color_1_active = $_POST["sub_level_1_gradient_color_1_active"];
	else $sub_level_1_gradient_color_1_active = "-not set-";
	if ($_POST["sub_level_1_gradient_color_2_active"]) $sub_level_1_gradient_color_2_active = $_POST["sub_level_1_gradient_color_2_active"];
	else $sub_level_1_gradient_color_2_active = "-not set-";
	if ($_POST["sub_level_1_gradient_color_3_active"]) $sub_level_1_gradient_color_3_active = $_POST["sub_level_1_gradient_color_3_active"];
	else $sub_level_1_gradient_color_3_active = "-not set-";
	if ($_POST["sub_level_1_gradient_color_4_active"]) $sub_level_1_gradient_color_4_active = $_POST["sub_level_1_gradient_color_4_active"];
	else $sub_level_1_gradient_color_4_active = "-not set-";
	if (is_numeric($_POST["sub_level_1_gradient_opacity_1_active"])) $sub_level_1_gradient_opacity_1_active = $_POST["sub_level_1_gradient_opacity_1_active"];
	else $sub_level_1_gradient_opacity_1_active = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_2_active"])) $sub_level_1_gradient_opacity_2_active = $_POST["sub_level_1_gradient_opacity_2_active"];
	else $sub_level_1_gradient_opacity_2_active = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_3_active"])) $sub_level_1_gradient_opacity_3_active = $_POST["sub_level_1_gradient_opacity_3_active"];
	else $sub_level_1_gradient_opacity_3_active = 100;
	if (is_numeric($_POST["sub_level_1_gradient_opacity_4_active"])) $sub_level_1_gradient_opacity_4_active = $_POST["sub_level_1_gradient_opacity_4_active"];
	else $sub_level_1_gradient_opacity_4_active = 100;
	if (is_numeric($_POST["sub_level_1_gradient_repeat_active"])) $sub_level_1_gradient_repeat_active = $_POST["sub_level_1_gradient_repeat_active"];
	else $sub_level_1_gradient_repeat_active = 0;
	
	if (($sub_level_1_gradient_color_1 == "-not set-") && ($sub_level_1_gradient_color_2 == "-not set-") && ($sub_level_1_gradient_color_3 == "-not set-") && ($sub_level_1_gradient_color_4 == "-not set-"))
		$sub_level_1_gradient_colors = "-not set-";
	else	{
		$comma = "";
		$sub_level_1_gradient_color == "";
		if ($sub_level_1_gradient_color_1 != "-not set-")	{
			$sub_level_1_gradient_colors .= $sub_level_1_gradient_color_1;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_2 != "-not set-")	{
			$sub_level_1_gradient_colors .= $comma . $sub_level_1_gradient_color_2;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_3 != "-not set-")	{
			$sub_level_1_gradient_colors .= $comma . $sub_level_1_gradient_color_3;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_4 != "-not set-")	{
			$sub_level_1_gradient_colors .= $comma . $sub_level_1_gradient_color_4;
			$comma = ",";
		}
	}
	
	if (($sub_level_1_gradient_opacity_1 == 100) && ($sub_level_1_gradient_opacity_2 == 100) && ($sub_level_1_gradient_opacity_3 == 100) && ($sub_level_1_gradient_opacity_4 == 100))
		$sub_level_1_gradient_opacities = "-not set-";
	else
		$sub_level_1_gradient_opacities = $sub_level_1_gradient_opacity_1 . "," . $sub_level_1_gradient_opacity_2 . "," . $sub_level_1_gradient_opacity_3 . "," . $sub_level_1_gradient_opacity_4;
		
		
	if (($sub_level_1_gradient_color_1_hover == "-not set-") && ($sub_level_1_gradient_color_2_hover == "-not set-") && ($sub_level_1_gradient_color_3_hover == "-not set-") && ($sub_level_1_gradient_color_4_hover == "-not set-"))
		$sub_level_1_gradient_colors_hover = "-not set-";
	else	{
		$comma = "";
		$sub_level_1_gradient_color_hover == "";
		if ($sub_level_1_gradient_color_1_hover != "-not set-")	{
			$sub_level_1_gradient_colors_hover .= $sub_level_1_gradient_color_1_hover;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_2_hover != "-not set-")	{
			$sub_level_1_gradient_colors_hover .= $comma . $sub_level_1_gradient_color_2_hover;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_3_hover != "-not set-")	{
			$sub_level_1_gradient_colors_hover .= $comma . $sub_level_1_gradient_color_3_hover;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_4_hover != "-not set-")	{
			$sub_level_1_gradient_colors_hover .= $comma . $sub_level_1_gradient_color_4_hover;
			$comma = ",";
		}
	}
	
	if (($sub_level_1_gradient_opacity_1_hover == 100) && ($sub_level_1_gradient_opacity_2_hover == 100) && ($sub_level_1_gradient_opacity_3_hover == 100) && ($sub_level_1_gradient_opacity_4_hover == 100))
		$sub_level_1_gradient_opacities_hover = "-not set-";
	else
		$sub_level_1_gradient_opacities_hover = $sub_level_1_gradient_opacity_1_hover . "," . $sub_level_1_gradient_opacity_2_hover . "," . $sub_level_1_gradient_opacity_3_hover . "," . $sub_level_1_gradient_opacity_4_hover;
		
		
	if (($sub_level_1_gradient_color_1_down == "-not set-") && ($sub_level_1_gradient_color_2_down == "-not set-") && ($sub_level_1_gradient_color_3_down == "-not set-") && ($sub_level_1_gradient_color_4_down == "-not set-"))
		$sub_level_1_gradient_colors_down = "-not set-";
	else	{
		$comma = "";
		$sub_level_1_gradient_color_down == "";
		if ($sub_level_1_gradient_color_1_down != "-not set-")	{
			$sub_level_1_gradient_colors_down .= $sub_level_1_gradient_color_1_down;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_2_down != "-not set-")	{
			$sub_level_1_gradient_colors_down .= $comma . $sub_level_1_gradient_color_2_down;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_3_down != "-not set-")	{
			$sub_level_1_gradient_colors_down .= $comma . $sub_level_1_gradient_color_3_down;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_4_down != "-not set-")	{
			$sub_level_1_gradient_colors_down .= $comma . $sub_level_1_gradient_color_4_down;
			$comma = ",";
		}
	}

	if (($sub_level_1_gradient_opacity_1_down == 100) && ($sub_level_1_gradient_opacity_2_down == 100) && ($sub_level_1_gradient_opacity_3_down == 100) && ($sub_level_1_gradient_opacity_4_down == 100))
		$sub_level_1_gradient_opacities_down = "-not set-";
	else
		$sub_level_1_gradient_opacities_down = $sub_level_1_gradient_opacity_1_down . "," . $sub_level_1_gradient_opacity_2_down . "," . $sub_level_1_gradient_opacity_3_down . "," . $sub_level_1_gradient_opacity_4_down;
		
		
	if (($sub_level_1_gradient_color_1_active == "-not set-") && ($sub_level_1_gradient_color_2_active == "-not set-") && ($sub_level_1_gradient_color_3_active == "-not set-") && ($sub_level_1_gradient_color_4_active == "-not set-"))
		$sub_level_1_gradient_colors_active = "-not set-";
	else	{
		$comma = "";
		$sub_level_1_gradient_color_active == "";
		if ($sub_level_1_gradient_color_1_active != "-not set-")	{
			$sub_level_1_gradient_colors_active .= $sub_level_1_gradient_color_1_active;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_2_active != "-not set-")	{
			$sub_level_1_gradient_colors_active .= $comma . $sub_level_1_gradient_color_2_active;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_3_active != "-not set-")	{
			$sub_level_1_gradient_colors_active .= $comma . $sub_level_1_gradient_color_3_active;
			$comma = ",";
		}
		if ($sub_level_1_gradient_color_4_active != "-not set-")	{
			$sub_level_1_gradient_colors_active .= $comma . $sub_level_1_gradient_color_4_active;
			$comma = ",";
		}
	}
	
	if (($sub_level_1_gradient_opacity_1_active == 100) && ($sub_level_1_gradient_opacity_2_active == 100) && ($sub_level_1_gradient_opacity_3_active == 100) && ($sub_level_1_gradient_opacity_4_active == 100))
		$sub_level_1_gradient_opacities_active = "-not set-";
	else
		$sub_level_1_gradient_opacities_active = $sub_level_1_gradient_opacity_1_active . "," . $sub_level_1_gradient_opacity_2_active . "," . $sub_level_1_gradient_opacity_3_active . "," . $sub_level_1_gradient_opacity_4_active;
		
		
	if (is_numeric($_POST["sub_level_2_gradient_type"])) $sub_level_2_gradient_type = $_POST["sub_level_2_gradient_type"];
	else $sub_level_2_gradient_type = 0;
	if (is_numeric($_POST["sub_level_2_gradient_angle"])) $sub_level_2_gradient_angle = $_POST["sub_level_2_gradient_angle"];
	else $sub_level_2_gradient_angle = 0;
	if ($_POST["sub_level_2_gradient_color_1"]) $sub_level_2_gradient_color_1 = $_POST["sub_level_2_gradient_color_1"];
	else $sub_level_2_gradient_color_1 = "-not set-";
	if ($_POST["sub_level_2_gradient_color_2"]) $sub_level_2_gradient_color_2 = $_POST["sub_level_2_gradient_color_2"];
	else $sub_level_2_gradient_color_2 = "-not set-";
	if ($_POST["sub_level_2_gradient_color_3"]) $sub_level_2_gradient_color_3 = $_POST["sub_level_2_gradient_color_3"];
	else $sub_level_2_gradient_color_3 = "-not set-";
	if ($_POST["sub_level_2_gradient_color_4"]) $sub_level_2_gradient_color_4 = $_POST["sub_level_2_gradient_color_4"];
	else $sub_level_2_gradient_color_4 = "-not set-";
	if (is_numeric($_POST["sub_level_2_gradient_opacity_1"])) $sub_level_2_gradient_opacity_1 = $_POST["sub_level_2_gradient_opacity_1"];
	else $sub_level_2_gradient_opacity_1 = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_2"])) $sub_level_2_gradient_opacity_2 = $_POST["sub_level_2_gradient_opacity_2"];
	else $sub_level_2_gradient_opacity_2 = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_3"])) $sub_level_2_gradient_opacity_3 = $_POST["sub_level_2_gradient_opacity_3"];
	else $sub_level_2_gradient_opacity_3 = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_4"])) $sub_level_2_gradient_opacity_4 = $_POST["sub_level_2_gradient_opacity_4"];
	else $sub_level_2_gradient_opacity_4 = 100;
	if (is_numeric($_POST["sub_level_2_gradient_repeat"])) $sub_level_2_gradient_repeat = $_POST["sub_level_2_gradient_repeat"];
	else $sub_level_2_gradient_repeat = 0;
	
	if (is_numeric($_POST["sub_level_2_gradient_type_hover"])) $sub_level_2_gradient_type_hover = $_POST["sub_level_2_gradient_type_hover"];
	else $sub_level_2_gradient_type_hover = 0;
	if (is_numeric($_POST["sub_level_2_gradient_angle_hover"])) $sub_level_2_gradient_angle_hover = $_POST["sub_level_2_gradient_angle_hover"];
	else $sub_level_2_gradient_angle_hover = 0;
	if ($_POST["sub_level_2_gradient_color_1_hover"]) $sub_level_2_gradient_color_1_hover = $_POST["sub_level_2_gradient_color_1_hover"];
	else $sub_level_2_gradient_color_1_hover = "-not set-";
	if ($_POST["sub_level_2_gradient_color_2_hover"]) $sub_level_2_gradient_color_2_hover = $_POST["sub_level_2_gradient_color_2_hover"];
	else $sub_level_2_gradient_color_2_hover = "-not set-";
	if ($_POST["sub_level_2_gradient_color_3_hover"]) $sub_level_2_gradient_color_3_hover = $_POST["sub_level_2_gradient_color_3_hover"];
	else $sub_level_2_gradient_color_3_hover = "-not set-";
	if ($_POST["sub_level_2_gradient_color_4_hover"]) $sub_level_2_gradient_color_4_hover = $_POST["sub_level_2_gradient_color_4_hover"];
	else $sub_level_2_gradient_color_4_hover = "-not set-";
	if (is_numeric($_POST["sub_level_2_gradient_opacity_1_hover"])) $sub_level_2_gradient_opacity_1_hover = $_POST["sub_level_2_gradient_opacity_1_hover"];
	else $sub_level_2_gradient_opacity_1_hover = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_2_hover"])) $sub_level_2_gradient_opacity_2_hover = $_POST["sub_level_2_gradient_opacity_2_hover"];
	else $sub_level_2_gradient_opacity_2_hover = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_3_hover"])) $sub_level_2_gradient_opacity_3_hover = $_POST["sub_level_2_gradient_opacity_3_hover"];
	else $sub_level_2_gradient_opacity_3_hover = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_4_hover"])) $sub_level_2_gradient_opacity_4_hover = $_POST["sub_level_2_gradient_opacity_4_hover"];
	else $sub_level_2_gradient_opacity_4_hover = 100;
	if (is_numeric($_POST["sub_level_2_gradient_repeat_hover"])) $sub_level_2_gradient_repeat_hover = $_POST["sub_level_2_gradient_repeat_hover"];
	else $sub_level_2_gradient_repeat_hover = 0;
	
	if (is_numeric($_POST["sub_level_2_gradient_type_down"])) $sub_level_2_gradient_type_down = $_POST["sub_level_2_gradient_type_down"];
	else $sub_level_2_gradient_type_down = 0;
	if (is_numeric($_POST["sub_level_2_gradient_angle_down"])) $sub_level_2_gradient_angle_down = $_POST["sub_level_2_gradient_angle_down"];
	else $sub_level_2_gradient_angle_down = 0;
	if ($_POST["sub_level_2_gradient_color_1_down"]) $sub_level_2_gradient_color_1_down = $_POST["sub_level_2_gradient_color_1_down"];
	else $sub_level_2_gradient_color_1_down = "-not set-";
	if ($_POST["sub_level_2_gradient_color_2_down"]) $sub_level_2_gradient_color_2_down = $_POST["sub_level_2_gradient_color_2_down"];
	else $sub_level_2_gradient_color_2_down = "-not set-";
	if ($_POST["sub_level_2_gradient_color_3_down"]) $sub_level_2_gradient_color_3_down = $_POST["sub_level_2_gradient_color_3_down"];
	else $sub_level_2_gradient_color_3_down = "-not set-";
	if ($_POST["sub_level_2_gradient_color_4_down"]) $sub_level_2_gradient_color_4_down = $_POST["sub_level_2_gradient_color_4_down"];
	else $sub_level_2_gradient_color_4_down = "-not set-";
	if (is_numeric($_POST["sub_level_2_gradient_opacity_1_down"])) $sub_level_2_gradient_opacity_1_down = $_POST["sub_level_2_gradient_opacity_1_down"];
	else $sub_level_2_gradient_opacity_1_down = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_2_down"])) $sub_level_2_gradient_opacity_2_down = $_POST["sub_level_2_gradient_opacity_2_down"];
	else $sub_level_2_gradient_opacity_2_down = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_3_down"])) $sub_level_2_gradient_opacity_3_down = $_POST["sub_level_2_gradient_opacity_3_down"];
	else $sub_level_2_gradient_opacity_3_down = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_4_down"])) $sub_level_2_gradient_opacity_4_down = $_POST["sub_level_2_gradient_opacity_4_down"];
	else $sub_level_2_gradient_opacity_4_down = 100;
	if (is_numeric($_POST["sub_level_2_gradient_repeat_down"])) $sub_level_2_gradient_repeat_down = $_POST["sub_level_2_gradient_repeat_down"];
	else $sub_level_2_gradient_repeat_down = 0;
	
	if (is_numeric($_POST["sub_level_2_gradient_type_active"])) $sub_level_2_gradient_type_active = $_POST["sub_level_2_gradient_type_active"];
	else $sub_level_2_gradient_type_active = 0;
	if (is_numeric($_POST["sub_level_2_gradient_angle_active"])) $sub_level_2_gradient_angle_active = $_POST["sub_level_2_gradient_angle_active"];
	else $sub_level_2_gradient_angle_active = 0;
	if ($_POST["sub_level_2_gradient_color_1_active"]) $sub_level_2_gradient_color_1_active = $_POST["sub_level_2_gradient_color_1_active"];
	else $sub_level_2_gradient_color_1_active = "-not set-";
	if ($_POST["sub_level_2_gradient_color_2_active"]) $sub_level_2_gradient_color_2_active = $_POST["sub_level_2_gradient_color_2_active"];
	else $sub_level_2_gradient_color_2_active = "-not set-";
	if ($_POST["sub_level_2_gradient_color_3_active"]) $sub_level_2_gradient_color_3_active = $_POST["sub_level_2_gradient_color_3_active"];
	else $sub_level_2_gradient_color_3_active = "-not set-";
	if ($_POST["sub_level_2_gradient_color_4_active"]) $sub_level_2_gradient_color_4_active = $_POST["sub_level_2_gradient_color_4_active"];
	else $sub_level_2_gradient_color_4_active = "-not set-";
	if (is_numeric($_POST["sub_level_2_gradient_opacity_1_active"])) $sub_level_2_gradient_opacity_1_active = $_POST["sub_level_2_gradient_opacity_1_active"];
	else $sub_level_2_gradient_opacity_1_active = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_2_active"])) $sub_level_2_gradient_opacity_2_active = $_POST["sub_level_2_gradient_opacity_2_active"];
	else $sub_level_2_gradient_opacity_2_active = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_3_active"])) $sub_level_2_gradient_opacity_3_active = $_POST["sub_level_2_gradient_opacity_3_active"];
	else $sub_level_2_gradient_opacity_3_active = 100;
	if (is_numeric($_POST["sub_level_2_gradient_opacity_4_active"])) $sub_level_2_gradient_opacity_4_active = $_POST["sub_level_2_gradient_opacity_4_active"];
	else $sub_level_2_gradient_opacity_4_active = 100;
	if (is_numeric($_POST["sub_level_2_gradient_repeat_active"])) $sub_level_2_gradient_repeat_active = $_POST["sub_level_2_gradient_repeat_active"];
	else $sub_level_2_gradient_repeat_active = 0;
	
	if (($sub_level_2_gradient_color_1 == "-not set-") && ($sub_level_2_gradient_color_2 == "-not set-") && ($sub_level_2_gradient_color_3 == "-not set-") && ($sub_level_2_gradient_color_4 == "-not set-"))
		$sub_level_2_gradient_colors = "-not set-";
	else	{
		$comma = "";
		$sub_level_2_gradient_color == "";
		if ($sub_level_2_gradient_color_1 != "-not set-")	{
			$sub_level_2_gradient_colors .= $sub_level_2_gradient_color_1;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_2 != "-not set-")	{
			$sub_level_2_gradient_colors .= $comma . $sub_level_2_gradient_color_2;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_3 != "-not set-")	{
			$sub_level_2_gradient_colors .= $comma . $sub_level_2_gradient_color_3;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_4 != "-not set-")	{
			$sub_level_2_gradient_colors .= $comma . $sub_level_2_gradient_color_4;
			$comma = ",";
		}
	}
	
	if (($sub_level_2_gradient_opacity_1 == 100) && ($sub_level_2_gradient_opacity_2 == 100) && ($sub_level_2_gradient_opacity_3 == 100) && ($sub_level_2_gradient_opacity_4 == 100))
		$sub_level_2_gradient_opacities = "-not set-";
	else
		$sub_level_2_gradient_opacities = $sub_level_2_gradient_opacity_1 . "," . $sub_level_2_gradient_opacity_2 . "," . $sub_level_2_gradient_opacity_3 . "," . $sub_level_2_gradient_opacity_4;
		
		
	if (($sub_level_2_gradient_color_1_hover == "-not set-") && ($sub_level_2_gradient_color_2_hover == "-not set-") && ($sub_level_2_gradient_color_3_hover == "-not set-") && ($sub_level_2_gradient_color_4_hover == "-not set-"))
		$sub_level_2_gradient_colors_hover = "-not set-";
	else	{
		$comma = "";
		$sub_level_2_gradient_color_hover == "";
		if ($sub_level_2_gradient_color_1_hover != "-not set-")	{
			$sub_level_2_gradient_colors_hover .= $sub_level_2_gradient_color_1_hover;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_2_hover != "-not set-")	{
			$sub_level_2_gradient_colors_hover .= $comma . $sub_level_2_gradient_color_2_hover;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_3_hover != "-not set-")	{
			$sub_level_2_gradient_colors_hover .= $comma . $sub_level_2_gradient_color_3_hover;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_4_hover != "-not set-")	{
			$sub_level_2_gradient_colors_hover .= $comma . $sub_level_2_gradient_color_4_hover;
			$comma = ",";
		}
	}
	
	if (($sub_level_2_gradient_opacity_1_hover == 100) && ($sub_level_2_gradient_opacity_2_hover == 100) && ($sub_level_2_gradient_opacity_3_hover == 100) && ($sub_level_2_gradient_opacity_4_hover == 100))
		$sub_level_2_gradient_opacities_hover = "-not set-";
	else
		$sub_level_2_gradient_opacities_hover = $sub_level_2_gradient_opacity_1_hover . "," . $sub_level_2_gradient_opacity_2_hover . "," . $sub_level_2_gradient_opacity_3_hover . "," . $sub_level_2_gradient_opacity_4_hover;
		
		
	if (($sub_level_2_gradient_color_1_down == "-not set-") && ($sub_level_2_gradient_color_2_down == "-not set-") && ($sub_level_2_gradient_color_3_down == "-not set-") && ($sub_level_2_gradient_color_4_down == "-not set-"))
		$sub_level_2_gradient_colors_down = "-not set-";
	else	{
		$comma = "";
		$sub_level_2_gradient_color_down == "";
		if ($sub_level_2_gradient_color_1_down != "-not set-")	{
			$sub_level_2_gradient_colors_down .= $sub_level_2_gradient_color_1_down;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_2_down != "-not set-")	{
			$sub_level_2_gradient_colors_down .= $comma . $sub_level_2_gradient_color_2_down;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_3_down != "-not set-")	{
			$sub_level_2_gradient_colors_down .= $comma . $sub_level_2_gradient_color_3_down;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_4_down != "-not set-")	{
			$sub_level_2_gradient_colors_down .= $comma . $sub_level_2_gradient_color_4_down;
			$comma = ",";
		}
	}

	if (($sub_level_2_gradient_opacity_1_down == 100) && ($sub_level_2_gradient_opacity_2_down == 100) && ($sub_level_2_gradient_opacity_3_down == 100) && ($sub_level_2_gradient_opacity_4_down == 100))
		$sub_level_2_gradient_opacities_down = "-not set-";
	else
		$sub_level_2_gradient_opacities_down = $sub_level_2_gradient_opacity_1_down . "," . $sub_level_2_gradient_opacity_2_down . "," . $sub_level_2_gradient_opacity_3_down . "," . $sub_level_2_gradient_opacity_4_down;
		
		
	if (($sub_level_2_gradient_color_1_active == "-not set-") && ($sub_level_2_gradient_color_2_active == "-not set-") && ($sub_level_2_gradient_color_3_active == "-not set-") && ($sub_level_2_gradient_color_4_active == "-not set-"))
		$sub_level_2_gradient_colors_active = "-not set-";
	else	{
		$comma = "";
		$sub_level_2_gradient_color_active == "";
		if ($sub_level_2_gradient_color_1_active != "-not set-")	{
			$sub_level_2_gradient_colors_active .= $sub_level_2_gradient_color_1_active;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_2_active != "-not set-")	{
			$sub_level_2_gradient_colors_active .= $comma . $sub_level_2_gradient_color_2_active;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_3_active != "-not set-")	{
			$sub_level_2_gradient_colors_active .= $comma . $sub_level_2_gradient_color_3_active;
			$comma = ",";
		}
		if ($sub_level_2_gradient_color_4_active != "-not set-")	{
			$sub_level_2_gradient_colors_active .= $comma . $sub_level_2_gradient_color_4_active;
			$comma = ",";
		}
	}
	
	if (($sub_level_2_gradient_opacity_1_active == 100) && ($sub_level_2_gradient_opacity_2_active == 100) && ($sub_level_2_gradient_opacity_3_active == 100) && ($sub_level_2_gradient_opacity_4_active == 100))
		$sub_level_2_gradient_opacities_active = "-not set-";
	else
		$sub_level_2_gradient_opacities_active = $sub_level_2_gradient_opacity_1_active . "," . $sub_level_2_gradient_opacity_2_active . "," . $sub_level_2_gradient_opacity_3_active . "," . $sub_level_2_gradient_opacity_4_active;
		
	

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["display"] == "block")
		$orientation = "horizontal";
	else
		$orientation = "vertical";
		
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_1_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["float"] == "left")
		$sub_level_1_orientation = "horizontal";
	else
		$sub_level_1_orientation = "vertical";
		
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.sub_level_2_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["float"] == "left")
		$sub_level_2_orientation = "horizontal";
	else
		$sub_level_2_orientation = "vertical";

	if (isset($_POST["top_level_item_omit_adjacent_border"]) && isset($_POST["top_level_item_border_top"]) && isset($_POST["top_level_item_border_bottom"]) && isset($_POST["top_level_item_border_left"]) && isset($_POST["top_level_item_border_right"]) && ($top_level_item_border_width > -1))	{
		$top_level_item_omit_adjacent_border = 1;
		if ($orientation == "horizontal")
			$top_level_item_border_sides = 8 | 4 | 2;
		else
			$top_level_item_border_sides = 8 | 2 | 1;
		$top_level_item_border_sides_h_d_a = 15;
	}
	else	{
		$top_level_item_omit_adjacent_border = 0;
		$top_level_item_border_sides_h_d_a = $top_level_item_border_sides;
	}
		
	if (isset($_POST["sub_level_1_item_omit_adjacent_border"]) && isset($_POST["sub_level_1_item_border_top"]) && isset($_POST["sub_level_1_item_border_bottom"]) && isset($_POST["sub_level_1_item_border_left"]) && isset($_POST["sub_level_1_item_border_right"]))	{
		$sub_level_1_item_omit_adjacent_border = 1;
		if ($sub_level_1_orientation == "horizontal")
			$sub_level_1_item_border_sides = 8 | 4 | 2;
		else
			$sub_level_1_item_border_sides = 8 | 2 | 1;
		$sub_level_1_item_border_sides_h_d_a = 15;
	}
	else	{
		$sub_level_1_item_omit_adjacent_border = 0;
		$sub_level_1_item_border_sides_h_d_a = $sub_level_1_item_border_sides;
	}
		
	if (isset($_POST["sub_level_2_item_omit_adjacent_border"]) && isset($_POST["sub_level_2_item_border_top"]) && isset($_POST["sub_level_2_item_border_bottom"]) && isset($_POST["sub_level_2_item_border_left"]) && isset($_POST["sub_level_2_item_border_right"]))	{
		$sub_level_2_item_omit_adjacent_border = 1;
		if ($sub_level_2_orientation == "horizontal")
			$sub_level_2_item_border_sides = 8 | 4 | 2;
		else
			$sub_level_2_item_border_sides = 8 | 2 | 1;
		$sub_level_2_item_border_sides_h_d_a = 15;
	}
	else	{
		$sub_level_2_item_omit_adjacent_border = 0;
		$sub_level_2_item_border_sides_h_d_a = $sub_level_2_item_border_sides;
	}
	
	$query = "SELECT `z_index` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $menu . "' AND `class` = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$menu_z_index = $row['z_index'];
	}
	else
		$menu_z_index = 100;

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////
	if (($top_level_underline == 0) && ($top_level_overline == 0) && ($top_level_blink == 0))
		$top_level_text_decoration_none = 1;
	else
		$top_level_text_decoration_none = 0;

	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $top_level_font . "', font2='" . $top_level_font_2 . "', font3='" . $top_level_font_3 
		. "', font_size=" . $top_level_font_size . ", font_size_units='" . $top_level_font_size_units
		. "', weight='" . $top_level_weight . "', letter_spacing='" . $top_level_letter_spacing 
		. "', letter_spacing_units=" . $top_level_letter_spacing_units
		. ", italic=" . $top_level_italic . ", oblique=" . $top_level_oblique . ", small_caps=" . $top_level_small_caps
		. ", text_transform='" . $top_level_text_transform . "', border='" . $top_level_item_border_width . "', border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color . "', border_sides='" . $top_level_item_border_sides 
		. "', border_style='" . $top_level_item_border_style
		. "', bkgd_color='" . $top_level_background_color . "', text_shadow=" . $top_level_shadow
		. ", shadow_color='" . $top_level_shadow_color . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", text_color='" . $top_level_text_color . "', bkgd_opacity=" . $top_level_background_opacity . ", bkgd_rgba=" . $top_level_rgba . ", display='block'"
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type . ", gradient_angle=" . $top_level_gradient_angle . ", gradient_colors='" . $top_level_gradient_colors
		. "', gradient_opacities='" . $top_level_gradient_opacities . "', gradient_repeat=" . $top_level_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . "', use_table_data=1, font='" . $top_level_font . "', font2='" . $top_level_font_2 . "', font3='" . $top_level_font_3 
		. "', font_size=" . $top_level_font_size . ", font_size_units='" . $top_level_font_size_units
		. "', weight='" . $top_level_weight . "', letter_spacing='" . $top_level_letter_spacing 
		. "', letter_spacing_units=" . $top_level_letter_spacing_units
		. ", italic=" . $top_level_italic . ", oblique=" . $top_level_oblique . ", small_caps=" . $top_level_small_caps
		. ", top_level_text_transform='" . $top_level_text_transform . "', border='" . $top_level_item_border_width . "', border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color . "', border_sides='" . $top_level_item_border_sides
		. "', border_style='" . $top_level_item_border_style
		. "', bkgd_color='" . $top_level_background_color . "', text_shadow=" . $top_level_shadow
		. ", shadow_color='" . $top_level_shadow_color . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", text_color='" . $top_level_text_color . "', bkgd_opacity=" . $top_level_background_opacity . ", bkgd_rgba=" . $top_level_rgba . ", display='block'"
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type . ", gradient_angle=" . $top_level_gradient_angle . ", gradient_colors='" . $top_level_gradient_colors
		. "', gradient_opacities='" . $top_level_gradient_opacities . "', gradient_repeat=" . $top_level_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////\
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $top_level_underline 
		. ", overline=" . $top_level_overline . ", blink=" . $top_level_blink . ", no_text_decoration=" . $top_level_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_a" . $suffix . "', use_table_data=1, underline=" 
		. $top_level_underline . ", overline=" . $top_level_overline . ", blink=" . $top_level_blink . ", no_text_decoration=" . $top_level_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	if (($sub_level_1_underline == 0) && ($sub_level_1_overline == 0) && ($sub_level_1_blink == 0))
		$sub_level_1_text_decoration_none = 1;
	else
		$sub_level_1_text_decoration_none = 0;

	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_1_font
		. "', font2='" . $sub_level_1_font_2 . "', font3='" . $sub_level_1_font_3 
		. "', font_size=" . $sub_level_1_font_size . ", font_size_units='" . $sub_level_1_font_size_units
		. "', weight='" . $sub_level_1_weight . "', letter_spacing='" . $sub_level_1_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_units
		. ", italic=" . $sub_level_1_italic . ", oblique=" . $sub_level_1_oblique . ", small_caps=" . $sub_level_1_small_caps
		. ", text_transform='" . $sub_level_1_text_transform . "', bkgd_color='" . $sub_level_1_background_color . "', bkgd_opacity=" . $sub_level_1_background_opacity 
		. ", bkgd_rgba=" . $sub_level_1_rgba . ", border=" . $sub_level_1_item_border_width 
		. ", border_units=" . $sub_level_1_item_border_units . ", border_color='" . $sub_level_1_item_border_color
		. "', border_sides='" . $sub_level_1_item_border_sides . "', border_style='" . $sub_level_1_item_border_style
		. "', text_shadow=" . $sub_level_1_shadow
		. ", shadow_color='" . $sub_level_1_shadow_color . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", text_color='" . $sub_level_1_text_color
		. "', radius_top_left=" . $sub_level_1_radius_top_left . ", radius_top_left_units=" . $sub_level_1_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_1_radius_top_right . ", radius_top_right_units=" . $sub_level_1_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_1_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_1_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_1_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_1_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type . ", gradient_angle=" . $sub_level_1_gradient_angle . ", gradient_colors='" . $sub_level_1_gradient_colors
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities . "', gradient_repeat=" . $sub_level_1_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . "', use_table_data=1, font='" . $sub_level_1_font . "', font2='" . $sub_level_1_font_2 . "', font3='" . $sub_level_1_font_3 
		. "', font_size=" . $sub_level_1_font_size . ", font_size_units='" . $sub_level_1_font_size_units
		. "', weight='" . $sub_level_1_weight . "', letter_spacing='" . $sub_level_1_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_units
		. ", italic=" . $sub_level_1_italic . ", oblique=" . $sub_level_1_oblique . ", small_caps=" . $sub_level_1_small_caps
		. ", text_transform='" . $sub_level_1_text_transform . "', bkgd_color='" . $sub_level_1_background_color . "', bkgd_opacity=" . $sub_level_1_background_opacity 
		. ", bkgd_rgba=" . $sub_level_1_rgba . ", border=" . $sub_level_1_item_border_width 
		. ", border_units=" . $sub_level_1_item_border_units . ", border_color='" . $sub_level_1_item_border_color
		. "', border_sides='" . $sub_level_1_item_border_sides . "', border_style='" . $sub_level_1_item_border_style
		. "', text_shadow=" . $sub_level_1_shadow
		. ", shadow_color='" . $sub_level_1_shadow_color . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", text_color='" . $sub_level_1_text_color
		. "', radius_top_left=" . $sub_level_1_radius_top_left . ", radius_top_left_units=" . $sub_level_1_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_1_radius_top_right . ", radius_top_right_units=" . $sub_level_1_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_1_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_1_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_1_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_1_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type . ", gradient_angle=" . $sub_level_1_gradient_angle . ", gradient_colors='" . $sub_level_1_gradient_colors
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities . "', gradient_repeat=" . $sub_level_1_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_1_underline . ", overline=" . $sub_level_1_overline 
		. ", blink=" . $sub_level_1_blink . ", no_text_decoration=" . $sub_level_1_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_a" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_1_underline . ", overline=" . $sub_level_1_overline . ", blink=" . $sub_level_1_blink
		. ", no_text_decoration=" . $sub_level_1_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	if (($sub_level_1_underline_down == 0) && ($sub_level_1_overline_down == 0) && ($sub_level_1_blink_down == 0))
		$sub_level_1_text_decoration_none_down = 1;
	else
		$sub_level_1_text_decoration_none_down = 0;
		
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_1_font
		. "', font2='" . $sub_level_1_font_2 . "', font3='" . $sub_level_1_font_3 
		. "', font_size=" . $sub_level_1_font_size_down . ", font_size_units='" . $sub_level_1_font_size_down_units
		. "', weight='" . $sub_level_1_weight_down . "', letter_spacing='" . $sub_level_1_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_down_units
		. ", italic=" . $sub_level_1_italic_down . ", oblique=" . $sub_level_1_oblique_down . ", small_caps=" . $sub_level_1_small_caps_down
		. ", text_transform='" . $sub_level_1_text_transform_down . "', bkgd_color='" . $sub_level_1_background_color_down 
		. "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba . ", border=" . $sub_level_1_item_border_width 
		. ", border_units=" . $sub_level_1_item_border_units 
		. ", border_color='" . $sub_level_1_item_border_color_down . "', border_sides='" . $sub_level_1_item_border_sides_h_d_a
		. "', border_style='" . $sub_level_1_item_border_style . "', text_shadow=" . $sub_level_1_shadow_down
		. ", shadow_color='" . $sub_level_1_shadow_color_down . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", text_color='" . $sub_level_1_text_color_down
		. "', radius_top_left=" . $sub_level_1_radius_top_left . ", radius_top_left_units=" . $sub_level_1_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_1_radius_top_right . ", radius_top_right_units=" . $sub_level_1_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_1_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_1_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_1_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_1_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type_down . ", gradient_angle=" . $sub_level_1_gradient_angle_down . ", gradient_colors='" . $sub_level_1_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_down . "', gradient_repeat=" . $sub_level_1_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix . "', use_table_data=1, font='" . $sub_level_1_font . "', font2='" . $sub_level_1_font_2 . "', font3='" . $sub_level_1_font_3 
		. "', font_size=" . $sub_level_1_font_size_down . ", font_size_units='" . $sub_level_1_font_size_down_units
		. "', weight='" . $sub_level_1_weight_down . "', letter_spacing='" . $sub_level_1_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_down_units
		. ", italic=" . $sub_level_1_italic_down . ", oblique=" . $sub_level_1_oblique_down . ", small_caps=" . $sub_level_1_small_caps_down
		. ", text_transform='" . $sub_level_1_text_transform_down. "', bkgd_color='" . $sub_level_1_background_color_down 
		. "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba . ", border=" . $sub_level_1_item_border_width 
		. ", border_units=" . $sub_level_1_item_border_units 
		. ", border_color='" . $sub_level_1_item_border_color_down . "', border_sides='" . $sub_level_1_item_border_sides_h_d_a
		. "', border_style='" . $sub_level_1_item_border_style . "', text_shadow=" . $sub_level_1_shadow_down
		. ", shadow_color='" . $sub_level_1_shadow_color_down . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", text_color='" . $sub_level_1_text_color_down
		. "', radius_top_left=" . $sub_level_1_radius_top_left . ", radius_top_left_units=" . $sub_level_1_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_1_radius_top_right . ", radius_top_right_units=" . $sub_level_1_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_1_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_1_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_1_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_1_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type_down . ", gradient_angle=" . $sub_level_1_gradient_angle_down . ", gradient_colors='" . $sub_level_1_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_down . "', gradient_repeat=" . $sub_level_1_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_1_underline_down . ", overline=" . $sub_level_1_overline_down 
		. ", blink=" . $sub_level_1_blink_down . ", no_text_decoration=" . $sub_level_1_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_a_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_1_underline_down . ", overline=" . $sub_level_1_overline_down 
		. ", blink=" . $sub_level_1_blink_down . ", no_text_decoration=" . $sub_level_1_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	if (($sub_level_2_underline == 0) && ($sub_level_2_overline == 0) && ($sub_level_2_blink == 0))
		$sub_level_2_text_decoration_none = 1;
	else
		$sub_level_2_text_decoration_none = 0;

	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font 
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic 
		. ", underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline . ", blink=" . $sub_level_2_blink
		. ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps . ", text_transform='" . $sub_level_2_text_transform
		. "', no_text_decoration=" . $sub_level_2_text_decoration_none		
		. ", bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color 
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic 
		. ", underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline . ", blink=" . $sub_level_2_blink
		. ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps . ", text_transform='" . $sub_level_2_text_transform
		. "', no_text_decoration=" . $sub_level_2_text_decoration_none
		. ", bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_a" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);

	///////////////////////////////////////////////////////////////////////////////////////////
	if (($sub_level_2_underline_down == 0) && ($sub_level_2_overline_down == 0) && ($sub_level_2_blink_down == 0))
		$sub_level_2_text_decoration_none_down = 1;
	else
		$sub_level_2_text_decoration_none_down = 0;
		
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font 
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix . "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_a_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic	. ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps 
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic . ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_a" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down 
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix . "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_a_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic . ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic . ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_a" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font 
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix 
		. "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_a_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font 
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic . ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps 
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix 
		. "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size . ", font_size_units='" . $sub_level_2_font_size_units
		. "', weight='" . $sub_level_2_weight . "', letter_spacing='" . $sub_level_2_letter_spacing 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_units
		. ", italic=" . $sub_level_2_italic . ", oblique=" . $sub_level_2_oblique . ", small_caps=" . $sub_level_2_small_caps
		. ", text_transform='" . $sub_level_2_text_transform . "', bkgd_color='" . $sub_level_2_background_color . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color
		. "', border_sides='" . $sub_level_2_item_border_sides . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type . ", gradient_angle=" . $sub_level_2_gradient_angle 
		. ", gradient_colors='" . $sub_level_2_gradient_colors
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities . "', gradient_repeat=" . $sub_level_2_gradient_repeat;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_a" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_a" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline . ", overline=" . $sub_level_2_overline 
		. ", blink=" . $sub_level_2_blink . ", no_text_decoration=" . $sub_level_2_text_decoration_none;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $sub_level_2_font
		. "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix 
		. "', use_table_data=1, font='" . $sub_level_2_font . "', font2='" . $sub_level_2_font_2 . "', font3='" . $sub_level_2_font_3 
		. "', font_size=" . $sub_level_2_font_size_down . ", font_size_units='" . $sub_level_2_font_size_down_units
		. "', weight='" . $sub_level_2_weight_down . "', letter_spacing='" . $sub_level_2_letter_spacing_down
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_down_units
		. ", italic=" . $sub_level_2_italic_down . ", oblique=" . $sub_level_2_oblique_down . ", small_caps=" . $sub_level_2_small_caps_down
		. ", text_transform='" . $sub_level_2_text_transform_down . "', bkgd_color='" . $sub_level_2_background_color_down . "', bkgd_opacity=" . $sub_level_2_background_opacity 
		. ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_down
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow_down
		. ", shadow_color='" . $sub_level_2_shadow_color_down . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", text_color='" . $sub_level_2_text_color_down
		. "', radius_top_left=" . $sub_level_2_radius_top_left . ", radius_top_left_units=" . $sub_level_2_radius_top_left_units 
		. ", radius_top_right=" . $sub_level_2_radius_top_right . ", radius_top_right_units=" . $sub_level_2_radius_top_right_units
		. ", radius_bottom_right=" . $sub_level_2_radius_bottom_right . ", radius_bottom_right_units=" . $sub_level_2_radius_bottom_right_units
		. ", radius_bottom_left=" . $sub_level_2_radius_bottom_left . ", radius_bottom_left_units=" . $sub_level_2_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_down . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_down . ", gradient_angle=" . $sub_level_2_gradient_angle_down 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_a_down" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $sub_level_2_underline_down . ", overline=" . $sub_level_2_overline_down 
		. ", blink=" . $sub_level_2_blink_down . ", no_text_decoration=" . $sub_level_2_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	// Clear use defaults flag.
	$query = "SELECT `border` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		if ($row['border'] == -2)	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET border=-1 WHERE style_sheet='" . $style_sheet . "' AND class='ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
			$cnt = $bwb_dbh->exec($query);
		}
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $top_level_block_border_width . ", border_units=" . $top_level_block_border_units . ", border_color='" . $top_level_block_border_color . "', border_sides='" . $top_level_block_border_sides
		. "', border_style='" . $top_level_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_ul" . $suffix . "'";
	}
	else
	{
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_ul" . $suffix . "', use_table_data=1, border=" . $top_level_block_border_width . ", border_units=" . $top_level_block_border_units
		. ", border_color='" . $top_level_block_border_color . "', border_sides='" . $top_level_block_border_sides . "', border_style='" . $top_level_block_border_style
		. "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $sub_level_1_block_border_width . ", border_units=" . $sub_level_1_block_border_units . ", border_color='" . $sub_level_1_block_border_color . "', border_sides='" . $sub_level_1_block_border_sides . "', border_style='" . $sub_level_1_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_ul" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_ul" . $suffix . "', use_table_data=1, border=" . $sub_level_1_block_border_width . ", border_units=" . $sub_level_1_block_border_units
		. ", border_color='" . $sub_level_1_block_border_color . "', border_sides='" . $sub_level_1_block_border_sides 
		. "', border_style='" . $sub_level_1_block_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	// Check to see if transinions are used.  If so, then need to add border to .top_level_liX:hover > ul which is set under save_css_menu_params.php.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $style_sheet . "' AND class = '.top_level_li" . $suffix . " > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["transition_timing_function"]) && ($row["transition_timing_function"] != ""))
		$sub_level_1_transition_timing_function = $row["transition_timing_function"];
	else
		$sub_level_1_transition_timing_function = "-not selected-";
	if (is_numeric($row["transition_duration"]) && ($row["transition_duration"] > -1))
		$sub_level_1_transition_duration = $row["transition_duration"];
	else
		$sub_level_1_transition_duration = _NOT_SET_;
	if (is_numeric($row["transition_delay"]) && ($row["transition_delay"] > -1))
		$sub_level_1_transition_delay = $row["transition_delay"];
	else
		$sub_level_1_transition_delay = _NOT_SET_;
		
	
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . ":hover > ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		if (($sub_level_1_transition_timing_function != "-not selected-") || ($sub_level_1_transition_duration > -1) || ($sub_level_1_transition_delay > -1))	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET border=" . $sub_level_1_block_border_width . ", border_sides=" . $sub_level_1_block_border_sides 
			. ", border_style='" . $sub_level_1_block_border_style . "', border_color='" . $sub_level_1_block_border_color 
			. "' WHERE style_sheet = '" . $style_sheet . "' AND class='.top_level_li" . $suffix . ":hover > ul'";
		}
		else	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET border=-1, border_sides=-1, border_style='-not selected-', border_color='-not_set-' WHERE style_sheet = '" 
			. $style_sheet . "' AND class='.top_level_li" . $suffix . ":hover > ul'";
		}
	}
	else
	{
		if (($sub_level_1_transition_timing_function != "-not selected-") || ($sub_level_1_transition_duration > -1) || ($sub_level_1_transition_delay > -1))	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $style_sheet . "', class='.top_level_li" . $suffix . ":hover > ul', border=" 
			. $sub_level_1_block_border_width . ", border_sides=" . $sub_level_1_block_border_sides 
			. ", border_style='" . $sub_level_1_block_border_style . "', border_color='" . $sub_level_1_block_border_color . "'";
		}
		else	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $style_sheet 
			. "', class='.top_level_li" . $suffix . ":hover > ul', border=-1, border_sides=-1, border_style='-not selected-', border_color='-not_set-'";
		}
	}
	$cnt = $bwb_dbh->exec($query);
		
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units . ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides . "', border_style='" . $sub_level_2_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_ul" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_ul" . $suffix . "', use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units
		. ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides 
		. "', border_style='" . $sub_level_2_block_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	// Check to see if transinions are used.  If so, then need to add border to .sub_level_1_liX:hover > ul which is set under save_css_menu_params.php.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $style_sheet . "' AND class = '.sub_level_1_li" . $suffix . " > ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["transition_timing_function"]) && ($row["transition_timing_function"] != ""))
		$sub_level_2_transition_timing_function = $row["transition_timing_function"];
	else
		$sub_level_2_transition_timing_function = "-not selected-";
	if (is_numeric($row["transition_duration"]) && ($row["transition_duration"] > -1))
		$sub_level_2_transition_duration = $row["transition_duration"];
	else
		$sub_level_2_transition_duration = _NOT_SET_;
	if (is_numeric($row["transition_delay"]) && ($row["transition_delay"] > -1))
		$sub_level_2_transition_delay = $row["transition_delay"];
	else
		$sub_level_2_transition_delay = _NOT_SET_;
		
	
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . ":hover > ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		if (($sub_level_2_transition_timing_function != "-not selected-") || ($sub_level_2_transition_duration > -1) || ($sub_level_2_transition_delay > -1))	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET border=" . $sub_level_2_block_border_width . ", border_sides=" . $sub_level_2_block_border_sides 
			. ", border_style='" . $sub_level_2_block_border_style . "', border_color='" . $sub_level_2_block_border_color 
			. "' WHERE style_sheet = '" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . ":hover > ul'";
		}
		else	{
			$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET border=-1, border_sides=-1, border_style='-not selected-', border_color='-not_set-' WHERE style_sheet = '" 
			. $style_sheet . "' AND class='.sub_level_1_li" . $suffix . ":hover > ul'";
		}
	}
	else
	{
		if (($sub_level_2_transition_timing_function != "-not selected-") || ($sub_level_2_transition_duration > -1) || ($sub_level_1_transition_delay > -1))	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $style_sheet . "', class='.sub_level_1_li" . $suffix . ":hover > ul', border=" 
			. $sub_level_1_block_border_width . ", border_sides=" . $sub_level_1_block_border_sides 
			. ", border_style='" . $sub_level_1_block_border_style . "', border_color='" . $sub_level_1_block_border_color . "'";
		}
		else	{
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $style_sheet 
			. "', class='.sub_level_1_li" . $suffix . ":hover > ul', border=-1, border_sides=-1, border_style='-not selected-', border_color='-not_set-'";
		}
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units . ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides . "', border_style='" . $sub_level_2_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_ul" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_ul" . $suffix . "', use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units
		. ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides 
		. "', border_style='" . $sub_level_2_block_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units . ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides . "', border_style='" . $sub_level_2_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_ul" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_ul" . $suffix . "', use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units
		. ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides 
		. "', border_style='" . $sub_level_2_block_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units . ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides . "', border_style='" . $sub_level_2_block_border_style
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_ul" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_ul" . $suffix . "', use_table_data=1, border=" . $sub_level_2_block_border_width . ", border_units=" . $sub_level_2_block_border_units
		. ", border_color='" . $sub_level_2_block_border_color . "', border_sides='" . $sub_level_2_block_border_sides 
		. "', border_style='" . $sub_level_2_block_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = 'ul.nav" . $suffix . " li:hover, .nav" . $suffix . " ul li a:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	$menu_z_index_li_hover = $menu_z_index + 15;
	
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, z_index=" . $menu_z_index_li_hover . " WHERE style_sheet='" . $style_sheet . "' AND class='ul.nav" . $suffix . " li:hover, .nav" . $suffix . " ul li a:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='ul.nav" . $suffix . " li:hover, .nav" . $suffix . " ul li a:hover', use_table_data=1, z_index=" . $menu_z_index_li_hover;
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $top_level_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($top_level_underline_hover == 0) && ($top_level_overline_hover == 0) && ($top_level_blink_hover == 0))
		$top_level_text_decoration_none_hover = 1;
	else
		$top_level_text_decoration_none_hover = 0;
		
	if (($top_level_shadow_hover == 0) && ($top_level_shadow == 1))	{
		$top_level_shadow_hover = 1;
		$top_level_shadow_x_offset_hover = 0;
		$top_level_shadow_y_offset_hover = 0;
		$top_level_shadow_blur_hover = 0;
	}
	else	{
		$top_level_shadow_x_offset_hover = $top_level_shadow_x_offset;
		$top_level_shadow_y_offset_hover = $top_level_shadow_y_offset;
		$top_level_shadow_blur_hover = $top_level_shadow_blur;
	}	
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_hover
		. "', bkgd_opacity=" . $top_level_background_opacity 
		. ", bkgd_rgba=" . $top_level_rgba . ", bkgd_color='" . $top_level_background_color_hover 
		. "', font_size=" . $top_level_font_size_hover . ", font_size_units='" . $top_level_font_size_hover_units
		. "', weight='" . $top_level_weight_hover . "', letter_spacing='" . $top_level_letter_spacing_hover 
		. "', letter_spacing_units=" . $top_level_letter_spacing_hover_units
		. ", italic=" . $top_level_italic_hover . ", oblique=" . $top_level_oblique_hover . ", small_caps=" . $top_level_small_caps_hover
		. ", text_transform='" . $top_level_text_transform_hover . "', text_shadow=" . $top_level_shadow_hover . ", shadow_color='" . $top_level_shadow_color_hover 
		. "', shadow_x_offset=" . $top_level_shadow_x_offset_hover . ", shadow_y_offset=" . $top_level_shadow_y_offset_hover . ", shadow_blur=" . $top_level_shadow_blur_hover
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_hover . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color_hover . "', border_sides='" . $top_level_item_border_sides_h_d_a . "', border_style='" . $top_level_item_border_style
		. "', gradient_type=" . $top_level_gradient_type_hover . ", gradient_angle=" . $top_level_gradient_angle_hover . ", gradient_colors='" . $top_level_gradient_colors_hover
		. "', gradient_opacities='" . $top_level_gradient_opacities_hover . "', gradient_repeat=" . $top_level_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix 
		. ":hover', use_table_data=1,  bkgd_opacity=" . $top_level_background_opacity . ", bkgd_rgba=" . $top_level_rgba 
		. ", text_color='" . $top_level_text_color_hover . "', bkgd_color='" . $top_level_background_color_hover 
		. "', font_size=" . $top_level_font_size_hover . ", font_size_units='" . $top_level_font_size_hover_units
		. "', weight='" . $top_level_weight_hover . "', letter_spacing='" . $top_level_letter_spacing_hover 
		. "', letter_spacing_units=" . $top_level_letter_spacing_hover_units
		. ", italic=" . $top_level_italic_hover . ", oblique=" . $top_level_oblique_hover . ", small_caps=" . $top_level_small_caps_hover
		. ", text_transform='" . $top_level_text_transform_hover . "', text_shadow=" . $top_level_shadow_hover . ", shadow_color='" . $top_level_shadow_color_hover 
		. "', shadow_x_offset=" . $top_level_shadow_x_offset_hover . ", shadow_y_offset=" . $top_level_shadow_y_offset_hover . ", shadow_blur=" . $top_level_shadow_blur_hover
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_hover . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color_hover . "', border_sides='" . $top_level_item_border_sides_h_d_a . "', border_style='" . $top_level_item_border_style
		. "', gradient_type=" . $top_level_gradient_type_hover . ", gradient_angle=" . $top_level_gradient_angle_hover . ", gradient_colors='" . $top_level_gradient_colors_hover
		. "', gradient_opacities='" . $top_level_gradient_opacities_hover . "', gradient_repeat=" . $top_level_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $top_level_underline_hover 
		. ", overline=" . $top_level_overline_hover . ", blink=" . $top_level_blink_hover . ", no_text_decoration=" . $top_level_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_a" . $suffix 
		. ":hover', use_table_data=1, underline=" . $top_level_underline_hover . ", overline=" . $top_level_overline_hover 
		. ", blink=" . $top_level_blink_hover . ", no_text_decoration=" . $top_level_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $top_level_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $top_level_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_active . "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . " A:active', use_table_data=1, text_color='" . $top_level_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $top_level_background_color_active
		. "', border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units . ", border_color='" . $top_level_item_border_color_active
		. "', border_sides=" . $top_level_item_border_sides_h_d_a . ", text_shadow=" . $top_level_shadow
		. ", shadow_color='" . $top_level_shadow_color_active . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_active . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type_active . ", gradient_angle=" . $top_level_gradient_angle_active . ", gradient_colors='" . $top_level_gradient_colors_active
		. "', gradient_opacities='" . $top_level_gradient_opacities_active . "', gradient_repeat=" . $top_level_gradient_repeat_active
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix 
		. ":active', use_table_data=1, bkgd_color='" . $top_level_background_color_active
		. "', border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units . ", border_color='" . $top_level_item_border_color_active
		. "', border_sides=" . $top_level_item_border_sides_h_d_a . ", text_shadow=" . $top_level_shadow
		. ", shadow_color='" . $top_level_shadow_color_active . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_active . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type_active . ", gradient_angle=" . $top_level_gradient_angle_active . ", gradient_colors='" . $top_level_gradient_colors_active
		. "', gradient_opacities='" . $top_level_gradient_opacities_active . "', gradient_repeat=" . $top_level_gradient_repeat_active;
	}
	$cnt = $bwb_dbh->exec($query);
		
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_1_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($sub_level_1_underline_hover == 0) && ($sub_level_1_overline_hover == 0) && ($sub_level_1_blink_hover == 0))
		$sub_level_1_text_decoration_none_hover = 1;
	else
		$sub_level_1_text_decoration_none_hover = 0;
		
	if (($sub_level_1_shadow_hover == 0) && ($sub_level_1_shadow == 1))	{
		$sub_level_1_shadow_hover = 1;
		$sub_level_1_shadow_x_offset_hover = 0;
		$sub_level_1_shadow_y_offset_hover = 0;
		$sub_level_1_shadow_blur_hover = 0;
	}
	else	{
		$sub_level_1_shadow_x_offset_hover = $sub_level_1_shadow_x_offset;
		$sub_level_1_shadow_y_offset_hover = $sub_level_1_shadow_y_offset;
		$sub_level_1_shadow_blur_hover = $sub_level_1_shadow_blur;
	}	
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_1_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba 
		. ", font_size=" . $sub_level_1_font_size_hover . ", font_size_units='" . $sub_level_1_font_size_hover_units
		. "', weight='" . $sub_level_1_weight_hover . "', letter_spacing='" . $sub_level_1_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_hover_units
		. ", italic=" . $sub_level_1_italic_hover . ", oblique=" . $sub_level_1_oblique_hover . ", small_caps=" . $sub_level_1_small_caps_hover
		. ", text_transform='" . $sub_level_1_text_transform_hover . "', text_shadow=" . $sub_level_1_shadow_hover . ", shadow_color='" . $sub_level_1_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_1_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_1_shadow_y_offset_hover 
		. ", shadow_blur=" . $sub_level_1_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", border=" . $sub_level_1_item_border_width 
		. ", border_units=" . $sub_level_1_item_border_units 
		. ", border_color='" . $sub_level_1_item_border_color_hover
		. "', border_sides='" . $sub_level_1_item_border_sides_h_d_a 
		. "', border_style='" . $sub_level_1_item_border_style
		. "', gradient_type=" . $sub_level_1_gradient_type_hover . ", gradient_angle=" . $sub_level_1_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_1_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" 
		. $suffix . ":hover', use_table_data=1, bkgd_color='" . $sub_level_1_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba 
		. ", font_size=" . $sub_level_1_font_size_hover . ", font_size_units='" . $sub_level_1_font_size_hover_units
		. "', weight='" . $sub_level_1_weight_hover . "', letter_spacing='" . $sub_level_1_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_1_letter_spacing_hover_units
		. ", italic=" . $sub_level_1_italic_hover . ", oblique=" . $sub_level_1_oblique_hover . ", small_caps=" . $sub_level_1_small_caps_hover
		. ", text_transform='" . $sub_level_1_text_transform_hover . "', text_shadow=" . $sub_level_1_shadow_hover . ", shadow_color='" . $sub_level_1_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_1_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_1_shadow_y_offset_hover 
		. ", shadow_blur=" . $sub_level_1_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", border=" . $sub_level_1_item_border_width . ", border_units=" . $sub_level_1_item_border_units . ", border_color='" 
		. $sub_level_1_item_border_color_hover . "', border_sides='" . $sub_level_1_item_border_sides_h_d_a
		. "', border_style='" . $sub_level_1_item_border_style
		. "', gradient_type=" . $sub_level_1_gradient_type_hover . ", gradient_angle=" . $sub_level_1_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_1_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_1_underline_hover . ", overline=" . $sub_level_1_overline_hover 
		. ", blink=" . $sub_level_1_blink_hover . ", no_text_decoration=" . $sub_level_1_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_a" 
		. $suffix . ":hover', use_table_data=1, underline=" . $sub_level_1_underline_hover . ", overline=" . $sub_level_1_overline_hover 
		. ", blink=" . $sub_level_1_blink_hover . ", no_text_decoration=" . $sub_level_1_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $sub_level_1_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $sub_level_1_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_active
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . " A:active', use_table_data=1, text_color='" . $sub_level_1_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_1_background_color_active 
		. "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba . ", border=" 
		. $sub_level_1_item_border_width . ", border_units=" . $sub_level_1_item_border_units 
		. ", border_color='" . $sub_level_1_item_border_color_active . "', border_sides='" . $sub_level_1_item_border_sides_h_d_a 
		. "', border_style='" . $sub_level_1_item_border_style
		. "', text_shadow=" . $sub_level_1_shadow
		. ", shadow_color='" . $sub_level_1_shadow_color_active . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type_active . ", gradient_angle=" . $sub_level_1_gradient_angle_active 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_active
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_active . "', gradient_repeat=" . $sub_level_1_gradient_repeat_active
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . ":active', use_table_data=1, bkgd_color='" . $sub_level_1_background_color_active . "', bkgd_opacity=" . $sub_level_1_background_opacity . ", bkgd_rgba=" . $sub_level_1_rgba . ", border_color='" . $sub_level_1_item_border_color_active . "', border_sides='" . $sub_level_1_item_border_sides_h_d_a . "', border_style='" . $sub_level_1_item_border_style . "', text_shadow=" . $sub_level_1_shadow
		. ", shadow_color='" . $sub_level_1_shadow_color_active . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset . ", shadow_blur=" . $sub_level_1_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_1_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_1_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_1_box_shadow_blur . ", box_shadow_spread=" . $sub_level_1_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_1_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_1_box_shadow_inset
		. ", gradient_type=" . $sub_level_1_gradient_type_active . ", gradient_angle=" . $sub_level_1_gradient_angle_active 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_active
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_active . "', gradient_repeat=" . $sub_level_1_gradient_repeat_active;
	}
	$cnt = $bwb_dbh->exec($query);
		
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . " A:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($sub_level_2_underline_hover == 0) && ($sub_level_2_overline_hover == 0) && ($sub_level_2_blink_hover == 0))
		$sub_level_2_text_decoration_none_hover = 1;
	else
		$sub_level_2_text_decoration_none_hover = 0;
		
	if (($sub_level_2_shadow_hover == 0) && ($sub_level_2_shadow == 1))	{
		$sub_level_2_shadow_hover = 1;
		$sub_level_2_shadow_x_offset_hover = 0;
		$sub_level_2_shadow_y_offset_hover = 0;
		$sub_level_2_shadow_blur_hover = 0;
	}
	else	{
		$sub_level_2_shadow_x_offset_hover = $sub_level_2_shadow_x_offset;
		$sub_level_2_shadow_y_offset_hover = $sub_level_2_shadow_y_offset;
		$sub_level_2_shadow_blur_hover = $sub_level_2_shadow_blur;
	}
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width 
		. ", border_units=" . $sub_level_2_item_border_units 
		. ", border_color='" . $sub_level_2_item_border_color_hover 
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover 
		. "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($sub_level_2_underline_hover == 0) && ($sub_level_2_overline_hover == 0) && ($sub_level_2_blink_hover == 0))
		$sub_level_2_text_decoration_none_hover = 1;
	else
		$sub_level_2_text_decoration_none_hover = 0;
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_a" . $suffix 
		. ":hover', use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_active
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . " A:active', use_table_data=1, text_color='" . $sub_level_2_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a 
		. "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_active . ", gradient_angle=" . $sub_level_2_gradient_angle_active 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_active
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_active . "', gradient_repeat=" . $sub_level_2_gradient_repeat_active
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . ":active', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style . "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", gradient_type=" . $sub_level_2_gradient_type_active . ", gradient_angle=" . $sub_level_2_gradient_angle_active 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_active
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_active . "', gradient_repeat=" . $sub_level_2_gradient_repeat_active;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . " A:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover 
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_a" . $suffix 
		. ":hover', use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	////////////////////////////////// new ////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_active
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . " A:active', use_table_data=1, text_color='" . $sub_level_2_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_a" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_a" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_a" . $suffix . ":active', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style . "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . " A:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset		
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_a" . $suffix 
		. ":hover', use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_active
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . " A:active', use_table_data=1, text_color='" . $sub_level_2_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_a" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_a" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_a" . $suffix . ":active', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style . "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . " A:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover 
		. "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset		
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_hover . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba 
		. ", font_size=" . $sub_level_2_font_size_hover . ", font_size_units='" . $sub_level_2_font_size_hover_units
		. "', weight='" . $sub_level_2_weight_hover . "', letter_spacing='" . $sub_level_2_letter_spacing_hover 
		. "', letter_spacing_units=" . $sub_level_2_letter_spacing_hover_units
		. ", italic=" . $sub_level_2_italic_hover . ", oblique=" . $sub_level_2_oblique_hover . ", small_caps=" . $sub_level_2_small_caps_hover
		. ", text_transform='" . $sub_level_2_text_transform_hover . "', text_shadow=" . $sub_level_2_shadow_hover . ", shadow_color='" . $sub_level_2_shadow_color_hover 
		. "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover . ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover
		. ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_hover . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_hover . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', gradient_type=" . $sub_level_2_gradient_type_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_a" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_a" . $suffix 
		. ":hover', use_table_data=1, underline=" . $sub_level_2_underline_hover . ", overline=" . $sub_level_2_overline_hover 
		. ", blink=" . $sub_level_2_blink_hover . ", no_text_decoration=" . $sub_level_2_text_decoration_none_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_active
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . " A:active', use_table_data=1, text_color='" . $sub_level_2_text_color_active . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_a" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style
		. "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_a" . $suffix . ":active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_a" . $suffix . ":active', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_active . "', bkgd_opacity=" . $sub_level_2_background_opacity . ", bkgd_rgba=" . $sub_level_2_rgba . ", border=" . $sub_level_2_item_border_width . ", border_units=" . $sub_level_2_item_border_units . ", border_color='" . $sub_level_2_item_border_color_active . "', border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style . "', text_shadow=" . $sub_level_2_shadow
		. ", shadow_color='" . $sub_level_2_shadow_color_active . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset . ", shadow_blur=" . $sub_level_2_shadow_blur
		. ", box_shadow_horizontal=" . $sub_level_2_box_shadow_horizontal . ", box_shadow_vertical=" . $sub_level_2_box_shadow_vertical
		. ", box_shadow_blur=" . $sub_level_2_box_shadow_blur . ", box_shadow_spread=" . $sub_level_2_box_shadow_spread
		. ", box_shadow_color='" . $sub_level_2_box_shadow_color_active . "', box_shadow_inset=" . $sub_level_2_box_shadow_inset;
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='block' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . " A', use_table_data=1, display='block'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . " A:link', use_table_data=1, text_color='" . $top_level_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . " A:link', use_table_data=1, text_color='" . $sub_level_1_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color . "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li" . $suffix . " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	if ($top_level_item_omit_adjacent_border == 1)	{
		if ($orientation == "horizontal")
			$top_level_item_last_child_border = 1;
		else
			$top_level_item_last_child_border = 4;
		$top_level_item_last_child_border_width = $top_level_item_border_width;
		$top_level_item_last_child_border_units = $top_level_item_border_units;
		$top_level_item_last_child_border_style = "solid";
		$top_level_item_last_child_border_color = $top_level_item_border_color;
		$top_level_item_last_child_border_color_hover = $top_level_item_border_color_hover;
		$top_level_item_last_child_border_color_active = $top_level_item_border_color_active;
	}
	else	{
		$top_level_item_last_child_border = -1;
		$top_level_item_last_child_border_width = -1;
		$top_level_item_last_child_border_units = 0;
		$top_level_item_last_child_border_style = "-not selected-";
		$top_level_item_last_child_border_color = "-not set-";
		$top_level_item_last_child_border_color_hover = "-not set-";
		$top_level_item_last_child_border_color_active = "-not set-";
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color . "', border_style='" . $top_level_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child', use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color . "', border_style='" . $top_level_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color_hover . "', border_style='" . $top_level_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color_hover . "', border_style='" . $top_level_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color_active . "', border_style='" . $top_level_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child:active', use_table_data=" . $top_level_item_omit_adjacent_border . ", border=" . $top_level_item_last_child_border_width . ", border_units=" . $top_level_item_last_child_border_units . ", border_sides=" . $top_level_item_last_child_border . ", border_color='" . $top_level_item_last_child_border_color_active . "', border_style='" . $top_level_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	if ($sub_level_1_item_omit_adjacent_border == 1)	{
		$sub_level_1_item_last_child_border = 4;
		$sub_level_1_item_last_child_border_width = $sub_level_1_item_border_width;
		$sub_level_1_item_last_child_border_units = $sub_level_1_item_border_units;
		$sub_level_1_item_last_child_border_style = "solid";
		$sub_level_1_item_last_child_border_color = $sub_level_1_item_border_color;
		$sub_level_1_item_last_child_border_color_hover = $sub_level_1_item_border_color_hover;
		$sub_level_1_item_last_child_border_color_active = $sub_level_1_item_border_color_active;
	}
	else	{
		$sub_level_1_item_last_child_border = -1;
		$sub_level_1_item_last_child_border_width = -1;
		$sub_level_1_item_last_child_border_units = 0;
		$sub_level_1_item_last_child_border_style = "-not selected-";
		$sub_level_1_item_last_child_border_color = "-not set-";
		$sub_level_1_item_last_child_border_color_hover = "-not set-";
		$sub_level_1_item_last_child_border_color_active = "-not set-";
	}
	
	if ($sub_level_2_item_omit_adjacent_border == 1)	{
		$sub_level_2_item_last_child_border = 4;
		$sub_level_2_item_last_child_border_width = $sub_level_2_item_border_width;
		$sub_level_2_item_last_child_border_units = $sub_level_2_item_border_units;
		$sub_level_2_item_last_child_border_style = "solid";
		$sub_level_2_item_last_child_border_color = $sub_level_2_item_border_color;
		$sub_level_2_item_last_child_border_color_hover = $sub_level_2_item_border_color_hover;
		$sub_level_2_item_last_child_border_color_active = $sub_level_2_item_border_color_active;
	}
	else	{
		$sub_level_2_item_last_child_border = -1;
		$sub_level_2_item_last_child_border_width = -1;
		$sub_level_2_item_last_child_border_units = 0;
		$sub_level_2_item_last_child_border_style = "-not selected-";
		$sub_level_2_item_last_child_border_color = "-not set-";
		$sub_level_2_item_last_child_border_color_hover = "-not set-";
		$sub_level_2_item_last_child_border_color_active = "-not set-";
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Level 1 Last Item Border
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color . "', border_style='" . $sub_level_1_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child', use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color . "', border_style='" . $sub_level_1_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color_hover . "', border_style='" . $sub_level_1_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color_hover . "', border_style='" . $sub_level_1_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color_active . "', border_style='" . $sub_level_1_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child:active', use_table_data=" . $sub_level_1_item_omit_adjacent_border . ", border=" . $sub_level_1_item_last_child_border_width . ", border_units=" . $sub_level_1_item_last_child_border_units . ", border_sides=" . $sub_level_1_item_last_child_border . ", border_color='" . $sub_level_1_item_last_child_border_color_active . "', border_style='" . $sub_level_1_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Level 2 Last Item Border
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child:active', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Level 3 Last Item Border
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_3_ul" . $suffix . " > li:last-child:active', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Level 4 Last Item Border
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_4_ul" . $suffix . " > li:last-child:active', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Level 5 Last Item Border
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Hover
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:hover', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_hover . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Active
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'  WHERE style_sheet='" . $style_sheet . "' AND class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.menu_div" . $suffix . " .sub_level_5_ul" . $suffix . " > li:last-child:active', use_table_data=" . $sub_level_2_item_omit_adjacent_border . ", border=" . $sub_level_2_item_last_child_border_width . ", border_units=" . $sub_level_2_item_last_child_border_units . ", border_sides=" . $sub_level_2_item_last_child_border . ", border_color='" . $sub_level_2_item_last_child_border_color_active . "', border_style='" . $sub_level_2_item_last_child_border_style . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	////////////////////////////////// new down states ///////////////////////////////////////////
	if (($top_level_underline_down == 0) && ($top_level_overline_down == 0) && ($top_level_blink_down == 0))
		$top_level_text_decoration_none_down = 1;
	else
		$top_level_text_decoration_none_down = 0;
		
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, font='" . $top_level_font  . "', font2='" . $top_level_font_2 . "', font3='" . $top_level_font_3 
		. "', font_size=" . $top_level_font_size_down . ", font_size_units='" . $top_level_font_size_down_units
		. "', weight='" . $top_level_weight_down . "', letter_spacing='" . $top_level_letter_spacing_down
		. "', letter_spacing_units=" . $top_level_letter_spacing_down_units
		. ", italic=" . $top_level_italic_down . ", oblique=" . $top_level_oblique_down . ", small_caps=" . $top_level_small_caps_down
		. ", text_transform='" . $top_level_text_transform_down . "', bkgd_color='" . $top_level_background_color_down
		. "', border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color_down . "', border_sides=" . $top_level_item_border_sides_h_d_a
		. ", text_shadow=" . $top_level_shadow_down
		. ", shadow_color='" . $top_level_shadow_color_down . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", text_color='" . $top_level_text_color_down . "', bkgd_opacity=" . $top_level_background_opacity . ", bkgd_rgba=" . $top_level_rgba . ", display='block'"
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_down . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type_down . ", gradient_angle=" . $top_level_gradient_angle_down . ", gradient_colors='" . $top_level_gradient_colors_down
		. "', gradient_opacities='" . $top_level_gradient_opacities_down . "', gradient_repeat=" . $top_level_gradient_repeat_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix 
		. "', use_table_data=1, font='" . $top_level_font . "', font2='" . $top_level_font_2 . "', font3='" . $top_level_font_3 
		. "', font_size=" . $top_level_font_size_down . ", font_size_units='" . $top_level_font_size_down_units
		. "', weight='" . $top_level_weight_down . "', letter_spacing='" . $top_level_letter_spacing_down
		. "', letter_spacing_units=" . $top_level_letter_spacing_down_units
		. ", italic=" . $top_level_italic_down . ", oblique=" . $top_level_oblique_down . ", small_caps=" . $top_level_small_caps_down
		. ", text_transform='" . $top_level_text_transform_down . "', bkgd_color='" . $top_level_background_color_down
		. "', border=" . $top_level_item_border_width . ", border_units=" . $top_level_item_border_units
		. ", border_color='" . $top_level_item_border_color_down . "', border_sides=" . $top_level_item_border_sides_h_d_a
		. ", text_shadow=" . $top_level_shadow_down
		. ", shadow_color='" . $top_level_shadow_color_down . "', shadow_x_offset=" . $top_level_shadow_x_offset
		. ", shadow_y_offset=" . $top_level_shadow_y_offset . ", shadow_blur=" . $top_level_shadow_blur
		. ", text_color='" . $top_level_text_color_down . "', bkgd_opacity=" . $top_level_background_opacity . ", bkgd_rgba=" . $top_level_rgba . ", display='block'"
		. ", radius_top_left=" . $top_level_radius_top_left . ", radius_top_left_units=" . $top_level_radius_top_left_units 
        . ", radius_top_right=" . $top_level_radius_top_right . ", radius_top_right_units=" . $top_level_radius_top_right_units
		. ", radius_bottom_right=" . $top_level_radius_bottom_right . ", radius_bottom_right_units=" . $top_level_radius_bottom_right_units
		. ", radius_bottom_left=" . $top_level_radius_bottom_left . ", radius_bottom_left_units=" . $top_level_radius_bottom_left_units
		. ", box_shadow_horizontal=" . $top_level_box_shadow_horizontal . ", box_shadow_vertical=" . $top_level_box_shadow_vertical
		. ", box_shadow_blur=" . $top_level_box_shadow_blur . ", box_shadow_spread=" . $top_level_box_shadow_spread
		. ", box_shadow_color='" . $top_level_box_shadow_color_down . "', box_shadow_inset=" . $top_level_box_shadow_inset
		. ", gradient_type=" . $top_level_gradient_type_down . ", gradient_angle=" . $top_level_gradient_angle_down . ", gradient_colors='" . $top_level_gradient_colors_down
		. "', gradient_opacities='" . $top_level_gradient_opacities_down . "', gradient_repeat=" . $top_level_gradient_repeat_down;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, underline=" . $top_level_underline_down . ", overline=" . $top_level_overline_down 
		. ", blink=" . $top_level_blink_down . ", no_text_decoration=" . $top_level_text_decoration_none_down
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_a_down" . $suffix 
		. "', use_table_data=1, underline=" . $top_level_underline_down . ", overline=" . $top_level_overline_down . ", blink=" . $top_level_blink_down
		. ", no_text_decoration=" . $top_level_text_decoration_none_down;
	}
	$cnt = $bwb_dbh->exec($query);

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix
		. " A:link', use_table_data=1, text_color='" . $sub_level_1_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix
		. " A:visited', use_table_data=1, text_color='" . $sub_level_1_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($sub_level_1_txt_color_hover_on_down == 1)
		$sub_level_1_text_color_down_hover = $sub_level_1_text_color_hover;
	else
		$sub_level_1_text_color_down_hover = $sub_level_1_text_color_down;
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" 
		. $suffix . " A:visited:hover', use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix
		. " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix
		. " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($sub_level_2_txt_color_hover_on_down == 1)
		$sub_level_2_text_color_down_hover = $sub_level_2_text_color_hover;
	else
		$sub_level_2_text_color_down_hover = $sub_level_2_text_color_down;
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix
		. " A:visited:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix
		. " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix
		. " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix
		. " A:visited:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix
		. " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix
		. " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix
		. " A:visited:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix
		. " A:link', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix
		. " A:visited', use_table_data=1, text_color='" . $sub_level_2_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix
		. " A:visited:hover', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, display='block' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . " A', use_table_data=1, display='block'";
	}
	$cnt = $bwb_dbh->exec($query);

	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A:link'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down . "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A:link'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . " A:link', use_table_data=1, text_color='" . $top_level_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($top_level_txt_color_hover_on_down == 1)
		$top_level_text_color_down_hover = $top_level_text_color_hover;
	else
		$top_level_text_color_down_hover = $top_level_text_color_down;
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix 
		. " A:hover', use_table_data=1, text_color='" . $top_level_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A:visited'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A:visited'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . " A:visited', use_table_data=1, text_color='" . $top_level_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A:visited:hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down_hover
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A:visited:hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . " A:visited:hover', use_table_data=1, text_color='"
		. $top_level_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	//////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down . "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . " A:active'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . " A:active', use_table_data=1, text_color='" . $top_level_text_color_down . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($top_level_bkgd_color_hover_on_down == 1)
		$top_level_background_color_down_hover = $top_level_background_color_hover;
	else
		$top_level_background_color_down_hover = "-not set-";
		
	if ($top_level_bkgd_gradient_hover_on_down == 1)	{
		$top_level_gradient_type_down_hover = $top_level_gradient_type_hover;
		$top_level_gradient_angle_down_hover = $top_level_gradient_angle_hover;
		$top_level_gradient_colors_down_hover = $top_level_gradient_colors_hover;
		$top_level_gradient_opacities_down_hover = $top_level_gradient_opacities_hover;
		$top_level_gradient_repeat_down_hover = $top_level_gradient_repeat_hover;
	}
	else	{
		$top_level_gradient_type_down_hover = 0;
		$top_level_gradient_angle_down_hover = 180;
		$top_level_gradient_colors_down_hover = "-not set-";
		$top_level_gradient_opacities_down_hover = "-not set-";
		$top_level_gradient_repeat_down_hover = 0;
	}
		
	if ($top_level_border_hover_on_down == 1)	{
		$top_level_item_border_color_down_hover = $top_level_item_border_color_hover;
		$top_level_item_border_width_down_hover = $top_level_item_border_width;
		$top_level_item_border_style_down_hover = $top_level_item_border_style;
		$top_level_shadow_down_hover = $top_level_shadow_hover;
		$top_level_shadow_color_down_hover = $top_level_shadow_color_hover;
	}
	else	{
		$top_level_item_border_color_down_hover = "-not set-";
		$top_level_item_border_width_down_hover = -1;
		$top_level_item_border_style_down_hover = "-not selected-";
		$top_level_shadow_down_hover = 0;
		$top_level_shadow_color_down_hover = "-not set-";
	}
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $top_level_background_color_down_hover 
		. "', border_color='" . $top_level_item_border_color_down_hover
		. "', border=" . $top_level_item_border_width_down_hover . ", border_units=" . $top_level_item_border_units
		. ", border_sides='" . $top_level_item_border_sides_h_d_a . "', border_style='" . $top_level_item_border_style_down_hover
		. "', text_shadow=" . $top_level_shadow_down_hover
		. ", shadow_color='" . $top_level_shadow_color_down_hover . "', shadow_x_offset=" . $top_level_shadow_x_offset_hover
		. ", shadow_y_offset=" . $top_level_shadow_y_offset_hover . ", shadow_blur=" . $top_level_shadow_blur_hover
		. ", gradient_type=" . $top_level_gradient_type_down_hover . ", gradient_angle=" . $top_level_gradient_angle_down_hover 
		. ", gradient_colors='" . $top_level_gradient_colors_down_hover
		. "', gradient_opacities='" . $top_level_gradient_opacities_down_hover . "', gradient_repeat=" . $top_level_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . ":hover', use_table_data=1, bkgd_color='" 
		. $top_level_background_color_down_hover . "', border_color='" . $top_level_item_border_color_down_hover 
		. "', border=" . $top_level_item_border_width_down_hover . ", border_units=" . $top_level_item_border_units
		. ", border_sides='" . $top_level_item_border_sides_h_d_a . "', border_style='" . $top_level_item_border_style_down_hover
		. "', text_shadow=" . $top_level_shadow_down_hover
		. ", shadow_color='" . $top_level_shadow_color_down_hover . "', shadow_x_offset=" . $top_level_shadow_x_offset_hover
		. ", shadow_y_offset=" . $top_level_shadow_y_offset_hover . ", shadow_blur=" . $top_level_shadow_blur_hover
		. ", gradient_type=" . $top_level_gradient_type_down_hover . ", gradient_angle=" . $top_level_gradient_angle_down_hover 
		. ", gradient_colors='" . $top_level_gradient_colors_down_hover
		. "', gradient_opacities='" . $top_level_gradient_opacities_down_hover . "', gradient_repeat=" . $top_level_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($sub_level_1_bkgd_color_hover_on_down == 1)
		$sub_level_1_background_color_down_hover = $sub_level_1_background_color_hover;
	else
		$sub_level_1_background_color_down_hover = "-not set-";
		
	if ($sub_level_1_bkgd_gradient_hover_on_down == 1)	{
		$sub_level_1_gradient_type_down_hover = $sub_level_1_gradient_type_hover;
		$sub_level_1_gradient_angle_down_hover = $sub_level_1_gradient_angle_hover;
		$sub_level_1_gradient_colors_down_hover = $sub_level_1_gradient_colors_hover;
		$sub_level_1_gradient_opacities_down_hover = $sub_level_1_gradient_opacities_hover;
		$sub_level_1_gradient_repeat_down_hover = $sub_level_1_gradient_repeat_hover;
	}
	else	{
		$sub_level_1_gradient_type_down_hover = 0;
		$sub_level_1_gradient_angle_down_hover = 180;
		$sub_level_1_gradient_colors_down_hover = "-not set-";
		$sub_level_1_gradient_opacities_down_hover = "-not set-";
		$sub_level_1_gradient_repeat_down_hover = 0;
	}
		
	if ($sub_level_1_border_hover_on_down == 1)	{
		$sub_level_1_item_border_color_down_hover = $sub_level_1_item_border_color_hover;
		$sub_level_1_item_border_width_down_hover = $sub_level_1_item_border_width;
		$sub_level_1_item_border_style_down_hover = $sub_level_1_item_border_style;
		$sub_level_1_shadow_down_hover = $sub_level_1_shadow_hover;
		$sub_level_1_shadow_color_down_hover = $sub_level_1_shadow_color_hover;
	}
	else	{
		$sub_level_1_item_border_color_down_hover = "-not set-";
		$sub_level_1_item_border_width_down_hover = -1;
		$sub_level_1_item_border_style_down_hover = "-not selected-";
		$sub_level_1_shadow_down_hover = 0;
		$sub_level_1_shadow_color_down_hover = "-not set-";
	}
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_1_background_color_down_hover 
		. "', border_color='" . $sub_level_1_item_border_color_down_hover
		. "', border=" . $sub_level_1_item_border_width_down_hover . ", border_units=" . $sub_level_1_item_border_units
		. ", border_sides='" . $sub_level_1_item_border_sides_h_d_a . "', border_style='" . $sub_level_1_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_1_shadow_down_hover
		. ", shadow_color='" . $sub_level_1_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_1_shadow_blur_hover
		. ", gradient_type=" . $sub_level_1_gradient_type_down_hover . ", gradient_angle=" . $sub_level_1_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_1_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix 
		. ":hover', use_table_data=1, bkgd_color='" . $sub_level_1_background_color_down_hover . "', border_color='" . $sub_level_1_item_border_color_down_hover 
		. "', border=" . $sub_level_1_item_border_width_down_hover . ", border_units=" . $sub_level_1_item_border_units
		. ", border_sides='" . $sub_level_1_item_border_sides_h_d_a . "', border_style='" . $sub_level_1_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_1_shadow_down_hover
		. ", shadow_color='" . $sub_level_1_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_1_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_1_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_1_shadow_blur_hover
		. ", gradient_type=" . $sub_level_1_gradient_type_down_hover . ", gradient_angle=" . $sub_level_1_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_1_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_1_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_1_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($sub_level_2_bkgd_color_hover_on_down == 1)
		$sub_level_2_background_color_down_hover = $sub_level_2_background_color_hover;
	else
		$sub_level_2_background_color_down_hover = "-not set-";
		
	if ($sub_level_2_bkgd_gradient_hover_on_down == 1)	{
		$sub_level_2_gradient_type_down_hover = $sub_level_2_gradient_type_hover;
		$sub_level_2_gradient_angle_down_hover = $sub_level_2_gradient_angle_hover;
		$sub_level_2_gradient_colors_down_hover = $sub_level_2_gradient_colors_hover;
		$sub_level_2_gradient_opacities_down_hover = $sub_level_2_gradient_opacities_hover;
		$sub_level_2_gradient_repeat_down_hover = $sub_level_2_gradient_repeat_hover;
	}
	else	{
		$sub_level_2_gradient_type_down_hover = 0;
		$sub_level_2_gradient_angle_down_hover = 180;
		$sub_level_2_gradient_colors_down_hover = "-not set-";
		$sub_level_2_gradient_opacities_down_hover = "-not set-";
		$sub_level_2_gradient_repeat_down_hover = 0;
	}
		
	if ($sub_level_2_border_hover_on_down == 1)	{
		$sub_level_2_item_border_color_down_hover = $sub_level_2_item_border_color_hover;
		$sub_level_2_item_border_width_down_hover = $sub_level_2_item_border_width;
		$sub_level_2_item_border_style_down_hover = $sub_level_2_item_border_style;
		$sub_level_2_shadow_down_hover = $sub_level_2_shadow_hover;
		$sub_level_2_shadow_color_down_hover = $sub_level_2_shadow_color_hover;
	}
	else	{
		$sub_level_2_item_border_color_down_hover = "-not set-";
		$sub_level_2_item_border_width_down_hover = -1;
		$sub_level_2_item_border_style_down_hover = "-not selected-";
		$sub_level_2_shadow_down_hover = 0;
		$sub_level_2_shadow_color_down_hover = "-not set-";
	}
		
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover 
		. "', border_color='" . $sub_level_2_item_border_color_down_hover
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix 
		. ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover . "', border_color='" . $sub_level_2_item_border_color_down_hover 
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover 
		. "', border_color='" . $sub_level_2_item_border_color_down_hover
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix 
		. ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover . "', border_color='" . $sub_level_2_item_border_color_down_hover 
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover 
		. "', border_color='" . $sub_level_2_item_border_color_down_hover
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix 
		. ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover . "', border_color='" . $sub_level_2_item_border_color_down_hover 
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_5_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();

	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover 
		. "', border_color='" . $sub_level_2_item_border_color_down_hover
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover
		. " WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_5_li_down" . $suffix . ":hover'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_5_li_down" . $suffix 
		. ":hover', use_table_data=1, bkgd_color='" . $sub_level_2_background_color_down_hover . "', border_color='" . $sub_level_2_item_border_color_down_hover 
		. "', border=" . $sub_level_2_item_border_width_down_hover . ", border_units=" . $sub_level_2_item_border_units
		. ", border_sides='" . $sub_level_2_item_border_sides_h_d_a . "', border_style='" . $sub_level_2_item_border_style_down_hover
		. "', text_shadow=" . $sub_level_2_shadow_down_hover
		. ", shadow_color='" . $sub_level_2_shadow_color_down_hover . "', shadow_x_offset=" . $sub_level_2_shadow_x_offset_hover
		. ", shadow_y_offset=" . $sub_level_2_shadow_y_offset_hover . ", shadow_blur=" . $sub_level_2_shadow_blur_hover
		. ", gradient_type=" . $sub_level_2_gradient_type_down_hover . ", gradient_angle=" . $sub_level_2_gradient_angle_down_hover 
		. ", gradient_colors='" . $sub_level_2_gradient_colors_down_hover
		. "', gradient_opacities='" . $sub_level_2_gradient_opacities_down_hover . "', gradient_repeat=" . $sub_level_2_gradient_repeat_down_hover;
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li" . $suffix . ":hover .top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li" . $suffix . ":hover .top_level_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li" . $suffix . ":hover .top_level_a" . $suffix . "', use_table_data=1, text_color='" . $top_level_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li" . $suffix . ":hover .sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li" . $suffix . ":hover .sub_level_1_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li" . $suffix . ":hover .sub_level_1_a" . $suffix . "', use_table_data=1, text_color='" . $sub_level_1_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li" . $suffix . ":hover .sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li" . $suffix . ":hover .sub_level_2_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li" . $suffix . ":hover .sub_level_2_a" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li" . $suffix . ":hover .sub_level_3_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li" . $suffix . ":hover .sub_level_3_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li" . $suffix . ":hover .sub_level_3_a" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li" . $suffix . ":hover .sub_level_4_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li" . $suffix . ":hover .sub_level_4_a" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li" . $suffix . ":hover .sub_level_4_a" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.top_level_li_down" . $suffix . ":hover .top_level_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $top_level_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.top_level_li_down" . $suffix . ":hover .top_level_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.top_level_li_down" . $suffix . ":hover .top_level_a_down" . $suffix . "', use_table_data=1, text_color='" . $top_level_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_1_li_down" . $suffix . ":hover .sub_level_1_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_1_li_down" . $suffix . ":hover .sub_level_1_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_1_li_down" . $suffix . ":hover .sub_level_1_a_down" . $suffix . "', use_table_data=1, text_color='" . $sub_level_1_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_2_li_down" . $suffix . ":hover .sub_level_2_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_2_li_down" . $suffix . ":hover .sub_level_2_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_2_li_down" . $suffix . ":hover .sub_level_2_a_down" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_3_li_down" . $suffix . ":hover .sub_level_3_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_3_li_down" . $suffix . ":hover .sub_level_3_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_3_li_down" . $suffix . ":hover .sub_level_3_a_down" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '.sub_level_4_li_down" . $suffix . ":hover .sub_level_4_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count > 0)
	{
		//Update class record.
		$query = "UPDATE " . BWB_TABLE_PREFIX . "site_css SET use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover 
		. "' WHERE style_sheet='" . $style_sheet . "' AND class='.sub_level_4_li_down" . $suffix . ":hover .sub_level_4_a_down" . $suffix . "'";
	}
	else
	{
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet='" . $style_sheet . "', class='.sub_level_4_li_down" . $suffix . ":hover .sub_level_4_a_down" . $suffix . "', use_table_data=1, text_color='" . $sub_level_2_text_color_down_hover . "'";
	}
	$cnt = $bwb_dbh->exec($query);
	
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX, -1);
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo ADD_PLUGIN_TO_PAGE_COULD_NOT_RENAME_MSG . " $file_name " . TO_WORD ." $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(UPLOAD_TEMPLATE_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	echo 1;
?>