<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	7/14/2017	ELL
	
	include ("check_session.php");

	$style_sheet = $_POST['style_sheet'];
	$class = $_POST['class'];
	$attribute = $_POST['attribute'];
	$action = $_POST['action'];
	
	if ($action == "add")
		$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "site_css_important` SET `style_sheet` = :style_sheet, `class` = :class, `attribute` = :attribute";
	elseif ($action == "remove")
		$query = "DELETE FROM `" . BWB_TABLE_PREFIX . "site_css_important` WHERE `style_sheet` = :style_sheet AND `class` = :class AND `attribute` = :attribute";
	else	{
		echo "Error: Action not defined.";
		exit;
	}
	$stmt = $bwb_dbh->prepare($query);
	$stmt->execute(array(':style_sheet' => $style_sheet, ':class' => $class, ':attribute' => $attribute));
	
	/////////////////////////////////////////////
	// Build string for CSS file /////
	include("lib/build_css_string.php");

	$css_string = BuildCSSString($style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX, -1);

	////////////////////////////////////////////////////////
	/// Write CSS file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$css_file = $style_sheet . ".css";
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	echo 1;
	
?>
