<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Completely re-engineered: 12/17/2010	ELL
// Revised: 1/9/2011	ELL
// Added ability to work with multiple JavaScript menus.
// Revised: 10/11/2011	ELL
// Added ability to handle URL unfriendly characters in menu-item text.
// Revised: 11/4/2011	ELL
// Discovered that menu_item class was missing . and added it.
// Revised: 2/10/2012	ELL
// Added table prefix handling.
// Revised: 3/1/2012	ELL
// Adding trimming of spaces to keep indent spaces from adding up and making display look whacky while editing.
// Revised: 10/15/2012	ELL
// Added link styles for each menu item to give more control.
// Added filtering of item text for & codes and storage of filtered results to `name` field.  This is to fix bug
// of 'name' attribute changing menu spacing when & codes are present.
// Revised: 5/14/2013	ELL
// Added URL escaping and unescaping of URL itself.
// Revised: 7/19/2015	ELL
// Fixed bug with saving mobile menu items.
// Revised: 10/22/2016	ELL
// Added handling of mega menus.
// Removed saving of unused "name" attribute.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Consolidated all menu items tables into menu_items.
// Modified: 4/12/2017	ELL
// Added individual item classing to list items in addation to span around anchor.
// Revised: 7/3/2019	ELL
// Overhauled to use jQuery AJAX instead of pure JavaScript to eliminate bugs and make easier to troubleshoot.
//
//

	include ("check_session.php");
	include("lib/unescape_url.php");

	$menu = $_POST['selectMenu'];
	$cnt = $_POST['nCount'];

	// Build item arrays from POST variables.
	$tmp = str_replace("_mobile", "", $menu);
	$tmp = str_replace("_touchscreen", "", $tmp);
	$suffix = substr($tmp, 4);
	if (strpos($menu, "_mobile") !== false)
		$mobile = "_mobile";
	elseif (strpos($menu, "_touchscreen") !== false)
		$mobile = "_touchscreen";
	else
		$mobile = "";

	$item_style_sheet =  "menu"  . $suffix . $mobile . "_item";

	for ($i = 0; $i < $cnt; $i++)
	{
		$item_text_str = "item_text" . $i;
		$level_str = "level" . $i;
		$URL_str = "URL" . $i;
		$target_str = "target" . $i;
		$mega_menu_str = "mega_menu" . $i;
		
		$item_text[$i] = $_POST[$item_text_str];
		$item_text[$i] = trim(UnescapeURL($item_text[$i]));
		$level[$i] = $_POST[$level_str];
		$URL[$i] = $_POST[$URL_str];
		$URL[$i] = trim(UnescapeURL($URL[$i]));
		$target[$i] = $_POST[$target_str];
		$mega_menu[$i] = $_POST[$mega_menu_str];
		$sort_order[$i] = 10 * ($i + 1);
	}
	
	//Start by deleting all old data in table.
	$query = "DELETE FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu = '" . $menu . "'";
	$count = $bwb_dbh->exec($query);

	$last_level = 0;
	//Insert new data into table.
	for ($j = 0; $j < $i; $j++)
	{
		$item_text[$j] = str_replace("'", "&#39;", $item_text[$j]);
		$item_text[$j] = str_replace("\"", "&quot;", $item_text[$j]);
		$item_text[$j] = addslashes($item_text[$j]);

		if (isset($level[$j]) && ($level[$j] != ""))	{
			$level[$j] = addslashes($level[$j]);
			$last_level = $level[$j];
		}
		else
			$level[$j] = $last_level;
		$URL[$j]=addslashes($URL[$j]);
		$target[$j]=addslashes($target[$j]);
		$k = $j + 1;
		$item_class = ".menu" . $suffix . "_item" . $k;
		$item_class_hover = $item_class . ":hover";
		$item_class_active = $item_class . ":active";
		$item_class_link = $item_class . " A";
		$item_class_link_visited = $item_class . " A:visited";
		$item_class_link_hover = $item_class . " A:hover";
		$item_class_link_active = $item_class . " A:active";
		$item_li_class = ".menu" . $suffix . "_item" . $k . "_li";
		$description = $item_text[$j];
		$description_hover = $description . " (Hover)";
		$description_active = $description . " (Active)";
		$description_link = $description . " (Link)";
		$description_link_visited = $description . " (Link:visited)";
		$description_link_hover = $description . " (Link:hover)";
		$description_link_active = $description . " (Link:active)";
		$description_li = $description . " (LI)";

		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "menu_items (menu, item_text, level, URL, target, mega_menu, sort_order) VALUES('".$menu."','".$item_text[$j]."','".$level[$j]."','".$URL[$j]."','".$target[$j]."','".$mega_menu[$j]."','".$sort_order[$j]."')";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class."','".$description."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_hover."','".$description_hover."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_active."','".$description_active."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_link."','".$description_link."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_link_visited."','".$description_link_visited."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_link_hover."','".$description_link_hover."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_class_link_active."','".$description_link_active."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
		
		$query = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_classes (style_sheet, class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_style_sheet."','".$item_li_class."','".$description_li."',".$j.",0,0)";
		$count = $bwb_dbh->exec($query);
	}

	// Re-write sitemap.xml for web crawlers.
	include("generate_site_map.php");
	
	echo "Update all complete";
?>
