<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/9/2013
// Revised: 4/12/2016	ELL
// Added Update Breeze Mode no allow multiple plugins to be installed on one login.
//
	
	include ("check_session.php");
	
	if ($access_level != "admin")
		exit;
	
	$password = $_REQUEST['password'];
	
	if (isset($_SESSION['install_plugin_mode']))	// Check for expiration.
	{
		if (intval($_SESSION['install_plugin_mode']) < time())
			unset($_SESSION['install_plugin_mode']);
	}
	
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}
#install_plugin_btn	{	width:80px;	}
#upload_plugin_login_btn	{
	width:100px;
	position:inherit;
}

.button_heading_sub_level_1	{
	margin-left: 10%;
}
</style>

<script language="javascript" src="js/hash.js" type="text/javascript"> </script>

<script language="javascript" type="text/javascript">
function OpenHelpWindow()
{
	window.open("<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#install_plugin", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function SubmitLogin()
{
	var password = document.getElementById("password_input").value;
	var hash = Sha256.hash(password);
	document.getElementById("password").value = hash;
	document.getElementById("password_input").value = '';
	document.forms["formLogin"].submit();
}

function checkForEnter(e) {
	if (e.keyCode == 13) {
		SubmitLogin();
	}
}
</script>

</head>

<body <?php if ((!$password) && (!isset($_SESSION['install_plugin_mode']))) { ?>onLoad="document.getElementById('password_input').focus();"<?php } ?>>
<?php
	if ((!$password) && (!isset($_SESSION['install_plugin_mode'])))
	{
?>
        <form action="upload_plugin.php" method="post" enctype="multipart/form-data" name="formLogin" id="formLogin">
        <p class="title" align="center"><?php echo INSTALL_PLUGIN_PLEASE_ENTER_PASSWORD_FOR_ADMIN; ?>:</p>
        <p align="center"><input name="password_input" id="password_input" type="password" onKeyDown="checkForEnter(event);" /></p>
        <input type="hidden" name="password" id="password" />
        <p align="center">
        <table align="center" border="0"><tr><td>
        <div class='button_console' id="upload_plugin_login_btn" onClick="SubmitLogin();"><span class='button_console_text'><?php echo LOGIN_LOGIN_BTN; ?></span></div>
        </td></tr></table>
        </p>
        </form>
<?php
	}
	else
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "users WHERE `UserID` = '" . $userid . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		
		/////////////////////////////////////////////
		//Decrypt password for comparison:
		$enc_text = stripslashes($row["password"]);
		$key = stripslashes($row["UserID"]);
		
		//Convert key to codes and pad as necessary.
		for( $i = 0; $i < (strlen($enc_text))/2; $i++)
		{
			if ($i < strlen($key))
			{
				$c = $key{$i};
				$k[$i] = ord($c);
			}
			else
				$k[$i] = 65 + $i;
		}
		
		//Convert encrypted string to array of HEX uni-character codes.
		$j = 0;
		$q = 0;
		for( $i = 0; $i < strlen($enc_text); $i++)
		{
			if ($j == 0) {
				$c = $enc_text{$i};
				$j++;
			}
			else {
				$c = $c.$enc_text{$i};
				$e[$q] = hexdec($c);
				$q++;
				$j = 0;
			}
			
		}
		
		//Decrypt encrypted string with key to get original data.
		$decrypt_text = "";
		for( $i = 0; $i < (strlen($enc_text))/2; $i++)
		{
			$a[$i] = $e[$i] ^ $k[$i];
			$decrypt_text = $decrypt_text. chr($a[$i]);
		}
		////////////////////////////////////////////////////
		
		$decrypt_text = str_replace(BWB_SALT, '', $decrypt_text);
		$password_lookup = hash('sha256', $decrypt_text);
		if (($password_lookup == $password) || (isset($_SESSION['install_plugin_mode'])))
		{
?>

<div class="button_heading_sub_level_1" id="install_plugin_heading"><div class="button_heading_text_sub_level_1"><?php echo INSTALL_PLUGIN_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>

<form name="frmUploadPlugin" id="frmUploadPlugin" action="install_plugin.php" method="post" enctype="multipart/form-data">
<table width="80%" align="center">
	<tr><td align="center"><h3><?php echo INSTALL_PLUGIN_SELECT_PLUGIN_FROM_YOUR_COMPUTER; ?>:</h3></td></tr>
	<tr><td align="center"><input name="plugin_file" id="plugin_file" type="file" /></td></tr>
    <tr><td align="center">
    <div class='button_console' id="install_plugin_btn" onClick="document.getElementById('uploading_gif').style.display = 'inline'; document.getElementById('frmUploadPlugin').submit();"><span class='button_console_text'><?php echo INSTALL_WORD; ?></span></div>
    </td></tr>
    <tr><td align="center"><img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo UPLOAD_TEMPLATE_UPLOADING; ?>" id="uploading_gif" style="display:none; margin-top:50px;" /></td></tr>
</table>
</form>

<?php
		}
		else
			echo LOGIN_PASSWORD_NOT_CONFIRMED_1_MSG . " " . CLICK_WORD . " <a href='upload_plugin.php'> " . HERE_WORD . " </a> " . LOGIN_PASSWORD_NOT_CONFIRMED_2_MSG;
	}
?>

</body>
</html>