<?php
/////////////////////////////////////////////
// Users Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/9/2010	ELL
// Added more access levels.  Levels are now admin, power_user, user and restricted.
// Revised: 12/9/2010	ELL
// Added password generator.
// Revised: 2/10/2012	ELL
// Added table prefix handling.
// Revised: 11/16/2012	ELL
// Added checking for SSL and prompting if not SSL.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 10/28/2014	ELL
// Added modify user to change access level and revise added fields email, first_name and last_name.
// Complete overhaul to switch from form posts to AJAX.
// Revised: 11/20/2017	ELL
// Changed from admin-only access to limited change password, email and name only access to non admins.
// 
//
	include ("check_session.php");
	
?>
<!DOCTYPE html>
<html>
<head>
<title>Manage Users | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#generate_password_btn	{	width:170px;	}
#add_user_btn	{	width:110px;	}
#generate_password_btn2	{	width:170px;}
#change_password_btn	{	width:180px;	}
#delete_user_btn	{	width:110px;	}
#edit_user_btn		{	width:110px;	}
.button_heading_sub_level_1	{
	margin-left: 10%;
	margin-bottom: 3px;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/users.js"></script>

<script>
<?php
	echo "	var access_level = \"" . $access_level . "\";\n\n";
	
	echo "	var MANAGE_USERS_DELETE_USER_CONFIRM_1_MSG = \"" . MANAGE_USERS_DELETE_USER_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_USERS_DELETE_USER_CONFIRM_2_MSG = \"" . MANAGE_USERS_DELETE_USER_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_DELETED_1_MSG = \"" . MANAGE_USERS_USER_DELETED_1_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_DELETED_2_MSG = \"" . MANAGE_USERS_USER_DELETED_2_MSG . "\";\n";
	echo "	var MANAGE_USERS_NO_USERS_FOUND_ERR = \"" . MANAGE_USERS_NO_USERS_FOUND_ERR . "\";\n";
	echo "	var MANAGE_USERS_NO_DATA_FOUND_FOR_USER_ERR = \"" . MANAGE_USERS_NO_DATA_FOUND_FOR_USER_ERR . "\";\n";
	echo "	var MANAGE_USERS_USER_NOT_ADDED_ERR = \"" . MANAGE_USERS_USER_NOT_ADDED_ERR . "\";\n";
	echo "	var MANAGE_USERS_NEW_USER_ADDED_1_MSG = \"" . MANAGE_USERS_NEW_USER_ADDED_1_MSG . "\";\n";
	echo "	var MANAGE_USERS_NEW_USER_ADDED_2_MSG = \"" . MANAGE_USERS_NEW_USER_ADDED_2_MSG . "\";\n";
	echo "	var MANAGE_USERS_NEW_USER_ADDED_3_MSG = \"" . MANAGE_USERS_NEW_USER_ADDED_3_MSG . "\";\n";
	echo "	var MANAGE_USERS_NEW_USER_ADDED_4_MSG = \"" . MANAGE_USERS_NEW_USER_ADDED_4_MSG . "\";\n";
	echo "	var MANAGE_USERS_NEW_USER_ADDED_5_MSG = \"" . MANAGE_USERS_NEW_USER_ADDED_5_MSG . "\";\n";
	echo "	var MANAGE_USERS_PASSWORD_CHANGED_1_MSG = \"" . MANAGE_USERS_PASSWORD_CHANGED_1_MSG . "\";\n";
	echo "	var MANAGE_USERS_PASSWORD_CHANGED_2_MSG = \"" . MANAGE_USERS_PASSWORD_CHANGED_2_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_MODIFIED_1_MSG = \"" . MANAGE_USERS_USER_MODIFIED_1_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_MODIFIED_2_MSG = \"" . MANAGE_USERS_USER_MODIFIED_2_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_MODIFIED_3_MSG = \"" . MANAGE_USERS_USER_MODIFIED_3_MSG . "\";\n";
	echo "	var MANAGE_USERS_USER_MODIFIED_4_MSG = \"" . MANAGE_USERS_USER_MODIFIED_4_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var CLASSES_ADD_CLASS_ADD_ERR = \"" . CLASSES_ADD_CLASS_ADD_ERR . "\";\n";
	
	echo "	var http = '$http';\n";
?>
</script>

</head>

<body onLoad="GetUsers();" id="workspace_body">
<br>

<div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_USERS_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>

<div align="center">
<?php
	if ($_SERVER["HTTPS"] != "on")
	{
		 $pageURL .= "https://";
		 if ($_SERVER["SERVER_PORT"] != "80")
		  	$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		 else
		 	$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
			
		 echo "<p class='warning_text' align='justify' style='width:80%;'>" . MANAGE_USERS_SSL_NOT_PRESENT_WARNING . " <b><a href='$pageURL'>" . HERE_WORD . "</a></b>.  <br /><span class='extra_small_message'>" . MANAGE_USERS_INVALID_CERTIFICATE_NOTE . "</span></p>\n";
	}
	
	if ($access_level == "admin")	{
?>
<table width="80%" class="group_box_table"><tr><td>
<form name="formAddUser" id="formAddUser" method="post" action="add_user.php">
<table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="8" class="sub_title"><?php echo ADD_USER; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td><input type="text" name="user_name" id="user_name_new_user"></td>
    <td align="right" style="width:150px;"><?php echo PASSWORD_WORD; ?>: </td>
    <td style="width:144px;"><input type="password" name="password" id="password_new_user"></td>
    <td style="width:22px;">
        <div onClick="convertType(document.getElementById('password_new_user'));" class="reveal_pass_icon">
          &nbsp;
        </div>
    </td>
    <td>
    	 <div class='button_console_generate_password' id="generate_password_btn" onClick="convertToTxt(document.getElementById('password_new_user')); GeneratePassword('new');"><span class='button_console_text_w_icon'><?php echo GENERATE_PASSWORD; ?></span></div>
    </td>
    <td align="right"><?php echo ACCESS_LEVEL_WORD; ?>: </td>
    <td><select name="selectAccessLevel" id="selectAccessLevelNewUser">
    <option value="blogger"><?php echo BLOGGER_WORD; ?></option>
	<option value="restricted"><?php echo RESTRICTED_WORD; ?></option>
    <option value="user"><?php echo USER_WORD; ?></option>
    <option value="power_user" selected><?php echo POWER_USER_WORD; ?></option>
    <option value="admin"><?php echo ADMIN_WORD; ?></option>
    </select></td>
  </tr>
  <tr>
  	<td colspan="8" align="center">
    <table width="90%"><tr>
    <td align="right"><?php echo EMAIL_WORD; ?>:</td>
    <td><input type="text" name="email" id="email_new_user" /></td>
	<td align="right"><?php echo NAME_WORD; ?> <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_FIRST_LAST; ?></span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_new_user" />
    	<input type="text" name="last_name" id="last_name_new_user" />
        <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_OPTIONAL; ?></span>
    </td>
    </tr></table>
    </td>
  </tr>
  <tr>
    <td colspan="8" align="center">
    <div class='button_console_add' id="add_user_btn" onClick="AddUser();"><span class='button_console_text_w_icon'><?php echo ADD_WORD; ?></span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br>
<?php	}	?>
  <table width="80%" class="group_box_table"><tr><td>
  <form name="formChangePassword" id="formChangePassword" method="post" action="change_password.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title"><?php if ($access_level == "admin") echo CHANGE_PASSWORD; else echo MANAGE_USERS_CHANGE_MY_PASSWORD; ?></td>
  </tr>
  <tr>
    <td align="right"><?php if ($access_level == "admin") echo USERNAME_WORD . ":"; ?> </td>
    <td>
<?php	if ($access_level == "admin")	{	?>
    <select name="selectUserName" id="selectUserNameExistingUser">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
    </select>
<?php	}	else 	{	?>
	<input type="hidden" name="selectUserName" id="selectUserNameExistingUser" value="<?php echo $userid; ?>" readonly />
<?php	}	?>
    </td>
    <td align="right"><?php echo NEW_PASSWORD; ?>: </td>
    <td style="width:150px; text-align:right;">
    	<input type="password" name="password" id="password_existing_user">
    </td>
    <td style="width:22px;">
        <div onClick="convertType(document.getElementById('password_existing_user'));" class="reveal_pass_icon">
          &nbsp;
        </div>
    </td>
    <td>
        <div class='button_console_generate_password' id="generate_password_btn2" onClick="convertToTxt(document.getElementById('password_existing_user')); GeneratePassword('existing');"><span class='button_console_text_w_icon'><?php echo GENERATE_PASSWORD; ?></span></div>
	</td>
  </tr>
  <tr><td colspan="6">&nbsp;</td></tr>
  <tr>
    <td colspan="6" align="center">
    <div class='button_console_edit' id="change_password_btn" onClick="ChangePassword();"><span class='button_console_text_w_icon'><?php echo CHANGE_PASSWORD; ?></span></div>
    </td>
  </tr>
  </table>
  <input type="hidden" name="table" id="table" value="users" />
  </form>
  </td></tr></table>

  <br>
  <table width="80%" class="group_box_table"><tr><td>
	<form name="formModifyUser" id="formModifyUser" method="post" action="modify_user.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title"><?php if ($access_level == "admin") echo MODIFY_USER; else echo MANAGE_USERS_MODIFY_MY_ACCOUNT; ?></td>
  </tr>
  <tr>
    <td align="right"><?php if ($access_level == "admin") echo USERNAME_WORD . ":"; ?> </td>
    <td>
<?php	if ($access_level == "admin")	{	?>
    <select name="selectUserName" id="selectUserNameEdit" onChange="GetUser(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
    </select>
<?php	}	else 	{	?>
	<input type="hidden" name="selectUserName" id="selectUserNameEdit" value="<?php echo $userid; ?>" readonly />
<?php	}	?>
    </td>
    <td align="right"><?php if ($access_level == "admin") echo ACCESS_LEVEL_WORD . ":"; ?> </td>
    <td>
<?php	if ($access_level == "admin")	{	?>
    <select name="selectAccessLevel" id="selectAccessLevelEdit">
    <option value="blogger"><?php echo BLOGGER_WORD; ?></option>
	<option value="restricted"><?php echo RESTRICTED_WORD; ?></option>
    <option value="user"><?php echo USER_WORD; ?></option>
    <option value="power_user" selected><?php echo POWER_USER_WORD; ?></option>
    <option value="admin"><?php echo ADMIN_WORD; ?></option>
    </select>
<?php	}	else 	{	?>
	<input type="hidden" name="selectAccessLevel" id="selectAccessLevelEdit" value="<?php echo $access_level; ?>" readonly />
<?php	}	?>
    </td>
  </tr>
  <tr>
    <td align="right"><?php echo EMAIL_WORD; ?>:</td>
    <td><input type="text" name="email" id="email_edit" /></td>
	<td align="right"><?php echo NAME_WORD; ?> <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_FIRST_LAST; ?></span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_edit" />
        <input type="text" name="last_name" id="last_name_edit" />
    </td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center">
    <div class='button_console_edit' id="edit_user_btn" onClick="ModifyUser();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
    </td>
  </tr>
</table>
<input type="hidden" name="table" id="table" value="users" />
</form>
  </td></tr></table>
<?php  if ($access_level == "admin")	{	?>
  <br>
  <table width="80%" class="group_box_table"><tr><td>

  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="2" class="sub_title"><?php echo DELETE_USER; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td>
    <select name="selectUserName" id="selectUserNameDelete">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
    </select>
    </td>
  </tr>
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
    <td colspan="2" align="center">
    <div class='button_console_delete' id="delete_user_btn" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
<?php	}	?>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
<?php if ($access_level != "admin")
	echo "GetUser('$userid')";
?>
</script>
</body>
</html>
