<?php
// "mime_mail.inc"
// Generic MIME mailer module created by Ed Lemmers, Silver Dolphin Solutions, LLC.
// For licensing, see license.txt.
// This module has the capability of sending attachments and creating either htlm or text messages.
// Other header information has been broken out from the original module including html, cc and bc
// for easier usage.  The intent is to provide easy email creating and handling without any further
// customization of this module.

class mime_mail
{
   var $to;
   var $from;
   var $headers;
   var $subject;
   var $body;
   var $replyto;
   var $cc;
   var $bc;
   var $html;			// Set equal to something for html message.  Leave undefined for plain text.
   						// If plain text, the /n causes new line.  If html, then use <br> for new line.
						
   var $encode_type;	//Content Transfer Encoding:
   						// 1 -- 7bit
						// 2 -- quoted-printable
						// 3 -- base64
						// 4 -- 8bit
						// 5 -- binary
						// 0 or not set -- base64
	
	var $no_mime;		// Some mail servers such as GoDaddy don't support mime.
	var $attachment;	// Data to be sent as binary attachment.
	var $attachment_application;	// Sets application intended to open attachment.  Default is octet-stream.
	var $charset;		// Char Set:
						// 1 -- UTF-8
						// 2 -- ISO-8859-1
						// 3 -- ANSI
						// 4 -- ASCII
						// 0 or not set -- UTF-8
	var $transfer_encoding;	//Transfer Enconding:
						//	7 -- 7bit
						//	8 -- 8bit
						// 0 or not set -- 8bit

   /*
    *     void mime_mail()
    *     class constructor
    */
   function __construct()
   {
      $this->to =  "";
      $this->from =  "";
      $this->subject =  "";
      $this->body =  "";
      $this->headers =  "";
	  $this->replyto =  "";
	  $this->cc =  "";
	  $this->bc =  "";
	  $this->html =  "";
	  $this->encode_type = "";
	  $this->no_mime = "";
	  $this->attachment = array();
	  $this->attachment_application = "";
	  $this->charset = "";
	  $this->transfer_encoding = "";
   }
   
   /*
    *     get_attachment()
    *     Add an attachment to the mail object
    */
  function get_attachment($file) {
		if (isset($file) && ($file != ""))	{
			$file_size = filesize($file);
			$handle = fopen($file, "r");
			$content = fread($handle, $file_size);
			fclose($handle);
			$content = chunk_split(base64_encode($content));
			return $content;
		}
		else
			return "Error: Attachment file name is blank.";
   }

	/*
    *     send()
    *     Main program for sending email.
	*     Builds header and sends email based on parameters given.
    */
	function send() {
		$eol = PHP_EOL;
			
		// Basic headers
		if (!empty($this->from) && ($this->from != ""))
			$this->headers = "From: " . $this->from . $eol;
		if (!empty($this->replyto) && ($this->replyto != ""))
			$this->headers .= "Reply-To: " . $this->replyto . $eol;
		if (!empty($this->cc) && ($this->cc != ""))
			$this->headers .= "CC: " . $this->cc . $eol;
		if (!empty($this->bc) && ($this->bc != ""))
			$this->headers .= "BC: " . $this->bc . $eol;

		if (($this->no_mime != 1) || (!empty($this->attachment)))
		{
			if (!isset($this->charset) || ($this->charset == 0))
				$charset = "UTF-8";
			elseif ($this->charset == 1)
				$charset = "UTF-8";
			elseif ($this->charset == 2)
				$charset = "ISO-8859-1";
			elseif ($this->charset == 3)
				$charset = "ANSI";
			elseif ($this->charset == 4)
				$charset = "ASCII";
			else
				$charset = "UTF-8";

			if (isset($this->attachment) && ($this->attachment[0] != ""))
			{
				$uid = md5(uniqid(time()));
					
				$this->headers .= "MIME-Version: 1.0" . $eol;
				$this->headers .= "Content-Type: multipart/mixed; boundary=\"" . $uid . "\"";
				$this->message = "--" . $uid . $eol;
				if ($this->html == 1)
					$this->message .= "Content-Type: text/html; charset=" . $charset . $eol;
				else
					$this->message .= "Content-Type: text/plain; charset=" . $charset . $eol;
				
				if (!isset($this->transfer_encoding) || ($this->transfer_encoding == 0))
					$transfer_encoding =  "8bit";
				elseif ($this->transfer_encoding == 7)
					$transfer_encoding = "7bit";
				elseif ($this->transfer_encoding == 8)
					$transfer_encoding = "8bit";	
				else
					$transfer_encoding = "8bit";	
				
				$this->message .= "Content-Transfer-Encoding: " . $transfer_encoding . $eol . $eol;
				$this->message .= $this->body . $eol;
				
				if (!isset($this->encode_type) || ($this->encode_type == 0))
					$encoding =  "base64";
				elseif ($this->encode_type == 1)
					$encoding = "7bit";
				elseif ($this->encode_type == 2)
					$encoding =  "quoted-printable";
				elseif ($this->encode_type == 3)
					$encoding =  "base64";
				elseif ($this->encode_type == 4)
					$encoding =  "8bit";
				elseif ($this->encode_type == 5)
					$encoding =  "binary";
				else
					$encoding =  "base64";
					
				if (!isset($this->attachment_application) || ($this->attachment_application == ""))
					$attachment_application = "octet-stream";
				else
					$attachment_application = $this->attachment_application;

				// Put everything else in $message
				foreach($this->attachment as $attachment)
				{
					$name = basename($attachment);
					$content = $this->get_attachment($attachment);
					
					$this->message .= "--" . $uid . $eol;
					$this->message .= "Content-Type: application/" . $attachment_application . "; name=\"" . $name . "\"" . $eol;
					$this->message .= "Content-Transfer-Encoding: " . $encoding . $eol;
					$this->message .= "Content-Disposition: attachment; filename=\"" . $name . "\"" . $eol . $eol;
					$this->message .= $content . $eol;
				}
				$this->message .= "--" . $uid . "--";
				
				mail($this->to, $this->subject, $this->message, $this->headers);
			}
			else
			{
				$pre = 'MIME-Version: 1.0' . $eol;
				if ($this->html == 1)
					$pre .= 'Content-type: text/html; charset=' . $charset . $eol;
				else
					$pre .= 'Content-type: text/plain; charset=' . $charset . $eol;
				$this->headers = $pre . $this->headers;

				mail($this->to, $this->subject, $this->body, $this->headers);
			}
		}
		else
		{
			mail($this->to, $this->subject, $this->body, $this->headers);
		}
	}
};
?>