////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/29/2018
//

var top_offset = -300;
var left_offset = 0;

function ShowLocationInfo(i)
{
	var ntop, nleft;
	ntop = tempY + top_offset;
	nleft = tempX + left_offset;

	var strtop = ntop + "px";
	var strleft = nleft + "px";
	document.getElementById("location_info").style.top = strtop;
	document.getElementById("location_info").style.left = strleft;
	
	document.getElementById("location_name").innerHTML = location_name[i];
	document.getElementById("address").innerHTML = address[i];
	document.getElementById("address2").innerHTML = address2[i];
	document.getElementById("city").innerHTML = city[i];
	document.getElementById("state").innerHTML = state[i];
	document.getElementById("postal_code").innerHTML = postal_code[i];
	document.getElementById("country").innerHTML = country[i];
	if ((typeof phone[i] != "undefined") && (phone[i] != ""))
		document.getElementById("phone").innerHTML = BuildTelLink(phone[i]);
	else
		document.getElementById("phone").innerHTML = ""
	if ((typeof phone2[i] != "undefined") && (phone2[i] != ""))
		document.getElementById("phone2").innerHTML = BuildTelLink(phone2[i]);
	else
		document.getElementById("phone2").innerHTML = "";
	document.getElementById("fax").innerHTML = fax[i];
	if ((typeof email[i] != "undefined") && (email[i] != ""))
		document.getElementById("email").innerHTML = BuildEmailLink(email[i]);
	else
		document.getElementById("email").innerHTML = "";
	document.getElementById("contact_first").innerHTML = contact_first[i];
	document.getElementById("contact_middle").innerHTML = contact_middle[i];
	document.getElementById("contact_last").innerHTML = contact_last[i];
	if ((typeof website[i] != "undefined") && (website[i] != "") && (website[i] != "http://"))	{
		if ((typeof web_link_text[i] == "undefined") || (web_link_text[i] == ""))
			document.getElementById("website").innerHTML = BuildWebLink(website[i], website[i]);
		else
			document.getElementById("website").innerHTML = BuildWebLink(website[i], web_link_text[i]);
	}
	else
		document.getElementById("website").innerHTML = "";
	document.getElementById("notes").innerHTML = notes[i];
	document.getElementById("location_categories").innerHTML = location_categories[i];
	
	var address_str = "";
	if (address[i] != "")
		address_str = address[i].replace(/ /g, "+");
	if (address2[i] != "")
		address_str = address_str + "+" + address2[i].replace(/ /g, "+");
	if (city[i] != "")
		address_str = address_str + "+" + city[i].replace(/ /g, "+");
	if (state[i] != "")
		address_str = address_str + "+" + state[i].replace(/ /g, "+");
	if (country[i] != "")
		address_str = address_str + "+" + country[i].replace(/ /g, "+");

	if (address_str != "")	{
		var map_url = "https://www.google.com/maps/search/?api=1&query=" + address_str;
		document.getElementById("location_map").href = map_url;
	}
	else
		document.getElementById("location_map").style.display = "none";
		
	document.getElementById("location_info").style.display = "block";
}

function HideLocationInfo()
{
	document.getElementById("location_info").style.display = "none";
}

function AdjustLocationPopupPosition()
{
	if ((!is_mobile) && (document.getElementById("content_div").style.position != "relative"))	{
		top_offset = -50;
		left_offset = -350;
	}
}
window.onload = function() { AdjustLocationPopupPosition()	};

function BuildTelLink(phone_str)
{
	phone_num = phone_str.replace(/-/g, "");
	phone_num = phone_num.replace(/\(/g, "");
	phone_num = phone_num.replace(/\)/g, "");
	phone_num = phone_num.replace(/\./g, "");
	if (phone_num.length < 10)
		phone_num = "1" + phone_num;
	var phone_html = "<a href='tel:+" + phone_num + "'>" + phone_str + "</a>";
	return(phone_html);
}

function BuildEmailLink(email)
{
	var email_html = "<a href='mailto:" + email + "'>" + email + "</a>";
	return(email_html);
}

function BuildWebLink(website, link_txt)
{
	if (website.indexOf("http") != 0)
		website = "http://" + website;
	var website_html = "<a href='" + website + "' target='_blank'>" + link_txt + "</a>";
	return(website_html);
}
