<?php
///////////// Calendar Code ///////////////////////////////////////////
// Breeze Website Builder
// Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// Created: 12/18/2018
	
	$month_count = 0;
	$month = array();
	$day = array();
	$year = array();
	$event_name = array();
	$event_description = array();
	$event_start_date = array();
	$event_end_date = array();
	$event_start_time = array();
	$event_end_time = array();
    $URL = array();
	$target = array();
	$event_private = array();
	
	if (SEF_URL == 1)
		include($php_dir_rel . "get_params_from_sef_url.php");
		
	include($php_dir_rel . "clean_var.php");
	foreach ($_POST as $key => $value)	{
		if ((!is_array($value)) && (!is_object($value)))
			$_POST[$key] = CleanVar($value);
		else	{
			foreach ($value as $k => $val)	{
				$value[$k]= CleanVar($val);
			}
			$_POST[$key] = $value;
		}
	}
	
	$curr_mth = $_GET['curr_mth'];
	if (!isset($curr_mth)) $curr_mth = 0;
	$mth_change = $_GET['mth_change'];
	$show_all = $_GET['show_all'];
	if (!isset($show_all)) $show_all = 0;
	$show_hebrew = $_GET['show_hebrew'];
	if (!isset($show_hebrew)) $show_hebrew = 0;
	$script_name = $_SERVER['SCRIPT_FILENAME'];
	if (SEF_URL == 1)	$script_name = str_replace(".php", "", $this_page);
	$pos = strrpos("$script_name", "/");
	if ($pos !== false)	$script_name = substr($script_name, ($pos + 1));
	$show_past = $_GET['show_past'];
	if (!isset($show_past)) $show_past = 0;
	$events_user_table = $_GET['user_table'];
	$events_UserID = $_GET['UserID'];
	$events_AccessLevel = $_GET['AccessLevel'];
	$use_logged_in_credentials = $_GET['use_logged_in_credentials'];
	
	$where = " WHERE (event_active = 1)";
	
	$today = date("Y-m-d");
	$first_day_this_mth = substr($today, 0, strlen($today) - 2) . "01";

	if ($show_past != 1)
		$where .= " AND (event_start_date >= '$first_day_this_mth')";
	
	if ($use_logged_in_credentials)
	{
		if ($events_user_table)
			$where .= " AND (user_table = '$user_table')";
		if ($events_UserID)
			$where .= " AND (UserID = '$userid')";
		if ($events_AccessLevel)
			$where .= " AND (AccessLevel = '$AccessLevel')";
	}
	else
	{
		if ($events_user_table != 1)
			$user_table = $events_user_table;
		if ($events_UserID != 1)
			$userid = $events_UserID;
		if ($events_AccessLevel != 1)
			$AccessLevel = $events_AccessLevel;
			
		if (($events_user_table) && ($events_UserID) && ($events_AccessLevel))
			$where .= " AND ((user_table = '$user_table') AND ((UserID = '$userid') OR (AccessLevel = '$AccessLevel')))";
		elseif (($events_user_table) && (!$events_UserID) && (!$events_AccessLevel))
			$where .= " AND (user_table = '$user_table')";
		elseif ((!$events_user_table) && ($events_UserID) && (!$events_AccessLevel))
			$where .= " AND (UserID = '$userid')";
		elseif ((!$events_user_table) && (!$events_UserID) && ($events_AccessLevel))
			$where .= " AND (AccessLevel = '$AccessLevel')";
		elseif (($events_user_table) && ($events_UserID) && (!$events_AccessLevel))
			$where .= " AND (user_table = '$user_table') AND (UserID = '$userid')";
		elseif (($events_user_table) && (!$events_UserID) && ($events_AccessLevel))
			$where .= " AND (user_table = '$user_table') AND (AccessLevel = '$AccessLevel')";
		elseif ((!$events_user_table) && ($events_UserID) && ($events_AccessLevel))
			$where .= " AND ((UserID = '$userid') OR (AccessLevel = '$AccessLevel'))";
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "events AS T1 LEFT JOIN " . BWB_TABLE_PREFIX . "locations AS T2 ON T1.location_id = T2.location_id" . $where . " ORDER BY `event_start_date`";

	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();

	echo "<script>\n";
	echo "	var location_name = new Array();\n";
	echo "	var address = new Array();\n";
	echo "	var address2 = new Array();\n";
	echo "	var city = new Array();\n";
	echo "	var state = new Array();\n";
	echo "	var postal_code = new Array();\n";
	echo "	var country = new Array();\n";
	echo "	var phone = new Array();\n";
	echo "	var phone2 = new Array();\n";
	echo "	var fax = new Array();\n";
	echo "	var email = new Array();\n";
	echo "	var contact_first = new Array();\n";
	echo "	var contact_middle = new Array();\n";
	echo "	var contact_last = new Array();\n";
	echo "	var website = new Array();\n";
	echo "	var web_link_text = new Array();\n";
	echo "	var notes = new Array();\n";
	echo "	var location_categories = new Array();\n";
	for ($i = 0; $i < $num_results; $i++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$event_name[$i] = stripslashes($row["event_name"]);
		$event_name[$i] = str_replace("'", "&#39;", $event_name[$i]);
		$event_description[$i] = stripslashes($row["event_description"]);
		$event_description[$i] = str_replace("'", "&#39;", $event_description[$i]);
		$event_start_date[$i] = $row["event_start_date"];
		$event_start_time[$i] = $row["event_start_time"];
		$event_end_time[$i] = $row["event_end_time"];
		$URL[$i] = $row["URL"];
		$target[$i] = $row["target"];
		$event_private[$i] = $row["event_private"];
		
		if ((substr($event_start_date[$i], 2, 1) ==  "/") && (substr($event_start_date[$i], 5, 1) ==  "/"))
			list($month[$i], $day[$i], $year[$i]) = explode("/", $event_start_date[$i]);
		else
			list($year[$i], $month[$i], $day[$i]) = preg_split("/[\/.-]/", $event_start_date[$i]);
		if ($month[$i] != $month[$i-1])
			$month_count++;
		
		if ((substr($event_start_time[$i], 2, 1) ==  ":") && (substr($event_start_time[$i], 5, 1) ==  ":"))	{
			list($start_hour, $start_minute, $second) = explode(":", $event_start_time[$i]);
			$start_am_pm = "am";
			if (intval($start_hour) >= 12)	{
				if (intval($start_hour) > 12)
					$start_hour = intval($start_hour) - 12;
				$start_am_pm = "pm";
			}
			elseif (intval($start_hour) == 0)	{
				$start_hour = "12";
				$start_am_pm = "am";
			}
			$event_start_time[$i] = intval($start_hour) . ":" . $start_minute . " " . $start_am_pm;
		}
		if ((substr($event_end_time[$i], 2, 1) ==  ":") && (substr($event_end_time[$i], 5, 1) ==  ":"))	{
			list($end_hour, $end_minute, $second) = explode(":", $event_end_time[$i]);
			$end_am_pm = "am";
			if (intval($end_hour) >= 12)	{
				if (intval($end_hour) > 12)
					$end_hour = intval($end_hour) - 12;
				$end_am_pm = "pm";
			}
			elseif (intval($end_hour) == 0)	{
				$end_hour = "12";
				$end_am_pm = "am";
			}
			if ($start_am_pm == $end_am_pm)
				$event_start_time[$i] = intval($start_hour) . ":" . $start_minute;
			$event_end_time[$i] = intval($end_hour) . ":" . $end_minute . " " . $end_am_pm;
		}
	
		$location_name[$i] = $row["location_name"];
		if (isset($row["location_name"]) && ($row["location_name"] != ""))	{
			echo "	location_name[$i] = \"" . $row["location_name"] . "\";\n";
			echo "	address[$i] = \"" . $row["address"] . "\";\n";
			echo "	address2[$i] = \"" . $row["address2"] . "\";\n";
			echo "	city[$i] = \"" . $row["city"] . "\";\n";
			echo "	state[$i] = \"" . $row["state"] . "\";\n";
			echo "	postal_code[$i] = \"" . $row["postal_code"] . "\";\n";
			echo "	country[$i] = \"" . $row["country"] . "\";\n";
			echo "	phone[$i] = \"" . $row["phone"] . "\";\n";
			echo "	phone2[$i] = \"" . $row["phone2"] . "\";\n";
			echo "	fax[$i] = \"" . $row["fax"] . "\";\n";
			echo "	email[$i] = \"" . $row["email"] . "\";\n";
			echo "	contact_first[$i] = \"" . $row["contact_first"] . "\";\n";
			echo "	contact_middle[$i] = \"" . $row["contact_middle"] . "\";\n";
			echo "	contact_last[$i] = \"" . $row["contact_last"] . "\";\n";
			echo "	website[$i] = \"" . $row["website"] . "\";\n";
			echo "	web_link_text[$i] = \"" . $row["web_link_text"] . "\";\n";
			echo "	notes[$i] = \"" . $row["notes"] . "\";\n";
			echo "	location_categories[$i] = \"" . $row["location_categories"] . "\";\n";
		}
	}
	echo "</script>\n";

	//////////////////////////////////////////////////
	if ($show_all != 1)
	{
		if (isset($mth_change))
		{
			switch($mth_change)	{
				case -1:
					$curr_mth = $curr_mth - 1;
					if ($curr_mth < 0)
						$curr_mth = 0;
					break;
				case 1:
					$curr_mth = $curr_mth + 1;
					if ($curr_mth > $month_count - 1)
						$curr_mth = $month_count - 1;
					break;
				case -10:
					$curr_mth = 0;
					break;
				case 10:
					$curr_mth = $month_count - 1;
					break;
			}
		}
		else
		{
			// If $curr_mth not set, then first time. Need to default to this month and set $curr_mth which is just index into months
			// by count of total valid months.  If this month is not one of the valid months, then got to first valid month.
			$m = 0;
			$this_month = date("n");
			$valid_mth_found = false;
			for ($k = 0; $k < $month_count; $k++)
			{				
				$grid_month = $month[$m];
				if($grid_month != $this_month)
				{
					while($month[$m] == $grid_month)
						$m++;
					continue;
				}
				else
				{
					$curr_mth = $k;
					$valid_mth_found = true;
					break;
				}
			}
			if (!$valid_mth_found)
				$curr_mth = 0;
		}
	}

$m = 0;
for ($k = 0; $k < $month_count; $k++)
{
	$grid_month = $month[$m];
	$current_year = $year[$m];
	if (($show_all != 1) && ($k != $curr_mth))
	{
		while ($month[$m] == $grid_month)
			$m++;
		continue;
	}

	$start_timestamp = mktime(0, 0, 0, $month[$m], 1, $year[$m]);
	$on_the_1st_day_of_week = date("w", $start_timestamp) + 1;	// 1 = Sunday, 7 = Saturday
	$days_in_month = date("t", $start_timestamp);
	$month_name = date("F", $start_timestamp);
	$month_number = date("m", $start_timestamp);
	$year_string = date("Y", $start_timestamp);
	
	// Get days from previous month to fill out calendar row.
	$first_day_cur_mth = $year[$m] . "-" . $month[$m] . "-01";
	$dt_first_day_this_mth = DateTime::createFromFormat("Y-m-d", $first_day_cur_mth);
	$ts_first_day_this_mth = $dt_first_day_this_mth->getTimestamp();
	$days_need_from_prev_mth = date("w", $ts_first_day_this_mth);
	$days_in_cur_mth = cal_days_in_month(CAL_GREGORIAN, $month[$m], $year[$m]);
	$prev_mth = $month[$m] - 1;
	$prev_yr = $year[$m];
	if ($prev_mth < 1)	{
		$prev_mth = 12;
		$prev_yr--;
	}
	if ($prev_mth < 10)
		$prev_mth = "0" . $prev_mth;
	$days_in_prev_mth = cal_days_in_month(CAL_GREGORIAN, $prev_mth, $prev_yr);
	
	// Get days from next month to fill out calendar row.
	$last_day_this_mth = $year[$m] . "-" . $month[$m] . "-" . $days_in_cur_mth;
	$dt_last_day_this_mth = DateTime::createFromFormat("Y-m-d", $last_day_this_mth);
	$ts_last_day_this_mth = $dt_last_day_this_mth->getTimestamp();
	$days_need_from_cur_mth = 7 - date("w", $ts_last_day_this_mth);
	$next_mth = $month[$m] + 1;
	$next_yr = $year[$m];
	if ($next_mth > 12)	{
		$next_mth = 1;
		$next_yr++;
	}
	if ($next_mth < 10)
		$next_mth = "0" . $next_mth;
	
	if ($show_hebrew == 1)
	{
		// Get Jewish date
		$julian_date = gregoriantojd($grid_month, 1, $current_year);
		$jewishdate = jdtojewish($julian_date);
		// Find the Jewish calendar date and parse out the day and year values
		list ($jc_month, $jc_day, $jc_year) = explode ('/', $jewishdate);
		// Get Jewish month name
		$jc_month_string = jdmonthname ($julian_date, CAL_MONTH_JEWISH);
		// Get second Jewish date
		$julian_date_2 = gregoriantojd($grid_month, $days_in_month, $current_year);
		$jewishdate_2 = jdtojewish($julian_date_2);
		// Find the Jewish calendar date and parse out the day and year values
		list ($jc_month_2, $jc_day_2, $jc_year_2) = explode ('/', $jewishdate_2);
		// Get Jewish month name
		$jc_month_string_2 = jdmonthname ($julian_date_2, CAL_MONTH_JEWISH);
		// In case this month spans the Jewish year, make year adjustment for heading.
		if ($jc_year != $jc_year_2)
			$jc_year = $jc_year . " - " . $jc_year_2;
	}
?>

<DIV CLASS="pagebreak">
<div class="calendar_div">
<table class="calendar_table">
<tr class="calendar_tr_head">
	<td colspan="7">
    <table class="calendar_nav_table">
    	<tr>
        <?php if ($show_all != 1) {	?>
        	<td align="left" class="calendar_td_head">
            <?php 
			if ($curr_mth > 0)	{
				if (SEF_URL == 1)
					echo "<a href='/$script_name/mth_change/-10/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past' title='First'>";
				else
					echo "<a href='$script_name?mth_change=-10&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past' title='First'>";
			}
			?>
            <span class="calendar_nav_links">&lt;&lt;</span>
			<?php if ($curr_mth > 0) echo "</a>"; ?>
            </td>
            <td align="left" class="calendar_td_head">
            <?php
            if ($curr_mth > 0)	{
				if (SEF_URL == 1)
					echo "<a href='/$script_name/mth_change/-1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past' title='Previous'>";
                else
	                echo "<a href='$script_name?mth_change=-1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past' title='Previous'>";
			}
			?>
            <span class="calendar_nav_links">&lt;</span>
            <?php if ($curr_mth > 0) echo "</a>"; ?>
            </td>
        <?php } ?>
    		<td align="center" class="calendar_td_head">
            <a <?php 
			if ($show_all == 1)	{
				if (SEF_URL == 1)
					echo "href='$script_name/show_all/0/curr_mth/$k/show_hebrew/$show_hebrew/show_past/$show_past' title='Show Current Month Only'"; 
				else
					echo "href='$script_name?show_all=0&curr_mth=$k&show_hebrew=$show_hebrew&show_past=$show_past' title='Show Current Month Only'"; 
			}
			else	{
				if (SEF_URL == 1)
					echo "href='$script_name/show_all/1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past' title='Show All Months'";
                else
                	echo "href='$script_name?show_all=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past' title='Show All Months'";
			}
			?>><span class="calendar_nav_links calendar_month_year">
                    
			<?php 
			if ($show_hebrew != 1)
				echo "$month_name, $year_string</span>";
			else
				echo "$month_name, $year_string<br><span class='calendar_hebrew_header'>$jc_month_string - $jc_month_string_2, $jc_year</span>";
			?>
            </a>
            </td>
        <?php if ($show_all != 1) {	?>
            <td align="right" class="calendar_td_head">
            <?php
            if ($curr_mth < $month_count - 1)	{
				if (SEF_URL == 1)
					echo "<a href='/$script_name/mth_change/1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past' title='Next'>";
                else
                	echo "<a href='$script_name?mth_change=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past' title='Next'>";
			}
			?>
            <span class="calendar_nav_links">&gt;</span>
            <?php if ($curr_mth < $month_count - 1) echo "</a>"; ?>
            </td>
            <td align="right" class="calendar_td_head">
            <?php
            if ($curr_mth < $month_count - 1)	{
				if (SEF_URL == 1)
					echo "<a href='/$script_name/mth_change/10/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past' title='Last'>";
				else
					echo "<a href='$script_name?mth_change=10&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past' title='Last'>";
			}
			?>
            <span class="calendar_nav_links">&gt;&gt;</span>
            <?php if ($curr_mth < $month_count -1 ) echo "</a>"; ?>
            </td>
         <?php } ?>
    	</tr>
    </table>
    </td>
</tr>
<tr class="calendar_tr_head2">
	<td class="calendar_td_head2">S</td>
	<td class="calendar_td_head2">M</td>
	<td class="calendar_td_head2">T</td>
	<td class="calendar_td_head2">W</td>
	<td class="calendar_td_head2">T</td>
	<td class="calendar_td_head2">F</td>
	<td class="calendar_td_head2">S</td>
</tr>
<tr class="calendar_tr">

<?php
	$got_1st_day = false;
	$got_last_day = false;
	$j = 1;
	$q = 1;
	for ($i = 1; $i < 43; $i++)
	{
		if ($i == $on_the_1st_day_of_week)
			$got_1st_day = true;

		$calendar_highlight = "";
		$calendar_past_dates = "";

		if ($j < 10)
			$day_str = "0" . (string)$j;
		else
			$day_str = (string)$j;
		$date_str = $year_string . "-" . $month_number . "-" . $day_str;
			
		if ($date_str == $today)
			$calendar_highlight = " calendar_curr_day";

		if ($date_str < $today)
			$calendar_past_dates = " calendar_past_dates";

		echo "<td class='calendar_td" . $calendar_highlight . $calendar_past_dates . "'>\n";
		echo "<div class='calendar_event'>\n";
		if (($got_1st_day == true) && ($got_last_day == false))
		{
			if ($show_hebrew == 1)
			{
				// Get Jewish date
				$julian_date = gregoriantojd($grid_month, $j, $current_year);
				$jewishdate = jdtojewish($julian_date);
				// Find the Jewish calendar date and parse out the day and year values
				list ($jc_month, $jc_day, $jc_year) = explode ('/', $jewishdate);
				// Find the Jewish calendar month name
				$jc_month = jdmonthname ($julian_date, CAL_MONTH_JEWISH);
				echo "<div class='calendar_day'>$j</div><div class='calendar_hebrew'>$jc_day $jc_month</div>";	// Print day.
			}
			else
				echo $j;	// Print day.
			/////////////////////////////////////////////////////////
			
			// Print event if one exists for this day.
			while (($day[$m] == $j) && ($month[$m] == $grid_month) && ($year[$m] == $current_year))
			{
				if ($event_end_time[$m] == "")
					$EndTimeStr = "";
				else
					$EndTimeStr = "- $event_end_time[$m]";
				if ($URL[$m])
					echo "<a href='$URL[$m]' target='$target[$m]'><div class='calendar_event_name'>$event_name[$m]</div><div class='calendar_event_description'>$event_description[$m]</div><div class='start_end_time'>$event_start_time[$m] $EndTimeStr</div></a>\n";
				else
					echo "<div class='calendar_event_name'>$event_name[$m]</div><div class='calendar_event_description'>$event_description[$m]</div><div class='start_end_time'>$event_start_time[$m] $EndTimeStr</div>\n";
					
				if ($event_private[$m] == 1)
					echo "<div class='calendar_private'>Private</div>\n";

				if ($location_name[$m] != "")
					echo "<div class='location_link' onclick='ShowLocationInfo($m);' onmouseover='ShowLocationInfo($m);'>Location</div>\n";
				$m++;
			}
			
			/////////////////////////////////////////////////////////
			$j++;
			if ($j > $days_in_month)
				$got_last_day = true;
		}
		elseif ($got_1st_day == false)
		{
			$o = $days_in_prev_mth - $days_need_from_prev_mth + $i;
			if ($show_hebrew == 1)
			{
				// Get Jewish date
				$julian_date = gregoriantojd($prev_mth, $o, $prev_yr);
				$jewishdate = jdtojewish($julian_date);
				// Find the Jewish calendar date and parse out the day and year values
				list ($jc_month, $jc_day, $jc_year) = explode ('/', $jewishdate);
				// Find the Jewish calendar month name
				$jc_month = jdmonthname ($julian_date, CAL_MONTH_JEWISH);
				echo "<div class='calendar_day'>$o</div><div class='calendar_hebrew'>$jc_day $jc_month</div>";	// Print day.
			}
			else
				echo $o;	// Print day.
			/////////////////////////////////////////////////////////
			
			// Print event if one exists for this day.
			for ($p = 0; $p < $num_results; $p++)
			{
				if (($month[$p] == $prev_mth) && ($day[$p] == $o) && ($year[$p] == $prev_yr))
				{
					if ($event_end_time[$p] == "")
						$EndTimeStr = "";
					else
						$EndTimeStr = "- $event_end_time[$p]";
					if ($URL[$p])
						echo "<a href='$URL[$p]' target='$target[$p]'><div class='calendar_event_name'>$event_name[$p]</div><div class='calendar_event_description'>$event_description[$p]</div><div class='start_end_time'>$event_start_time[$p] $EndTimeStr</div></a>\n";
					else
						echo "<div class='calendar_event_name'>$event_name[$p]</div><div class='calendar_event_description'>$event_description[$p]</div><div class='start_end_time'>$event_start_time[$p] $EndTimeStr</div>\n";					
	
					if ($location_name[$p] != "")
						echo "<div class='location_link' onclick='ShowLocationInfo($p);' onmouseover='ShowLocationInfo($p);'>Location</div>\n";
				}
			}
		}
		elseif ($got_last_day == true)
		{
			if ($show_hebrew == 1)
			{
				// Get Jewish date
				$julian_date = gregoriantojd($next_mth, $q, $next_yr);
				$jewishdate = jdtojewish($julian_date);
				// Find the Jewish calendar date and parse out the day and year values
				list ($jc_month, $jc_day, $jc_year) = explode ('/', $jewishdate);
				// Find the Jewish calendar month name
				$jc_month = jdmonthname ($julian_date, CAL_MONTH_JEWISH);
				echo "<div class='calendar_day'>$q</div><div class='calendar_hebrew'>$jc_day $jc_month</div>";	// Print day.
			}
			else
				echo $q;	// Print day.
			/////////////////////////////////////////////////////////
			
			// Print event if one exists for this day.
			for ($u = 0; $u < $num_results; $u++)
			{
				if (($month[$u] == $next_mth) && ($day[$u] == $q) && ($year[$u] == $next_yr))
				{
					if ($event_end_time[$u] == "")
						$EndTimeStr = "";
					else
						$EndTimeStr = "- $event_end_time[$u]";
					if ($URL[$u])
						echo "<a href='$URL[$u]' target='$target[$u]'><div class='calendar_event_name'>$event_name[$u]</div><div class='calendar_event_description'>$event_description[$u]</div><div class='start_end_time'>$event_start_time[$u] $EndTimeStr</div></a>\n";
					else
						echo "<div class='calendar_event_name'>$event_name[$u]</div><div class='calendar_event_description'>$event_description[$u]</div><div class='start_end_time'>$event_start_time[$u] $EndTimeStr</div>\n";					
	
					if ($location_name[$p] != "")
						echo "<div class='location_link' onclick='ShowLocationInfo($u);' onmouseover='ShowLocationInfo($u);'>Location</div>\n";
				}
			}
			$q++;
		}
		else
			echo "&nbsp;";

		echo "</div>\n";
		echo "</td>\n";

		if (($i == 35) && ($got_last_day == true))	//All done, don't need another row.
			$i = 50;
		else if (!($i % 7))	//If Saturday, start new row.
			echo "</tr><tr>\n";
	}
?>

</tr>
</table>
<br />
<?php
	$toggle_show_past = 1;
	$show_hide_past_btn_label = "Show Past Events";
	if ($show_past == 1)	{
		$toggle_show_past = 0;
		$show_hide_past_btn_label = "Hide Past Events";
	}
	
	if (SEF_URL == 1)	{
		$show_hide_past_url = "/" . str_replace(".php", "", $this_page) . "/show_past/" . $toggle_show_past . "/curr_mth/" . $curr_mth . "/show_hebrew/" . $show_hebrew . "/show_all/" . $show_all;
		if (isset($events_user_table) && ($events_user_table != ""))
			$show_hide_past_url .= "/user_table/" . $events_user_table;
		if (isset($events_UserID) && ($events_UserID != ""))
			$show_hide_past_url .= "/UserID/" . $events_UserID;
		if (isset($events_AccessLevel) && ($events_AccessLevel != ""))
			$show_hide_past_url .= "/AccessLevel/" . $events_AccessLevel;
		if (isset($use_logged_in_credentials) && ($use_logged_in_credentials != ""))
			$show_hide_past_url .= "/use_logged_in_credentials/" . $use_logged_in_credentials;
	}
	else	{
		$show_hide_past_url = $this_page . "?show_past=" . $toggle_show_past . "&curr_mth=" . $curr_mth . "&show_hebrew=" . $show_hebrew . "&show_all=" . $show_all;
		if (isset($events_user_table) && ($events_user_table != ""))
			$show_hide_past_url .= "&user_table=" . $events_user_table;
		if (isset($events_UserID) && ($events_UserID != ""))
			$show_hide_past_url .= "&UserID=" . $events_UserID;
		if (isset($events_AccessLevel) && ($events_AccessLevel != ""))
			$show_hide_past_url .= "&AccessLevel=" . $events_AccessLevel;
		if (isset($use_logged_in_credentials) && ($use_logged_in_credentials != ""))
			$show_hide_past_url .= "&use_logged_in_credentials=" . $use_logged_in_credentials;
	}
	
	echo "\n<div id='show_hide_past_btn'><a href='" . $show_hide_past_url . "'>" . $show_hide_past_btn_label . "</a></div>\n";
?>
</div>
</DIV>

<?php
}	//month count

include($scripts_dir_rel . "/location_info.html");
/////////////////////////////////////////////////////////////////////////////////////
?>