////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 9/22/2014	ELL
// Revised: 6/16/2017	ELL
// Overhauled for new form system.

function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else if ((document.getElementsByName(el) != null) && (typeof document.getElementsByName(el) != "undefined") && (document.getElementsByName(el).length > 0))
		return document.getElementsByName(el).length;
	else
		return false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
document.getElementById("userid").focus();
document.getElementById("javascript_warning").innerHTML = "";

var php_path_rel = php_dir_rel + "login_verify.php";
if (document.getElementById("frmLoginForm").action == "")
	document.getElementById("frmLoginForm").action = php_path_rel;
var php_path_rel = php_dir_rel + "reset_password.php";
if (document.getElementById("frmResetPassword").action == "")
	document.getElementById("frmResetPassword").action = php_path_rel;

var redirect_path;
var redirect_path2;
if (redirect == "")
	redirect_path = webpage_dir + this_page;
else
	redirect_path = redirect;
if (redirect2 == "")
	redirect_path2 = webpage_dir + this_page + "?err=password_reset";
else
	redirect_path2 = redirect2;
	
if (document.getElementById("redirect").value == "")	
	document.getElementById("redirect").value = redirect_path;
if (document.getElementById("redirect2").value == "")
	document.getElementById("redirect2").value = redirect_path2;
if (document.getElementById("user_table").value == "")
	document.getElementById("user_table").value = user_table;
if (document.getElementById("user_table2").value == "")
	document.getElementById("user_table2").value = user_table;
if (document.getElementById("AccessLevel").value == "" )
	document.getElementById("AccessLevel").value = AccessLevel;
	
var alt_go_back = webpage_dir + this_page;
if (document.getElementById("alt_go_back").value == "")
	document.getElementById("alt_go_back").value = alt_go_back;
if (document.getElementById("alt_go_back2").value == "")
	document.getElementById("alt_go_back2").value = alt_go_back;
if (document.getElementById("email_link_page").value == "")
	document.getElementById("email_link_page").value = this_page;
	
//////////////////////////////////////////////////////////////////////////////////////////////
	function ReadGetVar(variable)
	{
		var query = window.location.search.substring(1);
		var vars = query.split("&");
		for (var i=0;i<vars.length;i++) {
		   var pair = vars[i].split("=");
		   if(pair[0] == variable)	{
			   return pair[1];
		   }
		}
		return("");
	}
	
	function replaceAll(txt, search_str, replace_str) {
  		return txt.replace(new RegExp(search_str, 'g'),replace_str);
	}
	
	// Go thru all forms and get all elements and check for go-back values to re-populate.
	var frm_cnt = document.forms.length;
	var el_cnt = 0;
	var el;
	for (i = 0; i < frm_cnt; i++)
	{
		el_cnt = document.forms[i].elements.length;
		for (j = 0; j < el_cnt; j++)
		{
			el = document.forms[i].elements[j];
			if (el.type == "text")	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
				// Special patch for email_confirm.
				if (el.name == "email_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "email")	{
						tmp = ReadGetVar("email");
						el.value = replaceAll(tmp, "%20", "");
					}
				}
				// Special patch for password_confirm
				if (el.name == "password_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "no_match")	{
						tmp = ReadGetVar("password");
						if (tmp != "")
							el.value = tmp;
					}
				}
			}
			else if (el.type == "textarea")	{
				tmp = ReadGetVar(el.name);
				el.innerHTML = replaceAll(tmp, "%20", " ");
			}
			else if (el.type == "checkbox")	{
				if (ReadGetVar(el.name) != "")
					el.checked = true;
			}
			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
			}
		}
	}
	
//////////////////////////////////////////////////////////////////////////////////////////
	var err = ReadGetVar("err");
	var show_password_reset = ReadGetVar("show_password_reset");
	
	if (show_password_reset == 1)
		ShowPasswordReset();

	if ((err != undefined) && (err != ""))
	{
		if (err == "bad_email")	{
			document.getElementById("ErrBadEmail").style.display = "block";
			document.getElementById("email").focus();
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
		}
		else if (err == "blank_email")	{
			document.getElementById("ErrEmail").style.display = "block";
			document.getElementById("email").focus();
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
		}
		else if (err == "captcha")	{
			document.getElementById("ErrCaptcha").style.display = "block";
			if (captcha_type == "recaptcha")
				document.getElementById("recaptcha_td").className = "field_highlight";
			else  if (captcha_type == "recaptcha2")
				document.getElementById("recaptcha2_td").className = "field_highlight";
			else if (captcha_type == "wscaptcha")
				document.getElementById("wsp_code").className = "field_highlight";
			else if (captcha_type == "mollom")
				document.getElementById("captcha_response_field").className = "field_highlight";
		}
		else if (err == "bad_password")	{
			document.getElementById("ErrBadPassword").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
		}
		else if(err == "bad_user")	{          
			document.getElementById("ErrBadUser").style.display="block";
			document.getElementById("userid").focus();
			class_name = document.getElementById("userid").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("userid").className = class_name + " field_highlight";
		}
		else if(err == "bad_access_level")	{          
			document.getElementById("ErrAccessLevel").style.display="block";
		}
		else if(err == "not_active")	{          
			document.getElementById("ErrNotActive").style.display="block";
		}
		else if(err == "password_reset")	{          
			document.getElementById("PasswordReset").style.display="block";
			document.getElementById("userid").focus();
			class_name = document.getElementById("userid").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("userid").className = class_name + " field_highlight";
		}
	}

/////////////////////////////////////////////////////////////////////////////////////////////
function ShowPasswordReset()
{
	if (is_mobile)
		document.getElementById("reset_password_form").style.display="block";
	else
		document.getElementById("reset_password_form").style.display="inline";
	document.getElementById("recaptcha_row").style.display = "none";
	document.getElementById("recaptcha2_row").style.display = "none";
	document.getElementById("wscaptcha_row").style.display = "none";
	document.getElementById("mollomcaptcha_row").style.display = "none";
	if (document.getElementById("use_captcha").value == 1)
	{
		var element_type;
		if ((document.getElementById("captcha_type").value == "recaptcha") && (ElExists('recaptcha_row') === true))	{
			element_type = document.getElementById("recaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("recaptcha_row").style.display = "table-row";
			else
				document.getElementById("recaptcha_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "recaptcha2") && (ElExists('recaptcha2_row') === true))	{
			element_type = document.getElementById("recaptcha2_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("recaptcha2_row").style.display = "table-row";
			else
				document.getElementById("recaptcha2_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "wscaptcha") && (ElExists('wscaptcha_row') === true))	{
			element_type = document.getElementById("wscaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("wscaptcha_row").style.display = "table-row";
			else
				document.getElementById("wscaptcha_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "mollom") && (ElExists('mollomcaptcha_row') === true))	{
			element_type = document.getElementById("mollomcaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("mollomcaptcha_row").style.display = "table-row";
			else
				document.getElementById("mollomcaptcha_row").style.display = "inline-block";
		}
	}
	
	if ((document.getElementById("captcha_type").value == "recaptcha") && (document.getElementById("use_captcha").value == 1))
	{
		var captcha_challange_url = "http://www.google.com/recaptcha/api/challenge?k=" + recaptcha_public_key;
		document.getElementById("recaptcha_script").src = captcha_challange_url;
	}
	
	OnShowPasswordReset();
}

//////////////////////////////////////////////////////
function SubmitLogin()
{
	var password = document.getElementById("password_input").value;
	var hash = Sha256.hash(password);
	document.getElementById("password").value = hash;
	document.getElementById("password_input").value = "";
	document.forms["frmLoginForm"].submit();
}

/////////////////////////////////////////////////////
function checkForEnter(e) {
	if (e.keyCode == 13) {
		SubmitLogin();	
	}
}