/////////////////////////////////////////////
// Change Password /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2016	ELL
//
function ReadGetVar(variable)
{
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	   var pair = vars[i].split("=");
	   if(pair[0] == variable)	{
		   return pair[1];
	   }
	}
	return("");
}

function replaceAll(txt, search_str, replace_str) {
	return txt.replace(new RegExp(search_str, 'g'),replace_str);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else if ((document.getElementsByName(el) != null) && (typeof document.getElementsByName(el) != "undefined") && (document.getElementsByName(el).length > 0))
		return document.getElementsByName(el).length;
	else
		return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{
	if (ElExists('reset_pass_submit_btn') === true)
		document.getElementById("reset_pass_submit_btn").style.display = "none";
		
	if (ElExists('reset_pass_div_btn') === true)
		document.getElementById("reset_pass_div_btn").style.display = "inline-block";
	if (ElExists('generate_pass_div_btn') === true)
		document.getElementById("generate_pass_div_btn").style.display = "inline-block";
		
	var php_path_rel = php_dir_rel + "change_password.php";
	if (ElExists('frmChangePasswordForm') === true)	{	// If not exists then not logged in so no form exists.
		if (document.getElementById("frmChangePasswordForm").action == "")
			document.getElementById("frmChangePasswordForm").action = php_path_rel;
	
		var redirect_path = document.getElementById("redirect").value;
		if (redirect_path == "")
			redirect_path = redirect;
		var redirect_path_arr = redirect_path.split("/");
		var redirect_file = "";
		for(var i in redirect_path_arr)
		{
			if ((redirect_path_arr[i].indexOf(".php")) > 0)
				redirect_file = redirect_path_arr[i];
		}
		redirect_path = webpage_dir + redirect_file;
		document.getElementById("redirect").value = redirect_path;
		
		var alt_go_back = webpage_dir + this_page;
		if (document.getElementById("alt_go_back").value == "")
			document.getElementById("alt_go_back").value = alt_go_back;
		
		if (document.getElementById("user_table").value == "")
			document.getElementById("user_table").value = user_table;
		document.getElementById("UserID").value = userid;
		
		// Go thru all forms and get all elements and check for go-back values to re-populate.
		var frm_cnt = document.forms.length;
		var el_cnt = 0;
		var el;
		var tmp;
		for (i = 0; i < frm_cnt; i++)
		{
			el_cnt = document.forms[i].elements.length;
			for (j = 0; j < el_cnt; j++)
			{
				el = document.forms[i].elements[j];
				if ((el.type == "text") && (el.name != "password") && (el.name != "password_confirm"))	{
					tmp = ReadGetVar(el.name);
					el.value = replaceAll(tmp, "%20", " ");
					// Special patch for email_confirm.
					if (el.name == "email_confirm")	{
						var tmperr = ReadGetVar("err");
						if(tmperr != "email")	{
							tmp = ReadGetVar("email");
							el.value = replaceAll(tmp, "%20", "");
						}
					}
				}
				else if (el.type == "textarea")	{
					tmp = ReadGetVar(el.name);
					el.innerHTML = replaceAll(tmp, "%20", " ");
				}
				else if (el.type == "checkbox")	{
					if (ReadGetVar(el.name) != "")
						el.checked = true;
				}
				else if ((el.type == "select-one") || (el.type == "select-multiple"))	{
					tmp = ReadGetVar(el.name);
					el.value = replaceAll(tmp, "%20", " ");
				}
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////
	var err = ReadGetVar("err");
	var class_name;
	
	if ((err != undefined) && (err != ""))
	{
		if (err == "too_short")	{
			var password_length = ReadGetVar("password_length");
			if (ElExists("password_length_msg") === true)
				document.getElementById("password_length_msg").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
		}
		else if (err == "too_weak") {
			var password_strength = ReadGetVar("password_strength");
			if (ElExists("password_strength_msg") === true)	{
				if (password_strength == "medium")
					document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning both letters and numbers.";
				else if (password_strength == "strong")
					document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
			}
			document.getElementById("ErrTooWeak").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
		}
		else if (err == "no_match")	{
			document.getElementById("ErrNoMatch").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
			document.getElementById("password_confirm").className = class_name + " field_highlight";
		}
		else if (err == "no_error")	{
			document.getElementById("ErrSuccess").style.display = "block";
			document.getElementById("frmChangePasswordForm").style.display = "none";
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
function CheckForm()
{
	var OKtoSend = true;
	var el;
	var class_name;
	document.getElementById("ErrTooShort").style.display = "none";
	document.getElementById("ErrTooWeak").style.display = "none";
	document.getElementById("ErrNoMatch").style.display = "none";
	if (ElExists('ErrPassBlank') === true)
		document.getElementById("ErrPassBlank").style.display = "none";
	if (ElExists('ErrPassNoMatch') === true)
		document.getElementById("ErrPassNoMatch").style.display = "none";
	document.getElementById("ErrSuccess").style.display = "none";
	
	if ((document.getElementById('password').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value))	{
		class_name = document.getElementById('password').className;
		class_name = class_name.replace(" required_field", "");
		document.getElementById("password").className = class_name + " field_highlight";
		if (document.getElementById('password').value == "")
			document.getElementById("ErrPassBlank").style.display = "block";
		else
			document.getElementById("ErrPassNoMatch").style.display = "block";
		if (OKtoSend)	{
			document.getElementById("password").focus();
			OKtoSend = false;
		}
	}
	else	{	// Clear previous highlights.
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("password").className = class_name + " required_field";
		}
	if ((document.getElementById('password_confirm').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value))	{
		class_name = document.getElementById('password_confirm').className;
		class_name = class_name.replace(" required_field", "");
		document.getElementById("password_confirm").className = class_name + " field_highlight";
		if (document.getElementById('password').value == "")
			document.getElementById("ErrPassBlank").style.display = "block";
		else
			document.getElementById("ErrPassNoMatch").style.display = "block";
		OKtoSend = false;
	}
	else	{	// Clear previous highlights.
		class_name = document.getElementById("password_confirm").className;
		class_name = class_name.replace(" field_highlight", "");
		document.getElementById("password_confirm").className = class_name + " required_field";
	}
	
	if ((ElExists('password_length') === true) && (document.getElementById('password_length').value > 0) && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		var password_length = document.getElementById('password_length').value;
		if (document.getElementById('password').value.length < password_length)	{
			if (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm") === true)
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			if (ElExists("password_length_msg") === true)
				document.getElementById("password_length_msg").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}

	if ((ElExists('password_strength') === true) && (document.getElementById('password_strength').value != "") && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		
		var password_strength = document.getElementById('password_strength').value;
		if (ElExists("password_strength_msg") === true)	{
			if (password_strength == "medium")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning both letters and numbers.";
			else if (password_strength == "strong")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
		}

		if (((document.getElementById('password').value.match(/(?:[A-Za-z].*?\d|\d.*?[A-Za-z])/) == null) && (password_strength == "medium")) || ((document.getElementById('password').value.match(/(?=.*\d)(?=.*[a-zA-Z])(?=.*\W)/) == null) && (password_strength == "strong")))	{
			if  (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm") === true)
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			document.getElementById("ErrTooWeak").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}
		
	return OKtoSend;
}

function SubmitForm(frmID)
{
	if (CheckForm())
		document.getElementById(frmID).submit();
}