/////////////////////////////////////////////
// Generate Password /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2016	ELL
//
function GeneratePassword()
{
	var min_len = 6;
	var max_len = 10;
	if (ElExists("password_length") === true)	{
		if (document.getElementById("password_length").value != "")	{
			min_len = parseInt(document.getElementById("password_length").value);
			max_len = min_len + 4;
		}
	}
	var password = "";
	var password_length = rand(min_len, max_len);
	var i;
	var assci_segment;
	
	for (i = 0; i < password_length; i++)
	{
		assci_segment = rand(1,3);
		if (assci_segment == 1)
			password = password + String.fromCharCode(rand(48,57));	// numeric
		else if (assci_segment == 2)
			password = password + String.fromCharCode(rand(65,90));	// alpha upper case
		else
			password = password + String.fromCharCode(rand(97,122));	// alpha lower case
	}
	password = password.replace('I', 'i');
	password = password.replace('O', 'o');
	password = password.replace('l', 'L');
	
	document.getElementById('password').value = password;
	document.getElementById('password_confirm').value = password;
	if (ElExists("password_generated") === true)
		document.getElementById('password_generated').value = password;
		
	return password;
}

// Equivalent to PHP rand(min, max);
function rand ( n, m )
{
  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );
}

function convertType(elem)
{
	var input = document.createElement('input');
	input.id = elem.id;
	input.name = elem.name;
	input.value = elem.value;
	input.onfocus = elem.onfocus;
	input.onblur = elem.onblur;
	input.className = elem.className;
	if (elem.type == 'text' )
	  { input.type = 'password'; }
	else
	  { input.type = 'text'; }
	
	elem.parentNode.replaceChild(input, elem);         
	return input;
}

function convertToTxt(elem)
{
	var input = document.createElement('input');
	input.id = elem.id;
	input.name = elem.name;
	input.value = elem.value;
	input.onfocus = elem.onfocus;
	input.onblur = elem.onblur;
	input.className = elem.className;
	if (elem.type == 'text' )
	  { return elem; }
	else
	  { input.type = 'text'; }
	
	elem.parentNode.replaceChild(input, elem);         
	return input;
}

function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else if ((document.getElementsByName(el) != null) && (typeof document.getElementsByName(el) != "undefined") && (document.getElementsByName(el).length > 0))
		return document.getElementsByName(el).length;
	else
		return false;
}